/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.psi.TypeParametersVisitor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.wrapreturnvalue.ReturnValueBeanBuilder;
import com.intellij.refactoring.wrapreturnvalue.WrapReturnValueUsageViewDescriptor;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.ChangeReturnType;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.ReturnWrappedValue;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.UnwrapCall;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.WrapReturnValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WrapReturnValueProcessor
extends FixableUsagesRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"com.siyeh.rpp.wrapreturnvalue.WrapReturnValueProcessor");
    private final MoveDestination myMoveDestination;
    private final PsiMethod myMethod;
    private final String myClassName;
    private final String myPackageName;
    private final boolean myCreateInnerClass;
    private final PsiField myDelegateField;
    private final String myQualifiedName;
    private final boolean myUseExistingClass;
    private final List<PsiTypeParameter> myTypeParameters;
    private final String myUnwrapMethodName;

    public WrapReturnValueProcessor(String className, String packageName, MoveDestination moveDestination, PsiMethod method, boolean useExistingClass, boolean createInnerClass, PsiField delegateField) {
        super(method.getProject());
        this.myMoveDestination = moveDestination;
        this.myMethod = method;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myCreateInnerClass = createInnerClass;
        this.myDelegateField = delegateField;
        this.myQualifiedName = StringUtil.getQualifiedName((String)packageName, (String)className);
        this.myUseExistingClass = useExistingClass;
        HashSet<PsiTypeParameter> typeParamSet = new HashSet<PsiTypeParameter>();
        TypeParametersVisitor visitor = new TypeParametersVisitor(typeParamSet);
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        assert (returnTypeElement != null);
        returnTypeElement.accept((PsiElementVisitor)visitor);
        this.myTypeParameters = new ArrayList<PsiTypeParameter>(typeParamSet);
        this.myUnwrapMethodName = useExistingClass ? this.calculateUnwrapMethodName() : "getValue";
    }

    private String calculateUnwrapMethodName() {
        PsiClass existingClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myQualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
        if (existingClass != null) {
            if (TypeConversionUtil.isPrimitiveWrapper((String)this.myQualifiedName)) {
                PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createType(existingClass));
                assert (unboxedType != null);
                return unboxedType.getCanonicalText() + "Value()";
            }
            PsiMethod getter = PropertyUtilBase.findGetterForField((PsiField)this.myDelegateField);
            return getter != null ? getter.getName() : "";
        }
        return "";
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            WrapReturnValueProcessor.$$$reportNull$$$0(0);
        }
        WrapReturnValueUsageViewDescriptor wrapReturnValueUsageViewDescriptor = new WrapReturnValueUsageViewDescriptor(this.myMethod, usageInfos);
        if (wrapReturnValueUsageViewDescriptor == null) {
            WrapReturnValueProcessor.$$$reportNull$$$0(1);
        }
        return wrapReturnValueUsageViewDescriptor;
    }

    public void findUsages(@NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            WrapReturnValueProcessor.$$$reportNull$$$0(2);
        }
        this.findUsagesForMethod(this.myMethod, usages);
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)this.myMethod)) {
            this.findUsagesForMethod(overridingMethod, usages);
        }
    }

    private void findUsagesForMethod(PsiMethod psiMethod, List<FixableUsageInfo> usages) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)psiMethod, (SearchScope)psiMethod.getUseScope())) {
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (parent instanceof PsiCallExpression) {
                usages.add(new UnwrapCall((PsiExpression)((PsiCallExpression)parent), this.myUnwrapMethodName));
                continue;
            }
            if (!(referenceElement instanceof PsiMethodReferenceExpression)) continue;
            usages.add(new UnwrapCall((PsiExpression)((PsiMethodReferenceExpression)referenceElement), this.myUnwrapMethodName));
        }
        String returnType = this.calculateReturnTypeString();
        usages.add(new ChangeReturnType(psiMethod, returnType));
        psiMethod.accept((PsiElementVisitor)new ReturnSearchVisitor(usages, returnType));
    }

    private String calculateReturnTypeString() {
        PsiClass containingClass;
        PsiType returnType;
        PsiType type2;
        PsiType inferredType;
        String qualifiedName = StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName);
        StringBuilder returnTypeBuffer = new StringBuilder(qualifiedName);
        if (!this.myTypeParameters.isEmpty()) {
            returnTypeBuffer.append('<');
            returnTypeBuffer.append(StringUtil.join(this.myTypeParameters, typeParameter -> {
                String paramName = typeParameter.getName();
                LOG.assertTrue(paramName != null);
                return paramName;
            }, (String)","));
            returnTypeBuffer.append('>');
        } else if (this.myDelegateField != null && (inferredType = WrapReturnValueProcessor.getInferredType(type2 = this.myDelegateField.getType(), returnType = this.myMethod.getReturnType(), containingClass = this.myDelegateField.getContainingClass(), this.myMethod)) != null) {
            returnTypeBuffer.append("<").append(inferredType.getCanonicalText()).append(">");
        }
        return returnTypeBuffer.toString();
    }

    protected static PsiType getInferredType(PsiType type2, PsiType returnType, PsiClass containingClass, PsiMethod method) {
        PsiTypeParameter typeParameter;
        PsiSubstitutor substitutor;
        PsiType substituted;
        if (containingClass != null && containingClass.getTypeParameters().length == 1 && (substituted = (substitutor = PsiResolveHelper.SERVICE.getInstance((Project)method.getProject()).inferTypeArguments(containingClass.getTypeParameters(), new PsiType[]{type2}, new PsiType[]{returnType}, PsiUtil.getLanguageLevel((PsiElement)method))).substitute(typeParameter = containingClass.getTypeParameters()[0])) != null && !typeParameter.equals(PsiUtil.resolveClassInClassTypeOnly((PsiType)substituted))) {
            return substituted;
        }
        return null;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            WrapReturnValueProcessor.$$$reportNull$$$0(3);
        }
        MultiMap conflicts = new MultiMap();
        PsiClass existingClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myQualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
        if (this.myUseExistingClass) {
            if (existingClass == null) {
                conflicts.putValue(null, (Object)RefactorJBundle.message("could.not.find.selected.wrapping.class", new Object[0]));
            } else {
                PsiMethod[] constructors;
                PsiElement navigationElement = existingClass.getNavigationElement();
                if (navigationElement instanceof PsiClass) {
                    existingClass = (PsiClass)navigationElement;
                }
                boolean foundConstructor = false;
                final HashSet<PsiType> returnTypes = new HashSet<PsiType>();
                returnTypes.add(this.myMethod.getReturnType());
                PsiCodeBlock methodBody2 = this.myMethod.getBody();
                if (methodBody2 != null) {
                    methodBody2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            super.visitReturnStatement(statement);
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                returnTypes.add(returnValue.getType());
                            }
                        }

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression2) {
                        }
                    });
                }
                block0: for (PsiMethod constructor : constructors = existingClass.getConstructors()) {
                    PsiCodeBlock body2;
                    PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
                    if (parameters2.length != 1) continue;
                    PsiParameter parameter2 = parameters2[0];
                    PsiType parameterType = parameter2.getType();
                    for (PsiType returnType : returnTypes) {
                        if (WrapReturnValueProcessor.getInferredType(parameterType, returnType, existingClass, this.myMethod) != null || TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)returnType)) continue;
                        continue block0;
                    }
                    if (!PsiUtil.isAccessible((PsiMember)constructor, (PsiElement)this.myMethod, null) || (body2 = constructor.getBody()) == null) continue;
                    final boolean[] found = new boolean[1];
                    body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                            super.visitAssignmentExpression(expression2);
                            PsiExpression lExpression = expression2.getLExpression();
                            if (lExpression instanceof PsiReferenceExpression && WrapReturnValueProcessor.this.myDelegateField.isEquivalentTo(((PsiReferenceExpression)lExpression).resolve())) {
                                found[0] = true;
                            }
                        }
                    });
                    if (!found[0]) continue;
                    foundConstructor = true;
                    break;
                }
                if (!foundConstructor) {
                    conflicts.putValue((Object)existingClass, (Object)"Existing class does not have appropriate constructor");
                }
            }
            if (this.myUnwrapMethodName.length() == 0) {
                conflicts.putValue((Object)existingClass, (Object)"Existing class does not have getter for selected field");
            }
        } else {
            if (existingClass != null) {
                conflicts.putValue((Object)existingClass, (Object)RefactorJBundle.message("there.already.exists.a.class.with.the.selected.name", new Object[0]));
            }
            if (this.myMoveDestination != null && !this.myMoveDestination.isTargetAccessible(this.myProject, this.myMethod.getContainingFile().getVirtualFile())) {
                conflicts.putValue((Object)this.myMethod, (Object)"Created class won't be accessible in the call place");
            }
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            WrapReturnValueProcessor.$$$reportNull$$$0(4);
        }
        if (!this.myUseExistingClass && !this.buildClass()) {
            return;
        }
        super.performRefactoring(usageInfos);
    }

    private boolean buildClass() {
        block8: {
            String classString;
            PsiManager manager = this.myMethod.getManager();
            Project project = this.myMethod.getProject();
            ReturnValueBeanBuilder beanClassBuilder = new ReturnValueBeanBuilder();
            beanClassBuilder.setProject(project);
            beanClassBuilder.setFile(this.myMethod.getContainingFile());
            beanClassBuilder.setTypeArguments(this.myTypeParameters);
            beanClassBuilder.setClassName(this.myClassName);
            beanClassBuilder.setPackageName(this.myPackageName);
            beanClassBuilder.setStatic(this.myCreateInnerClass && this.myMethod.hasModifierProperty("static"));
            PsiType returnType = this.myMethod.getReturnType();
            beanClassBuilder.setValueType(returnType);
            try {
                classString = beanClassBuilder.buildBeanClass();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
            try {
                PsiDirectory directory;
                PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
                PsiJavaFile psiFile = (PsiJavaFile)factory.createFileFromText(this.myClassName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)classString);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                if (this.myCreateInnerClass) {
                    PsiClass containingClass = this.myMethod.getContainingClass();
                    PsiElement innerClass = containingClass.add((PsiElement)psiFile.getClasses()[0]);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(innerClass);
                    break block8;
                }
                PsiFile containingFile = this.myMethod.getContainingFile();
                PsiDirectory containingDirectory = containingFile.getContainingDirectory();
                if (this.myMoveDestination != null) {
                    directory = this.myMoveDestination.getTargetDirectory(containingDirectory);
                } else {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
                    directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.myPackageName, containingDirectory, true, true);
                }
                if (directory != null) {
                    PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)psiFile);
                    PsiElement reformattedFile = codeStyleManager.reformat(shortenedFile);
                    directory.add(reformattedFile);
                    break block8;
                }
                return false;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected String getCommandName() {
        PsiClass containingClass = this.myMethod.getContainingClass();
        String string = RefactorJBundle.message("wrapped.return.command.name", this.myClassName, containingClass.getName(), Character.valueOf('.'), this.myMethod.getName());
        if (string == null) {
            WrapReturnValueProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/wrapreturnvalue/WrapReturnValueProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/wrapreturnvalue/WrapReturnValueProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ReturnSearchVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final List<FixableUsageInfo> usages;
        private final String type;

        ReturnSearchVisitor(List<FixableUsageInfo> usages, String type2) {
            this.usages = usages;
            this.type = type2;
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethodCallExpression callExpression;
            super.visitReturnStatement(statement);
            PsiExpression returnValue = statement.getReturnValue();
            if (WrapReturnValueProcessor.this.myUseExistingClass && returnValue instanceof PsiMethodCallExpression && (callExpression = (PsiMethodCallExpression)returnValue).getArgumentList().isEmpty()) {
                PsiType qualifierType;
                PsiExpression qualifier;
                PsiReferenceExpression callMethodExpression = callExpression.getMethodExpression();
                String methodName = callMethodExpression.getReferenceName();
                if (Comparing.strEqual((String)WrapReturnValueProcessor.this.myUnwrapMethodName, (String)methodName) && (qualifier = callMethodExpression.getQualifierExpression()) != null && (qualifierType = qualifier.getType()) != null && qualifierType.getCanonicalText().equals(WrapReturnValueProcessor.this.myQualifiedName)) {
                    this.usages.add(new ReturnWrappedValue(statement));
                    return;
                }
            }
            this.usages.add(new WrapReturnValue(statement, this.type));
        }
    }
}

