/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExpressionReturnValue;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.FieldReturnValue;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Match {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.Match");
    private final PsiElement myMatchStart;
    private final PsiElement myMatchEnd;
    private final Map<PsiVariable, List<PsiElement>> myParameterValues = new HashMap<PsiVariable, List<PsiElement>>();
    private final Map<PsiVariable, List<PsiElement>> myParameterOccurrences = new HashMap<PsiVariable, List<PsiElement>>();
    private final Map<PsiElement, PsiElement> myDeclarationCorrespondence = new HashMap<PsiElement, PsiElement>();
    private ReturnValue myReturnValue;
    private Ref<PsiExpression> myInstanceExpression;
    final Map<PsiVariable, PsiType> myChangedParams = new HashMap<PsiVariable, PsiType>();
    private final boolean myIgnoreParameterTypes;
    private final List<ExtractedParameter> myExtractedParameters = new ArrayList<ExtractedParameter>();
    private final Map<DuplicatesFinder.Parameter, List<Pair.NonNull<PsiExpression, PsiExpression>>> myFoldedExpressionMappings = new HashMap<DuplicatesFinder.Parameter, List<Pair.NonNull<PsiExpression, PsiExpression>>>();

    Match(PsiElement start, PsiElement end, boolean ignoreParameterTypes) {
        LOG.assertTrue(start.getParent() == end.getParent());
        this.myMatchStart = start;
        this.myMatchEnd = end;
        this.myIgnoreParameterTypes = ignoreParameterTypes;
    }

    public PsiElement getMatchStart() {
        return this.myMatchStart;
    }

    public PsiElement getMatchEnd() {
        return this.myMatchEnd;
    }

    public PsiElement[] getMatchElements() {
        return (PsiElement[])StreamEx.iterate((Object)this.myMatchStart, Objects::nonNull, element -> element != this.myMatchEnd ? element.getNextSibling() : null).toArray((Object[])PsiElement.EMPTY_ARRAY);
    }

    @Nullable
    public List<PsiElement> getParameterValues(PsiVariable parameter2) {
        return this.myParameterValues.get(parameter2);
    }

    public ReturnValue getOutputVariableValue(PsiVariable outputParameter) {
        PsiElement decl = this.myDeclarationCorrespondence.get(outputParameter);
        if (decl instanceof PsiVariable) {
            return new VariableReturnValue((PsiVariable)decl);
        }
        List<PsiElement> parameterValue = this.getParameterValues(outputParameter);
        if (parameterValue != null && parameterValue.size() == 1 && parameterValue.get(0) instanceof PsiExpression) {
            return new ExpressionReturnValue((PsiExpression)parameterValue.get(0));
        }
        return null;
    }

    public boolean putParameter(DuplicatesFinder.Parameter parameter2, PsiElement value2) {
        boolean isVararg;
        PsiVariable psiVariable = parameter2.getVariable();
        if (this.myDeclarationCorrespondence.get(psiVariable) == null) {
            final boolean[] valueDependsOnReplacedScope = new boolean[1];
            value2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    PsiElement resolved = expression2.resolve();
                    if (resolved != null && Comparing.equal((Object)resolved.getContainingFile(), (Object)Match.this.getMatchEnd().getContainingFile())) {
                        TextRange range = Match.checkRange(resolved);
                        TextRange startRange = Match.checkRange(Match.this.getMatchStart());
                        TextRange endRange = Match.checkRange(Match.this.getMatchEnd());
                        if (startRange.getStartOffset() <= range.getStartOffset() && range.getEndOffset() <= endRange.getEndOffset()) {
                            valueDependsOnReplacedScope[0] = true;
                        }
                    }
                }
            });
            if (valueDependsOnReplacedScope[0]) {
                return false;
            }
        }
        List<PsiElement> currentValue = this.myParameterValues.get(psiVariable);
        boolean bl = isVararg = psiVariable instanceof PsiParameter && ((PsiParameter)psiVariable).isVarArgs();
        if (!(value2 instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)value2).getType();
        PsiType parameterType = parameter2.getType();
        if (type2 == null) {
            return false;
        }
        if (currentValue == null) {
            if (parameterType instanceof PsiClassType && ((PsiClassType)parameterType).resolve() instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)((PsiClassType)parameterType).resolve();
                LOG.assertTrue(typeParameter != null);
                for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                    if (classType.isAssignableFrom(type2)) continue;
                    return false;
                }
            } else if (isVararg) {
                if (!((PsiEllipsisType)psiVariable.getType()).getComponentType().isAssignableFrom(type2) && !((PsiEllipsisType)psiVariable.getType()).toArrayType().equals(type2)) {
                    this.myChangedParams.put(psiVariable, (PsiType)new PsiEllipsisType(parameterType));
                }
            } else if (!this.myIgnoreParameterTypes && !parameterType.isAssignableFrom(type2)) {
                return false;
            }
            ArrayList<PsiElement> values = new ArrayList<PsiElement>();
            values.add(value2);
            this.myParameterValues.put(psiVariable, values);
            ArrayList elements = new ArrayList();
            this.myParameterOccurrences.put(psiVariable, elements);
            return true;
        }
        for (PsiElement val : currentValue) {
            if (isVararg || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)val, (PsiElement)value2)) continue;
            return false;
        }
        if (isVararg) {
            if (!parameterType.isAssignableFrom(type2)) {
                return false;
            }
            if (!((PsiEllipsisType)psiVariable.getType()).toArrayType().equals(type2)) {
                currentValue.add(value2);
            }
        }
        this.myParameterOccurrences.get(psiVariable).add(value2);
        return true;
    }

    public ReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    boolean registerReturnValue(ReturnValue returnValue) {
        if (this.myReturnValue == null) {
            this.myReturnValue = returnValue;
            return true;
        }
        return this.myReturnValue.isEquivalent(returnValue);
    }

    boolean registerInstanceExpression(PsiExpression instanceExpression, PsiClass contextClass) {
        if (this.myInstanceExpression == null) {
            if (instanceExpression != null) {
                PsiType type2 = instanceExpression.getType();
                if (!(type2 instanceof PsiClassType)) {
                    return false;
                }
                PsiClass hisClass = ((PsiClassType)type2).resolve();
                if (hisClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)hisClass, (PsiClass)contextClass, (boolean)true)) {
                    return false;
                }
            }
            this.myInstanceExpression = Ref.create((Object)instanceExpression);
            return true;
        }
        if (this.myInstanceExpression.get() == null) {
            this.myInstanceExpression.set((Object)instanceExpression);
            return instanceExpression == null;
        }
        if (instanceExpression != null) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)instanceExpression, (PsiElement)((PsiElement)this.myInstanceExpression.get()));
        }
        return this.myInstanceExpression.get() == null || this.myInstanceExpression.get() instanceof PsiThisExpression;
    }

    boolean putDeclarationCorrespondence(PsiElement patternDeclaration, @NotNull PsiElement matchDeclaration) {
        PsiElement originalValue;
        if (matchDeclaration == null) {
            Match.$$$reportNull$$$0(0);
        }
        if ((originalValue = this.myDeclarationCorrespondence.get(patternDeclaration)) == null) {
            this.myDeclarationCorrespondence.put(patternDeclaration, matchDeclaration);
            return true;
        }
        return originalValue == matchDeclaration;
    }

    boolean areCorrespond(PsiElement patternDeclaration, PsiElement matchDeclaration) {
        if (matchDeclaration == null || patternDeclaration == null) {
            return false;
        }
        PsiElement originalValue = this.myDeclarationCorrespondence.get(patternDeclaration);
        return originalValue == null || originalValue == matchDeclaration;
    }

    private PsiElement replaceWith(PsiStatement statement) throws IncorrectOperationException {
        PsiElement matchStart = this.getMatchStart();
        PsiElement matchEnd = this.getMatchEnd();
        PsiElement element = matchStart.getParent().addBefore((PsiElement)statement, matchStart);
        matchStart.getParent().deleteChildRange(matchStart, matchEnd);
        return element;
    }

    public PsiElement replaceByStatement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression, PsiVariable outputVariable) throws IncorrectOperationException {
        PsiStatement statement = null;
        if (outputVariable != null) {
            ReturnValue returnValue = this.getOutputVariableValue(outputVariable);
            if (returnValue == null && outputVariable instanceof PsiField) {
                returnValue = new FieldReturnValue((PsiField)outputVariable);
            }
            if (returnValue == null) {
                return null;
            }
            statement = returnValue.createReplacement(extractedMethod, methodCallExpression);
        } else if (this.getReturnValue() != null) {
            statement = this.getReturnValue().createReplacement(extractedMethod, methodCallExpression);
        }
        if (statement == null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)elementFactory.createStatementFromText("x();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((PsiManager)methodCallExpression.getManager());
            expressionStatement = (PsiExpressionStatement)styleManager.reformat((PsiElement)expressionStatement);
            expressionStatement.getExpression().replace((PsiElement)methodCallExpression);
            statement = expressionStatement;
        }
        return this.replaceWith(statement);
    }

    public PsiExpression getInstanceExpression() {
        if (this.myInstanceExpression == null) {
            return null;
        }
        return (PsiExpression)this.myInstanceExpression.get();
    }

    public PsiElement replace(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression, PsiVariable outputVariable) throws IncorrectOperationException {
        this.declareLocalVariables();
        if (this.getMatchStart() == this.getMatchEnd() && this.getMatchStart() instanceof PsiExpression) {
            return this.replaceWithExpression((PsiExpression)methodCallExpression);
        }
        return this.replaceByStatement(extractedMethod, methodCallExpression, outputVariable);
    }

    private void declareLocalVariables() throws IncorrectOperationException {
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(this.getMatchStart());
        try {
            Project project = this.getMatchStart().getProject();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false, false);
            int endOffset = controlFlow.getEndOffset(this.getMatchEnd());
            int startOffset = controlFlow.getStartOffset(this.getMatchStart());
            List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(controlFlow, endOffset, controlFlow.getSize());
            Collection<ControlFlowUtil.VariableInfo> reassigned = ControlFlowUtil.getInitializedTwice(controlFlow, endOffset, controlFlow.getSize());
            Collection<PsiVariable> outVariables = ControlFlowUtil.getWrittenVariables(controlFlow, startOffset, endOffset, false);
            for (PsiVariable variable : usedVariables) {
                PsiIdentifier identifier;
                if (outVariables.contains(variable) || (identifier = variable.getNameIdentifier()) == null) continue;
                TextRange textRange = Match.checkRange((PsiElement)identifier);
                TextRange startRange = Match.checkRange(this.getMatchStart());
                TextRange endRange = Match.checkRange(this.getMatchEnd());
                if (textRange.getStartOffset() < startRange.getStartOffset() || textRange.getEndOffset() > endRange.getEndOffset()) continue;
                String name = variable.getName();
                LOG.assertTrue(name != null);
                PsiDeclarationStatement statement = JavaPsiFacade.getInstance((Project)project).getElementFactory().createVariableDeclarationStatement(name, variable.getType(), null);
                if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                    PsiElement[] psiElements = statement.getDeclaredElements();
                    PsiModifierList modifierList = ((PsiVariable)psiElements[0]).getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("final", false);
                }
                this.getMatchStart().getParent().addBefore((PsiElement)statement, this.getMatchStart());
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    private static TextRange checkRange(PsiElement element) {
        TextRange endRange = element.getTextRange();
        LOG.assertTrue(endRange != null, (Object)element);
        return endRange;
    }

    public PsiElement replaceWithExpression(PsiExpression psiExpression) throws IncorrectOperationException {
        PsiElement matchStart = this.getMatchStart();
        LOG.assertTrue(matchStart == this.getMatchEnd());
        if (psiExpression instanceof PsiMethodCallExpression && matchStart instanceof PsiReferenceExpression && matchStart.getParent() instanceof PsiMethodCallExpression) {
            return JavaCodeStyleManager.getInstance((Project)matchStart.getProject()).shortenClassReferences(matchStart.replace((PsiElement)((PsiMethodCallExpression)psiExpression).getMethodExpression()));
        }
        return JavaCodeStyleManager.getInstance((Project)matchStart.getProject()).shortenClassReferences(matchStart.replace((PsiElement)psiExpression));
    }

    TextRange getTextRange() {
        TextRange startRange = Match.checkRange(this.getMatchStart());
        TextRange endRange = Match.checkRange(this.getMatchEnd());
        return new TextRange(startRange.getStartOffset(), endRange.getEndOffset());
    }

    @Nullable
    public PsiType getChangedReturnType(PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        if (returnType != null) {
            PsiElement parent = this.getMatchEnd().getParent();
            if (parent instanceof PsiExpression) {
                JavaPsiFacade facade;
                PsiClassType expressionType;
                PsiClass psiClass;
                JavaResolveResult result;
                PsiElement element;
                if (parent instanceof PsiMethodCallExpression) {
                    PsiType type2;
                    JavaResolveResult result2 = ((PsiMethodCallExpression)parent).resolveMethodGenerics();
                    PsiMethod method = (PsiMethod)result2.getElement();
                    if (method != null && (type2 = method.getReturnType()) != null && Match.weakerType(psiMethod, returnType, type2 = result2.getSubstitutor().substitute(type2))) {
                        return type2;
                    }
                } else if (parent instanceof PsiReferenceExpression && (element = (result = ((PsiReferenceExpression)parent).advancedResolve(false)).getElement()) instanceof PsiMember && (psiClass = ((PsiMember)element).getContainingClass()) != null && psiClass.isPhysical() && Match.weakerType(psiMethod, returnType, (PsiType)(expressionType = (facade = JavaPsiFacade.getInstance((Project)parent.getProject())).getElementFactory().createType(psiClass, result.getSubstitutor())))) {
                    return expressionType;
                }
            } else if (parent instanceof PsiExpressionList) {
                JavaResolveResult result;
                PsiMethod method;
                Object[] expressions2 = ((PsiExpressionList)parent).getExpressions();
                PsiElement call = parent.getParent();
                if (call instanceof PsiMethodCallExpression && (method = (PsiMethod)(result = ((PsiMethodCallExpression)call).resolveMethodGenerics()).getElement()) != null) {
                    int idx = ArrayUtil.find((Object[])expressions2, (Object)this.getMatchEnd());
                    PsiParameter[] psiParameters = method.getParameterList().getParameters();
                    if (idx >= 0 && idx < psiParameters.length) {
                        PsiType type3 = result.getSubstitutor().substitute(psiParameters[idx].getType());
                        if (type3 instanceof PsiEllipsisType) {
                            type3 = ((PsiEllipsisType)type3).getComponentType();
                        }
                        if (Match.weakerType(psiMethod, returnType, type3)) {
                            return type3;
                        }
                    }
                }
            } else if (parent instanceof PsiLocalVariable) {
                PsiType localVariableType = ((PsiLocalVariable)parent).getType();
                if (Match.weakerType(psiMethod, returnType, localVariableType)) {
                    return localVariableType;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod replacedMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                LOG.assertTrue(replacedMethod != null);
                PsiType replacedMethodReturnType = replacedMethod.getReturnType();
                if (replacedMethodReturnType != null && Match.weakerType(psiMethod, returnType, replacedMethodReturnType)) {
                    return replacedMethodReturnType;
                }
            }
        }
        return null;
    }

    private static boolean weakerType(PsiMethod psiMethod, PsiType returnType, @NotNull PsiType currentType) {
        if (currentType == null) {
            Match.$$$reportNull$$$0(1);
        }
        PsiTypeParameter[] typeParameters = psiMethod.getTypeParameters();
        PsiSubstitutor substitutor = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getResolveHelper().inferTypeArguments(typeParameters, new PsiType[]{returnType}, new PsiType[]{currentType}, PsiUtil.getLanguageLevel((PsiElement)psiMethod));
        return !TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)substitutor.substitute(returnType));
    }

    public PsiFile getFile() {
        return this.getMatchStart().getContainingFile();
    }

    public boolean putExtractedParameter(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart) {
        if (patternPart == null) {
            Match.$$$reportNull$$$0(2);
        }
        if (candidatePart == null) {
            Match.$$$reportNull$$$0(3);
        }
        return ExtractedParameter.match(patternPart, candidatePart, this.myExtractedParameters);
    }

    public void addExtractedParameter(@NotNull ExtractedParameter parameter2) {
        if (parameter2 == null) {
            Match.$$$reportNull$$$0(4);
        }
        this.myExtractedParameters.add(parameter2);
    }

    @NotNull
    public List<ExtractedParameter> getExtractedParameters() {
        List<ExtractedParameter> list = this.myExtractedParameters;
        if (list == null) {
            Match.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void putFoldedExpressionMapping(@NotNull DuplicatesFinder.Parameter parameter2, @NotNull PsiExpression pattern, @NotNull PsiExpression candidate) {
        if (parameter2 == null) {
            Match.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            Match.$$$reportNull$$$0(7);
        }
        if (candidate == null) {
            Match.$$$reportNull$$$0(8);
        }
        this.myFoldedExpressionMappings.computeIfAbsent(parameter2, unused -> new ArrayList()).add(Pair.createNonNull((Object)pattern, (Object)candidate));
    }

    @Nullable
    public List<Pair.NonNull<PsiExpression, PsiExpression>> getFoldedExpressionMappings(@NotNull DuplicatesFinder.Parameter parameter2) {
        if (parameter2 == null) {
            Match.$$$reportNull$$$0(9);
        }
        return this.myFoldedExpressionMappings.get(parameter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternPart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidatePart";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/Match";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/Match";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putDeclarationCorrespondence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "weakerType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putExtractedParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExtractedParameter";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putFoldedExpressionMapping";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFoldedExpressionMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

