/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ComplexityHolder;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractableExpressionPart {
    final PsiExpression myUsage;
    final PsiVariable myVariable;
    final Object myValue;
    final PsiType myType;

    private ExtractableExpressionPart(@NotNull PsiExpression usage, PsiVariable variable, Object value2, @NotNull PsiType type2) {
        if (usage == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(1);
        }
        this.myUsage = usage;
        this.myVariable = variable;
        this.myValue = value2;
        this.myType = type2;
    }

    @Nullable
    static PsiType commonType(@NotNull ExtractableExpressionPart part1, @NotNull ExtractableExpressionPart part2) {
        if (part1 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(2);
        }
        if (part2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(3);
        }
        return ExtractableExpressionPart.commonType(part1.myType, part2.myType);
    }

    @Nullable
    private static PsiType commonType(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(5);
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return null;
    }

    @NotNull
    ExtractableExpressionPart copy() {
        ExtractableExpressionPart extractableExpressionPart = new ExtractableExpressionPart(this.myUsage, this.myVariable, this.myValue, this.myType);
        if (extractableExpressionPart == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(6);
        }
        return extractableExpressionPart;
    }

    @NotNull
    ExtractableExpressionPart deepCopy() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myUsage.getProject());
        PsiExpression usageCopy = factory.createExpressionFromText(this.myUsage.getText(), (PsiElement)this.myUsage);
        ExtractableExpressionPart extractableExpressionPart = new ExtractableExpressionPart(usageCopy, this.myVariable, this.myValue, this.myType);
        if (extractableExpressionPart == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(7);
        }
        return extractableExpressionPart;
    }

    boolean isEquivalent(@NotNull ExtractableExpressionPart part) {
        if (part == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(8);
        }
        if (this.myVariable != null && this.myVariable.equals(part.myVariable)) {
            return true;
        }
        if (this.myValue != null && this.myValue.equals(part.myValue)) {
            return true;
        }
        return JavaPsiEquivalenceUtil.areExpressionsEquivalent(PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myUsage), PsiUtil.skipParenthesizedExprDown((PsiExpression)part.myUsage));
    }

    @Nullable
    static ExtractableExpressionPart match(@NotNull PsiExpression expression2, @NotNull List<PsiElement> scope, @Nullable ComplexityHolder complexityHolder) {
        if (expression2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(10);
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return ExtractableExpressionPart.matchVariable((PsiReferenceExpression)expression2, scope);
        }
        boolean isConstant = PsiUtil.isConstantExpression((PsiExpression)expression2);
        if (isConstant && PsiTreeUtil.findChildOfType((PsiElement)expression2, PsiJavaCodeReferenceElement.class) == null) {
            return ExtractableExpressionPart.matchConstant(expression2);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
            return null;
        }
        if (complexityHolder != null && (isConstant || complexityHolder.isAcceptableExpression(expression2))) {
            return ExtractableExpressionPart.matchExpression(expression2);
        }
        return null;
    }

    @Nullable
    private static ExtractableExpressionPart matchConstant(@NotNull PsiExpression expression2) {
        PsiType type2;
        PsiConstantEvaluationHelper constantHelper;
        Object value2;
        if (expression2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(11);
        }
        if ((value2 = (constantHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)expression2, false)) != null && (type2 = expression2.getType()) != null) {
            return new ExtractableExpressionPart(expression2, null, value2, type2);
        }
        return null;
    }

    @Nullable
    static ExtractableExpressionPart matchVariable(@NotNull PsiReferenceExpression expression2, @Nullable List<PsiElement> scope) {
        PsiElement resolved;
        if (expression2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(12);
        }
        if ((resolved = expression2.resolve()) instanceof PsiField && ExtractableExpressionPart.isModification(expression2)) {
            return null;
        }
        if (resolved instanceof PsiVariable && (scope == null || !DuplicatesFinder.isUnder(resolved, scope))) {
            PsiVariable variable = (PsiVariable)resolved;
            return new ExtractableExpressionPart((PsiExpression)expression2, variable, null, variable.getType());
        }
        return null;
    }

    private static boolean isModification(@NotNull PsiReferenceExpression expression2) {
        PsiUnaryExpression unary;
        IElementType tokenType;
        PsiAssignmentExpression assignment;
        PsiElement parent;
        if (expression2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(13);
        }
        return (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiAssignmentExpression ? PsiTreeUtil.isAncestor((PsiElement)(assignment = (PsiAssignmentExpression)parent).getLExpression(), (PsiElement)expression2, (boolean)false) : parent instanceof PsiUnaryExpression && ((tokenType = (unary = (PsiUnaryExpression)parent).getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) && PsiTreeUtil.isAncestor((PsiElement)unary.getOperand(), (PsiElement)expression2, (boolean)false);
    }

    @Nullable
    private static ExtractableExpressionPart matchExpression(@NotNull PsiExpression expression2) {
        PsiType type2;
        if (expression2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(14);
        }
        if ((type2 = expression2.getType()) != null && !PsiType.VOID.equals((Object)type2)) {
            return new ExtractableExpressionPart(expression2, null, null, type2);
        }
        return null;
    }

    @NotNull
    public PsiExpression getUsage() {
        PsiExpression psiExpression = this.myUsage;
        if (psiExpression == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(15);
        }
        return psiExpression;
    }

    @NotNull
    public static ExtractableExpressionPart fromUsage(@NotNull PsiExpression usage, @NotNull PsiType type2) {
        PsiType usageType;
        if (usage == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(16);
        }
        if (type2 == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(17);
        }
        assert ((usageType = usage.getType()) == null || type2.isAssignableFrom(usageType)) : "expected " + type2.getCanonicalText() + ", got " + usageType.getCanonicalText();
        ExtractableExpressionPart extractableExpressionPart = new ExtractableExpressionPart(usage, null, null, type2);
        if (extractableExpressionPart == null) {
            ExtractableExpressionPart.$$$reportNull$$$0(18);
        }
        return extractableExpressionPart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/ExtractableExpressionPart";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractableExpressionPart";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commonType";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchConstant";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchVariable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isModification";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fromUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

