/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InlineUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.util.InlineUtil");

    private InlineUtil() {
    }

    @NotNull
    public static PsiExpression inlineVariable(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref) throws IncorrectOperationException {
        PsiExpression psiExpression = InlineUtil.inlineVariable(variable, initializer, ref, null);
        if (psiExpression == null) {
            InlineUtil.$$$reportNull$$$0(0);
        }
        return psiExpression;
    }

    @NotNull
    public static PsiExpression inlineVariable(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref, PsiExpression thisAccessExpr) throws IncorrectOperationException {
        PsiType exprType;
        PsiType type2;
        IElementType operationTokenType;
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiResourceExpression) {
            LOG.error("Unable to inline resource reference");
            PsiExpression psiExpression = (PsiExpression)ref;
            if (psiExpression == null) {
                InlineUtil.$$$reportNull$$$0(1);
            }
            return psiExpression;
        }
        PsiManager manager = initializer.getManager();
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)initializer);
        PsiClass refParent = RefactoringChangeUtil.getThisClass((PsiElement)ref);
        PsiType varType = variable.getType();
        if ((initializer = RefactoringUtil.convertInitializerToNormalExpression(initializer, varType)) instanceof PsiPolyadicExpression && ((operationTokenType = ((PsiPolyadicExpression)initializer).getOperationTokenType()) == JavaTokenType.PLUS || operationTokenType == JavaTokenType.MINUS) && parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType() == JavaTokenType.PLUS && (type2 = ((PsiPolyadicExpression)parent).getType()) != null && type2.equalsToText("java.lang.String")) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)initializer.getProject());
            initializer = factory.createExpressionFromText("(" + initializer.getText() + ")", (PsiElement)initializer);
        }
        InlineUtil.solveVariableNameConflicts((PsiElement)initializer, (PsiElement)ref, (PsiElement)initializer);
        ChangeContextUtil.encodeContextInfo((PsiElement)initializer, false);
        PsiExpression expr = (PsiExpression)InlineUtil.replaceDiamondWithInferredTypesIfNeeded(initializer, (PsiElement)ref);
        if (thisAccessExpr == null) {
            thisAccessExpr = InlineUtil.createThisExpression(manager, thisClass, refParent);
        }
        if ((exprType = RefactoringUtil.getTypeByExpression(expr = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)expr, thisClass, thisAccessExpr))) != null && !exprType.equals(varType)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiMethod method = InlineUtil.qualifyWithExplicitTypeArguments(initializer, expr, varType);
            if (method != null) {
                PsiReferenceExpression methodExpression;
                PsiExpression qualifierExpression2;
                if (expr instanceof PsiMethodCallExpression && (qualifierExpression2 = (methodExpression = ((PsiMethodCallExpression)expr).getMethodExpression()).getQualifierExpression()) == null) {
                    PsiClass containingClass = method.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    if (method.getModifierList().hasModifierProperty("static")) {
                        methodExpression.setQualifierExpression((PsiExpression)elementFactory.createReferenceExpression(containingClass));
                    } else {
                        methodExpression.setQualifierExpression((PsiExpression)InlineUtil.createThisExpression(method.getManager(), thisClass, refParent));
                    }
                }
            } else if (varType instanceof PsiEllipsisType && ((PsiEllipsisType)varType).getComponentType().equals(exprType)) {
                PsiExpressionList argumentList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiExpressionList.class);
                LOG.assertTrue(argumentList != null);
                PsiExpression[] arguments = argumentList.getExpressions();
                String varargsWrapper = "new " + exprType.getCanonicalText() + "[]{" + StringUtil.join(Arrays.asList(arguments), PsiElement::getText, (String)",") + '}';
                expr.replace((PsiElement)elementFactory.createExpressionFromText(varargsWrapper, (PsiElement)argumentList));
            } else {
                boolean insertCastWhenUnchecked;
                boolean bl = insertCastWhenUnchecked = !(exprType instanceof PsiClassType) || !((PsiClassType)exprType).isRaw() || !(parent instanceof PsiExpressionList);
                if (expr instanceof PsiFunctionalExpression || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expr) && insertCastWhenUnchecked) {
                    expr = InlineUtil.surroundWithCast(variable, expr);
                }
            }
        }
        ChangeContextUtil.clearContextInfo((PsiElement)initializer);
        PsiExpression psiExpression = expr;
        if (psiExpression == null) {
            InlineUtil.$$$reportNull$$$0(2);
        }
        return psiExpression;
    }

    private static PsiMethod qualifyWithExplicitTypeArguments(PsiExpression initializer, PsiExpression expr, PsiType varType) {
        PsiTypeParameter[] typeParameters;
        JavaResolveResult resolveResult;
        PsiElement resolved;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)initializer.getProject()).getElementFactory();
        if (expr instanceof PsiCallExpression && ((PsiCallExpression)expr).getTypeArguments().length == 0 && (resolved = (resolveResult = ((PsiCallExpression)initializer).resolveMethodGenerics()).getElement()) instanceof PsiMethod && (typeParameters = ((PsiMethod)resolved).getTypeParameters()).length > 0) {
            PsiCallExpression copy = (PsiCallExpression)expr.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType substituted = resolveResult.getSubstitutor().substitute(typeParameter);
                if (substituted == null) break;
                copy.getTypeArgumentList().add((PsiElement)elementFactory.createTypeElement(substituted));
            }
            if (varType.equals(copy.getType()) && copy.resolveMethodGenerics().isValidResult()) {
                ((PsiCallExpression)expr).getTypeArgumentList().replace((PsiElement)copy.getTypeArgumentList());
                return (PsiMethod)resolved;
            }
        }
        return null;
    }

    private static PsiExpression surroundWithCast(PsiVariable variable, PsiExpression expr) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr.getProject());
        PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(t)a", null);
        PsiTypeElement castTypeElement = cast.getCastType();
        assert (castTypeElement != null);
        PsiTypeElement typeElement = variable.getTypeElement();
        if (typeElement == null) {
            typeElement = factory.createTypeElement(variable.getType());
        } else if (typeElement.isInferredType()) {
            return expr;
        }
        castTypeElement.replace((PsiElement)typeElement);
        PsiExpression operand2 = cast.getOperand();
        assert (operand2 != null);
        operand2.replace((PsiElement)expr);
        expr = (PsiTypeCastExpression)expr.replace((PsiElement)cast);
        if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)expr))) {
            return RedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)expr));
        }
        return expr;
    }

    private static PsiThisExpression createThisExpression(PsiManager manager, PsiClass thisClass, PsiClass refParent) {
        PsiThisExpression thisAccessExpr = null;
        if (Comparing.equal((Object)thisClass, (Object)refParent)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression(manager, null);
        } else if (!(thisClass instanceof PsiAnonymousClass)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression(manager, thisClass);
        }
        return thisAccessExpr;
    }

    public static void tryToInlineArrayCreationForVarargs(PsiExpression expr) {
        PsiExpressionList exprList;
        if (expr instanceof PsiNewExpression && ((PsiNewExpression)expr).getArrayInitializer() != null && expr.getParent() instanceof PsiExpressionList && (exprList = (PsiExpressionList)expr.getParent()).getParent() instanceof PsiCall && InlineUtil.isSafeToInlineVarargsArgument((PsiCall)exprList.getParent())) {
            InlineUtil.inlineArrayCreationForVarargs((PsiNewExpression)expr);
        }
    }

    public static void inlineArrayCreationForVarargs(PsiNewExpression arrayCreation) {
        PsiExpressionList argumentList = (PsiExpressionList)arrayCreation.getParent();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] args = argumentList.getExpressions();
        PsiArrayInitializerExpression arrayInitializer = arrayCreation.getArrayInitializer();
        try {
            if (arrayInitializer == null) {
                arrayCreation.delete();
                return;
            }
            CommentTracker cm = new CommentTracker();
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            if (initializers.length > 0) {
                PsiExpression firstElement;
                PsiElement leadingComment;
                PsiElement nextSibling;
                PsiExpression lastInitializerSibling = initializers[initializers.length - 1];
                while (lastInitializerSibling != null && (nextSibling = lastInitializerSibling.getNextSibling()) != null && nextSibling.getNode().getElementType() != JavaTokenType.RBRACE) {
                    lastInitializerSibling = nextSibling;
                }
                if (lastInitializerSibling instanceof PsiWhiteSpace) {
                    lastInitializerSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)lastInitializerSibling);
                }
                if (lastInitializerSibling.getNode().getElementType() == JavaTokenType.COMMA) {
                    lastInitializerSibling = lastInitializerSibling.getPrevSibling();
                }
                if ((leadingComment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)(firstElement = initializers[0]))) instanceof PsiComment) {
                    firstElement = leadingComment;
                }
                argumentList.addRange((PsiElement)firstElement, (PsiElement)lastInitializerSibling);
                cm.markRangeUnchanged((PsiElement)firstElement, (PsiElement)lastInitializerSibling);
            }
            cm.deleteAndRestoreComments((PsiElement)args[args.length - 1]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean isSafeToInlineVarargsArgument(PsiCall expression2) {
        JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
        PsiElement element = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (element instanceof PsiMethod && ((PsiMethod)element).isVarArgs()) {
            PsiExpression[] args;
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList != null && parameters2.length == (args = argumentList.getExpressions()).length) {
                PsiType lastArgType;
                PsiExpression lastArg = args[args.length - 1];
                PsiParameter lastParameter = parameters2[args.length - 1];
                PsiType lastParamType = lastParameter.getType();
                LOG.assertTrue(lastParamType instanceof PsiEllipsisType);
                if (lastArg instanceof PsiNewExpression && (lastArgType = lastArg.getType()) != null && substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType()).isAssignableFrom(lastArgType)) {
                    PsiExpression[] initializers;
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)lastArg).getArrayInitializer();
                    PsiExpression[] psiExpressionArray = initializers = arrayInitializer != null ? arrayInitializer.getInitializers() : PsiExpression.EMPTY_ARRAY;
                    if (InlineUtil.isSafeToFlatten(expression2, method, initializers)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isSafeToFlatten(PsiCall callExpression, PsiMethod oldRefMethod, PsiExpression[] arrayElements) {
        for (PsiExpression arrayElement : arrayElements) {
            if (!(arrayElement instanceof PsiArrayInitializerExpression)) continue;
            return false;
        }
        PsiCall copy = (PsiCall)callExpression.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        LOG.assertTrue(copyArgumentList != null);
        PsiExpression[] args = copyArgumentList.getExpressions();
        try {
            args[args.length - 1].delete();
            if (arrayElements.length > 0) {
                copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
            }
            return copy.resolveMethod() == oldRefMethod;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public static boolean allUsagesAreTailCalls(PsiMethod method) {
        List nonTailCallUsages = Collections.synchronizedList(new ArrayList());
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)method).forEach(psiReference -> {
            ProgressManager.checkCanceled();
            if (InlineUtil.getTailCallType(psiReference) == TailCallType.None) {
                nonTailCallUsages.add(psiReference);
                return false;
            }
            return true;
        }), RefactoringBundle.message((String)"inline.method.checking.tail.calls.progress"), true, method.getProject());
        return result && nonTailCallUsages.isEmpty();
    }

    public static TailCallType getTailCallType(@NotNull PsiReference psiReference) {
        PsiElement element;
        if (psiReference == null) {
            InlineUtil.$$$reportNull$$$0(3);
        }
        if ((element = psiReference.getElement()) instanceof PsiMethodReferenceExpression) {
            return TailCallType.Return;
        }
        PsiExpression methodCall = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (methodCall == null) {
            return TailCallType.None;
        }
        PsiElement callParent = methodCall.getParent();
        if (callParent instanceof PsiReturnStatement || callParent instanceof PsiLambdaExpression) {
            return TailCallType.Return;
        }
        if (callParent instanceof PsiExpressionStatement) {
            PsiStatement curElement = (PsiStatement)callParent;
            while (true) {
                if (PsiTreeUtil.getNextSiblingOfType((PsiElement)curElement, PsiStatement.class) != null) {
                    return TailCallType.None;
                }
                PsiElement parent = curElement.getParent();
                if (parent instanceof PsiCodeBlock) {
                    PsiElement blockParent = parent.getParent();
                    if (blockParent instanceof PsiMethod || blockParent instanceof PsiLambdaExpression) {
                        return TailCallType.Simple;
                    }
                    if (!(blockParent instanceof PsiBlockStatement)) {
                        return TailCallType.None;
                    }
                    parent = blockParent.getParent();
                }
                if (!(parent instanceof PsiLabeledStatement) && !(parent instanceof PsiIfStatement)) {
                    return TailCallType.None;
                }
                curElement = (PsiStatement)parent;
            }
        }
        return TailCallType.None;
    }

    public static void substituteTypeParams(PsiElement scope, final PsiSubstitutor substitutor, final PsiElementFactory factory) {
        final HashMap replacement = new HashMap();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiElement resolved;
                super.visitTypeElement(typeElement);
                PsiType type2 = typeElement.getType();
                if (type2 instanceof PsiClassType && (resolved = (resolveResult = ((PsiClassType)type2).resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                    PsiType newType = resolveResult.getSubstitutor().putAll(substitutor).substitute((PsiTypeParameter)resolved);
                    if (newType instanceof PsiCapturedWildcardType) {
                        newType = ((PsiCapturedWildcardType)newType).getUpperBound();
                    }
                    if (newType instanceof PsiWildcardType) {
                        newType = ((PsiWildcardType)newType).getBound();
                    }
                    if (newType == null) {
                        newType = PsiType.getJavaLangObject((PsiManager)resolved.getManager(), (GlobalSearchScope)resolved.getResolveScope());
                    }
                    try {
                        replacement.put(typeElement, factory.createTypeElement(newType));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        for (PsiElement element : replacement.keySet()) {
            if (!element.isValid()) continue;
            element.replace((PsiElement)replacement.get(element));
        }
    }

    private static PsiElement replaceDiamondWithInferredTypesIfNeeded(PsiExpression initializer, PsiElement ref) {
        PsiDiamondType.DiamondInferenceResult inferenceResult;
        PsiDiamondType diamondType;
        if (initializer instanceof PsiNewExpression && (diamondType = PsiDiamondType.getDiamondType((PsiNewExpression)((PsiNewExpression)initializer))) != null && (inferenceResult = diamondType.resolveInferredTypes()).getErrorMessage() == null) {
            PsiElement copy = ref.copy();
            PsiElement parent = ref.replace((PsiElement)initializer);
            PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypes((PsiNewExpression)initializer, parent);
            ref = parent.replace(copy);
            if (!result.equals((Object)inferenceResult)) {
                String inferredTypeText = StringUtil.join((Object[])inferenceResult.getTypes(), psiType -> psiType.getCanonicalText(), (String)", ");
                PsiExpressionList argumentList = ((PsiNewExpression)initializer).getArgumentList();
                if (argumentList != null) {
                    PsiJavaCodeReferenceElement classReference2 = ((PsiNewExpression)initializer).getClassOrAnonymousClassReference();
                    LOG.assertTrue(classReference2 != null);
                    PsiExpression expression2 = JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createExpressionFromText("new " + classReference2.getReferenceName() + "<" + inferredTypeText + ">" + argumentList.getText(), (PsiElement)initializer);
                    return ref.replace((PsiElement)expression2);
                }
            }
        }
        return ref != initializer ? ref.replace((PsiElement)initializer) : initializer;
    }

    public static void solveVariableNameConflicts(PsiElement scope, PsiElement placeToInsert, PsiElement renameScope) throws IncorrectOperationException {
        PsiElement[] children;
        if (scope instanceof PsiVariable) {
            String newName;
            String name;
            PsiVariable var = (PsiVariable)scope;
            String oldName = name = var.getName();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)scope.getProject());
            while (!(newName = codeStyleManager.suggestUniqueVariableName(name, placeToInsert, true)).equals(name) && !(newName = codeStyleManager.suggestUniqueVariableName(name = newName, (PsiElement)var, true)).equals(name)) {
                name = newName;
            }
            if (!name.equals(oldName)) {
                RefactoringUtil.renameVariableReferences(var, name, (SearchScope)new LocalSearchScope(renameScope), true);
                var.getNameIdentifier().replace((PsiElement)JavaPsiFacade.getElementFactory((Project)scope.getProject()).createIdentifier(name));
            }
        }
        for (PsiElement child : children = scope.getChildren()) {
            InlineUtil.solveVariableNameConflicts(child, placeToInsert, renameScope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/InlineUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/InlineUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTailCallType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TailCallType {
        None,
        Simple,
        Return;

    }
}

