/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiPackageProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenamePsiPackageProcessor");

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PsiPackage;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, final @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(2);
        }
        RenameDialog renameDialog = new RenameDialog(project, element, nameSuggestionContext, editor){

            protected void createNewNameComponent() {
                super.createNewNameComponent();
                String qualifiedName = ((PsiPackage)element).getQualifiedName();
                String packageName = StringUtil.getPackageName((String)qualifiedName);
                this.preselectExtension(packageName.isEmpty() ? 0 : packageName.length() + 1, qualifiedName.length());
            }

            public String[] getSuggestedNames() {
                return new String[]{((PsiPackage)element).getQualifiedName()};
            }

            public String getNewName() {
                PsiPackage psiPackage = (PsiPackage)element;
                String oldName = psiPackage.getQualifiedName();
                String newName = super.getNewName();
                if (!Comparing.strEqual((String)StringUtil.getPackageName((String)oldName), (String)StringUtil.getPackageName((String)newName))) {
                    return newName;
                }
                return StringUtil.getShortName((String)newName);
            }

            protected void doAction() {
                PsiPackage psiPackage = (PsiPackage)element;
                String oldName = psiPackage.getQualifiedName();
                String newName = super.getNewName();
                if (!Comparing.strEqual((String)StringUtil.getPackageName((String)oldName), (String)StringUtil.getPackageName((String)newName))) {
                    this.invokeRefactoring((BaseRefactoringProcessor)RenamePsiPackageProcessor.createRenameMoveProcessor(newName, psiPackage, this.isSearchInComments(), this.isSearchInNonJavaFiles()));
                } else {
                    super.doAction();
                }
            }
        };
        if (renameDialog == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(3);
        }
        return renameDialog;
    }

    public static MoveDirectoryWithClassesProcessor createRenameMoveProcessor(final String newName, PsiPackage psiPackage, boolean searchInComments, boolean searchInNonJavaFiles) {
        Project project = psiPackage.getProject();
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiDirectory[] directories = psiPackage.getDirectories();
        return new MoveDirectoryWithClassesProcessor(project, directories, null, searchInComments, searchInNonJavaFiles, false, null){

            public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                VirtualFile vFile = dir.getVirtualFile();
                VirtualFile sourceRoot = index.getSourceRootForFile(vFile);
                LOG.assertTrue(sourceRoot != null, (Object)vFile.getPath());
                return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getManager().findDirectory(sourceRoot), newName.replaceAll("\\.", "\\/"));
            }

            protected String getTargetName() {
                return newName;
            }

            @NotNull
            protected String getCommandName() {
                if ("Rename package" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "Rename package";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiPackageProcessor$2", "getCommandName"));
            }
        };
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(5);
        }
        if (usages == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(6);
        }
        PsiPackage psiPackage = (PsiPackage)element;
        String shortName = StringUtil.getShortName((String)newName);
        psiPackage.handleQualifiedNameChange(PsiUtilCore.getQualifiedNameAfterRename((String)psiPackage.getQualifiedName(), (String)shortName));
        RenameUtil.doRenameGenericNamedElement((PsiElement)element, (String)shortName, (UsageInfo[])usages, (RefactoringElementListener)listener);
    }

    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(8);
        }
        return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename((PsiPackage)element, newName, nonJava);
    }

    public static String getPackageQualifiedNameAfterRename(PsiPackage element, String newName, boolean nonJava) {
        if (nonJava) {
            String qName = element.getQualifiedName();
            int index = qName.lastIndexOf(46);
            return index < 0 ? newName : qName.substring(0, index + 1) + newName;
        }
        return newName;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(10);
        }
        if (conflicts == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(11);
        }
        PsiPackage aPackage = (PsiPackage)element;
        Project project = element.getProject();
        String qualifiedNameAfterRename = RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(aPackage, newName, true);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedNameAfterRename, GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            conflicts.putValue((Object)psiClass, (Object)("Class with qualified name '" + qualifiedNameAfterRename + "'  already exist"));
        }
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(13);
        }
        if (allRenames == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(14);
        }
        RenamePsiPackageProcessor.preparePackageRenaming((PsiPackage)element, newName, allRenames);
    }

    public static void preparePackageRenaming(PsiPackage psiPackage, String newName, Map<PsiElement, String> allRenames) {
        PsiDirectory[] directories;
        String newDirectoryName = StringUtil.getShortName((String)newName);
        for (PsiDirectory directory : directories = psiPackage.getDirectories()) {
            if (JavaDirectoryService.getInstance().isSourceRoot(directory)) continue;
            allRenames.put((PsiElement)directory, newDirectoryName);
        }
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener listener) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(17);
        }
        Project project = element.getProject();
        PsiPackage psiPackage = (PsiPackage)element;
        String newQualifiedName = PsiUtilCore.getQualifiedNameAfterRename((String)psiPackage.getQualifiedName(), (String)newName);
        return () -> {
            PsiPackage aPackage;
            if (listener == null) {
                RenamePsiPackageProcessor.$$$reportNull$$$0(22);
            }
            if ((aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(newQualifiedName)) == null) {
                return;
            }
            listener.elementRenamed((PsiElement)aPackage);
        };
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renamePackage";
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(18);
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(19);
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(20);
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiPackageProcessor.$$$reportNull$$$0(21);
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiPackageProcessor";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiPackageProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPostRenameCallback$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

