/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesToNewDirectoryDialog
extends MoveDialogBase {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesToNewDirectoryDialog");
    private final PsiDirectory myDirectory;
    private final PsiElement[] myElementsToMove;
    private final MoveCallback myMoveCallback;
    private TextFieldWithBrowseButton myDestDirectoryField;
    private JCheckBox mySearchForTextOccurrencesCheckBox;
    private JCheckBox mySearchInCommentsAndStringsCheckBox;
    private JPanel myRootPanel;
    private JLabel myNameLabel;
    private JCheckBox myPreserveSourceRoot;
    private JPanel myOpenInEditor;

    public MoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, PsiElement[] elementsToMove, MoveCallback moveCallback) {
        if (directory == null) {
            MoveClassesOrPackagesToNewDirectoryDialog.$$$reportNull$$$0(0);
        }
        this(directory, elementsToMove, true, moveCallback);
    }

    public MoveClassesOrPackagesToNewDirectoryDialog(final @NotNull PsiDirectory directory, PsiElement[] elementsToMove, boolean canShowPreserveSourceRoots, MoveCallback moveCallback) {
        if (directory == null) {
            MoveClassesOrPackagesToNewDirectoryDialog.$$$reportNull$$$0(1);
        }
        super(directory.getProject(), false);
        this.$$$setupUI$$$();
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.myDirectory = directory;
        this.myElementsToMove = elementsToMove;
        this.myMoveCallback = moveCallback;
        this.myDestDirectoryField.setText(FileUtil.toSystemDependentName((String)directory.getVirtualFile().getPath()));
        final FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myDestDirectoryField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)MoveClassesOrPackagesToNewDirectoryDialog.this.myDirectory.getProject(), (VirtualFile)directory.getVirtualFile());
                if (file != null) {
                    MoveClassesOrPackagesToNewDirectoryDialog.this.myDestDirectoryField.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
        });
        if (elementsToMove.length == 1) {
            PsiElement firstElement = elementsToMove[0];
            this.myNameLabel.setText(RefactoringBundle.message((String)"move.single.class.or.package.name.label", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)firstElement), UsageViewUtil.getLongName((PsiElement)firstElement)}));
        } else if (elementsToMove.length > 1) {
            this.myNameLabel.setText(elementsToMove[0] instanceof PsiClass ? RefactoringBundle.message((String)"move.specified.classes") : RefactoringBundle.message((String)"move.specified.packages"));
        }
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        this.mySearchInCommentsAndStringsCheckBox.setSelected(refactoringSettings.MOVE_SEARCH_IN_COMMENTS);
        this.mySearchForTextOccurrencesCheckBox.setSelected(refactoringSettings.MOVE_SEARCH_FOR_TEXT);
        this.myDestDirectoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                MoveClassesOrPackagesToNewDirectoryDialog.this.setOKActionEnabled(MoveClassesOrPackagesToNewDirectoryDialog.this.myDestDirectoryField.getText().length() > 0);
            }
        });
        if (canShowPreserveSourceRoots) {
            HashSet<VirtualFile> sourceRoots = new HashSet<VirtualFile>();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex();
            Module destinationModule = fileIndex.getModuleForFile(directory.getVirtualFile());
            boolean sameModule = true;
            for (PsiElement element : elementsToMove) {
                if (element instanceof PsiPackage) {
                    for (PsiDirectory psiDirectory : ((PsiPackage)element).getDirectories()) {
                        VirtualFile virtualFile = psiDirectory.getVirtualFile();
                        sourceRoots.add(fileIndex.getSourceRootForFile(virtualFile));
                    }
                    continue;
                }
                if (!(element instanceof PsiClass)) continue;
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                sourceRoots.add(fileIndex.getSourceRootForFile(virtualFile));
                sameModule &= destinationModule == fileIndex.getModuleForFile(virtualFile);
            }
            this.myPreserveSourceRoot.setVisible(sourceRoots.size() > 1);
            this.myPreserveSourceRoot.setSelected(sameModule);
        }
        this.init();
        for (PsiElement element : elementsToMove) {
            if (element.getContainingFile() == null) continue;
            this.myOpenInEditor.add((Component)this.initOpenInEditorCb(), "West");
            break;
        }
    }

    private boolean isSearchInNonJavaFiles() {
        return this.mySearchForTextOccurrencesCheckBox.isSelected();
    }

    private boolean isSearchInComments() {
        return this.mySearchInCommentsAndStringsCheckBox.isSelected();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    protected void doAction() {
        String path = FileUtil.toSystemIndependentName((String)this.myDestDirectoryField.getText());
        Project project = this.myDirectory.getProject();
        PsiDirectory directory = (PsiDirectory)WriteAction.compute(() -> {
            try {
                return DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)project), (String)path);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
        if (directory == null) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"cannot.find.or.create.destination.directory"), (String)RefactoringBundle.message((String)"cannot.move"));
            return;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"destination.directory.does.not.correspond.to.any.package"), (String)RefactoringBundle.message((String)"cannot.move"));
            return;
        }
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        boolean searchInComments = this.isSearchInComments();
        boolean searchForTextOccurences = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = searchInComments;
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = searchForTextOccurences;
        this.saveOpenInEditorOption();
        BaseRefactoringProcessor refactoringProcessor = this.createRefactoringProcessor(project, directory, aPackage, searchInComments, searchForTextOccurences);
        if (refactoringProcessor != null) {
            this.invokeRefactoring(refactoringProcessor);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDestDirectoryField.getTextField();
    }

    @NotNull
    protected MoveClassesOrPackagesProcessor createMoveClassesOrPackagesProcessor(Project project, PsiElement[] elements, @NotNull MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        if (moveDestination == null) {
            MoveClassesOrPackagesToNewDirectoryDialog.$$$reportNull$$$0(2);
        }
        MoveClassesOrPackagesProcessor moveClassesOrPackagesProcessor = new MoveClassesOrPackagesProcessor(project, elements, moveDestination, searchInComments, searchInNonJavaFiles, moveCallback);
        if (moveClassesOrPackagesProcessor == null) {
            MoveClassesOrPackagesToNewDirectoryDialog.$$$reportNull$$$0(3);
        }
        return moveClassesOrPackagesProcessor;
    }

    protected BaseRefactoringProcessor createRefactoringProcessor(Project project, PsiDirectory directory, PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurences) {
        MoveDestination destination = this.createDestination(aPackage, directory);
        if (destination == null) {
            return null;
        }
        MoveClassesOrPackagesProcessor processor = this.createMoveClassesOrPackagesProcessor(this.myDirectory.getProject(), this.myElementsToMove, destination, searchInComments, searchForTextOccurences, this.myMoveCallback);
        processor.setOpenInEditor(this.isOpenInEditor());
        if (processor.verifyValidPackageName()) {
            return processor;
        }
        return null;
    }

    @Nullable
    protected MoveDestination createDestination(PsiPackage aPackage, PsiDirectory directory) {
        Project project = aPackage.getProject();
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
        if (sourceRoot == null) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"destination.directory.does.not.correspond.to.any.package"), (String)RefactoringBundle.message((String)"cannot.move"));
            return null;
        }
        JavaRefactoringFactory factory = JavaRefactoringFactory.getInstance((Project)project);
        return this.myPreserveSourceRoot.isSelected() && this.myPreserveSourceRoot.isVisible() ? factory.createSourceFolderPreservingMoveDestination(aPackage.getQualifiedName()) : factory.createSourceRootMoveDestination(aPackage.getQualifiedName(), sourceRoot);
    }

    @Override
    protected String getMovePropertySuffix() {
        return "ClassWithTarget";
    }

    @Override
    protected String getCbTitle() {
        return "Open moved classes in editor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesToNewDirectoryDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesToNewDirectoryDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMoveClassesOrPackagesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMoveClassesOrPackagesProcessor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox3;
        JLabel jLabel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.specified.classes.to"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySearchInCommentsAndStringsCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDestDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(400, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("To directory:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySearchForTextOccurrencesCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreserveSourceRoot = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Don't move to another source folder");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myOpenInEditor = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

