/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.intention.impl.CreateSubclassAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.JavaRefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.JavaRefactoringListenerManagerImpl;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownConflicts;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.refactoring.memberPushDown.PushDownDelegate;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPushDownDelegate
extends PushDownDelegate<MemberInfo, PsiMember> {
    public static final Key<Boolean> REMOVE_QUALIFIER_KEY = Key.create((String)"REMOVE_QUALIFIER_KEY");
    public static final Key<PsiClass> REPLACE_QUALIFIER_KEY = Key.create((String)"REPLACE_QUALIFIER_KEY");
    private static final Logger LOG = Logger.getInstance(JavaPushDownDelegate.class);

    public boolean isApplicableForSource(@NotNull PsiElement sourceClass) {
        if (sourceClass == null) {
            JavaPushDownDelegate.$$$reportNull$$$0(0);
        }
        return sourceClass.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public List<PsiElement> findInheritors(PushDownData<MemberInfo, PsiMember> pushDownData) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiClass aClass = (PsiClass)pushDownData.getSourceClass();
        ClassInheritorsSearch.search((PsiClass)aClass, (boolean)false).forEach(iClass -> {
            result.add((PsiElement)iClass);
            return true;
        });
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
        if (interfaceMethod != null) {
            for (MemberInfo info : pushDownData.getMembersToMove()) {
                if (interfaceMethod != info.getMember()) continue;
                FunctionalExpressionSearch.search((PsiClass)aClass).forEach(expression2 -> {
                    result.add((PsiElement)expression2);
                    return true;
                });
                break;
            }
        }
        return result;
    }

    public void checkSourceClassConflicts(PushDownData<MemberInfo, PsiMember> pushDownData, MultiMap<PsiElement, String> conflicts) {
        List toMove = pushDownData.getMembersToMove();
        new PushDownConflicts((PsiClass)pushDownData.getSourceClass(), toMove.toArray(new MemberInfo[0]), conflicts).checkSourceClassConflicts();
    }

    public void checkTargetClassConflicts(@Nullable PsiElement targetClass, PushDownData<MemberInfo, PsiMember> pushDownData, MultiMap<PsiElement, String> conflicts, NewSubClassData subClassData) {
        List toMove = pushDownData.getMembersToMove();
        PsiElement context = targetClass;
        if (context == null) {
            assert (subClassData != null);
            Object newClassContext = subClassData.getContext();
            if (newClassContext instanceof PsiElement) {
                context = (PsiElement)newClassContext;
            }
        }
        if (targetClass instanceof PsiAnonymousClass && toMove.stream().map(MemberInfoBase::getOverrides).anyMatch(Objects::nonNull)) {
            conflicts.putValue((Object)targetClass, (Object)"Unable to push implements to anonymous class");
        }
        new PushDownConflicts((PsiClass)pushDownData.getSourceClass(), toMove.toArray(new MemberInfo[0]), conflicts).checkTargetClassConflicts(targetClass, context);
    }

    public NewSubClassData preprocessNoInheritorsFound(PsiElement sourceClass, String conflictDialogTitle) {
        PsiClass aClass = (PsiClass)sourceClass;
        PsiFile containingFile = aClass.getContainingFile();
        boolean defaultPackage = StringUtil.isEmptyOrSpaces((String)(containingFile instanceof PsiClassOwner ? ((PsiClassOwner)containingFile).getPackageName() : ""));
        if (aClass.isEnum() || aClass.hasModifierProperty("final") || defaultPackage) {
            if (Messages.showOkCancelDialog((String)((aClass.isEnum() ? "Enum " + aClass.getQualifiedName() + " doesn't have constants to inline to. " : (defaultPackage ? "Class " : "Final class ") + aClass.getQualifiedName() + "does not have inheritors. ") + "Pushing members down will result in them being deleted. Would you like to proceed?"), (String)conflictDialogTitle, (Icon)Messages.getWarningIcon()) != 0) {
                return NewSubClassData.ABORT_REFACTORING;
            }
        } else {
            String noInheritors = aClass.isInterface() ? RefactoringBundle.message((String)"interface.0.does.not.have.inheritors", (Object[])new Object[]{aClass.getQualifiedName()}) : RefactoringBundle.message((String)"class.0.does.not.have.inheritors", (Object[])new Object[]{aClass.getQualifiedName()});
            String message2 = noInheritors + "\n" + RefactoringBundle.message((String)"push.down.will.delete.members");
            int answer = Messages.showYesNoCancelDialog((String)message2, (String)conflictDialogTitle, (Icon)Messages.getWarningIcon());
            if (answer == 0) {
                CreateClassDialog classDialog = CreateSubclassAction.chooseSubclassToCreate(aClass);
                if (classDialog != null) {
                    return new NewSubClassData((PsiElement)classDialog.getTargetDirectory(), classDialog.getClassName());
                }
                return NewSubClassData.ABORT_REFACTORING;
            }
            if (answer != 1) {
                return NewSubClassData.ABORT_REFACTORING;
            }
        }
        return null;
    }

    public void prepareToPush(final PushDownData<MemberInfo, PsiMember> pushDownData) {
        final HashSet<PsiMember> movedMembers = new HashSet<PsiMember>();
        for (MemberInfoBase memberInfo : pushDownData.getMembersToMove()) {
            movedMembers.add((PsiMember)memberInfo.getMember());
        }
        for (MemberInfoBase memberInfo : pushDownData.getMembersToMove()) {
            PsiElement member = memberInfo.getMember();
            member.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitThisExpression(PsiThisExpression expression2) {
                    JavaPushDownDelegate.encodeRef((PsiClass)pushDownData.getSourceClass(), null, movedMembers, (PsiElement)expression2, (PsiElement)expression2);
                    super.visitThisExpression(expression2);
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement referenceElement) {
                    JavaPushDownDelegate.encodeRef((PsiClass)pushDownData.getSourceClass(), referenceElement, movedMembers, (PsiElement)referenceElement);
                    super.visitReferenceElement(referenceElement);
                }

                public void visitNewExpression(PsiNewExpression expression2) {
                    PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
                    if (classReference2 != null) {
                        JavaPushDownDelegate.encodeRef((PsiClass)pushDownData.getSourceClass(), classReference2, movedMembers, (PsiElement)expression2);
                    }
                    super.visitNewExpression(expression2);
                }

                public void visitTypeElement(PsiTypeElement type2) {
                    PsiJavaCodeReferenceElement referenceElement = type2.getInnermostComponentReferenceElement();
                    if (referenceElement != null) {
                        JavaPushDownDelegate.encodeRef((PsiClass)pushDownData.getSourceClass(), referenceElement, movedMembers, (PsiElement)type2);
                    }
                    super.visitTypeElement(type2);
                }
            });
            ChangeContextUtil.encodeContextInfo(member, false);
        }
    }

    public void pushDownToClass(PsiElement targetElement, PushDownData<MemberInfo, PsiMember> pushDownData) {
        PsiClass targetClass;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)pushDownData.getSourceClass().getProject()).getElementFactory();
        PsiClass psiClass = targetClass = targetElement instanceof PsiClass ? (PsiClass)targetElement : null;
        if (targetClass == null) {
            return;
        }
        PsiClass sourceClass = (PsiClass)pushDownData.getSourceClass();
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)sourceClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        for (MemberInfoBase memberInfo : pushDownData.getMembersToMove()) {
            PsiClassType[] oldDocComment;
            PsiMember member = (PsiMember)memberInfo.getMember();
            ArrayList<PsiReference> refsToRebind = new ArrayList<PsiReference>();
            PsiModifierList list = member.getModifierList();
            LOG.assertTrue(list != null);
            if (list.hasModifierProperty("static") && !PsiUtil.isLocalOrAnonymousClass((PsiClass)targetClass)) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)member)) {
                    PsiClass inheritor;
                    PsiElement resolve;
                    PsiExpression qualifierExpression2;
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiReferenceExpression && ((qualifierExpression2 = ((PsiReferenceExpression)element).getQualifierExpression()) == null || qualifierExpression2 instanceof PsiReferenceExpression && (!((resolve = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiClass) || resolve != sourceClass || (inheritor = InheritanceUtil.findEnclosingInstanceInScope((PsiClass)sourceClass, (PsiElement)element, (Condition)Condition.TRUE, (boolean)false)) != null && inheritor != targetClass))) continue;
                    refsToRebind.add(reference);
                }
            }
            if (member instanceof PsiField) {
                ((PsiField)member).normalizeDeclaration();
            }
            member = (PsiMember)member.copy();
            RefactoringUtil.renameConflictingTypeParameters(member, targetClass);
            RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)member, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)sourceClass), substitutor, factory);
            PsiMember newMember = null;
            if (member instanceof PsiField) {
                if (sourceClass.isInterface() && !targetClass.isInterface()) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)member, (String)"public", (boolean)true);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)member, (String)"static", (boolean)true);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)member, (String)"final", (boolean)true);
                }
                newMember = (PsiMember)targetClass.add((PsiElement)member);
            } else if (member instanceof PsiMethod) {
                boolean pushMethodToClass;
                PsiMethod method = (PsiMethod)member;
                PsiMethod methodBySignature = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)targetClass, (MethodSignature)method.getSignature(substitutor), (boolean)true);
                boolean bl = pushMethodToClass = methodBySignature == null;
                if (!pushMethodToClass) {
                    PsiClass containingClass = methodBySignature.getContainingClass();
                    boolean bl2 = pushMethodToClass = containingClass == sourceClass || containingClass != targetClass && methodBySignature.hasModifierProperty("abstract");
                }
                if (pushMethodToClass) {
                    newMember = (PsiMethod)targetClass.add((PsiElement)method);
                    PsiMethod oldMethod = (PsiMethod)memberInfo.getMember();
                    if (sourceClass.isInterface() && !targetClass.isInterface()) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)newMember, (String)"public", (boolean)true);
                        if (oldMethod.hasModifierProperty("abstract")) {
                            RefactoringUtil.makeMethodAbstract(targetClass, (PsiMethod)newMember);
                        } else {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)newMember, (String)"default", (boolean)false);
                        }
                    }
                    if (memberInfo.isToAbstract()) {
                        if (newMember.hasModifierProperty("private")) {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)newMember, (String)"protected", (boolean)true);
                        }
                        pushDownData.getCommentPolicy().processNewJavaDoc((PsiComment)((PsiMethod)newMember).getDocComment());
                        OverrideImplementUtil.annotateOnOverrideImplement((PsiMethod)newMember, targetClass, (PsiMethod)memberInfo.getMember());
                    }
                } else {
                    if (!memberInfo.isToAbstract()) {
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)methodBySignature, (String[])new String[]{"java.lang.Override"});
                        if (annotation != null && !JavaPushDownDelegate.leaveOverrideAnnotation(sourceClass, substitutor, method)) {
                            annotation.delete();
                        }
                        PsiParameter[] sourceParameters = method.getParameterList().getParameters();
                        PsiParameter[] targetParameters = methodBySignature.getParameterList().getParameters();
                        for (int i = 0; i < sourceParameters.length; ++i) {
                            GenerateMembersUtil.copyAnnotations((PsiModifierListOwner)sourceParameters[i], (PsiModifierListOwner)targetParameters[i], new String[0]);
                        }
                        GenerateMembersUtil.copyAnnotations((PsiModifierListOwner)method, (PsiModifierListOwner)methodBySignature, new String[0]);
                    }
                    if ((oldDocComment = method.getDocComment()) != null) {
                        PsiDocComment docComment = methodBySignature.getDocComment();
                        int policy = pushDownData.getCommentPolicy().getJavaDocPolicy();
                        if (policy == 2 || policy == 1) {
                            if (docComment != null) {
                                docComment.replace((PsiElement)oldDocComment);
                            } else {
                                methodBySignature.getParent().addBefore((PsiElement)oldDocComment, (PsiElement)methodBySignature);
                            }
                        }
                    }
                }
            } else if (member instanceof PsiClass) {
                if (sourceClass.isInterface() && !targetClass.isInterface()) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)member, (String)"public", (boolean)true);
                }
                if (Boolean.FALSE.equals(memberInfo.getOverrides())) {
                    PsiClass psiClass2 = (PsiClass)memberInfo.getMember();
                    PsiClassType classType = null;
                    if (!targetClass.isInheritor(psiClass2, false)) {
                        PsiReferenceList extendsImplementsList;
                        PsiClassType[] types;
                        oldDocComment = types = ((MemberInfo)memberInfo).getSourceReferenceList().getReferencedTypes();
                        int docComment = oldDocComment.length;
                        for (int i = 0; i < docComment; ++i) {
                            PsiClassType type2 = oldDocComment[i];
                            if (type2.resolve() != psiClass2) continue;
                            classType = (PsiClassType)substitutor.substitute((PsiType)type2);
                        }
                        PsiJavaCodeReferenceElement classRef = classType != null ? factory.createReferenceElementByType(classType) : factory.createClassReferenceElement(psiClass2);
                        PsiReferenceList psiReferenceList = extendsImplementsList = psiClass2.isInterface() && !targetClass.isInterface() ? targetClass.getImplementsList() : targetClass.getExtendsList();
                        if (extendsImplementsList != null) {
                            extendsImplementsList.add((PsiElement)classRef);
                        }
                    }
                } else {
                    newMember = (PsiMember)targetClass.add((PsiElement)member);
                }
            }
            if (newMember == null) continue;
            JavaPushDownDelegate.decodeRefs(sourceClass, newMember, targetClass);
            Collections.sort(refsToRebind, Comparator.comparing(PsiReference::getElement, PsiUtil.BY_POSITION));
            for (PsiReference psiReference : refsToRebind) {
                JavaCodeStyleManager.getInstance((Project)sourceClass.getProject()).shortenClassReferences(psiReference.bindToElement((PsiElement)newMember));
            }
            JavaRefactoringListenerManager listenerManager = JavaRefactoringListenerManager.getInstance((Project)newMember.getProject());
            ((JavaRefactoringListenerManagerImpl)listenerManager).fireMemberMoved(sourceClass, newMember);
        }
    }

    public void removeFromSourceClass(PushDownData<MemberInfo, PsiMember> pushDownData) {
        for (MemberInfoBase memberInfo : pushDownData.getMembersToMove()) {
            PsiElement member = memberInfo.getMember();
            if (member instanceof PsiField) {
                member.delete();
                continue;
            }
            if (member instanceof PsiMethod) {
                if (memberInfo.isToAbstract()) {
                    PsiMethod method = (PsiMethod)member;
                    if (method.hasModifierProperty("private")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"protected", (boolean)true);
                    }
                    if (method.hasModifierProperty("default")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"default", (boolean)false);
                    }
                    RefactoringUtil.makeMethodAbstract((PsiClass)pushDownData.getSourceClass(), method);
                    pushDownData.getCommentPolicy().processOldJavaDoc((PsiComment)method.getDocComment());
                    continue;
                }
                member.delete();
                continue;
            }
            if (!(member instanceof PsiClass)) continue;
            if (Boolean.FALSE.equals(memberInfo.getOverrides())) {
                RefactoringUtil.removeFromReferenceList(((PsiClass)pushDownData.getSourceClass()).getImplementsList(), (PsiClass)member);
                continue;
            }
            member.delete();
        }
    }

    public PsiElement createSubClass(PsiElement aClass, NewSubClassData subClassData) {
        return CreateSubclassAction.createSubclass((PsiClass)aClass, (PsiDirectory)subClassData.getContext(), subClassData.getNewClassName(), false);
    }

    private static boolean leaveOverrideAnnotation(PsiClass aClass, PsiSubstitutor substitutor, PsiMethod method) {
        boolean is15;
        PsiMethod methodBySignature = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)method.getSignature(substitutor), (boolean)false);
        if (methodBySignature == null) {
            return false;
        }
        PsiMethod[] superMethods = methodBySignature.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            return false;
        }
        boolean bl = is15 = !PsiUtil.isLanguageLevel6OrHigher((PsiElement)methodBySignature);
        if (is15) {
            for (PsiMethod psiMethod : superMethods) {
                PsiClass psiClass = psiMethod.getContainingClass();
                if (psiClass == null || !psiClass.isInterface()) continue;
                return false;
            }
        }
        return true;
    }

    private static void encodeRef(PsiClass aClass, PsiJavaCodeReferenceElement expression2, Set<PsiMember> movedMembers, PsiElement toPut) {
        PsiElement resolved = expression2.resolve();
        if (resolved == null) {
            return;
        }
        JavaPushDownDelegate.encodeRef(aClass, resolved, movedMembers, toPut, expression2.getQualifier());
    }

    private static void encodeRef(PsiClass aClass, @Nullable PsiElement resolved, @NotNull Set<PsiMember> movedMembers, @NotNull PsiElement toPut, @Nullable PsiElement qualifier) {
        if (movedMembers == null) {
            JavaPushDownDelegate.$$$reportNull$$$0(1);
        }
        if (toPut == null) {
            JavaPushDownDelegate.$$$reportNull$$$0(2);
        }
        for (PsiMember movedMember : movedMembers) {
            PsiJavaCodeReferenceElement qElement;
            if (movedMember.equals(resolved)) {
                if (qualifier == null) {
                    toPut.putCopyableUserData(REMOVE_QUALIFIER_KEY, (Object)Boolean.TRUE);
                    continue;
                }
                if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !((PsiJavaCodeReferenceElement)qualifier).isReferenceTo((PsiElement)aClass)) continue;
                toPut.putCopyableUserData(REPLACE_QUALIFIER_KEY, (Object)aClass);
                continue;
            }
            if (movedMember instanceof PsiClass && PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiClass.class, (boolean)false) == movedMember) {
                if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !((PsiJavaCodeReferenceElement)qualifier).isReferenceTo((PsiElement)movedMember)) continue;
                toPut.putCopyableUserData(REPLACE_QUALIFIER_KEY, (Object)((PsiClass)movedMember));
                continue;
            }
            if (!(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression) || (qElement = ((PsiQualifiedExpression)qualifier).getQualifier()) == null || !qElement.isReferenceTo((PsiElement)aClass)) continue;
            toPut.putCopyableUserData(REPLACE_QUALIFIER_KEY, (Object)aClass);
        }
    }

    private static void decodeRefs(final PsiClass sourceClass, PsiMember member, final PsiClass targetClass) {
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)sourceClass.getProject()).getElementFactory();
        member.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement referenceElement) {
                JavaPushDownDelegate.decodeRef(sourceClass, (PsiElement)referenceElement, factory, targetClass, (PsiElement)referenceElement);
                super.visitReferenceElement(referenceElement);
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                JavaPushDownDelegate.decodeRef(sourceClass, (PsiElement)expression2, factory, targetClass, (PsiElement)expression2);
                super.visitThisExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
                if (classReference2 != null) {
                    JavaPushDownDelegate.decodeRef(sourceClass, (PsiElement)classReference2, factory, targetClass, (PsiElement)expression2);
                }
                super.visitNewExpression(expression2);
            }

            public void visitTypeElement(PsiTypeElement type2) {
                PsiJavaCodeReferenceElement referenceElement = type2.getInnermostComponentReferenceElement();
                if (referenceElement != null) {
                    JavaPushDownDelegate.decodeRef(sourceClass, (PsiElement)referenceElement, factory, targetClass, (PsiElement)type2);
                }
                super.visitTypeElement(type2);
            }
        });
    }

    private static void decodeRef(PsiClass sourceClass, PsiElement ref, PsiElementFactory factory, PsiClass targetClass, PsiElement toGet) {
        try {
            if (toGet.getCopyableUserData(REMOVE_QUALIFIER_KEY) != null) {
                PsiElement qualifier;
                toGet.putCopyableUserData(REMOVE_QUALIFIER_KEY, null);
                PsiElement psiElement = qualifier = ref instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)ref).getQualifier() : ref;
                if (qualifier != null) {
                    qualifier.delete();
                }
            } else {
                PsiClass psiClass = (PsiClass)toGet.getCopyableUserData(REPLACE_QUALIFIER_KEY);
                if (psiClass != null) {
                    PsiElement qualifier;
                    toGet.putCopyableUserData(REPLACE_QUALIFIER_KEY, null);
                    PsiElement psiElement = qualifier = ref instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)ref).getQualifier() : ref;
                    if (qualifier != null) {
                        if (psiClass == sourceClass) {
                            psiClass = targetClass;
                        } else if (psiClass.getContainingClass() == sourceClass) {
                            LOG.assertTrue((psiClass = targetClass.findInnerClassByName(psiClass.getName(), false)) != null);
                        }
                        if (!(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression) && ref instanceof PsiReferenceExpression) {
                            ((PsiReferenceExpression)ref).setQualifierExpression((PsiExpression)factory.createReferenceExpression(psiClass));
                        } else {
                            if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                                qualifier = ((PsiQualifiedExpression)qualifier).getQualifier();
                            }
                            qualifier.replace((PsiElement)factory.createReferenceElementByType(factory.createType(psiClass)));
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedMembers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPut";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/memberPushDown/JavaPushDownDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableForSource";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "encodeRef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

