/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.refactoring.inheritanceToDelegation.InnerClassMethod;
import com.intellij.util.IncorrectOperationException;

public class InnerClassConstructor
extends InnerClassMethod {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inheritanceToDelegation.InnerClassConstructor");

    public InnerClassConstructor(PsiMethod method) {
        super(method);
        LOG.assertTrue(method.isConstructor());
    }

    @Override
    public void createMethod(PsiClass innerClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)innerClass.getProject()).getElementFactory();
        PsiMethod constructor = factory.createConstructor();
        constructor.getNameIdentifier().replace((PsiElement)innerClass.getNameIdentifier());
        PsiParameterList parameterList = this.myMethod.getParameterList();
        constructor.getParameterList().replace((PsiElement)parameterList);
        PsiExpressionStatement superCallStatement = (PsiExpressionStatement)factory.createStatementFromText("super();", null);
        PsiExpressionList arguments = ((PsiMethodCallExpression)superCallStatement.getExpression()).getArgumentList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            arguments.add((PsiElement)factory.createExpressionFromText(parameters2[i].getName(), null));
        }
        constructor.getBody().add((PsiElement)superCallStatement);
        innerClass.add((PsiElement)constructor);
    }
}

