/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class MakeMethodDelegate
extends FixableUsageInfo {
    private final PsiMethod method;
    private final String delegate;

    public MakeMethodDelegate(PsiMethod method, String delegate) {
        super((PsiElement)method);
        this.method = method;
        this.delegate = delegate;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiStatement[] statements;
        PsiCodeBlock body2 = this.method.getBody();
        assert (body2 != null);
        for (PsiStatement statement : statements = body2.getStatements()) {
            statement.delete();
        }
        StringBuffer delegation = new StringBuffer();
        PsiType returnType = this.method.getReturnType();
        if (!PsiType.VOID.equals((Object)returnType)) {
            delegation.append("return ");
        }
        String methodName = this.method.getName();
        delegation.append(this.delegate + '.' + methodName + '(');
        PsiParameterList parameterList = this.method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        boolean first = true;
        for (PsiParameter parameter2 : parameters2) {
            if (!first) {
                delegation.append(',');
            }
            first = false;
            String parameterName = parameter2.getName();
            delegation.append(parameterName);
        }
        delegation.append(");");
        PsiManager manager = this.method.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String delegationText = delegation.toString();
        PsiStatement delegationStatement = factory.createStatementFromText(delegationText, (PsiElement)body2);
        body2.add((PsiElement)delegationStatement);
    }
}

