/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.extractclass.BackpointerUsageVisitor;
import com.intellij.refactoring.extractclass.BackpointerUtil;
import com.intellij.refactoring.extractclass.ExtractClassUsageViewDescriptor;
import com.intellij.refactoring.extractclass.ExtractEnumProcessor;
import com.intellij.refactoring.extractclass.ExtractedClassBuilder;
import com.intellij.refactoring.extractclass.usageInfo.BindJavadocReference;
import com.intellij.refactoring.extractclass.usageInfo.MakeMethodDelegate;
import com.intellij.refactoring.extractclass.usageInfo.RemoveField;
import com.intellij.refactoring.extractclass.usageInfo.RemoveInnerClass;
import com.intellij.refactoring.extractclass.usageInfo.RemoveMethod;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceClassReference;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceInstanceVariableAccess;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceInstanceVariableAssignment;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceInstanceVariableIncrementDecrement;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableAccess;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableAssignment;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableIncrementDecrement;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceThisCallWithDelegateCall;
import com.intellij.refactoring.extractclass.usageInfo.RetargetStaticMethodCall;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.refactoring.psi.TypeParametersVisitor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtractClassProcessor
extends FixableUsagesRefactoringProcessor {
    private static final Logger logger = Logger.getInstance((String)"com.siyeh.rpp.extractclass.ExtractClassProcessor");
    @NonNls
    public static final String REFACTORING_NAME = "Extract Delegate";
    private final PsiClass sourceClass;
    private final List<PsiField> fields;
    private final List<PsiMethod> methods;
    private final List<PsiClass> innerClasses;
    private final Set<PsiClass> innerClassesToMakePublic = new HashSet<PsiClass>();
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private final String newPackageName;
    private final MoveDestination myMoveDestination;
    private final String myNewVisibility;
    private final boolean myGenerateAccessors;
    private final List<PsiField> enumConstants;
    private final String newClassName;
    private final String delegateFieldName;
    private final boolean requiresBackpointer;
    private boolean delegationRequired;
    private final ExtractEnumProcessor myExtractEnumProcessor;
    private final PsiClass myClass;
    private boolean extractInnerClass;

    public ExtractClassProcessor(PsiClass sourceClass, List<PsiField> fields, List<PsiMethod> methods, List<PsiClass> innerClasses, String newPackageName, String newClassName) {
        this(sourceClass, fields, methods, innerClasses, newPackageName, null, newClassName, null, false, Collections.emptyList());
    }

    public ExtractClassProcessor(PsiClass sourceClass, List<PsiField> fields, List<PsiMethod> methods, List<PsiClass> classes2, String packageName, MoveDestination moveDestination, String newClassName, String newVisibility, boolean generateAccessors, List<MemberInfo> enumConstants) {
        super(sourceClass.getProject());
        this.sourceClass = sourceClass;
        this.newPackageName = packageName;
        this.myMoveDestination = moveDestination;
        this.myNewVisibility = newVisibility;
        this.myGenerateAccessors = generateAccessors;
        this.enumConstants = new ArrayList<PsiField>();
        for (MemberInfo constant : enumConstants) {
            if (!constant.isChecked()) continue;
            this.enumConstants.add((PsiField)constant.getMember());
        }
        this.fields = new ArrayList<PsiField>(fields);
        this.methods = new ArrayList<PsiMethod>(methods);
        this.innerClasses = new ArrayList<PsiClass>(classes2);
        this.newClassName = newClassName;
        this.delegateFieldName = this.calculateDelegateFieldName();
        this.requiresBackpointer = new BackpointerUsageVisitor(fields, this.innerClasses, methods, sourceClass).backpointerRequired();
        if (this.requiresBackpointer) {
            ContainerUtil.addAll(this.typeParams, (Object[])sourceClass.getTypeParameters());
        } else {
            HashSet<PsiTypeParameter> typeParamSet = new HashSet<PsiTypeParameter>();
            TypeParametersVisitor visitor = new TypeParametersVisitor(typeParamSet);
            for (PsiField field : fields) {
                field.accept((PsiElementVisitor)visitor);
            }
            for (PsiMethod method : methods) {
                method.accept((PsiElementVisitor)visitor);
                typeParamSet.removeAll(Arrays.asList(method.getTypeParameters()));
            }
            this.typeParams.addAll(typeParamSet);
        }
        this.myClass = (PsiClass)WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).compute(() -> this.buildClass(false));
        this.myExtractEnumProcessor = new ExtractEnumProcessor(this.myProject, this.enumConstants, this.myClass);
    }

    public PsiClass getCreatedClass() {
        return this.myClass;
    }

    public void setExtractInnerClass(boolean extractInnerClass) {
        this.extractInnerClass = extractInnerClass;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ExtractClassProcessor.$$$reportNull$$$0(0);
        }
        MultiMap conflicts = new MultiMap();
        this.myExtractEnumProcessor.findEnumConstantConflicts(refUsages);
        if (!DestinationFolderComboBox.isAccessible(this.myProject, this.sourceClass.getContainingFile().getVirtualFile(), this.myClass.getContainingFile().getContainingDirectory().getVirtualFile())) {
            conflicts.putValue((Object)this.sourceClass, (Object)("Extracted class won't be accessible in " + RefactoringUIUtil.getDescription((PsiElement)this.sourceClass, (boolean)true)));
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.myClass.delete());
        Project project = this.sourceClass.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass existingClass = JavaPsiFacade.getInstance((Project)project).findClass(this.getQualifiedName(), scope);
        if (existingClass != null) {
            conflicts.putValue((Object)existingClass, (Object)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("there.already.exists.a.class.with.the.chosen.name", new Object[0])));
        }
        if (!this.myGenerateAccessors) {
            this.calculateInitializersConflicts((MultiMap<PsiElement, String>)conflicts);
            NecessaryAccessorsVisitor visitor = this.checkNecessaryGettersSetters4ExtractedClass();
            NecessaryAccessorsVisitor srcVisitor = this.checkNecessaryGettersSetters4SourceClass();
            LinkedHashSet<PsiField> fieldsNeedingGetter = new LinkedHashSet<PsiField>();
            fieldsNeedingGetter.addAll(visitor.getFieldsNeedingGetter());
            fieldsNeedingGetter.addAll(srcVisitor.getFieldsNeedingGetter());
            for (PsiField field : fieldsNeedingGetter) {
                conflicts.putValue((Object)field, (Object)("Field '" + field.getName() + "' needs getter"));
            }
            LinkedHashSet<PsiField> fieldsNeedingSetter = new LinkedHashSet<PsiField>();
            fieldsNeedingSetter.addAll(visitor.getFieldsNeedingSetter());
            fieldsNeedingSetter.addAll(srcVisitor.getFieldsNeedingSetter());
            for (PsiField field : fieldsNeedingSetter) {
                conflicts.putValue((Object)field, (Object)("Field '" + field.getName() + "' needs setter"));
            }
        }
        ExtractClassProcessor.checkConflicts(refUsages, (MultiMap)conflicts);
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    private String getQualifiedName() {
        return this.extractInnerClass ? this.newClassName : StringUtil.getQualifiedName((String)this.newPackageName, (String)this.newClassName);
    }

    private void calculateInitializersConflicts(MultiMap<PsiElement, String> conflicts) {
        PsiClassInitializer[] initializers;
        for (PsiClassInitializer psiClassInitializer : initializers = this.sourceClass.getInitializers()) {
            if (!this.initializerDependsOnMoved((PsiElement)psiClassInitializer)) continue;
            conflicts.putValue((Object)psiClassInitializer, (Object)"Class initializer requires moved members");
        }
        for (PsiClassInitializer psiClassInitializer : this.sourceClass.getConstructors()) {
            if (!this.initializerDependsOnMoved((PsiElement)psiClassInitializer.getBody())) continue;
            conflicts.putValue((Object)psiClassInitializer, (Object)"Constructor requires moved members");
        }
    }

    private boolean initializerDependsOnMoved(PsiElement initializer) {
        final boolean[] dependsOnMoved = new boolean[]{false};
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiMember) {
                    dependsOnMoved[0] = dependsOnMoved[0] | (!((PsiMember)resolved).hasModifierProperty("static") && ExtractClassProcessor.this.isInMovedElement(resolved));
                }
            }
        });
        return dependsOnMoved[0];
    }

    private String calculateDelegateFieldName() {
        Project project = this.sourceClass.getProject();
        JavaCodeStyleSettings settings = JavaCodeStyleSettings.getInstance(this.sourceClass.getContainingFile());
        String baseName = settings.FIELD_NAME_PREFIX.length() == 0 ? StringUtil.decapitalize((String)this.newClassName) : this.newClassName;
        String name = settings.FIELD_NAME_PREFIX + baseName + settings.FIELD_NAME_SUFFIX;
        if (!this.existsFieldWithName(name) && !PsiNameHelper.getInstance((Project)project).isKeyword(name)) {
            return name;
        }
        int counter = 1;
        while (this.existsFieldWithName(name = settings.FIELD_NAME_PREFIX + baseName + counter + settings.FIELD_NAME_SUFFIX) || PsiNameHelper.getInstance((Project)project).isKeyword(name)) {
            ++counter;
        }
        return name;
    }

    private boolean existsFieldWithName(String name) {
        PsiField[] allFields;
        for (PsiField field : allFields = this.sourceClass.getAllFields()) {
            if (!name.equals(field.getName()) || this.fields.contains(field)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorJBundle.message("extracted.class.command.name", this.newClassName);
        if (string == null) {
            ExtractClassProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            ExtractClassProcessor.$$$reportNull$$$0(2);
        }
        ExtractClassUsageViewDescriptor extractClassUsageViewDescriptor = new ExtractClassUsageViewDescriptor(this.sourceClass);
        if (extractClassUsageViewDescriptor == null) {
            ExtractClassProcessor.$$$reportNull$$$0(3);
        }
        return extractClassUsageViewDescriptor;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        PsiMethod member;
        PsiClass psiClass;
        if (usageInfos == null) {
            ExtractClassProcessor.$$$reportNull$$$0(4);
        }
        if ((psiClass = this.buildClass(true)) == null) {
            return;
        }
        if (this.delegationRequired) {
            this.buildDelegate();
        }
        this.myExtractEnumProcessor.performEnumConstantTypeMigration(usageInfos);
        final HashSet<PsiMethod> members = new HashSet<PsiMethod>();
        for (PsiMethod psiMethod : this.methods) {
            member = psiClass.findMethodBySignature(psiMethod, false);
            if (member == null) continue;
            members.add(member);
        }
        for (PsiField psiField : this.fields) {
            member = psiClass.findFieldByName(psiField.getName(), false);
            if (member == null) continue;
            members.add(member);
            PsiExpression initializer = member.getInitializer();
            if (initializer == null) continue;
            final boolean[] moveInitializerToConstructor = new boolean[1];
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    PsiElement resolved = expression2.resolve();
                    if (resolved instanceof PsiField && !members.contains(resolved)) {
                        moveInitializerToConstructor[0] = true;
                    }
                }
            });
            if (!moveInitializerToConstructor[0]) continue;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
            PsiMethod[] constructors = psiClass.getConstructors();
            if (constructors.length == 0) {
                PsiMethod constructor = (PsiMethod)elementFactory.createConstructor().setName(psiClass.getName());
                constructors = new PsiMethod[]{(PsiMethod)psiClass.add((PsiElement)constructor)};
            }
            for (PsiMethod constructor : constructors) {
                MoveInstanceMembersUtil.moveInitializerToConstructor(elementFactory, constructor, (PsiField)member);
            }
        }
        if (this.myGenerateAccessors) {
            NecessaryAccessorsVisitor visitor = this.checkNecessaryGettersSetters4SourceClass();
            for (PsiField field : visitor.getFieldsNeedingGetter()) {
                this.sourceClass.add((PsiElement)GenerateMembersUtil.generateGetterPrototype(field));
            }
            for (PsiField field : visitor.getFieldsNeedingSetter()) {
                this.sourceClass.add((PsiElement)GenerateMembersUtil.generateSetterPrototype(field));
            }
        }
        super.performRefactoring(usageInfos);
        if (this.myNewVisibility == null) {
            return;
        }
        for (PsiMember psiMember : members) {
            VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements((UsageInfo[])usageInfos), (PsiMember)psiMember, (String)this.myNewVisibility);
        }
    }

    private NecessaryAccessorsVisitor checkNecessaryGettersSetters4SourceClass() {
        NecessaryAccessorsVisitor visitor = new NecessaryAccessorsVisitor(){

            @Override
            protected boolean hasGetterOrSetter(PsiMethod[] getters) {
                for (PsiMethod getter : getters) {
                    if (ExtractClassProcessor.this.isInMovedElement((PsiElement)getter)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected boolean isProhibitedReference(PsiField field) {
                if (ExtractClassProcessor.this.fields.contains(field)) {
                    return false;
                }
                return !ExtractClassProcessor.this.innerClasses.contains(field.getContainingClass());
            }
        };
        for (PsiField field : this.fields) {
            field.accept((PsiElementVisitor)visitor);
        }
        for (PsiMethod method : this.methods) {
            method.accept((PsiElementVisitor)visitor);
        }
        for (PsiClass innerClass : this.innerClasses) {
            innerClass.accept((PsiElementVisitor)visitor);
        }
        return visitor;
    }

    private NecessaryAccessorsVisitor checkNecessaryGettersSetters4ExtractedClass() {
        NecessaryAccessorsVisitor visitor = new NecessaryAccessorsVisitor(){

            @Override
            protected boolean hasGetterOrSetter(PsiMethod[] getters) {
                for (PsiMethod getter : getters) {
                    if (!ExtractClassProcessor.this.isInMovedElement((PsiElement)getter)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected boolean isProhibitedReference(PsiField field) {
                if (ExtractClassProcessor.this.fields.contains(field)) {
                    return true;
                }
                return ExtractClassProcessor.this.innerClasses.contains(field.getContainingClass());
            }

            public void visitMethod(PsiMethod method) {
                if (ExtractClassProcessor.this.methods.contains(method)) {
                    return;
                }
                super.visitMethod(method);
            }

            public void visitField(PsiField field) {
                if (ExtractClassProcessor.this.fields.contains(field)) {
                    return;
                }
                super.visitField(field);
            }

            public void visitClass(PsiClass aClass) {
                if (ExtractClassProcessor.this.innerClasses.contains(aClass)) {
                    return;
                }
                super.visitClass(aClass);
            }
        };
        this.sourceClass.accept((PsiElementVisitor)visitor);
        return visitor;
    }

    private void buildDelegate() {
        PsiManager manager = this.sourceClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        StringBuilder fieldBuffer = new StringBuilder();
        String delegateVisibility = this.calculateDelegateVisibility();
        if (delegateVisibility.length() > 0) {
            fieldBuffer.append(delegateVisibility).append(' ');
        }
        fieldBuffer.append("final ");
        String fullyQualifiedName = this.getQualifiedName();
        fieldBuffer.append(fullyQualifiedName);
        if (!this.typeParams.isEmpty()) {
            fieldBuffer.append('<');
            for (PsiTypeParameter typeParameter : this.typeParams) {
                fieldBuffer.append(typeParameter.getName());
            }
            fieldBuffer.append('>');
        }
        fieldBuffer.append(' ');
        fieldBuffer.append(this.delegateFieldName);
        fieldBuffer.append(" = new ").append(fullyQualifiedName);
        if (!this.typeParams.isEmpty()) {
            fieldBuffer.append('<');
            for (PsiTypeParameter typeParameter : this.typeParams) {
                fieldBuffer.append(typeParameter.getName());
            }
            fieldBuffer.append('>');
        }
        fieldBuffer.append('(');
        if (this.requiresBackpointer) {
            fieldBuffer.append("this");
        }
        fieldBuffer.append(");");
        try {
            String fieldString = fieldBuffer.toString();
            PsiField field = factory.createFieldFromText(fieldString, (PsiElement)this.sourceClass);
            PsiElement newField = this.sourceClass.add((PsiElement)field);
            codeStyleManager.reformat(JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(newField));
        }
        catch (IncorrectOperationException e) {
            logger.error((Throwable)e);
        }
    }

    @NonNls
    private String calculateDelegateVisibility() {
        for (PsiField field : this.fields) {
            if (!field.hasModifierProperty("public") || field.hasModifierProperty("static")) continue;
            return "public";
        }
        for (PsiField field : this.fields) {
            if (!field.hasModifierProperty("protected") || field.hasModifierProperty("static")) continue;
            return "protected";
        }
        for (PsiField field : this.fields) {
            if (!field.hasModifierProperty("packageLocal") || field.hasModifierProperty("static")) continue;
            return "";
        }
        return "private";
    }

    public void findUsages(@NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            ExtractClassProcessor.$$$reportNull$$$0(5);
        }
        for (PsiField field : this.fields) {
            this.findUsagesForField(field, usages);
            usages.add(new RemoveField(field));
        }
        usages.addAll(this.myExtractEnumProcessor.findEnumConstantUsages(new ArrayList<FixableUsageInfo>(usages)));
        for (PsiClass innerClass : this.innerClasses) {
            this.findUsagesForInnerClass(innerClass, usages);
            usages.add(new RemoveInnerClass(innerClass));
        }
        for (PsiMethod method : this.methods) {
            if (method.hasModifierProperty("static")) {
                this.findUsagesForStaticMethod(method, usages);
                continue;
            }
            this.findUsagesForMethod(method, usages);
        }
    }

    private void findUsagesForInnerClass(PsiClass innerClass, List<FixableUsageInfo> usages) {
        PsiManager psiManager = innerClass.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Query calls = ReferencesSearch.search((PsiElement)innerClass, (SearchScope)scope);
        String innerName = innerClass.getQualifiedName();
        assert (innerName != null);
        String sourceClassQualifiedName = this.sourceClass.getQualifiedName();
        assert (sourceClassQualifiedName != null);
        String newInnerClassName = this.getQualifiedName() + innerName.substring(sourceClassQualifiedName.length());
        boolean hasExternalReference = false;
        for (PsiReference reference : calls) {
            PsiElement referenceElement = reference.getElement();
            if (!(referenceElement instanceof PsiJavaCodeReferenceElement) || this.isInMovedElement(referenceElement)) continue;
            usages.add(new ReplaceClassReference((PsiJavaCodeReferenceElement)referenceElement, newInnerClassName));
            hasExternalReference = true;
        }
        if (hasExternalReference) {
            this.innerClassesToMakePublic.add(innerClass);
        }
    }

    private void findUsagesForMethod(PsiMethod method, List<FixableUsageInfo> usages) {
        PsiManager psiManager = method.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Query calls = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
        for (PsiReference reference : calls) {
            PsiMethodCallExpression call;
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (!(parent instanceof PsiMethodCallExpression) || this.isInMovedElement((PsiElement)(call = (PsiMethodCallExpression)parent))) continue;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                usages.add(new ReplaceThisCallWithDelegateCall(call, this.delegateFieldName));
            }
            this.delegationRequired = true;
        }
        if (!this.delegationRequired && MethodInheritanceUtils.hasSiblingMethods(method)) {
            this.delegationRequired = true;
        }
        if (this.delegationRequired) {
            usages.add(new MakeMethodDelegate(method, this.delegateFieldName));
        } else {
            usages.add(new RemoveMethod(method));
        }
    }

    private void findUsagesForStaticMethod(PsiMethod method, List<FixableUsageInfo> usages) {
        PsiManager psiManager = method.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Query calls = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
        String fullyQualifiedName = this.getQualifiedName();
        for (PsiReference reference : calls) {
            PsiElement qualifier;
            PsiJavaCodeReferenceElement importReference2;
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)parent;
                if (this.isInMovedElement((PsiElement)call)) continue;
                usages.add(new RetargetStaticMethodCall(call, fullyQualifiedName));
                continue;
            }
            if (!(parent instanceof PsiImportStaticStatement) || (importReference2 = ((PsiImportStaticStatement)parent).getImportReference()) == null || !((qualifier = importReference2.getQualifier()) instanceof PsiJavaCodeReferenceElement)) continue;
            usages.add(new ReplaceClassReference((PsiJavaCodeReferenceElement)qualifier, fullyQualifiedName));
        }
        usages.add(new RemoveMethod(method));
    }

    private boolean isInMovedElement(PsiElement exp) {
        for (PsiField field : this.fields) {
            if (!PsiTreeUtil.isAncestor((PsiElement)field, (PsiElement)exp, (boolean)false)) continue;
            return true;
        }
        for (PsiMethod method : this.methods) {
            if (!PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)exp, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void findUsagesForField(PsiField field, List<FixableUsageInfo> usages) {
        PsiManager psiManager = field.getManager();
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        String qualifiedName = this.getQualifiedName();
        String getter = null;
        if (this.myGenerateAccessors) {
            getter = GenerateMembersUtil.suggestGetterName(field);
        } else {
            PsiMethod fieldGetter = PropertyUtilBase.findPropertyGetter((PsiClass)this.sourceClass, (String)field.getName(), (boolean)false, (boolean)false);
            if (fieldGetter != null && this.isInMovedElement((PsiElement)fieldGetter)) {
                getter = fieldGetter.getName();
            }
        }
        String setter = null;
        if (this.myGenerateAccessors) {
            setter = GenerateMembersUtil.suggestSetterName(field);
        } else {
            PsiMethod fieldSetter = PropertyUtilBase.findPropertySetter((PsiClass)this.sourceClass, (String)field.getName(), (boolean)false, (boolean)false);
            if (fieldSetter != null && this.isInMovedElement((PsiElement)fieldSetter)) {
                setter = fieldSetter.getName();
            }
        }
        boolean isStatic = field.hasModifierProperty("static");
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)scope)) {
            PsiElement element = reference.getElement();
            if (this.isInMovedElement(element)) continue;
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression exp = (PsiReferenceExpression)element;
                if (PsiUtil.isIncrementDecrementOperation((PsiElement)exp.getParent())) {
                    usages.add(isStatic ? new ReplaceStaticVariableIncrementDecrement((PsiExpression)exp, qualifiedName) : new ReplaceInstanceVariableIncrementDecrement((PsiExpression)exp, this.delegateFieldName, setter, getter, field.getName()));
                } else if (RefactoringUtil.isAssignmentLHS((PsiElement)exp)) {
                    usages.add(isStatic ? new ReplaceStaticVariableAssignment(exp, qualifiedName) : new ReplaceInstanceVariableAssignment((PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)exp, PsiAssignmentExpression.class), this.delegateFieldName, setter, getter, field.getName()));
                } else {
                    usages.add(isStatic ? new ReplaceStaticVariableAccess(exp, qualifiedName, this.enumConstants.contains(field)) : new ReplaceInstanceVariableAccess(exp, this.delegateFieldName, getter, field.getName()));
                }
                if (isStatic) continue;
                this.delegationRequired = true;
                continue;
            }
            if (!(element instanceof PsiDocTagValue)) continue;
            usages.add(new BindJavadocReference(element, qualifiedName, field.getName()));
        }
    }

    private PsiClass buildClass(boolean normalizeDeclaration) {
        PsiManager manager = this.sourceClass.getManager();
        Project project = this.sourceClass.getProject();
        ExtractedClassBuilder extractedClassBuilder = new ExtractedClassBuilder();
        extractedClassBuilder.setProject(this.myProject);
        extractedClassBuilder.setClassName(this.newClassName);
        extractedClassBuilder.setPackageName(this.newPackageName);
        extractedClassBuilder.setOriginalClassName(this.sourceClass.getQualifiedName());
        extractedClassBuilder.setRequiresBackPointer(this.requiresBackpointer);
        extractedClassBuilder.setExtractAsEnum(this.enumConstants);
        for (PsiField field : this.fields) {
            extractedClassBuilder.addField(field);
        }
        for (PsiMethod method : this.methods) {
            extractedClassBuilder.addMethod(method);
        }
        for (PsiClass innerClass : this.innerClasses) {
            extractedClassBuilder.addInnerClass(innerClass, this.innerClassesToMakePublic.contains(innerClass));
        }
        extractedClassBuilder.setTypeArguments(this.typeParams);
        List<PsiClass> interfaces = this.calculateInterfacesSupported();
        extractedClassBuilder.setInterfaces(interfaces);
        if (this.myGenerateAccessors) {
            NecessaryAccessorsVisitor visitor = this.checkNecessaryGettersSetters4ExtractedClass();
            this.sourceClass.accept((PsiElementVisitor)visitor);
            extractedClassBuilder.setFieldsNeedingGetters(visitor.getFieldsNeedingGetter());
            extractedClassBuilder.setFieldsNeedingSetters(visitor.getFieldsNeedingSetter());
        }
        String classString = extractedClassBuilder.buildBeanClass(normalizeDeclaration);
        if (this.extractInnerClass) {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
            PsiJavaFile newFile = (PsiJavaFile)factory.createFileFromText(this.newClassName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)classString);
            PsiClass psiClass = newFile.getClasses()[0];
            if (!psiClass.isEnum()) {
                PsiModifierList modifierList = psiClass.getModifierList();
                assert (modifierList != null);
                modifierList.setModifierProperty("static", true);
            }
            PsiElement addedClass = this.sourceClass.add((PsiElement)psiClass);
            return (PsiClass)CodeStyleManager.getInstance((PsiManager)manager).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedClass));
        }
        try {
            PsiDirectory directory;
            PsiFile containingFile = this.sourceClass.getContainingFile();
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            if (this.myMoveDestination != null) {
                directory = this.myMoveDestination.getTargetDirectory(containingDirectory);
            } else {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
                assert (module != null);
                directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.newPackageName, containingDirectory, false, true);
            }
            if (directory != null) {
                PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
                PsiFile newFile = factory.createFileFromText(this.newClassName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)classString);
                PsiElement addedFile = directory.add((PsiElement)newFile);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedFile);
                return ((PsiJavaFile)codeStyleManager.reformat(shortenedFile)).getClasses()[0];
            }
            return null;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private List<PsiClass> calculateInterfacesSupported() {
        PsiClass[] supers;
        ArrayList<PsiClass> out = new ArrayList<PsiClass>();
        for (PsiClass superClass : supers = this.sourceClass.getSupers()) {
            PsiMethod[] superclassMethods;
            if (!superClass.isInterface() || (superclassMethods = superClass.getMethods()).length == 0) continue;
            boolean allMethodsCovered = true;
            for (PsiMethod method : superclassMethods) {
                boolean isCovered = false;
                for (PsiMethod movedMethod : this.methods) {
                    if (!ExtractClassProcessor.isSuperMethod(method, movedMethod)) continue;
                    isCovered = true;
                    break;
                }
                if (isCovered) continue;
                allMethodsCovered = false;
                break;
            }
            if (!allMethodsCovered) continue;
            out.add(superClass);
        }
        Project project = this.sourceClass.getProject();
        PsiManager manager = this.sourceClass.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        if (ExtractClassProcessor.usesDefaultSerialization(this.sourceClass)) {
            PsiClass serializable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.io.Serializable", scope);
            out.add(serializable);
        }
        if (ExtractClassProcessor.usesDefaultClone(this.sourceClass)) {
            PsiClass cloneable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Cloneable", scope);
            out.add(cloneable);
        }
        return out;
    }

    private static boolean isSuperMethod(PsiMethod method, PsiMethod movedMethod) {
        PsiMethod[] superMethods;
        for (PsiMethod testMethod : superMethods = movedMethod.findSuperMethods()) {
            if (!testMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean usesDefaultClone(PsiClass aClass) {
        PsiMethod[] methods;
        Project project = aClass.getProject();
        PsiManager manager = aClass.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass cloneable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Cloneable", scope);
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)cloneable, (boolean)true)) {
            return false;
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("clone", false)) {
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (parameters2.length != 0) continue;
            return false;
        }
        return true;
    }

    private static boolean usesDefaultSerialization(PsiClass aClass) {
        PsiMethod[] methods;
        Project project = aClass.getProject();
        PsiManager manager = aClass.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass serializable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.io.Serializable", scope);
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)serializable, (boolean)true)) {
            return false;
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", false)) {
            PsiType type2;
            String text2;
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (parameters2.length != 1 || !"java.io.DataOutputStream".equals(text2 = (type2 = parameters2[0].getType()).getCanonicalText())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractclass/ExtractClassProcessor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractclass/ExtractClassProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class NecessaryAccessorsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> fieldsNeedingGetter = new HashSet<PsiField>();
        private final Set<PsiField> fieldsNeedingSetter = new HashSet<PsiField>();

        private NecessaryAccessorsVisitor() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiField field;
            super.visitReferenceExpression(expression2);
            if (this.isProhibitedReference((PsiExpression)expression2) && !this.hasGetter(field = this.getReferencedField((PsiExpression)expression2)) && !this.isStaticFinal(field) && !field.getModifierList().hasModifierProperty("public")) {
                this.fieldsNeedingGetter.add(field);
            }
        }

        private boolean isStaticFinal(PsiField field) {
            PsiModifierList modifierList = field.getModifierList();
            logger.assertTrue(modifierList != null);
            return modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final");
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            PsiField field;
            super.visitAssignmentExpression(expression2);
            PsiExpression lhs = expression2.getLExpression();
            if (this.isProhibitedReference(lhs) && !this.hasGetter(field = this.getReferencedField(lhs)) && !this.isStaticFinal(field) && !field.getModifierList().hasModifierProperty("public")) {
                this.fieldsNeedingSetter.add(field);
            }
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            this.checkSetterNeeded(expression2.getOperand(), expression2.getOperationSign());
        }

        private void checkSetterNeeded(PsiExpression operand2, PsiJavaToken sign) {
            PsiField field;
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            if (this.isProhibitedReference(operand2) && !this.hasSetter(field = this.getReferencedField(operand2)) && !this.isStaticFinal(field)) {
                this.fieldsNeedingSetter.add(field);
            }
        }

        public Set<PsiField> getFieldsNeedingGetter() {
            return this.fieldsNeedingGetter;
        }

        public Set<PsiField> getFieldsNeedingSetter() {
            return this.fieldsNeedingSetter;
        }

        private boolean hasGetter(PsiField field) {
            return this.hasGetterOrSetter(ExtractClassProcessor.this.sourceClass.findMethodsBySignature(GenerateMembersUtil.generateGetterPrototype(field), false));
        }

        private boolean hasSetter(PsiField field) {
            return this.hasGetterOrSetter(ExtractClassProcessor.this.sourceClass.findMethodsBySignature(GenerateMembersUtil.generateSetterPrototype(field), false));
        }

        protected abstract boolean hasGetterOrSetter(PsiMethod[] var1);

        protected boolean isProhibitedReference(PsiExpression expression2) {
            return BackpointerUtil.isBackpointerReference(expression2, (Condition<PsiField>)((Condition)field -> this.isProhibitedReference((PsiField)field)));
        }

        protected abstract boolean isProhibitedReference(PsiField var1);

        private PsiField getReferencedField(PsiExpression expression2) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiExpression contents = ((PsiParenthesizedExpression)expression2).getExpression();
                return this.getReferencedField(contents);
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
            return (PsiField)reference.resolve();
        }
    }
}

