/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;

public class BackpointerUtil {
    private BackpointerUtil() {
    }

    public static boolean isBackpointerReference(PsiExpression expression2, Condition<PsiField> value2) {
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiExpression contents = ((PsiParenthesizedExpression)expression2).getExpression();
            return BackpointerUtil.isBackpointerReference(contents, value2);
        }
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
        PsiElement qualifier = reference.getQualifier();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        PsiElement referent = reference.resolve();
        return referent instanceof PsiField && value2.value((Object)((PsiField)referent));
    }
}

