/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.util.Consumer;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class PreviewDiffRequest
extends SimpleDiffRequest {
    private static final Logger LOG = Logger.getInstance(PreviewDiffRequest.class);
    private final Map<FragmentNode, Couple<TextRange>> myLinesBounds;
    private final Consumer<FragmentNode> mySelectNode;
    private CaretTracker myCaretTracker;

    public PreviewDiffRequest(@NotNull Map<FragmentNode, Couple<TextRange>> linesBounds, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull Consumer<FragmentNode> selectNode) {
        if (linesBounds == null) {
            PreviewDiffRequest.$$$reportNull$$$0(0);
        }
        if (content1 == null) {
            PreviewDiffRequest.$$$reportNull$$$0(1);
        }
        if (content2 == null) {
            PreviewDiffRequest.$$$reportNull$$$0(2);
        }
        if (selectNode == null) {
            PreviewDiffRequest.$$$reportNull$$$0(3);
        }
        super(null, content1, content2, null, null);
        this.myLinesBounds = linesBounds;
        this.mySelectNode = selectNode;
    }

    public void setViewer(FrameDiffTool.DiffViewer viewer) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread(), (Object)"EDT only");
        this.myCaretTracker = viewer instanceof UnifiedDiffViewer ? new UnifiedCaretTracker((UnifiedDiffViewer)viewer) : (viewer instanceof SimpleDiffViewer ? new SimpleCaretTracker((SimpleDiffViewer)viewer) : null);
    }

    public void onNodeSelected(@NotNull FragmentNode node) {
        if (node == null) {
            PreviewDiffRequest.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread(), (Object)"EDT only");
        Couple<TextRange> bounds = this.myLinesBounds.get(node);
        if (bounds != null && this.myCaretTracker != null) {
            this.myCaretTracker.selectBounds(bounds);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesBounds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffRequest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onNodeSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class SimpleCaretTracker
    extends CaretTracker<SimpleDiffViewer> {
        private final CaretListener myListener1;
        private final CaretListener myListener2;

        protected SimpleCaretTracker(SimpleDiffViewer viewer) {
            super(PreviewDiffRequest.this, (DiffViewerBase)viewer);
            this.myListener1 = new CaretTracker.MyCaretListener(c -> (TextRange)c.getFirst());
            this.myListener2 = new CaretTracker.MyCaretListener(c -> (TextRange)c.getSecond());
        }

        protected void onInit() {
            ((SimpleDiffViewer)this.myViewer).getEditor1().getCaretModel().addCaretListener(this.myListener1);
            ((SimpleDiffViewer)this.myViewer).getEditor2().getCaretModel().addCaretListener(this.myListener2);
        }

        protected void onDispose() {
            ((SimpleDiffViewer)this.myViewer).getEditor1().getCaretModel().removeCaretListener(this.myListener1);
            ((SimpleDiffViewer)this.myViewer).getEditor2().getCaretModel().removeCaretListener(this.myListener2);
        }

        @Override
        protected void selectBounds(Couple<TextRange> bounds) {
            if (this.myMoveCaret) {
                this.setCaretPosition(((SimpleDiffViewer)this.myViewer).getEditor1(), (TextRange)bounds.getFirst());
                this.setCaretPosition(((SimpleDiffViewer)this.myViewer).getEditor2(), (TextRange)bounds.getSecond());
            }
        }
    }

    class UnifiedCaretTracker
    extends CaretTracker<UnifiedDiffViewer> {
        private final CaretListener myListener;

        protected UnifiedCaretTracker(UnifiedDiffViewer viewer) {
            super(PreviewDiffRequest.this, (DiffViewerBase)viewer);
            this.myListener = new CaretTracker.MyCaretListener(c -> (TextRange)c.getFirst());
        }

        protected void onInit() {
            EditorEx editor = ((UnifiedDiffViewer)this.myViewer).getEditor();
            editor.getCaretModel().addCaretListener(this.myListener);
        }

        protected void onDispose() {
            EditorEx editor = ((UnifiedDiffViewer)this.myViewer).getEditor();
            editor.getCaretModel().removeCaretListener(this.myListener);
        }

        @Override
        protected void selectBounds(Couple<TextRange> bounds) {
            if (this.myMoveCaret) {
                this.setCaretPosition(((UnifiedDiffViewer)this.myViewer).getEditor(), (TextRange)bounds.getFirst());
            }
        }
    }

    static abstract class CaretTracker<V extends DiffViewerBase>
    extends DiffViewerListener {
        protected final V myViewer;
        protected boolean myMoveCaret = true;
        final /* synthetic */ PreviewDiffRequest this$0;

        protected CaretTracker(V viewer) {
            this.this$0 = this$0;
            this.myViewer = viewer;
            viewer.addListener((DiffViewerListener)this);
        }

        protected abstract void selectBounds(Couple<TextRange> var1);

        protected void setCaretPosition(EditorEx editor, TextRange range) {
            CaretModel caretModel = editor.getCaretModel();
            int offset = caretModel.getOffset();
            if (!range.contains(offset)) {
                caretModel.moveToOffset(range.getStartOffset());
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }

        protected class MyCaretListener
        implements CaretListener {
            private final Function<Couple<TextRange>, TextRange> mySideGetter;

            public MyCaretListener(Function<Couple<TextRange>, TextRange> sideGetter) {
                this.mySideGetter = sideGetter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void caretPositionChanged(CaretEvent e) {
                CaretTracker.this.myMoveCaret = false;
                try {
                    int newOffset = e.getEditor().logicalPositionToOffset(e.getNewPosition());
                    for (Map.Entry entry : CaretTracker.this.this$0.myLinesBounds.entrySet()) {
                        TextRange range = this.mySideGetter.apply((Couple<TextRange>)entry.getValue());
                        if (!range.containsOffset(newOffset)) continue;
                        CaretTracker.this.this$0.mySelectNode.consume(entry.getKey());
                        break;
                    }
                }
                finally {
                    CaretTracker.this.myMoveCaret = true;
                }
            }
        }
    }
}

