/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractableFragment {
    private final SmartPsiElementPointer<PsiElement> myStart;
    private final SmartPsiElementPointer<PsiElement> myEnd;

    public ExtractableFragment(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            ExtractableFragment.$$$reportNull$$$0(0);
        }
        if (end == null) {
            ExtractableFragment.$$$reportNull$$$0(1);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)start.getProject());
        this.myStart = smartPointerManager.createSmartPsiElementPointer(start);
        this.myEnd = start != end ? smartPointerManager.createSmartPsiElementPointer(end) : this.myStart;
    }

    public ExtractableFragment(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ExtractableFragment.$$$reportNull$$$0(2);
        }
        if (elements.length == 0) {
            this.myStart = null;
            this.myEnd = null;
            return;
        }
        PsiElement start = elements[0];
        PsiElement end = elements[elements.length - 1];
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)start.getProject());
        this.myStart = smartPointerManager.createSmartPsiElementPointer(start);
        this.myEnd = start != end ? smartPointerManager.createSmartPsiElementPointer(end) : this.myStart;
    }

    @Nullable
    public Navigatable getNavigatable() {
        PsiElement start = this.myStart != null ? this.myStart.getElement() : null;
        return start instanceof Navigatable ? (Navigatable)start : null;
    }

    @Nullable
    public TextRange getTextRange() {
        if (this.myStart == null || this.myEnd == null) {
            return null;
        }
        PsiElement start = this.myStart.getElement();
        if (this.myStart == this.myEnd) {
            return start != null ? start.getTextRange() : null;
        }
        PsiElement end = this.myEnd.getElement();
        if (start == null || end == null) {
            return null;
        }
        return new TextRange(start.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
    }

    @Nullable
    public static TextRange getTextRange(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ExtractableFragment.$$$reportNull$$$0(3);
        }
        if (elements.length == 0) {
            return null;
        }
        if (elements.length == 1) {
            return elements[0].getTextRange();
        }
        return new TextRange(elements[0].getTextRange().getStartOffset(), elements[elements.length - 1].getTextRange().getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/ExtractableFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

