/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText;
        if (expr == null) {
            StringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            StringLiteralManipulator.$$$reportNull$$$0(1);
        }
        if ((oldText = expr.getText()).startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters((String)newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace((PsiElement)newExpr);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            StringLiteralManipulator.$$$reportNull$$$0(2);
        }
        TextRange textRange = StringLiteralManipulator.getValueRange(element);
        if (textRange == null) {
            StringLiteralManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression element) {
        boolean isQuoted;
        if (element == null) {
            StringLiteralManipulator.$$$reportNull$$$0(4);
        }
        int length = element.getTextLength();
        if (element instanceof PsiLiteralExpressionImpl) {
            IElementType type2 = ((PsiLiteralExpressionImpl)element).getLiteralElementType();
            if (type2 == JavaTokenType.RAW_STRING_LITERAL) {
                int trailingSeq;
                String text2 = ((PsiLiteralExpressionImpl)element).getNode().getText();
                int leadingSeq = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
                TextRange textRange = length >= leadingSeq + (trailingSeq = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2)) ? TextRange.from((int)leadingSeq, (int)(length - trailingSeq - leadingSeq)) : TextRange.from((int)0, (int)length);
                if (textRange == null) {
                    StringLiteralManipulator.$$$reportNull$$$0(5);
                }
                return textRange;
            }
            isQuoted = type2 == JavaTokenType.STRING_LITERAL || type2 == JavaTokenType.CHARACTER_LITERAL;
        } else {
            Object value2 = element.getValue();
            isQuoted = value2 instanceof String || value2 instanceof Character;
        }
        TextRange textRange = isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from((int)0, (int)length);
        if (textRange == null) {
            StringLiteralManipulator.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

