/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.List;

public class StrictSubtypingConstraint
implements ConstraintFormula {
    private PsiType myS;
    private PsiType myT;
    private final boolean myCapture;

    public StrictSubtypingConstraint(PsiType t, PsiType s) {
        this(t, s, true);
    }

    public StrictSubtypingConstraint(PsiType t, PsiType s, boolean capture) {
        this.myT = t;
        this.myS = s;
        this.myCapture = capture;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
        boolean reduceResult = this.doReduce(session, dependencies, constraints);
        if (!reduceResult) {
            session.registerIncompatibleErrorMessage(dependencies, session.getPresentableText(this.myS) + " conforms to " + session.getPresentableText(this.myT));
        }
        return reduceResult;
    }

    private boolean doReduce(InferenceSession session, HashSet<InferenceVariable> dependencies, List<ConstraintFormula> constraints) {
        PsiType lowerBound;
        if (!session.collectDependencies(this.myS, dependencies) && !session.collectDependencies(this.myT, dependencies)) {
            if (this.myT == null) {
                return this.myS == null || this.myS.equalsToText("java.lang.Object");
            }
            if (this.myS == null) {
                return true;
            }
            return TypeConversionUtil.isAssignable((PsiType)this.myT, (PsiType)this.myS);
        }
        if (PsiType.NULL.equals((Object)this.myT) || this.myT == null) {
            return false;
        }
        if (PsiType.NULL.equals((Object)this.myS) || this.myS == null || this.myT.equalsToText("java.lang.Object")) {
            return true;
        }
        if (PsiType.VOID.equals((Object)this.myS) ^ PsiType.VOID.equals((Object)this.myT)) {
            return false;
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myS, this.myT, InferenceBound.UPPER, session);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myT, this.myS, InferenceBound.LOWER, session);
            return true;
        }
        if (this.myT instanceof PsiArrayType) {
            PsiType upperBound;
            PsiType sType = this.myS;
            if (this.myS instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)this.myS).getUpperBound()) instanceof PsiArrayType) {
                sType = upperBound;
            }
            if (!(sType instanceof PsiArrayType)) {
                return false;
            }
            PsiType tComponentType = ((PsiArrayType)this.myT).getComponentType();
            PsiType sComponentType = ((PsiArrayType)sType).getComponentType();
            if (!(tComponentType instanceof PsiPrimitiveType) && !(sComponentType instanceof PsiPrimitiveType)) {
                constraints.add(new StrictSubtypingConstraint(tComponentType, sComponentType, this.myCapture));
                return true;
            }
            return sComponentType instanceof PsiPrimitiveType && sComponentType.equals(tComponentType);
        }
        if (this.myT instanceof PsiClassType) {
            PsiClassType.ClassResolveResult TResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClass CClass = TResult.getElement();
            if (CClass != null) {
                if (CClass instanceof PsiTypeParameter) {
                    PsiType lowerBound2;
                    if (this.myS instanceof PsiIntersectionType) {
                        for (PsiType conjunct : ((PsiIntersectionType)this.myS).getConjuncts()) {
                            if (!this.myT.equals(conjunct)) continue;
                            return true;
                        }
                    }
                    if ((lowerBound2 = TypeConversionUtil.getInferredLowerBoundForSynthetic((PsiTypeParameter)((PsiTypeParameter)CClass))) != null) {
                        constraints.add(new StrictSubtypingConstraint(lowerBound2, this.myS, this.myCapture));
                        return true;
                    }
                    return false;
                }
                if (this.myS instanceof PsiArrayType) {
                    return this.myT.isAssignableFrom(this.myS);
                }
                PsiClassType sType = StrictSubtypingConstraint.getSubclassType(CClass, this.myS, this.myCapture);
                if (sType == null) {
                    return false;
                }
                PsiClassType.ClassResolveResult SResult = sType.resolveGenerics();
                PsiClass SClass = SResult.getElement();
                if (SClass == null) {
                    return false;
                }
                if (((PsiClassType)this.myT).isRaw()) {
                    return InheritanceUtil.isInheritorOrSelf((PsiClass)SClass, (PsiClass)CClass, (boolean)true);
                }
                PsiSubstitutor substitutor = SResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : SClass.getTypeParameters()) {
                    substitutor = substitutor.put(typeParameter, substitutor.substituteWithBoundsPromotion(typeParameter));
                }
                PsiSubstitutor tSubstitutor = TResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)CClass, (PsiClass)SClass, (PsiSubstitutor)substitutor);
                if (sSubstitutor != null) {
                    for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)CClass)) {
                        PsiType sSubstituted;
                        PsiType tSubstituted = tSubstitutor.substitute(parameter2);
                        if (tSubstituted == null ^ (sSubstituted = sSubstitutor.substitute(parameter2)) == null) {
                            return false;
                        }
                        constraints.add(new SubtypingConstraint(tSubstituted, sSubstituted));
                    }
                    return true;
                }
            }
            return false;
        }
        if (this.myT instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)this.myT).getConjuncts()) {
                constraints.add(new StrictSubtypingConstraint(conjunct, this.myS, this.myCapture));
            }
            return true;
        }
        if (this.myT instanceof PsiCapturedWildcardType && (lowerBound = ((PsiCapturedWildcardType)this.myT).getLowerBound()) != PsiType.NULL) {
            constraints.add(new StrictSubtypingConstraint(lowerBound, this.myS, this.myCapture));
        }
        return true;
    }

    public static PsiClassType getSubclassType(PsiClass containingClass, PsiType sType, boolean capture) {
        if (sType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiClassType.ClassResolveResult conjunctResult;
                if (!(conjunct instanceof PsiClassType) || !InheritanceUtil.isInheritorOrSelf((PsiClass)(conjunctResult = ((PsiClassType)conjunct).resolveGenerics()).getElement(), (PsiClass)containingClass, (boolean)true)) continue;
                return (PsiClassType)conjunct;
            }
        } else {
            if (sType instanceof PsiClassType) {
                return (PsiClassType)sType;
            }
            if (sType instanceof PsiCapturedWildcardType) {
                PsiType upperBound = ((PsiCapturedWildcardType)sType).getUpperBound(capture);
                if (upperBound instanceof PsiClassType) {
                    return (PsiClassType)upperBound;
                }
                if (upperBound instanceof PsiIntersectionType) {
                    return StrictSubtypingConstraint.getSubclassType(containingClass, upperBound, capture);
                }
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictSubtypingConstraint that = (StrictSubtypingConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result = this.myS != null ? this.myS.hashCode() : 0;
        result = 31 * result + (this.myT != null ? this.myT.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myT.getPresentableText() + " < " + this.myS.getPresentableText();
    }
}

