/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiOldInferenceHelper
implements PsiInferenceHelper {
    private static final Logger LOG = Logger.getInstance(PsiOldInferenceHelper.class);
    public static final Pair<PsiType, ConstraintType> RAW_INFERENCE = new Pair(null, (Object)ConstraintType.EQUALS);
    private final PsiManager myManager;
    private static final Pair<PsiType, ConstraintType> FAILED_INFERENCE = new Pair((Object)PsiType.NULL, (Object)ConstraintType.EQUALS);

    public PsiOldInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(2);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(3);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(4);
        }
        PsiType[] paramTypes = PsiType.createArray((int)arguments.length);
        PsiType[] argTypes = PsiType.createArray((int)arguments.length);
        if (parameters2.length > 0) {
            for (int j = 0; j < argTypes.length; ++j) {
                PsiExpression argument = arguments[j];
                if (argument == null || argument instanceof PsiMethodCallExpression && PsiResolveHelper.ourGuard.currentStack().contains(argument)) continue;
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                argTypes[j] = argument.getType();
                if (!stackStamp.mayCacheNow()) {
                    argTypes[j] = null;
                    continue;
                }
                PsiParameter parameter2 = parameters2[Math.min(j, parameters2.length - 1)];
                if (j >= parameters2.length && !parameter2.isVarArgs()) break;
                paramTypes[j] = parameter2.getType();
                if (!(paramTypes[j] instanceof PsiEllipsisType)) continue;
                paramTypes[j] = ((PsiEllipsisType)paramTypes[j]).getComponentType();
                if (arguments.length != parameters2.length || !(argTypes[j] instanceof PsiArrayType) || ((PsiArrayType)argTypes[j]).getComponentType() instanceof PsiPrimitiveType) continue;
                argTypes[j] = ((PsiArrayType)argTypes[j]).getComponentType();
            }
        }
        return this.inferTypeForMethodTypeParameterInner(typeParameter, paramTypes, argTypes, partialSubstitutor, parent, policy);
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType[] paramTypes, @NotNull PsiType[] argTypes, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(5);
        }
        if (paramTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(6);
        }
        if (argTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(7);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(8);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(9);
        }
        PsiWildcardType wildcardToCapture = null;
        Pair<PsiType, ConstraintType> rawInference = null;
        PsiPrimitiveType lowerBound = PsiType.NULL;
        PsiPrimitiveType upperBound = PsiType.NULL;
        if (paramTypes.length > 0) {
            block5: for (int j = 0; j < argTypes.length; ++j) {
                Pair<PsiType, ConstraintType> currentSubstitution;
                PsiType parameterType;
                PsiType argumentType = argTypes[j];
                if (argumentType == null) continue;
                if (j >= paramTypes.length || (parameterType = paramTypes[j]) == null) break;
                if (parameterType instanceof PsiEllipsisType) {
                    parameterType = ((PsiEllipsisType)parameterType).getComponentType();
                    if (argTypes.length == paramTypes.length && argumentType instanceof PsiArrayType && !(((PsiArrayType)argumentType).getComponentType() instanceof PsiPrimitiveType)) {
                        argumentType = ((PsiArrayType)argumentType).getComponentType();
                    }
                }
                if ((currentSubstitution = this.getSubstitutionForTypeParameterConstraint(typeParameter, parameterType, argumentType, true, PsiUtil.getLanguageLevel((PsiElement)typeParameter))) == null) continue;
                if (currentSubstitution == FAILED_INFERENCE) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                ConstraintType constraintType = (ConstraintType)currentSubstitution.getSecond();
                PsiType type2 = (PsiType)currentSubstitution.getFirst();
                if (type2 == null) {
                    rawInference = RAW_INFERENCE;
                    continue;
                }
                switch (constraintType) {
                    case EQUALS: {
                        if (!(type2 instanceof PsiWildcardType)) {
                            return currentSubstitution;
                        }
                        if (wildcardToCapture != null) {
                            return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                        }
                        wildcardToCapture = (PsiWildcardType)type2;
                        continue block5;
                    }
                    case SUPERTYPE: {
                        if (PsiType.NULL.equals((Object)lowerBound)) {
                            lowerBound = type2;
                            continue block5;
                        }
                        if (lowerBound.equals(type2) || (lowerBound = GenericsUtil.getLeastUpperBound((PsiType)lowerBound, (PsiType)type2, (PsiManager)this.myManager)) != null) continue block5;
                        return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                    }
                    case SUBTYPE: {
                        if (!PsiType.NULL.equals((Object)upperBound) && !TypeConversionUtil.isAssignable((PsiType)upperBound, (PsiType)type2)) continue block5;
                        upperBound = type2;
                    }
                }
            }
        }
        if (wildcardToCapture != null) {
            if (lowerBound != PsiType.NULL) {
                if (!wildcardToCapture.isAssignableFrom((PsiType)lowerBound)) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                if (wildcardToCapture.isSuper()) {
                    return new Pair(wildcardToCapture, (Object)ConstraintType.SUPERTYPE);
                }
                lowerBound = GenericsUtil.getLeastUpperBound((PsiType)lowerBound, wildcardToCapture, (PsiManager)this.myManager);
            } else {
                if (upperBound != PsiType.NULL && !upperBound.isAssignableFrom(wildcardToCapture)) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                return new Pair(wildcardToCapture, (Object)ConstraintType.EQUALS);
            }
        }
        if (rawInference != null) {
            return rawInference;
        }
        if (lowerBound != PsiType.NULL) {
            return Pair.create((Object)lowerBound, (Object)ConstraintType.EQUALS);
        }
        if (parent != null && (constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null) {
            if (constraint.getSecond() != ConstraintType.SUBTYPE) {
                return constraint;
            }
            if (upperBound != PsiType.NULL) {
                return Pair.create((Object)upperBound, (Object)ConstraintType.SUBTYPE);
            }
            return constraint;
        }
        if (upperBound != PsiType.NULL) {
            return Pair.create((Object)upperBound, (Object)ConstraintType.SUBTYPE);
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> getFailedInferenceConstraint(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(10);
        }
        return new Pair((Object)JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType((PsiClass)typeParameter), (Object)ConstraintType.EQUALS);
    }

    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(11);
        }
        if (parameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(12);
        }
        if (arguments == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(13);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(14);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(15);
        }
        if ((constraint = this.inferTypeForMethodTypeParameterInner(typeParameter, parameters2, arguments, partialSubstitutor, parent, policy)) == null) {
            return PsiType.NULL;
        }
        return (PsiType)constraint.getFirst();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        PsiType substitution;
        PsiTypeParameter typeParameter;
        int i;
        if (typeParameters == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(16);
        }
        if (parameters2 == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(17);
        }
        if (arguments == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(18);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(20);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(21);
        }
        if (languageLevel == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(22);
        }
        PsiType[] substitutions = PsiType.createArray((int)typeParameters.length);
        Pair[] constraints = new Pair[typeParameters.length];
        for (i = 0; i < typeParameters.length; ++i) {
            Pair<PsiType, ConstraintType> constraint;
            if (substitutions[i] != null) continue;
            constraints[i] = constraint = this.inferTypeForMethodTypeParameterInner(typeParameters[i], parameters2, arguments, partialSubstitutor, null, policy);
            if (constraint == null || constraint.getSecond() == ConstraintType.SUBTYPE) continue;
            substitutions[i] = (PsiType)constraint.getFirst();
            if (substitutions[i] == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameters[i], substitutions[i]);
            i = -1;
        }
        for (i = 0; i < typeParameters.length; ++i) {
            typeParameter = typeParameters[i];
            if (substitutions[i] != null) continue;
            PsiPrimitiveType substitutionFromBounds = PsiType.NULL;
            block2: for (int j = 0; j < typeParameters.length; ++j) {
                PsiClassType[] bounds;
                if (i == j) continue;
                PsiTypeParameter other = typeParameters[j];
                PsiType otherSubstitution = substitutions[j];
                if (otherSubstitution == null) continue;
                for (PsiClassType bound : bounds = other.getExtendsListTypes()) {
                    PsiType substitutedBound = partialSubstitutor.substitute((PsiType)bound);
                    Pair<PsiType, ConstraintType> currentConstraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                    if (currentConstraint == null) continue;
                    PsiType currentSubstitution = (PsiType)currentConstraint.getFirst();
                    ConstraintType currentConstraintType = (ConstraintType)currentConstraint.getSecond();
                    if (currentConstraintType == ConstraintType.EQUALS) {
                        substitutionFromBounds = currentSubstitution;
                        if (currentSubstitution != null) break block2;
                        constraints[i] = FAILED_INFERENCE;
                        break block2;
                    }
                    if (currentConstraintType != ConstraintType.SUPERTYPE || JavaVersionService.getInstance().isAtLeast(parent, JavaSdkVersion.JDK_1_7)) continue;
                    substitutionFromBounds = PsiType.NULL.equals((Object)substitutionFromBounds) ? currentSubstitution : GenericsUtil.getLeastUpperBound((PsiType)substitutionFromBounds, (PsiType)currentSubstitution, (PsiManager)this.myManager);
                }
            }
            if (substitutionFromBounds == PsiType.NULL) continue;
            substitutions[i] = substitutionFromBounds;
        }
        for (i = 0; i < typeParameters.length; ++i) {
            typeParameter = typeParameters[i];
            substitution = substitutions[i];
            if (substitution == PsiType.NULL) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, substitution);
        }
        for (i = 0; i < typeParameters.length; ++i) {
            Pair<PsiType, ConstraintType> otherConstraint;
            typeParameter = typeParameters[i];
            substitution = substitutions[i];
            if (substitution != null) continue;
            Pair<PsiType, ConstraintType> constraint = constraints[i];
            if (constraint == null) {
                constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy);
            } else if (constraint.getSecond() == ConstraintType.SUBTYPE && (otherConstraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null && (otherConstraint.getSecond() == ConstraintType.EQUALS || otherConstraint.getSecond() == ConstraintType.SUPERTYPE || PsiOldInferenceHelper.compareSubtypes((PsiType)constraint.getFirst(), (PsiType)otherConstraint.getFirst()))) {
                constraint = otherConstraint;
            }
            if (constraint != null) {
                substitution = (PsiType)constraint.getFirst();
            }
            if (substitution == null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
                PsiSubstitutor psiSubstitutor = factory.createRawSubstitutor(partialSubstitutor, typeParameters);
                if (psiSubstitutor == null) {
                    PsiOldInferenceHelper.$$$reportNull$$$0(23);
                }
                return psiSubstitutor;
            }
            if (substitution == PsiType.NULL) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, substitution);
        }
        PsiSubstitutor psiSubstitutor = partialSubstitutor;
        if (psiSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(24);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(25);
        }
        if (leftTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(26);
        }
        if (rightTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(27);
        }
        if (languageLevel == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(28);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
        if (psiSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(29);
        }
        return psiSubstitutor;
    }

    private static boolean compareSubtypes(PsiType type2, PsiType parentType) {
        return type2 != null && parentType != null && TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)parentType);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(30);
        }
        if (leftTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(31);
        }
        if (rightTypes == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(32);
        }
        if (partialSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(33);
        }
        if (languageLevel == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(34);
        }
        if (leftTypes.length != rightTypes.length) {
            throw new IllegalArgumentException("Types must be of the same length");
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : typeParameters) {
            PsiPrimitiveType substitution = PsiType.NULL;
            PsiPrimitiveType lowerBound = PsiType.NULL;
            for (int i1 = 0; i1 < leftTypes.length; ++i1) {
                PsiType leftType = leftTypes[i1];
                PsiType rightType = rightTypes[i1];
                Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, leftType, rightType, true, languageLevel);
                if (constraint == null) continue;
                ConstraintType constraintType = (ConstraintType)constraint.getSecond();
                PsiType current = (PsiType)constraint.getFirst();
                if (constraintType == ConstraintType.EQUALS) {
                    substitution = current;
                    break;
                }
                if (constraintType == ConstraintType.SUBTYPE) {
                    if (PsiType.NULL.equals((Object)substitution)) {
                        substitution = current;
                        continue;
                    }
                    substitution = GenericsUtil.getLeastUpperBound((PsiType)substitution, (PsiType)current, (PsiManager)this.myManager);
                    continue;
                }
                lowerBound = PsiType.NULL.equals((Object)lowerBound) ? current : GenericsUtil.getLeastUpperBound((PsiType)lowerBound, (PsiType)current, (PsiManager)this.myManager);
            }
            if (PsiType.NULL.equals((Object)substitution)) {
                substitution = lowerBound;
            }
            if (substitution == PsiType.NULL) continue;
            substitutor = substitutor.put(typeParameter, (PsiType)substitution);
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            if (substitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiPrimitiveType substitutionFromBounds = PsiType.NULL;
            block3: for (int j = 0; j < typeParameters.length; ++j) {
                PsiClassType[] bounds;
                PsiTypeParameter other;
                PsiType otherSubstitution;
                if (i == j || (otherSubstitution = substitutor.substitute(other = typeParameters[j])) == null) continue;
                for (PsiClassType bound : bounds = other.getExtendsListTypes()) {
                    PsiType substitutedBound = substitutor.substitute((PsiType)bound);
                    Pair<PsiType, ConstraintType> currentConstraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                    if (currentConstraint == null) continue;
                    PsiType currentSubstitution = (PsiType)currentConstraint.getFirst();
                    ConstraintType currentConstraintType = (ConstraintType)currentConstraint.getSecond();
                    if (currentConstraintType == ConstraintType.EQUALS) {
                        substitutionFromBounds = currentSubstitution;
                        break block3;
                    }
                    if (currentConstraintType != ConstraintType.SUPERTYPE) continue;
                    substitutionFromBounds = PsiType.NULL.equals((Object)substitutionFromBounds) ? currentSubstitution : GenericsUtil.getLeastUpperBound((PsiType)substitutionFromBounds, (PsiType)currentSubstitution, (PsiManager)this.myManager);
                }
            }
            if (substitutionFromBounds == PsiType.NULL) continue;
            substitutor = substitutor.put(typeParameter, (PsiType)substitutionFromBounds);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(35);
        }
        return psiSubstitutor;
    }

    @Nullable
    private static Pair<PsiType, ConstraintType> processArgType(PsiType arg, ConstraintType constraintType, boolean captureWildcard) {
        if (arg instanceof PsiWildcardType && !captureWildcard) {
            return FAILED_INFERENCE;
        }
        if (arg != PsiType.NULL) {
            return Pair.create((Object)arg, (Object)constraintType);
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(36);
        }
        if (substitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(37);
        }
        if (parent == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(38);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(39);
        }
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        Pair<PsiType, ConstraintType> substitution = null;
        if (owner instanceof PsiMethod && parent instanceof PsiCallExpression) {
            PsiCallExpression methodCall = (PsiCallExpression)parent;
            substitution = this.inferMethodTypeParameterFromParent(PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent()), (PsiExpression)methodCall, typeParameter, substitutor, policy);
        }
        return substitution;
    }

    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParam, param, arg, isContraVariantPosition, languageLevel);
        return constraint == null ? PsiType.NULL : (PsiType)constraint.getFirst();
    }

    @Nullable
    public Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterConstraint(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiClassType.ClassResolveResult paramResult;
        PsiClass paramClass;
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterConstraint(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return null;
        }
        PsiManager manager = this.myManager;
        if (arg instanceof PsiPrimitiveType) {
            if (!JavaVersionService.getInstance().isAtLeast((PsiElement)typeParam, JavaSdkVersion.JDK_1_7) && !isContraVariantPosition) {
                return null;
            }
            if ((arg = ((PsiPrimitiveType)arg).getBoxedType((PsiElement)typeParam)) == null) {
                return null;
            }
        }
        if (arg instanceof PsiCapturedWildcardType) {
            arg = ((PsiCapturedWildcardType)arg).getUpperBound();
        }
        if (typeParam == (paramClass = (PsiClass)(paramResult = ((PsiClassType)param).resolveGenerics()).getElement())) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)arg);
            if (arg == null || arg.getDeepComponentType() instanceof PsiPrimitiveType || arg instanceof PsiIntersectionType || psiClass != null && (isContraVariantPosition || !"java.lang.Object".equals(psiClass.getQualifiedName()) || arg instanceof PsiArrayType)) {
                PsiType bound = PsiOldInferenceHelper.intersectAllExtends(typeParam, arg);
                return Pair.create((Object)bound, (Object)ConstraintType.SUPERTYPE);
            }
            if (psiClass == null && arg instanceof PsiClassType) {
                return Pair.create((Object)arg, (Object)ConstraintType.EQUALS);
            }
            return null;
        }
        if (paramClass == null) {
            return null;
        }
        if (!(arg instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
        PsiClass argClass = (PsiClass)argResult.getElement();
        if (argClass == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiClassType patternType = factory.createType((PsiClass)typeParam);
        if (isContraVariantPosition) {
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)paramClass, (PsiClass)argClass, (PsiSubstitutor)argResult.getSubstitutor());
            if (substitutor == null) {
                return null;
            }
            arg = factory.createType(paramClass, substitutor, languageLevel);
        } else {
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)argClass, (PsiClass)paramClass, (PsiSubstitutor)paramResult.getSubstitutor());
            if (substitutor == null) {
                return null;
            }
            param = factory.createType(argClass, substitutor, languageLevel);
        }
        return this.getSubstitutionForTypeParameterInner(param, arg, (PsiType)patternType, ConstraintType.SUPERTYPE, 0);
    }

    private static PsiType intersectAllExtends(PsiTypeParameter typeParam, PsiType arg) {
        if (arg == null) {
            return null;
        }
        PsiClassType[] superTypes = typeParam.getSuperTypes();
        Object[] erasureTypes = PsiType.createArray((int)superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            erasureTypes[i] = TypeConversionUtil.erasure((PsiType)superTypes[i]);
        }
        PsiType[] types = (PsiType[])ArrayUtil.append((Object[])erasureTypes, (Object)arg, PsiType.class);
        assert (types.length != 0);
        return PsiIntersectionType.createIntersection((PsiType[])types);
    }

    @Nullable
    private Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterInner(PsiType param, PsiType arg, PsiType patternType, ConstraintType constraintType, int depth) {
        if (patternType.equals(param)) {
            return PsiOldInferenceHelper.processArgType(arg, constraintType, depth < 2);
        }
        if (arg instanceof PsiCapturedWildcardType && (depth < 2 || constraintType != ConstraintType.EQUALS || param instanceof PsiWildcardType)) {
            arg = ((PsiCapturedWildcardType)arg).getWildcard();
        }
        if (param instanceof PsiWildcardType) {
            PsiClassType.ClassResolveResult argResult;
            PsiClass argClass;
            PsiClassType.ClassResolveResult boundResult;
            PsiClass boundClass;
            Pair<PsiType, ConstraintType> res;
            ConstraintType constrType;
            PsiWildcardType wildcardParam = (PsiWildcardType)param;
            PsiType paramBound = wildcardParam.getBound();
            if (paramBound == null) {
                return null;
            }
            ConstraintType constraintType2 = constrType = wildcardParam.isExtends() ? ConstraintType.SUPERTYPE : ConstraintType.SUBTYPE;
            if (arg instanceof PsiWildcardType) {
                if (((PsiWildcardType)arg).isExtends() == wildcardParam.isExtends() && ((PsiWildcardType)arg).isBounded() == wildcardParam.isBounded() && (res = this.getSubstitutionForTypeParameterInner(paramBound, ((PsiWildcardType)arg).getBound(), patternType, constrType, depth)) != null) {
                    return res;
                }
            } else if (patternType.equals(paramBound)) {
                res = this.getSubstitutionForTypeParameterInner(paramBound, arg, patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiArrayType && arg instanceof PsiArrayType) {
                res = this.getSubstitutionForTypeParameterInner(((PsiArrayType)paramBound).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiClassType && arg instanceof PsiClassType && (boundClass = (boundResult = ((PsiClassType)paramBound).resolveGenerics()).getElement()) != null && (argClass = (argResult = ((PsiClassType)arg).resolveGenerics()).getElement()) != null) {
                Pair<PsiType, ConstraintType> res2;
                PsiType substituted;
                PsiSubstitutor superSubstitutor;
                if (wildcardParam.isExtends()) {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)boundClass, (PsiClass)argClass, (PsiSubstitutor)argResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)boundClass)) {
                            substituted = superSubstitutor.substitute(typeParameter);
                            if (substituted == null || (res2 = this.getSubstitutionForTypeParameterInner(boundResult.getSubstitutor().substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                            return res2;
                        }
                    }
                } else {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)argClass, (PsiClass)boundClass, (PsiSubstitutor)boundResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)argClass)) {
                            substituted = argResult.getSubstitutor().substitute(typeParameter);
                            if (substituted == null || (res2 = this.getSubstitutionForTypeParameterInner(superSubstitutor.substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null || res2 == FAILED_INFERENCE) continue;
                            return res2;
                        }
                    }
                }
            }
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterInner(((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constraintType, depth);
        }
        if (param instanceof PsiClassType && arg instanceof PsiClassType) {
            PsiClassType.ClassResolveResult paramResult = ((PsiClassType)param).resolveGenerics();
            PsiClass paramClass = paramResult.getElement();
            if (paramClass == null) {
                return null;
            }
            PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
            PsiClass argClass = argResult.getElement();
            if (!paramClass.isEquivalentTo((PsiElement)argClass)) {
                return null;
            }
            PsiPrimitiveType lowerBound = PsiType.NULL;
            PsiPrimitiveType upperBound = PsiType.NULL;
            Pair<PsiType, ConstraintType> wildcardCaptured = null;
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)paramClass)) {
                Pair<PsiType, ConstraintType> res;
                PsiType paramType = paramResult.getSubstitutor().substitute(typeParameter);
                PsiType argType = argResult.getSubstitutor().substituteWithBoundsPromotion(typeParameter);
                if (wildcardCaptured != null) {
                    boolean alreadyFound = false;
                    for (PsiTypeParameter typeParam : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)paramClass)) {
                        if (typeParam == typeParameter || paramType == null || argResult.getSubstitutor().substituteWithBoundsPromotion(typeParam) != argType || !paramType.equals(paramResult.getSubstitutor().substitute(typeParam))) continue;
                        alreadyFound = true;
                    }
                    if (alreadyFound) continue;
                }
                if ((res = this.getSubstitutionForTypeParameterInner(paramType, argType, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                PsiType type2 = (PsiType)res.getFirst();
                switch ((ConstraintType)res.getSecond()) {
                    case EQUALS: {
                        if (!(type2 instanceof PsiWildcardType)) {
                            return res;
                        }
                        if (wildcardCaptured != null) {
                            return FAILED_INFERENCE;
                        }
                        wildcardCaptured = res;
                        break;
                    }
                    case SUPERTYPE: {
                        wildcardCaptured = res;
                        if (PsiType.NULL.equals((Object)lowerBound)) {
                            lowerBound = type2;
                            break;
                        }
                        if (lowerBound.equals(type2) || (lowerBound = GenericsUtil.getLeastUpperBound((PsiType)lowerBound, (PsiType)type2, (PsiManager)this.myManager)) != null) break;
                        return FAILED_INFERENCE;
                    }
                    case SUBTYPE: {
                        wildcardCaptured = res;
                        if (!PsiType.NULL.equals((Object)upperBound) && !TypeConversionUtil.isAssignable((PsiType)upperBound, (PsiType)type2)) break;
                        upperBound = type2;
                    }
                }
            }
            if (lowerBound != PsiType.NULL) {
                return Pair.create((Object)lowerBound, (Object)ConstraintType.SUPERTYPE);
            }
            if (upperBound != PsiType.NULL) {
                return Pair.create((Object)upperBound, (Object)ConstraintType.SUBTYPE);
            }
            return wildcardCaptured;
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiElement parent, @NotNull PsiExpression methodCall, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull ParameterTypeInferencePolicy policy) {
        PsiElement pParent;
        if (parent == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(40);
        }
        if (methodCall == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(41);
        }
        if (typeParameter == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(42);
        }
        if (substitutor == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(43);
        }
        if (policy == null) {
            PsiOldInferenceHelper.$$$reportNull$$$0(44);
        }
        Pair constraint = null;
        PsiType expectedType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)methodCall);
        if (expectedType == null && parent instanceof PsiExpressionList && (pParent = parent.getParent()) instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList())) {
            constraint = policy.inferTypeConstraintFromCallContext(methodCall, (PsiExpressionList)parent, (PsiCallExpression)pParent, typeParameter);
        }
        GlobalSearchScope scope = parent.getResolveScope();
        PsiType returnType = null;
        if (constraint == null) {
            PsiType guess;
            if (expectedType == null) {
                PsiType psiType = expectedType = methodCall instanceof PsiCallExpression ? policy.getDefaultExpectedType((PsiCallExpression)methodCall) : null;
            }
            if ((constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, returnType = ((PsiMethod)typeParameter.getOwner()).getReturnType(), expectedType, false, PsiUtil.getLanguageLevel((PsiElement)parent))) != null && (guess = (PsiType)constraint.getFirst()) != null && !guess.equals(PsiType.NULL) && constraint.getSecond() == ConstraintType.SUPERTYPE && guess instanceof PsiIntersectionType && !JavaVersionService.getInstance().isAtLeast(parent, JavaSdkVersion.JDK_1_7)) {
                for (PsiType conjuct : ((PsiIntersectionType)guess).getConjuncts()) {
                    if (conjuct.isAssignableFrom(expectedType)) continue;
                    return FAILED_INFERENCE;
                }
            }
        }
        PsiClassType[] superTypes = typeParameter.getSuperTypes();
        PsiType[] types = PsiType.createArray((int)superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            PsiType superType = substitutor.substitute((PsiType)superTypes[i]);
            if (superType instanceof PsiClassType && ((PsiClassType)superType).isRaw()) {
                superType = TypeConversionUtil.erasure((PsiType)superType);
            }
            if (superType == null) {
                superType = PsiType.getJavaLangObject((PsiManager)this.myManager, (GlobalSearchScope)scope);
            }
            types[i] = superType;
        }
        if (constraint == null) {
            if (methodCall instanceof PsiCallExpression) {
                if (types.length == 0) {
                    return null;
                }
                return policy.getInferredTypeWithNoConstraint(this.myManager, PsiIntersectionType.createIntersection((PsiType[])types));
            }
            return null;
        }
        PsiType guess = (PsiType)constraint.getFirst();
        if (guess != null && types.length > 0) {
            guess = GenericsUtil.getGreatestLowerBound((PsiType)guess, (PsiType)PsiIntersectionType.createIntersection((PsiType[])types));
        }
        guess = policy.adjustInferredType(this.myManager, guess, (ConstraintType)constraint.getSecond());
        if (returnType instanceof PsiClassType && typeParameter.equals(((PsiClassType)returnType).resolve())) {
            PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
            PsiSubstitutor newSubstitutor = substitutor.put(typeParameter, guess);
            for (PsiClassType extendsType1 : extendsTypes) {
                PsiType extendsType = newSubstitutor.substitute((PsiType)extendsType1);
                if (guess == null || extendsType.isAssignableFrom(guess)) continue;
                if (!guess.isAssignableFrom(extendsType)) break;
                guess = extendsType;
                newSubstitutor = substitutor.put(typeParameter, guess);
            }
        }
        return Pair.create((Object)guess, (Object)constraint.getSecond());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 1: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 21: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
            case 16: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 20: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypes";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypes";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameterInner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFailedInferenceConstraint";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameter";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodTypeParameterFromParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

