/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.formatting.IndentInfo;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDComment {
    protected final CommentFormatter myFormatter;
    private String myDescription;
    private List<String> myUnknownList;
    private List<String> mySeeAlsoList;
    private List<String> mySinceList;
    private String myDeprecated;
    private boolean myMultiLineComment;
    private String myFirstLine;
    private String myEndLine;

    public JDComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            JDComment.$$$reportNull$$$0(0);
        }
        this.myFirstLine = "/**";
        this.myEndLine = "*/";
        this.myFormatter = formatter;
    }

    protected static boolean isNull(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    protected static boolean isNull(@Nullable List<?> l) {
        return l == null || l.isEmpty();
    }

    public void setMultiLine(boolean value2) {
        this.myMultiLineComment = value2;
    }

    @NotNull
    protected String javadocContinuationIndent() {
        if (!this.myFormatter.getSettings().JD_INDENT_ON_CONTINUATION) {
            if ("" == null) {
                JDComment.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = this.continuationIndent();
        if (string == null) {
            JDComment.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String continuationIndent() {
        CodeStyleSettings settings = this.myFormatter.getSettings().getContainer();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)JavaFileType.INSTANCE);
        String string = new IndentInfo(0, indentOptions.CONTINUATION_INDENT_SIZE, 0).generateNewWhiteSpace(indentOptions);
        if (string == null) {
            JDComment.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String generate(@NotNull String indent) {
        StringBuilder tagDescription;
        JDTag tag;
        if (indent == null) {
            JDComment.$$$reportNull$$$0(4);
        }
        String prefix = this.myFormatter.getSettings().JD_LEADING_ASTERISKS_ARE_ENABLED ? indent + " * " : indent;
        StringBuilder sb = new StringBuilder();
        int start = sb.length();
        if (!JDComment.isNull(this.myDescription)) {
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myDescription, prefix));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_DESCRIPTION) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        this.generateSpecial(prefix, sb);
        String continuationPrefix = prefix + this.javadocContinuationIndent();
        if (!JDComment.isNull(this.myUnknownList) && this.myFormatter.getSettings().JD_KEEP_INVALID_TAGS) {
            for (String string : this.myUnknownList) {
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(string, prefix, continuationPrefix));
            }
        }
        if (!JDComment.isNull(this.mySeeAlsoList)) {
            tag = JDTag.SEE;
            for (String aSeeAlsoList : this.mySeeAlsoList) {
                tagDescription = this.myFormatter.getParser().formatJDTagDescription(aSeeAlsoList, prefix + tag.getWithEndWhitespace(), continuationPrefix);
                sb.append((CharSequence)tagDescription);
            }
        }
        if (!JDComment.isNull(this.mySinceList)) {
            tag = JDTag.SINCE;
            for (String since : this.mySinceList) {
                tagDescription = this.myFormatter.getParser().formatJDTagDescription(since, prefix + tag.getWithEndWhitespace(), continuationPrefix);
                sb.append((CharSequence)tagDescription);
            }
        }
        if (this.myDeprecated != null) {
            tag = JDTag.DEPRECATED;
            StringBuilder stringBuilder = this.myFormatter.getParser().formatJDTagDescription(this.myDeprecated, prefix + tag.getWithEndWhitespace(), continuationPrefix);
            sb.append((CharSequence)stringBuilder);
        }
        if (sb.length() == start) {
            return null;
        }
        int nlen = sb.length() - prefix.length() - 1;
        if (sb.substring(nlen, sb.length()).equals(prefix + "\n")) {
            sb.delete(nlen, sb.length());
        }
        if (this.myMultiLineComment && this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || !this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || sb.indexOf("\n") != sb.length() - 1) {
            sb.insert(0, this.myFirstLine + '\n');
            sb.append(indent);
        } else {
            sb.replace(0, prefix.length(), this.myFirstLine + " ");
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(' ').append(this.myEndLine);
        return sb.toString();
    }

    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (prefix == null) {
            JDComment.$$$reportNull$$$0(5);
        }
        if (sb == null) {
            JDComment.$$$reportNull$$$0(6);
        }
    }

    public void setFirstCommentLine(@NotNull String firstCommentLine) {
        if (firstCommentLine == null) {
            JDComment.$$$reportNull$$$0(7);
        }
        this.myFirstLine = firstCommentLine;
    }

    public void setLastCommentLine(@NotNull String lastCommentLine) {
        if (lastCommentLine == null) {
            JDComment.$$$reportNull$$$0(8);
        }
        this.myEndLine = lastCommentLine;
    }

    public void addSeeAlso(@NotNull String seeAlso) {
        if (seeAlso == null) {
            JDComment.$$$reportNull$$$0(9);
        }
        if (this.mySeeAlsoList == null) {
            this.mySeeAlsoList = new ArrayList<String>();
        }
        this.mySeeAlsoList.add(seeAlso);
    }

    public void addUnknownTag(@NotNull String unknownTag) {
        if (unknownTag == null) {
            JDComment.$$$reportNull$$$0(10);
        }
        if (this.myUnknownList == null) {
            this.myUnknownList = new ArrayList<String>();
        }
        this.myUnknownList.add(unknownTag);
    }

    public void addSince(@NotNull String since) {
        if (since == null) {
            JDComment.$$$reportNull$$$0(11);
        }
        if (this.mySinceList == null) {
            this.mySinceList = new ArrayList<String>();
        }
        this.mySinceList.add(since);
    }

    public void setDeprecated(@Nullable String deprecated) {
        this.myDeprecated = deprecated;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstCommentLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommentLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seeAlso";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownTag";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "since";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "javadocContinuationIndent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "continuationIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateSpecial";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFirstCommentLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLastCommentLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSeeAlso";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addUnknownTag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSince";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

