/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @NotNull
    public PsiElement getElement() {
        PsiStatement psiStatement = this.myStatement;
        if (psiStatement == null) {
            PsiLabelReference.$$$reportNull$$$0(0);
        }
        return psiStatement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int parent = this.myIdentifier.getStartOffsetInParent();
        TextRange textRange = new TextRange(parent, this.myIdentifier.getTextLength() + parent);
        if (textRange == null) {
            PsiLabelReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        if (label == null) {
            return null;
        }
        for (PsiStatement context = this.myStatement; context != null; context = context.getContext()) {
            PsiLabeledStatement statement;
            if (!(context instanceof PsiLabeledStatement) || !label.equals((statement = (PsiLabeledStatement)context).getName())) continue;
            return statement;
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getElement().getText();
        if (string == null) {
            PsiLabelReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName((PsiElement)this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiLabelReference.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiLabeledStatement) {
            this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName((PsiElement)this.myIdentifier, ((PsiLabeledStatement)element).getName());
            return this.myIdentifier;
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public String[] getVariants() {
        ArrayList<String> result = new ArrayList<String>();
        for (PsiStatement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement)) continue;
            result.add(((PsiLabeledStatement)context).getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            PsiLabelReference.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiLabelReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiLabelReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

