/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaStubPsiElement<T extends StubElement>
extends StubBasedPsiElementBase<T>
implements StubBasedPsiElement<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.JavaStubPsiElement");

    public JavaStubPsiElement(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            JavaStubPsiElement.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            JavaStubPsiElement.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public JavaStubPsiElement(@NotNull ASTNode node) {
        if (node == null) {
            JavaStubPsiElement.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            JavaStubPsiElement.$$$reportNull$$$0(3);
        }
        return javaLanguage;
    }

    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    protected CompositeElement calcTreeElement() {
        return (CompositeElement)this.getNode();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaStubPsiElement.$$$reportNull$$$0(4);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)element);
        this.calcTreeElement().addInternal(elementCopy, (ASTNode)elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JavaStubPsiElement.$$$reportNull$$$0(5);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)element);
        this.calcTreeElement().addInternal(elementCopy, (ASTNode)elementCopy, SourceTreeToPsiMap.psiElementToTree((PsiElement)anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JavaStubPsiElement.$$$reportNull$$$0(6);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)element);
        this.calcTreeElement().addInternal(elementCopy, (ASTNode)elementCopy, SourceTreeToPsiMap.psiElementToTree((PsiElement)anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaStubPsiElement.$$$reportNull$$$0(7);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public void delete() throws IncorrectOperationException {
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(treeElement.getTreeParent() != null);
        CheckUtil.checkWritable((PsiElement)this);
        ((CompositeElement)treeElement.getTreeParent()).deleteChildInternal((ASTNode)treeElement);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)last);
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren((ASTNode)treeElement, (ASTNode)firstElement, (ASTNode)lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JavaStubPsiElement.$$$reportNull$$$0(8);
        }
        CompositeElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace((PsiElement)this, (TreeElement)treeElement, (PsiElement)newElement);
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JavaStubPsiElement.$$$reportNull$$$0(9);
        }
        SharedImplUtil.acceptChildren((PsiElementVisitor)visitor, (ASTNode)this.calcTreeElement());
    }

    protected Object clone() {
        CompositeElement treeElement = this.calcTreeElement();
        CompositeElement treeElementClone = (CompositeElement)(treeElement.getTreeParent() != null ? treeElement.copyElement() : treeElement.clone());
        return this.cloneImpl(treeElementClone);
    }

    protected StubBasedPsiElementBase cloneImpl(@NotNull CompositeElement treeElementClone) {
        if (treeElementClone == null) {
            JavaStubPsiElement.$$$reportNull$$$0(10);
        }
        StubBasedPsiElementBase clone = (StubBasedPsiElementBase)super.clone();
        clone.setNode((ASTNode)treeElementClone);
        treeElementClone.setPsi((PsiElement)clone);
        return clone;
    }

    public void subtreeChanged() {
        CompositeElement compositeElement = this.calcTreeElement();
        if (compositeElement != null) {
            compositeElement.clearCaches();
        }
        super.subtreeChanged();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            if (EMPTY_ARRAY == null) {
                JavaStubPsiElement.$$$reportNull$$$0(11);
            }
            return EMPTY_ARRAY;
        }
        int count = 0;
        while (psiChild != null) {
            ++count;
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] answer = new PsiElement[count];
        count = 0;
        for (psiChild = this.getFirstChild(); psiChild != null; psiChild = psiChild.getNextSibling()) {
            answer[count++] = psiChild;
        }
        if (answer == null) {
            JavaStubPsiElement.$$$reportNull$$$0(12);
        }
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/JavaStubPsiElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElementClone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/JavaStubPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cloneImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

