/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.highlighter.JShellFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JShellLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellRootClass;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import com.intellij.psi.impl.source.tree.JShellElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JShellFileImpl
extends PsiJavaFileBaseImpl
implements PsiJShellFile {
    private static final Condition<PsiElement> EXECUTABLE_PREDICATE = elem -> elem != null && !(elem instanceof PsiWhiteSpace) && !(elem instanceof PsiEmptyStatement) && !(elem instanceof PsiComment);

    public JShellFileImpl(FileViewProvider viewProvider) {
        super((IElementType)JShellElementType.FILE, (IElementType)JShellElementType.FILE, viewProvider);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JShellLanguage jShellLanguage = JShellLanguage.INSTANCE;
        if (jShellLanguage == null) {
            JShellFileImpl.$$$reportNull$$$0(0);
        }
        return jShellLanguage;
    }

    @NotNull
    public FileType getFileType() {
        JShellFileType jShellFileType = JShellFileType.INSTANCE;
        if (jShellFileType == null) {
            JShellFileImpl.$$$reportNull$$$0(1);
        }
        return jShellFileType;
    }

    public boolean isPhysical() {
        return this.getViewProvider().isPhysical();
    }

    public Collection<PsiElement> getExecutableSnippets() {
        SmartList result = new SmartList();
        JShellFileImpl.collectExecutableSnippets((PsiElement)this, (Collection<PsiElement>)result);
        return result;
    }

    private static void collectExecutableSnippets(PsiElement container, Collection<PsiElement> result) {
        for (PsiElement child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiJShellRootClass) {
                JShellFileImpl.collectExecutableSnippets(child, result);
                continue;
            }
            if (!JShellFileImpl.isExecutable(child)) continue;
            result.add(child);
        }
    }

    private static boolean isExecutable(PsiElement element) {
        if (element instanceof PsiJShellHolderMethod) {
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!EXECUTABLE_PREDICATE.value((Object)child)) continue;
                return true;
            }
            return false;
        }
        return EXECUTABLE_PREDICATE.value((Object)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/source/JShellFileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

