/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.CustomPropertyScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SimpleAccessorReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SimpleAccessorReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement refElement;
        if (queryParameters == null) {
            SimpleAccessorReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SimpleAccessorReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((refElement = queryParameters.getElementToSearch()) instanceof PsiMethod)) {
            return;
        }
        SimpleAccessorReferenceSearcher.addPropertyAccessUsages((PsiMethod)refElement, queryParameters.getEffectiveSearchScope(), queryParameters.getOptimizer());
    }

    static void addPropertyAccessUsages(@NotNull PsiMethod method, @NotNull SearchScope scope, @NotNull SearchRequestCollector collector) {
        String propertyName;
        if (method == null) {
            SimpleAccessorReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            SimpleAccessorReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (collector == null) {
            SimpleAccessorReferenceSearcher.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method)))) {
            GlobalSearchScope additional = GlobalSearchScope.EMPTY_SCOPE;
            for (CustomPropertyScopeProvider provider : (CustomPropertyScopeProvider[])Extensions.getExtensions(CustomPropertyScopeProvider.EP_NAME)) {
                additional = additional.union(provider.getScope(method.getProject()));
            }
            SearchScope propScope = scope.intersectWith(method.getUseScope()).intersectWith((SearchScope)additional);
            collector.searchWord(propertyName, propScope, (short)8, true, (PsiElement)method);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addPropertyAccessUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

