/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class RelaxedDirectInheritorChecker {
    private final String myBaseClassName;
    private final PsiClass myBaseClass;
    private final VolatileNotNullLazyValue<PsiClass[]> myClasses;
    private final VolatileNotNullLazyValue<Boolean> myHasGlobalAmbiguities;
    private final ProjectFileIndex myFileIndex;

    public RelaxedDirectInheritorChecker(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(0);
        }
        this.myBaseClass = baseClass;
        this.myBaseClassName = Objects.requireNonNull(baseClass.getName());
        this.myClasses = VolatileNotNullLazyValue.createValue(() -> RelaxedDirectInheritorChecker.getClassesByName(this.myBaseClass.getProject(), this.myBaseClassName));
        this.myHasGlobalAmbiguities = VolatileNotNullLazyValue.createValue(() -> RelaxedDirectInheritorChecker.hasAmbiguities((Iterable<PsiClass>)JBIterable.of((Object[])((Object[])this.myClasses.getValue()))));
        this.myFileIndex = ProjectFileIndex.getInstance((Project)this.myBaseClass.getProject());
    }

    @NotNull
    private static PsiClass[] getClassesByName(Project project, String name) {
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap map = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        PsiClass[] result = (PsiClass[])SoftReference.dereference((Reference)((Reference)cache.get(name)));
        if (result == null) {
            result = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, GlobalSearchScope.allScope((Project)project));
            cache.put(name, new SoftReference((Object)result));
        }
        if (result == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(1);
        }
        return result;
    }

    private static boolean hasAmbiguities(Iterable<PsiClass> classes2) {
        int locals = 0;
        HashSet<String> qNames = new HashSet<String>();
        for (PsiClass psiClass : classes2) {
            String qName = psiClass.getQualifiedName();
            if (qName == null) {
                if (++locals <= 1) continue;
                break;
            }
            qNames.add(qName);
            if (qNames.size() <= 1) continue;
            break;
        }
        return locals + qNames.size() > 1;
    }

    public boolean checkInheritance(@NotNull PsiClass inheritorCandidate) {
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(2);
        }
        if (!inheritorCandidate.isValid() || !this.myBaseClass.isValid()) {
            return false;
        }
        if (this.myFileIndex.isInSourceContent(inheritorCandidate.getContainingFile().getVirtualFile())) {
            if (!((Boolean)this.myHasGlobalAmbiguities.getValue()).booleanValue()) {
                return true;
            }
            GlobalSearchScope scope = inheritorCandidate.getResolveScope();
            List accessible = ContainerUtil.findAll((Object[])((Object[])this.myClasses.getValue()), base -> {
                if (inheritorCandidate == null) {
                    RelaxedDirectInheritorChecker.$$$reportNull$$$0(5);
                }
                return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)base) && RelaxedDirectInheritorChecker.isAccessibleLight(inheritorCandidate, base);
            });
            if (!RelaxedDirectInheritorChecker.hasAmbiguities(accessible)) {
                return accessible.contains(this.myBaseClass);
            }
        }
        return inheritorCandidate.isInheritor(this.myBaseClass, false);
    }

    private static boolean isAccessibleLight(@NotNull PsiClass inheritorCandidate, @NotNull PsiClass base) {
        PsiModifierList modifierList;
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(3);
        }
        if (base == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(4);
        }
        if ((modifierList = base.getModifierList()) != null && PsiUtil.getAccessLevel((PsiModifierList)modifierList) == 3) {
            return true;
        }
        return JavaResolveUtil.isAccessible((PsiMember)base, base.getContainingClass(), modifierList, (PsiElement)inheritorCandidate, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorCandidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkInheritance";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleLight";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkInheritance$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

