/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class JavaAutoModuleNameIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"java.auto.module.name");
    private final FileBasedIndex.InputFilter myFilter = file -> file.isDirectory() && file.getParent() == null && "jar".equalsIgnoreCase(file.getExtension()) && !JavaAutoModuleNameIndex.hasDescriptor(file);
    private final DataIndexer<String, Void, FileContent> myIndexer = data -> Collections.singletonMap(LightJavaModule.moduleName(data.getFile()), null);

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 2 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myFilter;
        if (inputFilter == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(3);
        }
        return dataIndexer;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(5);
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)moduleName, scope);
        if (collection == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull Project project) {
        if (project == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(7);
        }
        Collection collection = FileBasedIndex.getInstance().getAllKeys(NAME, project);
        if (collection == null) {
            JavaAutoModuleNameIndex.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static boolean hasDescriptor(VirtualFile root) {
        VirtualFile versions;
        if (root.findChild("module-info.class") != null) {
            return true;
        }
        if (JavaAutoModuleNameIndex.isMultiReleaseJar(root) && (versions = root.findFileByRelativePath("META-INF/versions")) != null) {
            for (VirtualFile version : versions.getChildren()) {
                if (version.findChild("module-info.class") == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMultiReleaseJar(VirtualFile root) {
        VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return false;
        try (InputStream stream = manifest.getInputStream();){
            boolean bl = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(new Attributes.Name("Multi-Release")));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

