/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final PsiShortNamesCache[] myCaches;

    public CompositeShortNamesCache(Project project) {
        this.myCaches = project.isDefault() ? new PsiShortNamesCache[]{} : (PsiShortNamesCache[])project.getExtensions(PsiShortNamesCache.EP_NAME);
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(0);
        }
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiFile[] classes2 = cache.getFilesByName(name);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes2);
        }
        PsiFile[] result = merger == null ? null : (PsiFile[])merger.getResult();
        PsiFile[] psiFileArray = result != null ? result : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            merger.add(cache.getAllFileNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(4);
        }
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiClass[] classes2 = cache.getClassesByName(name, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes2);
        }
        PsiClass[] result = merger == null ? null : (PsiClass[])merger.getResult();
        PsiClass[] psiClassArray = result != null ? result : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            String[] names = cache.getAllClassNames();
            merger.add(names);
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    public boolean processAllClassNames(Processor<String> processor) {
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllClassNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllMethodNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllFieldNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(8);
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiMethod[] methods = cache.getMethodsByName(name, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result;
        if (psiMethodArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(11);
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, maxCount);
            if (methods.length == maxCount) {
                if (methods == null) {
                    CompositeShortNamesCache.$$$reportNull$$$0(12);
                }
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result;
        if (psiMethodArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(13);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(15);
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiField[] fields = cache.getFieldsByNameIfNotMoreThan(name, scope, maxCount);
            if (fields.length == maxCount) {
                if (fields == null) {
                    CompositeShortNamesCache.$$$reportNull$$$0(16);
                }
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result == null ? PsiField.EMPTY_ARRAY : result;
        if (psiFieldArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(17);
        }
        return psiFieldArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(20);
        }
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(23);
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processMethodsWithName(name, processor, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            merger.add(cache.getAllMethodNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(26);
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiField[] classes2 = cache.getFieldsByName(name, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes2);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result == null ? PsiField.EMPTY_ARRAY : result;
        if (psiFieldArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(27);
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            String[] classes2 = cache.getAllFieldNames();
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes2);
        }
        String[] result = merger == null ? null : (String[])merger.getResult();
        String[] stringArray = result == null ? ArrayUtil.EMPTY_STRING_ARRAY : result;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    public boolean processFieldsWithName(@NotNull String key2, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(31);
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processFieldsWithName(key2, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key2, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(34);
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processClassesWithName(key2, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + Arrays.asList(this.myCaches);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/CompositeShortNamesCache";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 22: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/CompositeShortNamesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 27: 
            case 28: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        public void add(@NotNull T[] items) {
            if (items == null) {
                Merger.$$$reportNull$$$0(0);
            }
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll((Collection)new THashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }

        public T[] getResult() {
            if (this.myAllItems == null) {
                return this.mySingleItem;
            }
            return this.myAllItems.toArray(this.mySingleItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/psi/impl/CompositeShortNamesCache$Merger", "add"));
        }
    }
}

