/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.blocks.CStyleCommentBlock;
import com.intellij.formatting.blocks.TextLineBlock;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspJavaComment;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSpacePropertyProcessor
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.java.JavaSpacePropertyProcessor");
    private static final TokenSet REF_LIST_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.THROWS_KEYWORD, JavaTokenType.WITH_KEYWORD});
    private static final TokenSet ESCAPED_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LT, JavaTokenType.LTLT, JavaTokenType.LTLTEQ, JavaTokenType.GT, JavaTokenType.GTGT, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.AND, JavaTokenType.ANDAND, JavaTokenType.ANDEQ, JavaTokenType.STRING_LITERAL});
    private static final Map<Pair<IElementType, IElementType>, Boolean> ourTokenStickingMatrix = ContainerUtil.newConcurrentMap();
    private Spacing myResult;
    private PsiElement myParent;
    private int myRole1;
    private int myRole2;
    private ASTNode myChild1;
    private ASTNode myChild2;
    private IElementType myType1;
    private IElementType myType2;
    private CommonCodeStyleSettings mySettings;
    private JavaCodeStyleSettings myJavaSettings;
    private ImportHelper myImportHelper;

    private JavaSpacePropertyProcessor(Block block, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        ASTNode child = AbstractJavaBlock.getTreeNode(block);
        if (JavaSpacePropertyProcessor.isErrorElement(child)) {
            this.myResult = Spacing.getReadOnlySpacing();
            return;
        }
        this.init(child);
        this.mySettings = settings;
        this.myJavaSettings = javaSettings;
        if (this.myChild1 == null) {
            if (FormatterUtil.isFormatterCalledExplicitly()) {
                this.createSpaceInCode(false);
            }
            return;
        }
        PsiElement myChild1Psi1 = this.myChild1.getPsi();
        PsiElement myChild1Psi2 = this.myChild2.getPsi();
        if (myChild1Psi1 == null || myChild1Psi1.getLanguage() != JavaLanguage.INSTANCE || myChild1Psi2 == null || myChild1Psi2.getLanguage() != JavaLanguage.INSTANCE) {
            return;
        }
        if (block instanceof TextLineBlock) {
            this.myResult = ((TextLineBlock)block).getSpacing();
            return;
        }
        if (block instanceof CStyleCommentBlock) {
            this.myResult = ((CStyleCommentBlock)block).getSpacing();
            return;
        }
        if (this.myChild2 != null && StdTokenSets.COMMENT_BIT_SET.contains(this.myChild2.getElementType())) {
            this.myResult = this.mySettings.KEEP_FIRST_COLUMN_COMMENT ? Spacing.createKeepingFirstColumnSpacing((int)0, (int)Integer.MAX_VALUE, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myParent != null) {
            this.myParent.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
                if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (!JavaSpacePropertyProcessor.canStickChildrenTogether(this.myChild1, this.myChild2)) {
                    this.myResult = Spacing.createSpacing((int)1, (int)Integer.MIN_VALUE, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myChild1.getElementType() == JavaTokenType.C_STYLE_COMMENT) {
                    this.myResult = null;
                } else if (!JavaSpacePropertyProcessor.shouldKeepSpace(this.myParent)) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
        }
    }

    private static boolean isErrorElement(ASTNode child) {
        return child != null && child.getPsi() instanceof PsiErrorElement;
    }

    private static boolean shouldKeepSpace(PsiElement parent) {
        ASTNode node = parent.getNode();
        if (node == null) {
            return true;
        }
        IElementType type2 = node.getElementType();
        if (type2 == JavaDocElementType.DOC_TAG_VALUE_ELEMENT) {
            return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDocMethodOrFieldRef.class) != null;
        }
        return type2 == JavaDocElementType.DOC_COMMENT || type2 == JavaDocElementType.DOC_TAG || type2 == JavaDocElementType.DOC_INLINE_TAG;
    }

    private void init(ASTNode child) {
        ASTNode treePrev;
        if (child == null) {
            return;
        }
        for (treePrev = child.getTreePrev(); treePrev != null && JavaSpacePropertyProcessor.isWhiteSpace(treePrev); treePrev = treePrev.getTreePrev()) {
        }
        if (treePrev == null) {
            this.init(child.getTreeParent());
        } else {
            this.myChild2 = child;
            this.myChild1 = treePrev;
            CompositeElement parent = (CompositeElement)treePrev.getTreeParent();
            this.myParent = SourceTreeToPsiMap.treeElementToPsi((ASTNode)parent);
            this.myRole1 = parent.getChildRole(treePrev);
            this.myType1 = treePrev.getElementType();
            this.myRole2 = parent.getChildRole(child);
            this.myType2 = child.getElementType();
        }
    }

    private static boolean isWhiteSpace(ASTNode treePrev) {
        return treePrev != null && (treePrev.getElementType() == TokenType.WHITE_SPACE || treePrev.getTextLength() == 0);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        if (this.myRole1 == 88 && this.myRole2 == 74) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 74 || this.myRole2 == 75) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    private void createSpaceInCode(boolean space) {
        this.createSpaceProperty(space, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        if (this.myRole2 == 77) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        } else if (this.myRole1 == 69) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else if (this.myRole1 == 74 ^ this.myRole2 == 75) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        this.visitArrayInitializer();
    }

    public void visitClass(PsiClass aClass) {
        if (this.myChild1.getElementType() == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole2 == 18) {
            this.myResult = this.getSpaceBeforeClassLBrace(aClass);
        } else if (this.myRole1 == 18 || JavaSpacePropertyProcessor.isEndOfLineCommentAfterLBrace(this.myChild1)) {
            if (aClass.isEnum()) {
                this.createParenthSpace(true, false);
            } else if (this.myRole2 == 19 && this.mySettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE) {
                int spaces = this.mySettings.SPACE_WITHIN_BRACES ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else {
                this.myResult = aClass instanceof PsiAnonymousClass ? (this.myRole2 == 6 && JavaSpacePropertyProcessor.isTheOnlyClassMember(this.myChild2) ? Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS) : Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS)) : Spacing.createSpacing((int)1, (int)1, (int)(this.mySettings.BLANK_LINES_AFTER_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole2 == 19 && aClass.isEnum()) {
            this.myResult = Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myRole1 == 23 && aClass.isEnum() && JavaSpacePropertyProcessor.isJavadocHoldingEnumConstant(this.myChild2)) {
            this.createParenthSpace(true, true);
        } else if (aClass instanceof PsiAnonymousClass && ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(this.myChild1.getElementType())) {
            ASTNode prev = this.myChild1.getTreePrev();
            if (prev.getElementType() == TokenType.WHITE_SPACE && !StringUtil.containsLineBreak((CharSequence)prev.getChars())) {
                prev = prev.getTreePrev();
            }
            if (prev.getElementType() == JavaTokenType.LBRACE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else {
                this.processClassBody();
            }
        } else if (this.myChild1.getElementType() == JavaTokenType.COMMA && this.myChild2.getElementType() == JavaTokenType.SEMICOLON && aClass.isEnum()) {
            this.createParenthSpace(true, false);
        } else if (aClass instanceof PsiAnonymousClass && this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else {
            this.processClassBody();
        }
    }

    private static boolean isJavadocHoldingEnumConstant(@NotNull ASTNode node) {
        if (node == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(0);
        }
        if (!(node instanceof EnumConstantElement)) {
            return false;
        }
        ASTNode firstChildNode = node.getFirstChildNode();
        return firstChildNode instanceof PsiDocComment;
    }

    @NotNull
    private Spacing getSpaceBeforeMethodLBrace(@NotNull PsiMethod method) {
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(1);
        }
        int space = this.mySettings.SPACE_BEFORE_METHOD_LBRACE ? 1 : 0;
        int methodBraceStyle = this.mySettings.METHOD_BRACE_STYLE;
        if (methodBraceStyle == 1) {
            Spacing spacing = this.createNonLFSpace(space, null);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(2);
            }
            return spacing;
        }
        if (methodBraceStyle == 5) {
            TextRange headerRange = new TextRange(JavaSpacePropertyProcessor.getMethodHeaderStartOffset(method), JavaSpacePropertyProcessor.getMethodHeaderEndOffset(method));
            Spacing spacing = this.createNonLFSpace(space, headerRange);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(3);
            }
            return spacing;
        }
        if (this.shouldHandleAsSimpleMethod(method)) {
            TextRange rangeWithoutAnnotations = new TextRange(JavaSpacePropertyProcessor.getMethodHeaderStartOffset(method), method.getTextRange().getEndOffset());
            Spacing spacing = this.createNonLFSpace(space, rangeWithoutAnnotations);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(4);
            }
            return spacing;
        }
        Spacing spacing = Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        if (spacing == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(5);
        }
        return spacing;
    }

    private static int getMethodHeaderEndOffset(@NotNull PsiMethod method) {
        PsiElement headerEnd;
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = headerEnd = method.getBody() != null ? method.getBody().getPrevSibling() : null;
        if (headerEnd != null) {
            return headerEnd.getTextRange().getEndOffset();
        }
        return method.getTextRange().getEndOffset();
    }

    @NotNull
    private Spacing getSpaceBeforeClassLBrace(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(7);
        }
        int space = this.mySettings.SPACE_BEFORE_CLASS_LBRACE ? 1 : 0;
        int classBraceStyle = this.mySettings.CLASS_BRACE_STYLE;
        if (classBraceStyle == 1 || this.shouldHandleAsSimpleClass(aClass)) {
            Spacing spacing = this.createNonLFSpace(space, null);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(8);
            }
            return spacing;
        }
        if (classBraceStyle == 5) {
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            int startOffset = nameIdentifier == null ? this.myParent.getTextRange().getStartOffset() : nameIdentifier.getTextRange().getStartOffset();
            TextRange range = new TextRange(startOffset, this.myChild1.getTextRange().getEndOffset());
            Spacing spacing = this.createNonLFSpace(space, range);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(9);
            }
            return spacing;
        }
        Spacing spacing = Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        if (spacing == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(10);
        }
        return spacing;
    }

    private Spacing getSpaceBeforeLBrace(@NotNull ASTNode lBraceBlock, boolean spaceBeforeLbrace, @Nullable TextRange nextLineIfWrappedOptionRange) {
        int space;
        if (lBraceBlock == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(11);
        }
        int n = space = spaceBeforeLbrace ? 1 : 0;
        if (this.mySettings.BRACE_STYLE == 1) {
            return this.createNonLFSpace(space, null);
        }
        if (this.mySettings.BRACE_STYLE == 5) {
            return this.createNonLFSpace(space, nextLineIfWrappedOptionRange);
        }
        if (this.shouldHandleAsSimpleBlock(lBraceBlock)) {
            return this.createNonLFSpace(space, lBraceBlock.getTextRange());
        }
        return Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private boolean shouldHandleAsSimpleClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(12);
        }
        if (!this.mySettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE) {
            return false;
        }
        PsiElement lBrace = aClass.getLBrace();
        PsiElement rBrace = aClass.getRBrace();
        if (lBrace != null && rBrace != null) {
            PsiElement beforeLBrace = lBrace.getPrevSibling();
            if (beforeLBrace instanceof PsiWhiteSpace && beforeLBrace.textContains('\n')) {
                return false;
            }
            PsiElement betweenBraces = lBrace.getNextSibling();
            if (betweenBraces == rBrace || JavaSpacePropertyProcessor.isWhiteSpaceWithoutLineFeeds(betweenBraces) && betweenBraces.getNextSibling() == rBrace) {
                return true;
            }
        }
        return false;
    }

    private static boolean isWhiteSpaceWithoutLineFeeds(@Nullable PsiElement betweenBraces) {
        return betweenBraces instanceof PsiWhiteSpace && !betweenBraces.textContains('\n');
    }

    private boolean shouldHandleAsSimpleBlock(@NotNull ASTNode node) {
        if (node == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(13);
        }
        if (!this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
            return false;
        }
        PsiElement prev = node.getPsi().getPrevSibling();
        if (prev instanceof PsiWhiteSpace && prev.textContains('\n')) {
            return false;
        }
        return !node.textContains('\n');
    }

    private boolean shouldHandleAsSimpleMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(14);
        }
        if (!this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        return body2 != null && !body2.textContains('\n');
    }

    private static int getMethodHeaderStartOffset(@NotNull PsiMethod method) {
        PsiElement nextNonWsElem;
        PsiTypeParameterList typeParameterList;
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(15);
        }
        if ((typeParameterList = (PsiTypeParameterList)PsiTreeUtil.findChildOfType((PsiElement)method, PsiTypeParameterList.class)) != null && (nextNonWsElem = PsiTreeUtil.skipWhitespacesForward((PsiElement)typeParameterList)) != null) {
            return nextNonWsElem.getTextRange().getStartOffset();
        }
        return method.getTextRange().getStartOffset();
    }

    private static boolean isEndOfLineCommentAfterLBrace(@NotNull ASTNode node) {
        PsiElement beforeWs;
        PsiElement ws;
        if (node == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(16);
        }
        return node.getPsi() instanceof PsiComment && JavaSpacePropertyProcessor.isWhiteSpaceWithoutLineFeeds(ws = node.getPsi().getPrevSibling()) && PsiUtil.isJavaToken((PsiElement)(beforeWs = ws.getPrevSibling()), (IElementType)JavaTokenType.LBRACE);
    }

    private static boolean isTheOnlyClassMember(ASTNode node) {
        ASTNode next = node.getTreeNext();
        if (next == null || next.getElementType() != JavaTokenType.RBRACE) {
            return false;
        }
        ASTNode prev = node.getTreePrev();
        return prev != null && prev.getElementType() == JavaTokenType.LBRACE;
    }

    private void processClassBody() {
        if (this.myChild1 instanceof JspJavaComment || this.myChild2 instanceof JspJavaComment) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (!this.processMethod()) {
            if (this.myRole2 == 6) {
                if (this.myRole1 == 18) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myRole1 == 4) {
                    int blankLines = this.myJavaSettings.BLANK_LINES_AROUND_INITIALIZER + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)(this.mySettings.SPACE_BEFORE_CLASS_LBRACE ? 1 : 0), (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else if (this.myRole1 == 3) {
                    this.setAroundClassSpacing();
                } else {
                    int blankLines = this.getLinesAroundMethod() + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole1 == 6) {
                if (this.myRole2 == 19) {
                    int minLineFeeds = JavaSpacePropertyProcessor.getMinLineFeedsBetweenRBraces(this.myChild1);
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)minLineFeeds, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else if (this.myRole2 == 3) {
                    this.setAroundClassSpacing();
                } else {
                    int blankLines = this.myJavaSettings.BLANK_LINES_AROUND_INITIALIZER + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole1 == 3) {
                if (this.myRole2 == 19) {
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.getLineBreaksBeforeClassEnd(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else {
                    int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole2 == 3) {
                if (this.myRole1 == 18) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
                } else {
                    int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole2 == 4) {
                if (this.myRole1 == 23) {
                    this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myRole1 == 18) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
                } else {
                    int blankLines = this.getLinesAroundField() + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole1 == 4) {
                if (this.myRole2 == 23) {
                    ASTNode lastChildNode = this.myChild1.getLastChildNode();
                    if (lastChildNode != null && lastChildNode.getElementType() == JavaTokenType.SEMICOLON) {
                        this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                    } else {
                        this.createSpaceProperty(false, false, 0);
                    }
                } else if (this.myRole2 == 19) {
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.getLineBreaksBeforeClassEnd(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else {
                    int blankLines = this.getLinesAroundField() + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole2 == 23 || this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
                this.createSpaceProperty(false, false, 0);
            } else if (this.myRole1 == 23) {
                this.createSpaceProperty(this.mySettings.SPACE_AFTER_COMMA, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else if (this.myRole1 == 8) {
                this.processModifierList();
            } else if (this.myRole1 == 18 && this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else if (this.myRole2 == 12 || this.myRole2 == 13) {
                this.createSpaceInCode(true);
            } else if (this.myRole2 == 245) {
                this.createSpaceInCode(this.myJavaSettings.SPACE_BEFORE_OPENING_ANGLE_BRACKET_IN_TYPE_PARAMETER);
            } else if (this.myRole2 == 73) {
                this.createSpaceInCode(false);
            } else if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            }
        }
    }

    private int getLineBreaksBeforeClassEnd() {
        return this.myParent instanceof PsiAnonymousClass ? 1 : this.mySettings.BLANK_LINES_BEFORE_CLASS_END + 1;
    }

    private void setAroundClassSpacing() {
        this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)(this.mySettings.BLANK_LINES_AROUND_CLASS + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
    }

    private boolean processMethod() {
        if (this.myRole2 == 5 || this.myChild2.getElementType() == JavaElementType.METHOD) {
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else if (this.myRole1 == 6) {
                int blankLines = this.myJavaSettings.BLANK_LINES_AROUND_INITIALIZER + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                int blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole1 == 5 || this.myChild1.getElementType() == JavaElementType.METHOD) {
            int blankLines;
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else {
                blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
            if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.getLineBreaksBeforeClassEnd(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        }
        return this.myResult != null;
    }

    private static int getMinLineFeedsBetweenRBraces(ASTNode leftNode) {
        if (leftNode == null || leftNode.getElementType() != JavaElementType.CLASS_INITIALIZER) {
            return 1;
        }
        ASTNode lbraceCandidate = leftNode.getTreePrev();
        return lbraceCandidate != null && lbraceCandidate.getElementType() == JavaTokenType.LBRACE ? 0 : 1;
    }

    private int getLinesAroundMethod() {
        boolean useInterfaceMethodSpacing = !JavaSpacePropertyProcessor.isClass(this.myParent) || JavaSpacePropertyProcessor.isAbstractMethod(this.myChild1) && JavaSpacePropertyProcessor.isAbstractMethod(this.myChild2);
        return useInterfaceMethodSpacing ? this.mySettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE : this.mySettings.BLANK_LINES_AROUND_METHOD;
    }

    private int getLinesAroundField() {
        if (JavaSpacePropertyProcessor.isClass(this.myParent)) {
            return this.mySettings.BLANK_LINES_AROUND_FIELD;
        }
        return this.mySettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
    }

    private static boolean isClass(PsiElement parent) {
        if (parent instanceof PsiClass) {
            return !((PsiClass)parent).isInterface();
        }
        return false;
    }

    private static boolean isAbstractMethod(ASTNode node) {
        PsiElement element = node.getPsi();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return method.getModifierList().hasModifierProperty("abstract");
        }
        return false;
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.createSpaceInCode(true);
    }

    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        if (this.myRole2 == 12 || this.myRole2 == 13) {
            this.createSpaceInCode(true);
        } else {
            this.processMethod();
        }
    }

    public void visitImportList(PsiImportList list) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(this.myChild1.getElementType()) && ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(this.myChild2.getElementType())) {
            if (this.myImportHelper == null) {
                this.myImportHelper = new ImportHelper(this.myJavaSettings);
            }
            int emptyLines = this.myImportHelper.getEmptyLinesBetween((PsiImportStatementBase)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)this.myChild1), (PsiImportStatementBase)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)this.myChild2)) + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)emptyLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
    }

    public void visitFile(PsiFile file) {
        if (this.myType1 == JavaElementType.PACKAGE_STATEMENT) {
            int lf = this.mySettings.BLANK_LINES_AFTER_PACKAGE + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.PACKAGE_STATEMENT) {
            int lf = this.mySettings.BLANK_LINES_BEFORE_PACKAGE + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType1 == JavaElementType.IMPORT_LIST) {
            int lf = this.mySettings.BLANK_LINES_AFTER_IMPORTS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.IMPORT_LIST) {
            int lf = this.mySettings.BLANK_LINES_BEFORE_IMPORTS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.CLASS) {
            int lf = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myRole2 == 38 || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_WHILE_LBRACE, null);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        if (this.myRole1 == 35 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myRole2 == 38) {
            if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_DO_LBRACE, null);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myRole1 == 38 || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            this.processOnNewLineCondition(this.mySettings.WHILE_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_WHILE_KEYWORD);
        }
    }

    private void processOnNewLineCondition(boolean onNewLine, boolean createSpaceInline) {
        if (onNewLine) {
            this.myResult = !this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceProperty(createSpaceInline, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        if (this.myChild1.getElementType() == JavaTokenType.THROW_KEYWORD) {
            this.createSpaceInCode(true);
        }
    }

    public void visitTryStatement(PsiTryStatement statement) {
        if (this.myRole2 == 47 || this.myRole2 == 251) {
            boolean putRightChildOnNewLine;
            boolean bl = putRightChildOnNewLine = this.myRole2 == 47 ? this.mySettings.FINALLY_ON_NEW_LINE : this.mySettings.CATCH_ON_NEW_LINE;
            if (putRightChildOnNewLine) {
                this.processOnNewLineCondition(true, true);
            } else {
                boolean useSpace = this.myRole2 == 251 && this.mySettings.SPACE_BEFORE_CATCH_KEYWORD || this.myRole2 == 47 && this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD;
                this.createSpaceProperty(useSpace, false, 0);
            }
            return;
        }
        if (this.myRole2 == 48) {
            TextRange dependentRange = null;
            if (this.myChild1 instanceof PsiResourceList && this.mySettings.BRACE_STYLE == 5) {
                dependentRange = this.myChild1.getTextRange();
            }
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_TRY_LBRACE, dependentRange);
        } else if (this.myRole2 == 52) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, null);
        } else if (this.myType2 == JavaElementType.RESOURCE_LIST) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_TRY_PARENTHESES);
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        if (this.myRole1 == 37 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
        } else if (this.myRole1 == 125 && this.myRole2 == 87 && this.myJavaSettings.SPACE_BEFORE_COLON_IN_FOREACH || this.myRole1 == 87 && this.myRole2 == 124) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 38) {
            this.processLoopBody();
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        if (this.myRole1 == 24) {
            this.createParenthSpace(this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP, this.mySettings.SPACE_WITHIN_PARENTHESES);
        } else if (this.myRole2 == 25) {
            this.createParenthSpace(this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP, this.mySettings.SPACE_WITHIN_PARENTHESES);
        }
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.processCodeBlock(this.keepInOneLine(block), block.getTextRange());
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        if (this.myChild1.getPsi() instanceof PsiStatement && this.myChild2.getPsi() instanceof PsiStatement) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private void processCodeBlock(boolean keepInOneLine, TextRange textRange) {
        boolean lhsStatement = this.myChild1.getPsi() instanceof PsiStatement;
        boolean rhsStatement = this.myChild2.getPsi() instanceof PsiStatement;
        if (this.myParent instanceof JspCodeBlock) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 0 && !lhsStatement || this.myRole2 == 0 && !rhsStatement) {
            IElementType firstElementType = this.myChild1.getElementType();
            this.myResult = firstElementType == JavaTokenType.END_OF_LINE_COMMENT || firstElementType == JavaTokenType.C_STYLE_COMMENT ? Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : null;
        } else if (this.myRole1 == 18) {
            if (!keepInOneLine) {
                ASTNode grandPa;
                ASTNode parentNode;
                int blankLines = 1;
                if (this.myParent != null && (parentNode = this.myParent.getNode()) != null && (grandPa = parentNode.getTreeParent()) != null && grandPa.getElementType() == JavaElementType.METHOD) {
                    blankLines += this.mySettings.BLANK_LINES_BEFORE_METHOD_BODY;
                }
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.myResult = Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.myRole2 == 19) {
            this.myResult = !keepInOneLine ? Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
        } else if (this.myChild1.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT) {
            if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, null);
            } else {
                int lineFeeds = this.mySettings.CASE_STATEMENT_ON_NEW_LINE ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)lineFeeds, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (lhsStatement && rhsStatement) {
            int minSpaces = 0;
            int minLineFeeds = 1;
            PsiElement psi = this.myChild1.getPsi();
            if (this.mySettings.KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE && (FormatterUtil.isFormatterCalledExplicitly() || ApplicationManager.getApplication().isUnitTestMode()) || psi != null && PsiTreeUtil.hasErrorElements((PsiElement)psi)) {
                minSpaces = 1;
                minLineFeeds = 0;
                if (this.myChild1 != null) {
                    ASTNode lastElement = this.myChild1;
                    while (lastElement.getLastChildNode() != null) {
                        lastElement = lastElement.getLastChildNode();
                    }
                    if (lastElement instanceof PsiComment && lastElement.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
                        minLineFeeds = 1;
                    }
                }
            }
            this.myResult = Spacing.createSpacing((int)minSpaces, (int)0, (int)minLineFeeds, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private boolean keepInOneLine(PsiCodeBlock block) {
        if (block.getParent() instanceof PsiMethod) {
            return this.shouldHandleAsSimpleMethod((PsiMethod)block.getParent());
        }
        if (block.getParent() instanceof PsiLambdaExpression) {
            return this.shouldHandleAsSimpleLambda((PsiLambdaExpression)block.getParent());
        }
        return this.shouldHandleAsSimpleBlock(block.getNode());
    }

    private boolean shouldHandleAsSimpleLambda(PsiLambdaExpression lambda2) {
        return this.mySettings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE && !lambda2.textContains('\n');
    }

    public void visitIfStatement(PsiIfStatement statement) {
        if (this.myRole2 == 31) {
            if (this.myChild1.getElementType() != JavaElementType.BLOCK_STATEMENT) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.mySettings.ELSE_ON_NEW_LINE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_BEFORE_ELSE_KEYWORD, false, 0);
            }
        } else if (this.myRole1 == 31) {
            if (this.myChild2.getElementType() == JavaElementType.IF_STATEMENT) {
                if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.createSpaceProperty(false, false, 0);
                } else {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            } else if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_ELSE_LBRACE, null);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            PsiExpression condition2;
            boolean space = this.myRole2 == 34 ? this.mySettings.SPACE_BEFORE_ELSE_LBRACE : this.mySettings.SPACE_BEFORE_IF_LBRACE;
            TextRange dependentRange = null;
            if (this.myRole2 == 33 && (condition2 = statement.getCondition()) != null) {
                dependentRange = condition2.getTextRange();
            }
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, space, dependentRange);
        } else if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (this.myRole2 == 33) {
            this.createSpacingBeforeElementInsideControlStatement();
        }
    }

    private void createSpacingBeforeElementInsideControlStatement() {
        if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE && this.myChild1.getElementType() != JavaTokenType.END_OF_LINE_COMMENT) {
            this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private Spacing createNonLFSpace(int spaces, @Nullable TextRange dependantRange) {
        ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
        if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (dependantRange != null) {
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependantRange, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
    }

    @Nullable
    private static ASTNode getPrevElementType(ASTNode child) {
        return FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)child);
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            IElementType i = expression2.getOperationTokenType();
            if (i == JavaTokenType.OROR || i == JavaTokenType.ANDAND) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
            } else if (i == JavaTokenType.OR || i == JavaTokenType.AND || i == JavaTokenType.XOR) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
            } else if (i == JavaTokenType.EQEQ || i == JavaTokenType.NE) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS);
            } else if (i == JavaTokenType.GT || i == JavaTokenType.LT || i == JavaTokenType.GE || i == JavaTokenType.LE) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS);
            } else if (i == JavaTokenType.ASTERISK || i == JavaTokenType.DIV || i == JavaTokenType.PERC) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
            } else if (i == JavaTokenType.LTLT || i == JavaTokenType.GTGT || i == JavaTokenType.GTGTGT) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_SHIFT_OPERATORS);
            } else {
                this.createSpaceInCode(false);
            }
        }
    }

    public void visitField(PsiField field) {
        if (this.myChild1.getElementType() == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole1 == 20 || this.myRole2 == 20) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.myRole1 == 10 || this.myRole2 == 10) {
            this.createSpaceInCode(true);
        } else if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceProperty(false, false, 0);
        } else if (this.myRole1 == 8) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    public void visitLocalVariable(PsiLocalVariable variable) {
        if (this.myRole1 == 20 || this.myRole2 == 20) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (JavaSpacePropertyProcessor.isFinalKeywordBefore(this.myChild2) && this.myType2 == JavaElementType.TYPE) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 8 || this.myRole2 == 71 || this.myRole1 == 71 || this.myRole2 == 10 || this.myRole1 == 10) {
            this.createSpaceInCode(true);
        } else if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            PsiElement ppp;
            PsiElement pp = this.myParent.getParent();
            if (pp instanceof PsiDeclarationStatement && (ppp = pp.getParent()) instanceof PsiForStatement) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
                return;
            }
            this.createSpaceProperty(false, false, 0);
        }
    }

    private static boolean isFinalKeywordBefore(ASTNode node) {
        ASTNode prevLeaf = TreeUtil.prevLeaf((ASTNode)node);
        if (prevLeaf != null && prevLeaf.getElementType() == TokenType.WHITE_SPACE) {
            prevLeaf = TreeUtil.prevLeaf((ASTNode)prevLeaf);
        }
        return prevLeaf != null && prevLeaf.getElementType() == JavaTokenType.FINAL_KEYWORD;
    }

    public void visitMethod(PsiMethod method) {
        if (this.myChild1.getElementType() == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole2 == 14) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        } else if (this.myRole1 == 14 && this.myRole2 == 16 || this.myRole1 == 245) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 17) {
            this.myResult = this.getSpaceBeforeMethodLBrace(method);
        } else if (this.myRole1 == 8) {
            this.processModifierList();
        } else if (StdTokenSets.COMMENT_BIT_SET.contains(this.myChild1.getElementType()) && (this.myRole2 == 8 || this.myRole2 == 71)) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (this.myRole2 == 85 || this.myRole2 == 248) {
            this.createSpaceInCode(true);
        } else if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 10) {
            this.createSpaceInCode(true);
        }
    }

    private void processModifierList() {
        if (this.mySettings.MODIFIER_LIST_WRAP) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 8 && this.myRole2 == 102) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole2 == 10 && this.myChild1.getLastChildNode() != null && this.myChild1.getLastChildNode().getElementType() == JavaElementType.ANNOTATION || this.myRole1 == 8 && this.myRole2 == 19 || this.myRole1 == 8 && this.myRole2 == 11) {
            this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else {
            this.createSpaceProperty(true, false, 0);
        }
    }

    public void visitModifierList(PsiModifierList list) {
        this.myResult = this.myType1 == JavaElementType.ANNOTATION && this.myType2 == JavaTokenType.FINAL_KEYWORD ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (this.myType1 == JavaTokenType.END_OF_LINE_COMMENT ? Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
    }

    public void visitParameterList(PsiParameterList list) {
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createParenthSpace(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES);
        } else if (this.myRole2 == 25) {
            this.createParenthSpace(this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        } else if (this.myRole1 == 24) {
            this.createParenthSpace(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        }
    }

    private void createParenthSpace(boolean onNewLine, boolean space) {
        this.createParenthSpace(onNewLine, space, this.myParent.getTextRange());
    }

    private void createParenthSpace(boolean onNewLine, boolean space, TextRange dependence) {
        if (onNewLine) {
            int spaces = space ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependence, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceInCode(space);
        }
    }

    public void visitElement(PsiElement element) {
        if (this.myRole1 == 8) {
            this.processModifierList();
        } else if (this.myRole1 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        } else if (this.myType2 == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
            this.createSpaceProperty(false, true, 0);
        } else if (!(this.myType1 != JavaDocTokenType.DOC_TAG_VALUE_TOKEN && this.myType1 != JavaDocElementType.DOC_TAG_VALUE_ELEMENT || this.myType2 != JavaDocTokenType.DOC_TAG_VALUE_TOKEN && this.myType2 != JavaDocElementType.DOC_TAG_VALUE_ELEMENT)) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        if (this.myRole1 == 10 && this.myRole2 == 55 || this.myRole1 == 55 && this.myRole2 == 90) {
            this.createSpaceInCode(false);
        }
    }

    public void visitExpressionList(PsiExpressionList list) {
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES);
        } else if (this.myRole2 == 25) {
            boolean space;
            boolean bl = space = this.myRole1 == 23 || this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
            if (this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE && list.getExpressionCount() > 1) {
                this.createSpaceWithLinefeedIfListWrapped(list, space);
                return;
            }
            this.createSpaceInCode(space);
        } else if (this.myRole1 == 24) {
            boolean space = this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
            if (this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE && list.getExpressionCount() > 1) {
                this.createSpaceWithLinefeedIfListWrapped(list, space);
                return;
            }
            this.createSpaceInCode(space);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    private void createSpaceWithLinefeedIfListWrapped(@NotNull PsiExpressionList list, boolean space) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(17);
        }
        PsiExpression[] expressions2 = list.getExpressions();
        int length = expressions2.length;
        assert (length > 1);
        ArrayList ranges = ContainerUtil.newArrayList();
        for (int i = 0; i < length - 1; ++i) {
            int startOffset = expressions2[i].getTextRange().getEndOffset();
            int endOffset = expressions2[i + 1].getTextRange().getStartOffset();
            ranges.add(new TextRange(startOffset, endOffset));
        }
        int spaces = space ? 1 : 0;
        this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (List)ranges, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        if (this.myRole1 == 79 || this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES);
        } else if (this.myRole2 == 60) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE, null);
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        if (this.myRole1 == 84 || this.myRole2 == 86) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        if (this.myRole1 == 42 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        } else if (this.myRole2 == 44) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, null);
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        boolean spaceAroundArrow = this.mySettings.SPACE_AROUND_LAMBDA_ARROW;
        if (this.myRole1 == 14 && this.myRole2 == 252) {
            this.createSpaceInCode(spaceAroundArrow);
        } else if (this.myRole1 == 252) {
            if (this.myRole2 == 18) {
                switch (this.mySettings.LAMBDA_BRACE_STYLE) {
                    case 2: 
                    case 3: 
                    case 4: {
                        int space = spaceAroundArrow ? 1 : 0;
                        this.myResult = Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
                        break;
                    }
                    default: {
                        this.createSpaceInCode(spaceAroundArrow);
                        break;
                    }
                }
            } else if (this.myRole2 == 64) {
                this.createSpaceInCode(spaceAroundArrow);
            }
        }
    }

    public void visitModule(PsiJavaModule module) {
        if (this.myType2 == JavaTokenType.RBRACE || ElementType.JAVA_MODULE_STATEMENT_BIT_SET.contains(this.myType2)) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myType1 == JavaElementType.MODULE_REFERENCE || this.myType2 == JavaElementType.MODULE_REFERENCE) {
            this.createSpaceInCode(true);
        } else if (this.myType1 == JavaElementType.MODIFIER_LIST) {
            this.processModifierList();
        }
    }

    public void visitModuleStatement(PsiStatement statement) {
        if (this.myType1 == JavaElementType.MODULE_REFERENCE) {
            this.createSpaceInCode(this.myType2 != JavaTokenType.SEMICOLON && this.myType2 != JavaTokenType.COMMA);
        }
        if (this.myType2 == JavaElementType.MODULE_REFERENCE) {
            this.createSpaceInCode(true);
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        if (this.myRole1 == 253 && this.myRole2 == 53 || this.myRole1 == 64 && this.myRole2 == 253 || this.myRole1 == 119 && this.myRole2 == 253) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_METHOD_REF_DBL_COLON);
        }
    }

    public void visitForStatement(PsiForStatement statement) {
        if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myRole1 == 24) {
            ASTNode rparenth = JavaSpacePropertyProcessor.findFrom(this.myChild2, JavaTokenType.RPARENTH, true);
            if (rparenth == null) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            } else {
                this.createParenthSpace(this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(this.myChild1.getTextRange().getStartOffset(), rparenth.getTextRange().getEndOffset()));
                if (this.myChild2.getElementType() == JavaElementType.EMPTY_STATEMENT) {
                    this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON || this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
                }
            }
        } else if (this.myRole2 == 25) {
            ASTNode lparenth = JavaSpacePropertyProcessor.findFrom(this.myChild2, JavaTokenType.LPARENTH, false);
            if (lparenth == null) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            } else {
                ASTNode prev = FormatterUtil.getPreviousLeaf((ASTNode)this.myChild2, (IElementType[])new IElementType[]{TokenType.WHITE_SPACE, TokenType.ERROR_ELEMENT});
                if (prev != null && prev.getElementType() == JavaTokenType.SEMICOLON) {
                    this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
                } else {
                    this.createParenthSpace(this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(lparenth.getTextRange().getStartOffset(), this.myChild2.getTextRange().getEndOffset()));
                }
            }
        } else if (this.myRole1 == 39) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myRole1 == 32) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
        } else if (this.myRole1 == 41) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myRole2 == 38 || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            this.processLoopBody();
        }
    }

    protected void processLoopBody() {
        this.myResult = this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT ? this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_FOR_LBRACE, null) : (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
    }

    @Nullable
    private static ASTNode findFrom(ASTNode current, IElementType expected, boolean forward) {
        while (current != null) {
            if (current.getElementType() == expected) {
                return current;
            }
            current = forward ? current.getTreeNext() : current.getTreePrev();
        }
        return null;
    }

    public void visitCatchSection(PsiCatchSection section) {
        if (this.myRole2 == 49) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_CATCH_LBRACE, null);
        } else if (this.myRole2 == 50) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
        } else if (this.myRole1 == 50 || this.myRole2 == 51) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        }
    }

    public void visitResourceList(PsiResourceList resourceList) {
        if (this.myType1 == JavaTokenType.LPARENTH && this.myType2 == JavaTokenType.RPARENTH) {
            this.createParenthSpace(this.mySettings.RESOURCE_LIST_RPAREN_ON_NEXT_LINE, false);
        } else if (this.myType1 == JavaTokenType.LPARENTH) {
            this.createParenthSpace(this.mySettings.RESOURCE_LIST_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_TRY_PARENTHESES);
        } else if (this.myType2 == JavaTokenType.RPARENTH) {
            this.createParenthSpace(this.mySettings.RESOURCE_LIST_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_TRY_PARENTHESES);
        } else if (this.myType1 == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myType2 == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
        }
    }

    public void visitReferenceParameterList(PsiReferenceParameterList list) {
        if (this.myRole1 == 121 && this.myRole2 == 122 || this.myRole1 == 120 && this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 121 && this.myRole2 == 120) {
            this.createSpaceInCode(this.myJavaSettings.SPACES_WITHIN_ANGLE_BRACKETS);
        } else if (this.myRole1 == 23 && this.myRole2 == 120) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
        } else if (this.myRole2 == 122) {
            this.createSpaceInCode(this.myJavaSettings.SPACES_WITHIN_ANGLE_BRACKETS);
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CAST_PARENTHESES);
        } else if (this.myRole1 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_TYPE_CAST);
        }
    }

    private void createSpaceProperty(boolean space, int keepBlankLines) {
        this.createSpaceProperty(space, this.mySettings.KEEP_LINE_BREAKS, keepBlankLines);
    }

    private void createSpaceProperty(boolean space, boolean keepLineBreaks, int keepBlankLines) {
        ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
        if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            if (!space && !JavaSpacePropertyProcessor.canStickChildrenTogether(this.myChild1, this.myChild2)) {
                space = true;
            }
            this.myResult = Spacing.createSpacing((int)(space ? 1 : 0), (int)(space ? 1 : 0), (int)0, (boolean)keepLineBreaks, (int)keepBlankLines);
        }
    }

    public void visitReferenceList(PsiReferenceList list) {
        if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 123 || this.myRole2 == 123) {
            this.createSpaceInCode(this.myJavaSettings.SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS);
        } else if (REF_LIST_KEYWORDS.contains(this.myType1) || REF_LIST_KEYWORDS.contains(this.myType2)) {
            this.createSpaceInCode(true);
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        if (this.myRole2 == 114) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_QUEST);
        } else if (this.myRole1 == 114) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_QUEST);
        } else if (this.myRole2 == 87) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        } else if (this.myRole1 == 87) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        }
    }

    public void visitStatement(PsiStatement statement) {
        if (this.myRole2 == 22) {
            this.createSpaceInCode(false);
        }
        if (statement instanceof JspClassLevelDeclarationStatement) {
            this.processClassBody();
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 65) {
            this.createSpaceInCode(true);
        } else {
            super.visitReturnStatement(statement);
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
    }

    public void visitTypeParameter(PsiTypeParameter classParameter) {
        this.createSpaceInCode(true);
    }

    public void visitTypeElement(PsiTypeElement type2) {
        if (this.myType1 == JavaElementType.ANNOTATION || this.myType2 == JavaElementType.ANNOTATION) {
            this.createSpaceInCode(true);
        } else if (this.myType2 == JavaTokenType.ELLIPSIS || this.myType2 == JavaTokenType.LBRACKET || this.myType2 == JavaTokenType.RBRACKET) {
            this.createSpaceInCode(false);
        } else if (type2.getType() instanceof PsiDisjunctionType) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
        } else {
            this.createSpaceInCode(true);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement declarationStatement) {
        if (this.myRole2 == 23) {
            this.createSpaceProperty(false, false, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList list) {
        if (this.myRole1 == 121 || this.myRole2 == 122) {
            this.createSpaceInCode(this.myJavaSettings.SPACES_WITHIN_ANGLE_BRACKETS);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        if (this.myRole1 == 246 && this.myRole2 == 53) {
            this.createSpaceInCode(this.myJavaSettings.SPACE_AFTER_CLOSING_ANGLE_BRACKET_IN_TYPE_ARGUMENT);
        } else if (this.myRole2 == 246) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_TYPE_PARAMETER_LIST);
        } else if (this.myRole2 == 55) {
            this.createSpaceInCode(false);
        } else if (this.myType1 == JavaElementType.ANNOTATION) {
            this.createSpaceInCode(true);
        }
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        if (this.myRole2 == 14) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ANOTATION_PARAMETER_LIST);
        } else if (this.myChild1.getElementType() == JavaTokenType.AT && this.myChild2.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            this.createSpaceInCode(false);
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        if (this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_METHOD_LBRACE, null);
        }
    }

    public void visitAnnotationParameterList(PsiAnnotationParameterList list) {
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 24 && this.mySettings.SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE && this.myRole2 == 249) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_ANNOTATION_PARENTHESES);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    public void visitNameValuePair(PsiNameValuePair pair) {
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        this.visitArrayInitializer();
    }

    private void visitArrayInitializer() {
        if (this.myRole1 == 18) {
            if (this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE) {
                int spaces = this.myRole2 != 19 ? (this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0) : (this.mySettings.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES ? 1 : 0);
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                boolean addSpace = this.myRole2 != 19 ? this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES : this.mySettings.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES;
                this.createSpaceProperty(addSpace, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.myRole2 == 18) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        } else if (this.myRole2 == 19) {
            if (this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE) {
                int spaces = this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0;
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            }
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else if (this.myRole2 == 70) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_CLASS_LBRACE, null);
        } else if (this.myRole1 == 8 && this.myRole2 == 9) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 7 && this.myRole2 == 9) {
            this.createParenthSpace(true, true);
        }
    }

    public void visitDocTag(PsiDocTag tag) {
        if (this.myType1 == JavaDocTokenType.DOC_TAG_NAME && this.myType2 == JavaDocElementType.DOC_TAG_VALUE_ELEMENT) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myChild1.getElementType() == JavaTokenType.ASSERT_KEYWORD) {
            this.createSpaceInCode(true);
        } else if (this.myChild1.getElementType() == JavaTokenType.COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        } else if (this.myChild2.getElementType() == JavaTokenType.COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        }
    }

    public void visitParameter(PsiParameter parameter2) {
        if (this.myRole1 == 10 || this.myRole1 == 8) {
            this.createSpaceInCode(true);
        }
    }

    public static Spacing getSpacing(Block node, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        return new JavaSpacePropertyProcessor((Block)node, (CommonCodeStyleSettings)settings, (JavaCodeStyleSettings)javaSettings).myResult;
    }

    public static boolean canStickChildrenTogether(ASTNode child1, ASTNode child2) {
        if (child1 == null || child2 == null || child1.getElementType() == TokenType.WHITE_SPACE || child2.getElementType() == TokenType.WHITE_SPACE) {
            return true;
        }
        ASTNode token1 = TreeUtil.findLastLeaf((ASTNode)child1);
        LeafElement token2 = TreeUtil.findFirstLeaf((ASTNode)child2);
        LOG.assertTrue(token1 != null);
        LOG.assertTrue(token2 != null);
        IElementType type1 = token1.getElementType();
        IElementType type2 = token2.getElementType();
        if (!(type1 instanceof IJavaElementType) || !(type2 instanceof IJavaElementType)) {
            return true;
        }
        Pair key2 = Pair.pair((Object)type1, (Object)type2);
        Boolean result = ourTokenStickingMatrix.get(key2);
        if (result == null) {
            Lexer lexer = JavaParserDefinition.createLexer(LanguageLevel.HIGHEST);
            String text1 = JavaSpacePropertyProcessor.unescapeTokenText(token1, type1);
            String text2 = JavaSpacePropertyProcessor.unescapeTokenText((ASTNode)token2, type2);
            lexer.start((CharSequence)(text1 + text2));
            IElementType reparsedType1 = lexer.getTokenType();
            String reparsedText1 = lexer.getTokenText();
            lexer.advance();
            IElementType reparsedType2 = lexer.getTokenType();
            String reparsedText2 = lexer.getTokenText();
            result = JavaSpacePropertyProcessor.sameTokens(type1, text1, reparsedType1, reparsedText1) && JavaSpacePropertyProcessor.sameTokens(type2, text2, reparsedType2, reparsedText2);
            ourTokenStickingMatrix.put((Pair<IElementType, IElementType>)key2, result);
        }
        return result;
    }

    private static String unescapeTokenText(ASTNode token, IElementType type2) {
        String text2 = token.getText();
        if (ESCAPED_TOKENS.contains(type2) && StringUtil.startsWithChar((CharSequence)text2, (char)'&')) {
            text2 = StringUtil.unescapeXml((String)text2);
        }
        return text2;
    }

    private static boolean sameTokens(IElementType type2, String text2, IElementType reparsedType, String reparsedText) {
        return reparsedType == type2 || reparsedType == JavaTokenType.IDENTIFIER && ElementType.KEYWORD_BIT_SET.contains(type2) && Comparing.equal((String)text2, (String)reparsedText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/JavaSpacePropertyProcessor";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lBraceBlock";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/JavaSpacePropertyProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpaceBeforeMethodLBrace";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpaceBeforeClassLBrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJavadocHoldingEnumConstant";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeMethodLBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMethodHeaderEndOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeClassLBrace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeLBrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldHandleAsSimpleClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldHandleAsSimpleBlock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldHandleAsSimpleMethod";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMethodHeaderStartOffset";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEndOfLineCommentAfterLBrace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSpaceWithLinefeedIfListWrapped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

