/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.CallChunkBlockBuilder;
import com.intellij.psi.formatter.java.ChainedCallChunk;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ChainMethodCallsBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myBlockWrap;
    private final Alignment myBlockAlignment;
    private final Indent myBlockIndent;
    private final FormattingMode myFormattingMode;

    public ChainMethodCallsBlockBuilder(Alignment alignment, Wrap wrap, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(0);
        }
        this.myBlockWrap = wrap;
        this.myBlockAlignment = alignment;
        this.myBlockIndent = indent;
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
    }

    public Block build(List<ASTNode> nodes) {
        List<Block> blocks = this.buildBlocksFrom(nodes);
        Indent indent = this.myBlockIndent != null ? this.myBlockIndent : Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        return new SyntheticCodeBlock(blocks, this.myBlockAlignment, this.mySettings, this.myJavaSettings, indent, this.myBlockWrap);
    }

    private List<Block> buildBlocksFrom(List<ASTNode> nodes) {
        List<ChainedCallChunk> methodCall = ChainMethodCallsBlockBuilder.splitMethodCallOnChunksByDots(nodes);
        Wrap wrap = null;
        Alignment chainedCallsAlignment = null;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < methodCall.size(); ++i) {
            ChainedCallChunk currentCallChunk = methodCall.get(i);
            if (ChainMethodCallsBlockBuilder.isMethodCall(currentCallChunk) || ChainMethodCallsBlockBuilder.isComment(currentCallChunk)) {
                if (wrap == null) {
                    wrap = this.createCallChunkWrap(i, methodCall);
                }
                if (chainedCallsAlignment == null) {
                    chainedCallsAlignment = this.createCallChunkAlignment(i, methodCall);
                }
            } else {
                wrap = null;
                chainedCallsAlignment = null;
            }
            CallChunkBlockBuilder builder = new CallChunkBlockBuilder(this.mySettings, this.myJavaSettings, this.myFormattingMode);
            blocks.add(builder.create(currentCallChunk.nodes, wrap, chainedCallsAlignment));
        }
        return blocks;
    }

    private static boolean isComment(ChainedCallChunk chunk) {
        List<ASTNode> nodes = chunk.nodes;
        if (nodes.size() == 1) {
            return nodes.get(0).getPsi() instanceof PsiComment;
        }
        return false;
    }

    private Wrap createCallChunkWrap(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        if (methodCall == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(1);
        }
        if (this.mySettings.WRAP_FIRST_METHOD_IN_CALL_CHAIN) {
            ChainedCallChunk next;
            ChainedCallChunk chainedCallChunk = next = chunkIndex + 1 < methodCall.size() ? methodCall.get(chunkIndex + 1) : null;
            if (next != null && ChainMethodCallsBlockBuilder.isMethodCall(next)) {
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)true);
            }
        }
        return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)false);
    }

    private boolean shouldAlignMethod(ChainedCallChunk currentMethodChunk, List<ChainedCallChunk> methodCall) {
        return this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && !currentMethodChunk.isEmpty() && !ChainMethodCallsBlockBuilder.chunkIsFirstInChainMethodCall(currentMethodChunk, methodCall);
    }

    private static boolean chunkIsFirstInChainMethodCall(@NotNull ChainedCallChunk callChunk, @NotNull List<ChainedCallChunk> methodCall) {
        if (callChunk == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(2);
        }
        if (methodCall == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(3);
        }
        return !methodCall.isEmpty() && callChunk == methodCall.get(0);
    }

    @NotNull
    private static List<ChainedCallChunk> splitMethodCallOnChunksByDots(@NotNull List<ASTNode> nodes) {
        if (nodes == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(4);
        }
        ArrayList<ChainedCallChunk> result = new ArrayList<ChainedCallChunk>();
        ArrayList<Object> current = new ArrayList<ASTNode>();
        for (ASTNode node : nodes) {
            if (node.getElementType() == JavaTokenType.DOT || node.getPsi() instanceof PsiComment) {
                if (!current.isEmpty()) {
                    result.add(new ChainedCallChunk(current));
                }
                current = new ArrayList();
            }
            current.add(node);
        }
        if (!current.isEmpty()) {
            result.add(new ChainedCallChunk(current));
        }
        ArrayList<ChainedCallChunk> arrayList = result;
        if (arrayList == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private Alignment createCallChunkAlignment(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        ChainedCallChunk current;
        if (methodCall == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(6);
        }
        return this.shouldAlignMethod(current = methodCall.get(chunkIndex), methodCall) ? AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS, null) : null;
    }

    private static boolean isMethodCall(@NotNull ChainedCallChunk callChunk) {
        List<ASTNode> nodes;
        if (callChunk == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(7);
        }
        return (nodes = callChunk.nodes).size() >= 3 && nodes.get(2).getElementType() == JavaElementType.EXPRESSION_LIST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callChunk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitMethodCallOnChunksByDots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCallChunkWrap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chunkIsFirstInChainMethodCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitMethodCallOnChunksByDots";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCallChunkAlignment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMethodCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

