/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallChunkBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final FormattingMode myFormattingMode;

    public CallChunkBlockBuilder(@NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (settings == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(0);
        }
        if (javaSettings == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(2);
        }
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
    }

    @NotNull
    public Block create(@NotNull List<ASTNode> subNodes, Wrap wrap, @Nullable Alignment alignment) {
        if (subNodes == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(3);
        }
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode firstNode = subNodes.get(0);
        if (firstNode.getElementType() == JavaTokenType.DOT) {
            AlignmentStrategy strategy = AlignmentStrategy.getNullStrategy();
            Block block = AbstractJavaBlock.newJavaBlock(firstNode, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, strategy, this.myFormattingMode);
            subBlocks.add(block);
            subNodes.remove(0);
            if (!subNodes.isEmpty()) {
                subBlocks.add(this.create(subNodes, wrap, null));
            }
            SyntheticCodeBlock syntheticCodeBlock = new SyntheticCodeBlock(subBlocks, alignment, this.mySettings, this.myJavaSettings, Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), wrap);
            if (syntheticCodeBlock == null) {
                CallChunkBlockBuilder.$$$reportNull$$$0(4);
            }
            return syntheticCodeBlock;
        }
        SyntheticCodeBlock syntheticCodeBlock = new SyntheticCodeBlock(this.createJavaBlocks(subNodes), alignment, this.mySettings, this.myJavaSettings, Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), null);
        if (syntheticCodeBlock == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(5);
        }
        return syntheticCodeBlock;
    }

    @NotNull
    private List<Block> createJavaBlocks(@NotNull List<ASTNode> subNodes) {
        if (subNodes == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(6);
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode node : subNodes) {
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
            result.add(AbstractJavaBlock.newJavaBlock(node, this.mySettings, this.myJavaSettings, indent, null, AlignmentStrategy.getNullStrategy(), this.myFormattingMode));
        }
        ArrayList<Block> arrayList = result;
        if (arrayList == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subNodes";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/CallChunkBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/CallChunkBlockBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createJavaBlocks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

