/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassLiteralLookupElement
extends LookupElement
implements TypedLookupItem {
    @NonNls
    private static final String DOT_CLASS = ".class";
    @Nullable
    private final SmartPsiElementPointer<PsiClass> myClass;
    private final PsiExpression myExpr;
    private final String myPresentableText;
    private final String myCanonicalText;

    ClassLiteralLookupElement(PsiClassType type2, PsiElement context) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        this.myClass = psiClass == null ? null : SmartPointerManager.createPointer((PsiElement)psiClass);
        this.myCanonicalText = type2.getCanonicalText();
        this.myPresentableText = type2.getPresentableText();
        this.myExpr = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createExpressionFromText(this.myCanonicalText + DOT_CLASS, context);
    }

    @NotNull
    public String getLookupString() {
        String string = this.myPresentableText + DOT_CLASS;
        if (string == null) {
            ClassLiteralLookupElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setIcon(this.myExpr.getIcon(0));
        String pkg = StringUtil.getPackageName((String)this.myCanonicalText);
        if (StringUtil.isNotEmpty((String)pkg)) {
            presentation.setTailText(" (" + pkg + ")", true);
        }
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myClass == null ? null : this.myClass.getElement();
    }

    @NotNull
    public Object getObject() {
        PsiExpression psiExpression = this.myExpr;
        if (psiExpression == null) {
            ClassLiteralLookupElement.$$$reportNull$$$0(1);
        }
        return psiExpression;
    }

    @Override
    public PsiType getType() {
        return this.myExpr.getType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassLiteralLookupElement)) {
            return false;
        }
        return this.myCanonicalText.equals(((ClassLiteralLookupElement)o).myCanonicalText);
    }

    public int hashCode() {
        return this.myCanonicalText.hashCode();
    }

    public void handleInsert(InsertionContext context) {
        Document document = context.getEditor().getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)(this.myCanonicalText + DOT_CLASS));
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)context.getFile(), context.getStartOffset(), context.getTailOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/filters/getters/ClassLiteralLookupElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

