/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.annotations.NotNull;

public class ReturnInstruction
extends GoToInstruction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ReturnInstruction");
    @NotNull
    private final ControlFlowStack myStack;
    @NotNull
    private CallInstruction myCallInstruction;
    private boolean myRethrowFromFinally;

    public ReturnInstruction(int offset, @NotNull ControlFlowStack stack, @NotNull CallInstruction callInstruction) {
        if (stack == null) {
            ReturnInstruction.$$$reportNull$$$0(0);
        }
        if (callInstruction == null) {
            ReturnInstruction.$$$reportNull$$$0(1);
        }
        super(offset, BranchingInstruction.Role.END, false);
        this.myStack = stack;
        this.myCallInstruction = callInstruction;
    }

    @Override
    public String toString() {
        return "RETURN FROM " + this.getProcBegin() + (this.offset == 0 ? "" : " TO " + this.offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(boolean pushBack) {
        ControlFlowStack controlFlowStack = this.myStack;
        synchronized (controlFlowStack) {
            int jumpTo = -1;
            if (this.myStack.size() != 0) {
                jumpTo = this.myStack.pop(pushBack);
            }
            if (this.offset != 0) {
                jumpTo = this.offset;
            }
            return jumpTo;
        }
    }

    @NotNull
    int[] getPossibleReturnOffsets() {
        int[] nArray;
        if (this.offset == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = this.getProcBegin() - 5;
            nArray2[1] = this.getProcBegin() - 3;
            nArray = nArray2;
            nArray2[2] = this.getProcBegin() - 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = this.offset;
        }
        if (nArray == null) {
            ReturnInstruction.$$$reportNull$$$0(2);
        }
        return nArray;
    }

    int getProcBegin() {
        return this.myCallInstruction.procBegin;
    }

    int getProcEnd() {
        return this.myCallInstruction.procEnd;
    }

    void setCallInstruction(@NotNull CallInstruction callInstruction) {
        if (callInstruction == null) {
            ReturnInstruction.$$$reportNull$$$0(3);
        }
        this.myCallInstruction = callInstruction;
    }

    @Override
    public int nNext() {
        return this.offset == 0 ? 3 : 1;
    }

    @Override
    public int getNext(int index, int no) {
        if (this.offset == 0) {
            switch (no) {
                case 0: {
                    return this.getProcBegin() - 5;
                }
                case 1: {
                    return this.getProcBegin() - 3;
                }
                case 2: {
                    return this.getProcBegin() - 1;
                }
            }
            LOG.assertTrue(false);
            return -1;
        }
        switch (no) {
            case 0: {
                return this.offset;
            }
        }
        LOG.assertTrue(false);
        return -1;
    }

    @Override
    public void accept(@NotNull ControlFlowInstructionVisitor visitor, int offset, int nextOffset) {
        if (visitor == null) {
            ReturnInstruction.$$$reportNull$$$0(4);
        }
        visitor.visitReturnInstruction(this, offset, nextOffset);
    }

    @NotNull
    public ControlFlowStack getStack() {
        ControlFlowStack controlFlowStack = this.myStack;
        if (controlFlowStack == null) {
            ReturnInstruction.$$$reportNull$$$0(5);
        }
        return controlFlowStack;
    }

    void setRethrowFromFinally() {
        this.myRethrowFromFinally = true;
    }

    boolean isRethrowFromFinally() {
        return this.myRethrowFromFinally;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callInstruction";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ReturnInstruction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ReturnInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleReturnOffsets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCallInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

