/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.AnalysisCanceledSoftException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowImpl;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ControlFlowAnalyzer");
    private final PsiElement myCodeFragment;
    private final ControlFlowPolicy myPolicy;
    private ControlFlowImpl myCurrentFlow;
    private final ControlFlowStack myStack;
    private final Stack<PsiParameter> myCatchParameters;
    private final Stack<PsiElement> myCatchBlocks;
    private final Stack<FinallyBlockSubroutine> myFinallyBlocks;
    private final Stack<PsiElement> myUnhandledExceptionCatchBlocks;
    private final StatementStack myStartStatementStack;
    private final StatementStack myEndStatementStack;
    private final Stack<BranchingInstruction.Role> myStartJumpRoles;
    private final Stack<BranchingInstruction.Role> myEndJumpRoles;
    private final boolean myEnabledShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myAssignmentTargetsAreElements;
    private final Stack<TIntArrayList> intArrayPool;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementStart;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementEnd;
    private final ControlFlowFactory myControlFlowFactory;
    private final Map<PsiElement, ControlFlowSubRange> mySubRanges;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final Map<PsiElement, List<PsiElement>> finallyBlockToUnhandledExceptions;

    ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        this(codeFragment, policy, enabledShortCircuit, evaluateConstantIfCondition, false);
    }

    private ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition, boolean assignmentTargetsAreElements) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        if (policy == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        this.myStack = new ControlFlowStack();
        this.myCatchParameters = new Stack();
        this.myCatchBlocks = new Stack();
        this.myFinallyBlocks = new Stack();
        this.myUnhandledExceptionCatchBlocks = new Stack();
        this.myStartStatementStack = new StatementStack();
        this.myEndStatementStack = new StatementStack();
        this.myStartJumpRoles = new Stack();
        this.myEndJumpRoles = new Stack();
        this.intArrayPool = new Stack();
        this.offsetsAddElementStart = new THashMap();
        this.offsetsAddElementEnd = new THashMap();
        this.mySubRanges = new THashMap();
        this.finallyBlockToUnhandledExceptions = new HashMap<PsiElement, List<PsiElement>>();
        this.myCodeFragment = codeFragment;
        this.myPolicy = policy;
        this.myEnabledShortCircuit = enabledShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myAssignmentTargetsAreElements = assignmentTargetsAreElements;
        Project project = codeFragment.getProject();
        this.myControlFlowFactory = ControlFlowFactory.getInstance(project);
        this.myConstantEvaluationHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
    }

    @NotNull
    ControlFlow buildControlFlow() throws AnalysisCanceledException {
        this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
        this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
        this.myCurrentFlow = new ControlFlowImpl();
        this.myStartStatementStack.pushStatement(this.myCodeFragment, false);
        this.myEndStatementStack.pushStatement(this.myCodeFragment, false);
        try {
            this.myCodeFragment.accept((PsiElementVisitor)this);
            this.cleanup();
        }
        catch (AnalysisCanceledSoftException e) {
            throw new AnalysisCanceledException(e.getErrorElement());
        }
        ControlFlowImpl controlFlowImpl = this.myCurrentFlow;
        if (controlFlowImpl == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        return controlFlowImpl;
    }

    @NotNull
    private TIntArrayList getEmptyIntArray() {
        if (this.intArrayPool.isEmpty()) {
            TIntArrayList tIntArrayList = new TIntArrayList(1);
            if (tIntArrayList == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(5);
            }
            return tIntArrayList;
        }
        TIntArrayList list = (TIntArrayList)this.intArrayPool.pop();
        list.clear();
        TIntArrayList tIntArrayList = list;
        if (tIntArrayList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        return tIntArrayList;
    }

    private void poolIntArray(@NotNull TIntArrayList list) {
        if (list == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        this.intArrayPool.add((Object)list);
    }

    private void addElementOffsetLater(@NotNull PsiElement element, boolean atStart) {
        Map<PsiElement, TIntArrayList> offsetsAddElement;
        TIntArrayList offsets;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        if ((offsets = (offsetsAddElement = atStart ? this.offsetsAddElementStart : this.offsetsAddElementEnd).get(element)) == null) {
            offsets = this.getEmptyIntArray();
            offsetsAddElement.put(element, offsets);
        }
        int offset = this.myCurrentFlow.getSize() - 1;
        offsets.add(offset);
        if (this.myCurrentFlow.getEndOffset(element) != -1) {
            this.patchInstructionOffsets(element);
        }
    }

    private void patchInstructionOffsets(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        this.patchInstructionOffsets(this.offsetsAddElementStart.get(element), this.myCurrentFlow.getStartOffset(element));
        this.offsetsAddElementStart.put(element, null);
        this.patchInstructionOffsets(this.offsetsAddElementEnd.get(element), this.myCurrentFlow.getEndOffset(element));
        this.offsetsAddElementEnd.put(element, null);
    }

    private void patchInstructionOffsets(@Nullable TIntArrayList offsets, int add) {
        if (offsets == null) {
            return;
        }
        for (int i = 0; i < offsets.size(); ++i) {
            int offset = offsets.get(i);
            BranchingInstruction instruction = (BranchingInstruction)this.myCurrentFlow.getInstructions().get(offset);
            instruction.offset += add;
            LOG.assertTrue(instruction.offset >= 0);
        }
        this.poolIntArray(offsets);
    }

    private void cleanup() {
        for (TIntArrayList tIntArrayList : this.offsetsAddElementStart.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (TIntArrayList tIntArrayList : this.offsetsAddElementEnd.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (Map.Entry entry : this.mySubRanges.entrySet()) {
            ProgressManager.checkCanceled();
            ControlFlowSubRange subRange = (ControlFlowSubRange)entry.getValue();
            PsiElement element = (PsiElement)entry.getKey();
            this.myControlFlowFactory.registerSubRange(element, subRange, this.myEvaluateConstantIfCondition, this.myEnabledShortCircuit, this.myPolicy);
        }
    }

    private void startElement(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressManager.checkCanceled();
            if (!(child instanceof PsiErrorElement) || Comparing.strEqual((String)((PsiErrorElement)child).getErrorDescription(), (String)JavaErrorMessages.message("expected.semicolon", new Object[0]))) continue;
            throw new AnalysisCanceledSoftException(element);
        }
        ProgressManager.checkCanceled();
        this.myCurrentFlow.startElement(element);
        this.generateUncheckedExceptionJumpsIfNeeded(element, true);
    }

    private void generateUncheckedExceptionJumpsIfNeeded(@NotNull PsiElement element, boolean atStart) {
        boolean isGeneratingCodeBlock;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(11);
        }
        boolean isGeneratingStatement = element instanceof PsiStatement && !(element instanceof PsiSwitchLabelStatement);
        boolean bl = isGeneratingCodeBlock = element instanceof PsiCodeBlock && !(element.getParent() instanceof PsiSwitchStatement);
        if (isGeneratingStatement || isGeneratingCodeBlock) {
            this.generateUncheckedExceptionJumps(element, atStart);
        }
    }

    private void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(12);
        }
        this.generateUncheckedExceptionJumpsIfNeeded(element, false);
        this.myCurrentFlow.finishElement(element);
        this.patchInstructionOffsets(element);
    }

    private void generateUncheckedExceptionJumps(@NotNull PsiElement element, boolean atStart) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(13);
        }
        if (atStart && element instanceof PsiStatement && element.getParent() instanceof PsiCodeBlock && element.getPrevSibling() != null) {
            return;
        }
        for (int i = this.myUnhandledExceptionCatchBlocks.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiElement block = (PsiElement)this.myUnhandledExceptionCatchBlocks.get(i);
            if (block == null) {
                if (this.myFinallyBlocks.isEmpty()) continue;
                break;
            }
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-1);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, block)) continue;
            this.addElementOffsetLater(block, true);
        }
        if (!this.myFinallyBlocks.isEmpty()) {
            PsiElement finallyBlock = ((FinallyBlockSubroutine)this.myFinallyBlocks.peek()).getElement();
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-2);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (!this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, finallyBlock)) {
                this.addElementOffsetLater(finallyBlock, true);
            }
        }
    }

    private void generateCheckedExceptionJumps(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(14);
        }
        this.generateExceptionJumps(element, ExceptionUtil.collectUnhandledExceptions(element, element.getParent()));
    }

    private void generateExceptionJumps(@NotNull PsiElement element, Collection<PsiClassType> unhandledExceptions) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(15);
        }
        for (PsiClassType unhandledException : unhandledExceptions) {
            ProgressManager.checkCanceled();
            this.generateThrow(unhandledException, element);
        }
    }

    private void generateThrow(@NotNull PsiClassType unhandledException, @NotNull PsiElement throwingElement) {
        if (unhandledException == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(16);
        }
        if (throwingElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(17);
        }
        List<PsiElement> catchBlocks = this.findThrowToBlocks(unhandledException);
        for (PsiElement block : catchBlocks) {
            ProgressManager.checkCanceled();
            ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.patchCheckedThrowInstructionIfInsideFinally(instruction, throwingElement, block)) continue;
            if (block == null) {
                this.addElementOffsetLater(this.myCodeFragment, false);
                continue;
            }
            --instruction.offset;
            this.addElementOffsetLater(block, true);
        }
    }

    private boolean patchCheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, PsiElement elementToJumpTo) {
        int index;
        PsiElement finallyBlock;
        if (instruction == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(18);
        }
        if (throwingElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(19);
        }
        if ((finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo)) == null) {
            return false;
        }
        List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.get(finallyBlock);
        if (unhandledExceptionCatchBlocks == null) {
            unhandledExceptionCatchBlocks = new ArrayList<PsiElement>();
            this.finallyBlockToUnhandledExceptions.put(finallyBlock, unhandledExceptionCatchBlocks);
        }
        if ((index = unhandledExceptionCatchBlocks.indexOf(elementToJumpTo)) == -1) {
            index = unhandledExceptionCatchBlocks.size();
            unhandledExceptionCatchBlocks.add(elementToJumpTo);
        }
        instruction.offset = 3 + index;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    private boolean patchUncheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, @NotNull PsiElement elementToJumpTo) {
        PsiElement finallyBlock;
        if (instruction == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(20);
        }
        if (throwingElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(21);
        }
        if (elementToJumpTo == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(22);
        }
        if ((finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo)) == null) {
            return false;
        }
        instruction.offset = 2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiElement[] children;
        this.startElement((PsiElement)codeFragment);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiElement child : children = codeFragment.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
        this.registerSubRange((PsiElement)codeFragment, prevOffset);
    }

    private void registerSubRange(@NotNull PsiElement codeFragment, int startOffset) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(23);
        }
        ControlFlowSubRange flow = new ControlFlowSubRange(this.myCurrentFlow, startOffset, this.myCurrentFlow.getSize());
        this.mySubRanges.put(codeFragment, flow);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements;
        this.startElement((PsiElement)block);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiStatement statement : statements = block.getStatements()) {
            ProgressManager.checkCanceled();
            statement.accept((PsiElementVisitor)this);
        }
        int nextOffset = this.myCurrentFlow.getSize();
        if (!(block.getParent() instanceof PsiSwitchStatement) && prevOffset == nextOffset) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)block);
        if (prevOffset != 0) {
            this.registerSubRange((PsiElement)block, prevOffset);
        }
    }

    private void emitEmptyInstruction() {
        this.myCurrentFlow.addInstruction(EmptyInstruction.INSTANCE);
    }

    public void visitFile(PsiFile file) {
        this.visitChildren((PsiElement)file);
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement((PsiElement)statement);
        PsiCodeBlock codeBlock = statement.getCodeBlock();
        codeBlock.accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement);
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            this.callFinallyBlocksOnExit(exitedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement((PsiElement)statement, (PsiElement)exitedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0, BranchingInstruction.Role.END, PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.myCodeFragment, (boolean)true));
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)exitedStatement, false);
        }
        this.finishElement((PsiElement)statement);
    }

    private void callFinallyBlocksOnExit(PsiStatement exitedStatement) {
        FinallyBlockSubroutine finallyBlockSubroutine;
        PsiElement finallyBlock;
        PsiElement enclosingTryStatement;
        ListIterator it = this.myFinallyBlocks.listIterator(this.myFinallyBlocks.size());
        while (it.hasPrevious() && (enclosingTryStatement = (finallyBlock = (finallyBlockSubroutine = (FinallyBlockSubroutine)it.previous()).getElement()).getParent()) != null && PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)enclosingTryStatement, (boolean)false)) {
            CallInstruction instruction = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(instruction);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, true);
        }
    }

    private PsiElement findEnclosingFinallyBlockElement(@NotNull PsiElement sourceElement, @Nullable PsiElement jumpElement) {
        if (sourceElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(24);
        }
        for (PsiElement element = sourceElement; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiCodeBlock) || !(element.getParent() instanceof PsiTryStatement) || ((PsiTryStatement)element.getParent()).getFinallyBlock() != element) continue;
            if (this.myCurrentFlow.getStartOffset(element.getParent()) == -1) {
                return null;
            }
            if (jumpElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)jumpElement, (boolean)false)) continue;
            return element;
        }
        return null;
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            PsiStatement body2 = null;
            if (continuedStatement instanceof PsiLoopStatement) {
                body2 = ((PsiLoopStatement)continuedStatement).getBody();
            }
            if (body2 == null) {
                body2 = this.myCodeFragment;
            }
            this.callFinallyBlocksOnExit(continuedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement((PsiElement)statement, (PsiElement)continuedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0, BranchingInstruction.Role.END, PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)this.myCodeFragment, (boolean)true));
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)body2, false);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            ProgressManager.checkCanceled();
            if (element instanceof PsiClass) {
                element.accept((PsiElementVisitor)this);
                continue;
            }
            if (!(element instanceof PsiVariable)) continue;
            this.processVariable((PsiVariable)element);
        }
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)statement);
    }

    private void processVariable(@NotNull PsiVariable element) {
        PsiExpression initializer;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(25);
        }
        if ((initializer = element.getInitializer()) != null) {
            this.myStartStatementStack.pushStatement((PsiElement)initializer, false);
            this.myEndStatementStack.pushStatement((PsiElement)initializer, false);
            initializer.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if (element instanceof PsiLocalVariable && initializer != null || element instanceof PsiField) {
            if (element instanceof PsiLocalVariable && !this.myPolicy.isLocalVariableAccepted((PsiLocalVariable)element)) {
                return;
            }
            if (this.myAssignmentTargetsAreElements) {
                this.startElement((PsiElement)element);
            }
            this.generateWriteInstruction(element);
            if (this.myAssignmentTargetsAreElements) {
                this.finishElement((PsiElement)element);
            }
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        PsiExpression condition2;
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body2 == null ? statement : body2), true);
        this.myEndStatementStack.pushStatement((PsiElement)statement, false);
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if ((condition2 = statement.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
        }
        int offset = this.myCurrentFlow.getStartOffset((PsiElement)statement);
        Object loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)statement.getCondition());
        if (loopCondition instanceof Boolean) {
            if (((Boolean)loopCondition).booleanValue()) {
                this.myCurrentFlow.addInstruction(new GoToInstruction(offset));
            } else {
                this.emitEmptyInstruction();
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(offset, statement.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement((PsiElement)statement);
        this.emitEmptyInstruction();
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression expression2 = statement.getExpression();
        expression2.accept((PsiElementVisitor)this);
        for (PsiParameter catchParameter : this.myCatchParameters) {
            ProgressManager.checkCanceled();
            PsiType type2 = catchParameter.getType();
            if (!(type2 instanceof PsiClassType)) continue;
            this.generateThrow((PsiClassType)type2, (PsiElement)statement);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)statement);
        for (PsiExpression expr : expressions2 = statement.getExpressionList().getExpressions()) {
            ProgressManager.checkCanceled();
            expr.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.startElement((PsiElement)field);
            initializer.accept((PsiElementVisitor)this);
            this.finishElement((PsiElement)field);
        }
    }

    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update2;
        Object loopCondition;
        PsiExpression condition2;
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body2 == null ? statement : body2), false);
        this.myEndStatementStack.pushStatement((PsiElement)statement, false);
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
        }
        if ((condition2 = statement.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)condition2)) instanceof Boolean || condition2 == null) {
            boolean value2;
            boolean bl = value2 = condition2 == null || (Boolean)loopCondition != false;
            if (value2) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater((PsiElement)statement, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)statement, false);
        }
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if ((update2 = statement.getUpdate()) != null) {
            update2.accept((PsiElementVisitor)this);
        }
        int offset = initialization != null ? this.myCurrentFlow.getEndOffset((PsiElement)initialization) : this.myCurrentFlow.getStartOffset((PsiElement)statement);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement);
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body2 == null ? statement : body2), false);
        this.myEndStatementStack.pushStatement((PsiElement)statement, false);
        PsiExpression iteratedValue2 = statement.getIteratedValue();
        if (iteratedValue2 != null) {
            iteratedValue2.accept((PsiElementVisitor)this);
        }
        int gotoTarget = this.myCurrentFlow.getSize();
        ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getIteratedValue());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater((PsiElement)statement, false);
        PsiParameter iterationParameter = statement.getIterationParameter();
        if (this.myPolicy.isParameterAccepted(iterationParameter)) {
            this.generateWriteInstruction((PsiVariable)iterationParameter);
        }
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        GoToInstruction gotoInstruction = new GoToInstruction(gotoTarget);
        this.myCurrentFlow.addInstruction(gotoInstruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement);
    }

    public void visitIfStatement(PsiIfStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement elseBranch = statement.getElseBranch();
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpression conditionExpression = statement.getCondition();
        this.generateConditionalStatementInstructions((PsiElement)statement, conditionExpression, (PsiElement)thenBranch, (PsiElement)elseBranch);
        this.finishElement((PsiElement)statement);
    }

    private void generateConditionalStatementInstructions(@NotNull PsiElement statement, @Nullable PsiExpression conditionExpression, PsiElement thenBranch, PsiElement elseBranch) {
        Object value2;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(26);
        }
        if (thenBranch == null) {
            this.myStartStatementStack.pushStatement(statement, false);
        } else {
            this.myStartStatementStack.pushStatement(thenBranch, true);
        }
        if (elseBranch == null) {
            this.myEndStatementStack.pushStatement(statement, false);
        } else {
            this.myEndStatementStack.pushStatement(elseBranch, true);
        }
        this.myEndJumpRoles.push((Object)(elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE));
        this.myStartJumpRoles.push((Object)(thenBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.THEN));
        if (conditionExpression != null) {
            conditionExpression.accept((PsiElementVisitor)this);
        }
        boolean thenReachable = true;
        boolean generateConditionalJump = true;
        if (this.myEvaluateConstantIfCondition && (value2 = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)conditionExpression)) instanceof Boolean) {
            thenReachable = (Boolean)value2;
            generateConditionalJump = false;
            this.myCurrentFlow.setConstantConditionOccurred(true);
        }
        if (generateConditionalJump || !thenReachable) {
            BranchingInstruction.Role role = elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE;
            BranchingInstruction instruction = generateConditionalJump ? new ConditionalGoToInstruction(0, role, conditionExpression) : new GoToInstruction(0, role);
            this.myCurrentFlow.addInstruction(instruction);
            if (elseBranch == null) {
                this.addElementOffsetLater(statement, false);
            } else {
                this.addElementOffsetLater(elseBranch, true);
            }
        }
        if (thenBranch != null) {
            thenBranch.accept((PsiElementVisitor)this);
        }
        if (elseBranch != null) {
            GoToInstruction instruction = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement, false);
            elseBranch.accept((PsiElementVisitor)this);
        }
        this.myStartJumpRoles.pop();
        this.myEndJumpRoles.pop();
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement innerStatement = statement.getStatement();
        if (innerStatement != null) {
            innerStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (returnValue != null) {
            this.myStartStatementStack.pushStatement((PsiElement)returnValue, false);
            this.myEndStatementStack.pushStatement((PsiElement)returnValue, false);
            returnValue.accept((PsiElementVisitor)this);
        }
        this.addReturnInstruction((PsiElement)statement);
        if (returnValue != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement((PsiElement)statement);
    }

    private void addReturnInstruction(@NotNull PsiElement statement) {
        PsiElement finallyBlock;
        int finallyStartOffset;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(27);
        }
        int n = finallyStartOffset = (finallyBlock = this.findEnclosingFinallyBlockElement(statement, null)) == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
        if (finallyBlock != null && finallyStartOffset != -1) {
            GoToInstruction instruction = new GoToInstruction(1, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, false);
        } else {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                this.addElementOffsetLater(this.myCodeFragment, false);
            } else {
                instruction.offset = -4;
                this.addElementOffsetLater(((FinallyBlockSubroutine)this.myFinallyBlocks.peek()).getElement(), true);
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression caseValue = statement.getCaseValue();
        if (caseValue != null) {
            this.myStartStatementStack.pushStatement((PsiElement)caseValue, false);
            this.myEndStatementStack.pushStatement((PsiElement)caseValue, false);
            caseValue.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        PsiCodeBlock body2;
        this.startElement((PsiElement)statement);
        PsiExpression expr = statement.getExpression();
        if (expr != null) {
            expr.accept((PsiElementVisitor)this);
        }
        if ((body2 = statement.getBody()) != null) {
            PsiStatement[] statements = body2.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement aStatement : statements) {
                ProgressManager.checkCanceled();
                if (!(aStatement instanceof PsiSwitchLabelStatement)) continue;
                if (((PsiSwitchLabelStatement)aStatement).isDefaultCase()) {
                    defaultLabel = (PsiSwitchLabelStatement)aStatement;
                }
                ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, expr);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater((PsiElement)aStatement, true);
            }
            if (defaultLabel == null) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater((PsiElement)body2, false);
            }
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        PsiCodeBlock body2;
        this.startElement((PsiElement)statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
        }
        if ((body2 = statement.getBody()) != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
        }
        List<PsiElement> blocks = this.findThrowToBlocks(statement);
        this.addThrowInstructions(blocks);
        this.finishElement((PsiElement)statement);
    }

    private void addThrowInstructions(@NotNull List<PsiElement> blocks) {
        if (blocks == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(28);
        }
        if (blocks.isEmpty() || blocks.get(0) == null) {
            ThrowToInstruction instruction = new ThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                PsiElement element = this.myCodeFragment;
                this.addElementOffsetLater(element, false);
            } else {
                instruction.offset = -2;
                PsiElement element = ((FinallyBlockSubroutine)this.myFinallyBlocks.peek()).getElement();
                this.addElementOffsetLater(element, true);
            }
        } else {
            for (int i = 0; i < blocks.size(); ++i) {
                ProgressManager.checkCanceled();
                PsiElement element = blocks.get(i);
                BranchingInstruction instruction = i == blocks.size() - 1 ? new ThrowToInstruction(0) : new ConditionalThrowToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                instruction.offset = -1;
                this.addElementOffsetLater(element, true);
            }
        }
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiThrowStatement statement) {
        PsiExpression exceptionExpr;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(29);
        }
        if ((exceptionExpr = statement.getException()) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(30);
            }
            return list;
        }
        PsiType throwType = exceptionExpr.getType();
        if (!(throwType instanceof PsiClassType)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(31);
            }
            return list;
        }
        List<PsiElement> list = this.findThrowToBlocks((PsiClassType)throwType);
        if (list == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiClassType throwType) {
        if (throwType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(33);
        }
        ArrayList<PsiElement> blocks = new ArrayList<PsiElement>();
        for (int i = this.myCatchParameters.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiParameter parameter2 = (PsiParameter)this.myCatchParameters.get(i);
            PsiType catchType = parameter2.getType();
            if (!ControlFlowUtil.isCaughtExceptionType(throwType, catchType)) continue;
            blocks.add((PsiElement)this.myCatchBlocks.get(i));
        }
        if (blocks.isEmpty()) {
            blocks.add(null);
        }
        ArrayList<PsiElement> arrayList = blocks;
        if (arrayList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        Object conditionValue;
        this.startElement((PsiElement)statement);
        this.myStartStatementStack.pushStatement((PsiElement)statement, false);
        this.myEndStatementStack.pushStatement((PsiElement)statement, false);
        ConditionalGoToInstruction passByWhenAssertionsDisabled = new ConditionalGoToInstruction(0, BranchingInstruction.Role.END, null);
        this.myCurrentFlow.addInstruction(passByWhenAssertionsDisabled);
        this.addElementOffsetLater((PsiElement)statement, false);
        PsiExpression condition2 = statement.getAssertCondition();
        boolean generateCondition = true;
        boolean throwReachable = true;
        if (this.myEvaluateConstantIfCondition && (conditionValue = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)condition2)) instanceof Boolean) {
            throwReachable = (Boolean)conditionValue == false;
            generateCondition = false;
            this.emitEmptyInstruction();
        }
        if (generateCondition) {
            if (condition2 != null) {
                this.myStartStatementStack.pushStatement((PsiElement)statement, false);
                this.myEndStatementStack.pushStatement((PsiElement)statement, false);
                this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
                this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
                condition2.accept((PsiElementVisitor)this);
                this.myStartJumpRoles.pop();
                this.myEndJumpRoles.pop();
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            ConditionalGoToInstruction ifTrue = new ConditionalGoToInstruction(0, BranchingInstruction.Role.END, statement.getAssertCondition());
            this.myCurrentFlow.addInstruction(ifTrue);
            this.addElementOffsetLater((PsiElement)statement, false);
        } else if (!throwReachable) {
            this.myCurrentFlow.addInstruction(new GoToInstruction(0, BranchingInstruction.Role.END));
            this.addElementOffsetLater((PsiElement)statement, false);
        }
        PsiExpression description = statement.getAssertDescription();
        if (description != null) {
            description.accept((PsiElementVisitor)this);
        }
        PsiClassType exceptionClass = JavaPsiFacade.getElementFactory((Project)statement.getProject()).createTypeByFQClassName("java.lang.Throwable", statement.getResolveScope());
        this.addThrowInstructions(this.findThrowToBlocks(exceptionClass));
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement);
    }

    public void visitTryStatement(PsiTryStatement statement) {
        int i;
        PsiCodeBlock tryBlock;
        PsiResourceList resourceList;
        this.startElement((PsiElement)statement);
        PsiCodeBlock[] catchBlocks = statement.getCatchBlocks();
        PsiParameter[] catchBlockParameters = statement.getCatchBlockParameters();
        int catchNum = Math.min(catchBlocks.length, catchBlockParameters.length);
        this.myUnhandledExceptionCatchBlocks.push(null);
        block0: for (int i2 = catchNum - 1; i2 >= 0; --i2) {
            ProgressManager.checkCanceled();
            this.myCatchParameters.push((Object)catchBlockParameters[i2]);
            this.myCatchBlocks.push((Object)catchBlocks[i2]);
            PsiType type2 = catchBlockParameters[i2].getType();
            if (type2 instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)type2)) {
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue;
            }
            if (!(type2 instanceof PsiDisjunctionType)) continue;
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            if (lub instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)lub)) {
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue;
            }
            if (!(lub instanceof PsiIntersectionType)) continue;
            for (PsiType conjunct : ((PsiIntersectionType)lub).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)conjunct)) continue;
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue block0;
            }
        }
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        FinallyBlockSubroutine finallyBlockSubroutine = null;
        if (finallyBlock != null) {
            finallyBlockSubroutine = new FinallyBlockSubroutine((PsiElement)finallyBlock);
            this.myFinallyBlocks.push((Object)finallyBlockSubroutine);
        }
        if ((resourceList = statement.getResourceList()) != null) {
            this.generateCheckedExceptionJumps((PsiElement)resourceList);
            resourceList.accept((PsiElementVisitor)this);
        }
        if ((tryBlock = statement.getTryBlock()) != null) {
            this.generateCheckedExceptionJumps((PsiElement)tryBlock);
            tryBlock.accept((PsiElementVisitor)this);
        }
        while (this.myUnhandledExceptionCatchBlocks.pop() != null) {
        }
        this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
        if (finallyBlock == null) {
            this.addElementOffsetLater((PsiElement)statement, false);
        } else {
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
        }
        for (i = 0; i < catchNum; ++i) {
            this.myCatchParameters.pop();
            this.myCatchBlocks.pop();
        }
        for (i = catchNum - 1; i >= 0; --i) {
            PsiCodeBlock catchBlock;
            ProgressManager.checkCanceled();
            if (this.myPolicy.isParameterAccepted(catchBlockParameters[i])) {
                this.generateWriteInstruction((PsiVariable)catchBlockParameters[i]);
            }
            if ((catchBlock = catchBlocks[i]) != null) {
                catchBlock.accept((PsiElementVisitor)this);
            } else {
                LOG.error("Catch body is null (" + i + ") " + statement.getText());
            }
            this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
            if (finallyBlock == null) {
                this.addElementOffsetLater((PsiElement)statement, false);
                continue;
            }
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
        }
        if (finallyBlock != null) {
            this.myFinallyBlocks.pop();
        }
        if (finallyBlock != null) {
            CallInstruction normalCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(normalCompletion);
            this.myCurrentFlow.addInstruction(normalCompletion);
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            this.myCurrentFlow.addInstruction(new GoToInstruction(0));
            this.addElementOffsetLater((PsiElement)statement, false);
            CallInstruction returnCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(returnCompletion);
            this.myCurrentFlow.addInstruction(returnCompletion);
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            this.addReturnInstruction((PsiElement)statement);
            CallInstruction throwExceptionCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(throwExceptionCompletion);
            this.myCurrentFlow.addInstruction(throwExceptionCompletion);
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            GoToInstruction gotoUncheckedRethrow = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(gotoUncheckedRethrow);
            this.addElementOffsetLater((PsiElement)finallyBlock, false);
            finallyBlock.accept((PsiElementVisitor)this);
            int procStart = this.myCurrentFlow.getStartOffset((PsiElement)finallyBlock);
            int procEnd = this.myCurrentFlow.getEndOffset((PsiElement)finallyBlock);
            for (CallInstruction callInstruction : finallyBlockSubroutine.getCalls()) {
                callInstruction.procBegin = procStart;
                callInstruction.procEnd = procEnd;
            }
            this.myCurrentFlow.addInstruction(new ReturnInstruction(0, this.myStack, normalCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 3, this.myStack, returnCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 1, this.myStack, throwExceptionCompletion));
            List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.remove(finallyBlock);
            for (int i3 = 0; unhandledExceptionCatchBlocks != null && i3 < unhandledExceptionCatchBlocks.size(); ++i3) {
                ProgressManager.checkCanceled();
                PsiElement catchBlock = unhandledExceptionCatchBlocks.get(i3);
                ReturnInstruction returnInstruction = new ReturnInstruction(0, this.myStack, throwExceptionCompletion);
                returnInstruction.setRethrowFromFinally();
                this.myCurrentFlow.addInstruction(returnInstruction);
                if (catchBlock == null) {
                    returnInstruction.offset = procStart - 1;
                    continue;
                }
                --returnInstruction.offset;
                this.addElementOffsetLater(catchBlock, true);
            }
            gotoUncheckedRethrow.offset = this.myCurrentFlow.getSize();
            this.generateUncheckedExceptionJumps((PsiElement)statement, false);
            this.myCurrentFlow.addInstruction(new ThrowToInstruction(0));
            this.addElementOffsetLater(this.myCodeFragment, false);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitResourceList(PsiResourceList resourceList) {
        this.startElement((PsiElement)resourceList);
        for (PsiResourceListElement resource : resourceList) {
            ProgressManager.checkCanceled();
            if (resource instanceof PsiResourceVariable) {
                this.processVariable((PsiVariable)resource);
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)resourceList);
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        Object loopCondition;
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        if (body2 == null) {
            this.myStartStatementStack.pushStatement((PsiElement)statement, false);
        } else {
            this.myStartStatementStack.pushStatement((PsiElement)body2, true);
        }
        this.myEndStatementStack.pushStatement((PsiElement)statement, false);
        PsiExpression condition2 = statement.getCondition();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)statement.getCondition())) instanceof Boolean) {
            boolean value2 = (Boolean)loopCondition;
            if (value2) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater((PsiElement)statement, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)statement, false);
        }
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        int offset = this.myCurrentFlow.getStartOffset((PsiElement)statement);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions2;
        for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
            ProgressManager.checkCanceled();
            this.myStartStatementStack.pushStatement((PsiElement)expression2, false);
            this.myEndStatementStack.pushStatement((PsiElement)expression2, false);
            expression2.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        expression2.getArrayExpression().accept((PsiElementVisitor)this);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        this.startElement((PsiElement)expression2);
        for (PsiExpression initializer : initializers = expression2.getInitializers()) {
            ProgressManager.checkCanceled();
            initializer.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression rExpr = expression2.getRExpression();
        this.myStartStatementStack.pushStatement((PsiElement)(rExpr == null ? expression2 : rExpr), false);
        this.myEndStatementStack.pushStatement((PsiElement)(rExpr == null ? expression2 : rExpr), false);
        PsiExpression lExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLExpression());
        if (lExpr instanceof PsiReferenceExpression) {
            PsiVariable variable = this.getUsedVariable((PsiReferenceExpression)lExpr);
            if (variable != null) {
                PsiExpression qualifier;
                if (this.myAssignmentTargetsAreElements) {
                    this.startElement((PsiElement)lExpr);
                }
                if ((qualifier = ((PsiReferenceExpression)lExpr).getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
                if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
                    this.generateReadInstruction(variable);
                }
                if (rExpr != null) {
                    rExpr.accept((PsiElementVisitor)this);
                }
                this.generateWriteInstruction(variable);
                if (this.myAssignmentTargetsAreElements) {
                    this.finishElement((PsiElement)lExpr);
                }
            } else {
                if (rExpr != null) {
                    rExpr.accept((PsiElementVisitor)this);
                }
                lExpr.accept((PsiElementVisitor)this);
            }
        } else if (lExpr instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)lExpr).getArrayExpression() instanceof PsiReferenceExpression) {
            PsiVariable variable = this.getUsedVariable((PsiReferenceExpression)((PsiArrayAccessExpression)lExpr).getArrayExpression());
            if (variable != null) {
                this.generateReadInstruction(variable);
                PsiExpression indexExpression = ((PsiArrayAccessExpression)lExpr).getIndexExpression();
                if (indexExpression != null) {
                    indexExpression.accept((PsiElementVisitor)this);
                }
            } else {
                lExpr.accept((PsiElementVisitor)this);
            }
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
        } else if (lExpr != null) {
            lExpr.accept((PsiElementVisitor)this);
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)expression2);
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement((PsiElement)expression2);
        IElementType signTokenType = expression2.getOperationTokenType();
        boolean isAndAnd = signTokenType == JavaTokenType.ANDAND;
        boolean isOrOr = signTokenType == JavaTokenType.OROR;
        PsiExpression[] operands2 = expression2.getOperands();
        Boolean lValue = isAndAnd;
        PsiExpression lOperand = null;
        Boolean rValue = null;
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression rOperand = operands2[i];
            if ((isAndAnd || isOrOr) && this.myEnabledShortCircuit) {
                boolean gotoIsAtStart;
                Object exprValue = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)rOperand);
                if (exprValue instanceof Boolean) {
                    this.myCurrentFlow.setConstantConditionOccurred(true);
                    rValue = this.shouldCalculateConstantExpression((PsiExpression)expression2) ? (Boolean)exprValue : null;
                } else {
                    rValue = null;
                }
                BranchingInstruction.Role role = isAndAnd ? (BranchingInstruction.Role)((Object)this.myEndJumpRoles.peek()) : (BranchingInstruction.Role)((Object)this.myStartJumpRoles.peek());
                PsiElement gotoElement = isAndAnd ? this.myEndStatementStack.peekElement() : this.myStartStatementStack.peekElement();
                boolean bl = gotoIsAtStart = isAndAnd ? this.myEndStatementStack.peekAtStart() : this.myStartStatementStack.peekAtStart();
                Shortcut shortcut = lValue != null ? (lValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.SKIP_CURRENT_OPERAND) : (rValue != null && rValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.NO_SHORTCUT);
                switch (shortcut) {
                    case NO_SHORTCUT: {
                        assert (lOperand != null);
                        this.myCurrentFlow.addInstruction(new ConditionalGoToInstruction(0, role, lOperand));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                    case STOP_EXPRESSION: {
                        if (lOperand == null) break;
                        this.myCurrentFlow.addInstruction(new GoToInstruction(0, role));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        rValue = null;
                        break;
                    }
                }
            }
            this.generateLOperand(rOperand, i == operands2.length - 1 ? null : operands2[i + 1], signTokenType);
            lOperand = rOperand;
            lValue = rValue;
        }
        this.finishElement((PsiElement)expression2);
    }

    private void generateLOperand(@NotNull PsiExpression lOperand, @Nullable PsiExpression rOperand, @NotNull IElementType signTokenType) {
        if (lOperand == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(35);
        }
        if (signTokenType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(36);
        }
        if (rOperand != null) {
            this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
            this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
            PsiExpression then = signTokenType == JavaTokenType.OROR ? this.myStartStatementStack.peekElement() : rOperand;
            boolean thenAtStart = signTokenType != JavaTokenType.OROR || this.myStartStatementStack.peekAtStart();
            this.myStartStatementStack.pushStatement((PsiElement)then, thenAtStart);
            PsiExpression elseS = signTokenType == JavaTokenType.ANDAND ? this.myEndStatementStack.peekElement() : rOperand;
            boolean elseAtStart = signTokenType != JavaTokenType.ANDAND || this.myEndStatementStack.peekAtStart();
            this.myEndStatementStack.pushStatement((PsiElement)elseS, elseAtStart);
        }
        lOperand.accept((PsiElementVisitor)this);
        if (rOperand != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
        }
    }

    private static boolean isInsideIfCondition(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(37);
        }
        PsiExpression element = expression2;
        while (element instanceof PsiExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getCondition()) {
                return true;
            }
            element = parent;
        }
        return false;
    }

    private boolean shouldCalculateConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(38);
        }
        return this.myEvaluateConstantIfCondition || !ControlFlowAnalyzer.isInsideIfCondition(expression2);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.visitChildren((PsiElement)expression2);
    }

    private void visitChildren(@NotNull PsiElement element) {
        PsiElement[] children;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(39);
        }
        this.startElement(element);
        for (PsiElement child : children = element.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.finishElement(element);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression condition2 = expression2.getCondition();
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        this.generateConditionalStatementInstructions((PsiElement)expression2, condition2, (PsiElement)thenExpression2, (PsiElement)elseExpression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        operand2.accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)expression2);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiElement body2 = expression2.getBody();
        if (body2 != null) {
            ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
            this.addUsedVariables(array, body2);
            for (PsiVariable var : array) {
                ProgressManager.checkCanceled();
                this.generateReadInstruction(var);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        this.startElement((PsiElement)methodExpression);
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)methodExpression);
        PsiExpressionList argumentList = expression2.getArgumentList();
        argumentList.accept((PsiElementVisitor)this);
        this.emitEmptyInstruction();
        this.generateExceptionJumps((PsiElement)expression2, ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression2, expression2.getParent()));
        this.finishElement((PsiElement)expression2);
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiElement[] children;
        this.startElement((PsiElement)expression2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement child : children = expression2.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.generateExceptionJumps((PsiElement)expression2, ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression2, expression2.getParent()));
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.visitChildren((PsiElement)expression2);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement((PsiElement)expression2);
        IElementType op = expression2.getOperationTokenType();
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            PsiVariable variable;
            operand2.accept((PsiElementVisitor)this);
            if ((op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) && operand2 instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)operand2)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            PsiVariable variable;
            IElementType operationSign = expression2.getOperationTokenType();
            if (operationSign == JavaTokenType.EXCL) {
                PsiElement topStartStatement = this.myStartStatementStack.peekElement();
                boolean topAtStart = this.myStartStatementStack.peekAtStart();
                this.myStartStatementStack.pushStatement(this.myEndStatementStack.peekElement(), this.myEndStatementStack.peekAtStart());
                this.myEndStatementStack.pushStatement(topStartStatement, topAtStart);
            }
            operand2.accept((PsiElementVisitor)this);
            if (operationSign == JavaTokenType.EXCL) {
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            if (operand2 instanceof PsiReferenceExpression && (operationSign == JavaTokenType.PLUSPLUS || operationSign == JavaTokenType.MINUSMINUS) && (variable = this.getUsedVariable((PsiReferenceExpression)operand2)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiVariable variable;
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        }
        if ((variable = this.getUsedVariable(expression2)) != null) {
            this.generateReadInstruction(variable);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitThisExpression(PsiThisExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitClass(PsiClass aClass) {
        PsiElement arguments;
        this.startElement((PsiElement)aClass);
        if (aClass instanceof PsiAnonymousClass && (arguments = PsiTreeUtil.getChildOfType((PsiElement)aClass, PsiExpressionList.class)) != null) {
            arguments.accept((PsiElementVisitor)this);
        }
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        this.addUsedVariables(array, (PsiElement)aClass);
        for (PsiVariable var : array) {
            ProgressManager.checkCanceled();
            this.generateReadInstruction(var);
        }
        this.finishElement((PsiElement)aClass);
    }

    private void addUsedVariables(@NotNull List<PsiVariable> array, @NotNull PsiElement scope) {
        PsiElement[] children;
        PsiVariable variable;
        if (array == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(41);
        }
        if (scope instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)scope)) != null && !array.contains(variable)) {
            array.add(variable);
        }
        for (PsiElement child : children = scope.getChildren()) {
            ProgressManager.checkCanceled();
            this.addUsedVariables(array, child);
        }
    }

    private void generateReadInstruction(@NotNull PsiVariable variable) {
        if (variable == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(42);
        }
        ReadVariableInstruction instruction = new ReadVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    private void generateWriteInstruction(@NotNull PsiVariable variable) {
        if (variable == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(43);
        }
        WriteVariableInstruction instruction = new WriteVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    @Nullable
    private PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(44);
        }
        if (refExpr.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return this.myPolicy.getUsedVariable(refExpr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowAnalyzer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandledException";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwingElement";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToJumpTo";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOperand";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signTokenType";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowAnalyzer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildControlFlow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIntArray";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findThrowToBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "poolIntArray";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addElementOffsetLater";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchInstructionOffsets";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateUncheckedExceptionJumpsIfNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "finishElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateUncheckedExceptionJumps";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateCheckedExceptionJumps";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateExceptionJumps";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateThrow";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "patchCheckedThrowInstructionIfInsideFinally";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "patchUncheckedThrowInstructionIfInsideFinally";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerSubRange";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingFinallyBlockElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generateConditionalStatementInstructions";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addReturnInstruction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addThrowInstructions";
                break;
            }
            case 29: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findThrowToBlocks";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateLOperand";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isInsideIfCondition";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldCalculateConstantExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitChildren";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addUsedVariables";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateReadInstruction";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateWriteInstruction";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FinallyBlockSubroutine {
        private final PsiElement myElement;
        private final List<CallInstruction> myCalls;

        public FinallyBlockSubroutine(@NotNull PsiElement element) {
            if (element == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myCalls = new ArrayList<CallInstruction>();
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @NotNull
        public List<CallInstruction> getCalls() {
            List<CallInstruction> list = this.myCalls;
            if (list == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(2);
            }
            return list;
        }

        private void addCall(@NotNull CallInstruction callInstruction) {
            if (callInstruction == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(3);
            }
            this.myCalls.add(callInstruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callInstruction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCalls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addCall";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum Shortcut {
        NO_SHORTCUT,
        SKIP_CURRENT_OPERAND,
        STOP_EXPRESSION;

    }

    private static class StatementStack {
        private final Stack<PsiElement> myStatements = new Stack();
        private final TIntArrayList myAtStart = new TIntArrayList();

        private StatementStack() {
        }

        private void popStatement() {
            this.myAtStart.remove(this.myAtStart.size() - 1);
            this.myStatements.pop();
        }

        @NotNull
        private PsiElement peekElement() {
            PsiElement psiElement = (PsiElement)this.myStatements.peek();
            if (psiElement == null) {
                StatementStack.$$$reportNull$$$0(0);
            }
            return psiElement;
        }

        private boolean peekAtStart() {
            return this.myAtStart.get(this.myAtStart.size() - 1) == 1;
        }

        private void pushStatement(@NotNull PsiElement statement, boolean atStart) {
            if (statement == null) {
                StatementStack.$$$reportNull$$$0(1);
            }
            this.myStatements.push((Object)statement);
            this.myAtStart.add(atStart ? 1 : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "peekElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "pushStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

