/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.FieldDependenciesManager;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementOverriddenMethodsInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementPropertyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrangementParseInfo {
    private final List<JavaElementArrangementEntry> myEntries = new ArrayList<JavaElementArrangementEntry>();
    private final Map<Pair<String, String>, JavaArrangementPropertyInfo> myProperties = new HashMap<Pair<String, String>, JavaArrangementPropertyInfo>();
    private final List<ArrangementEntryDependencyInfo> myMethodDependencyRoots = new ArrayList<ArrangementEntryDependencyInfo>();
    private final Map<PsiMethod, Set<PsiMethod>> myMethodDependencies = new HashMap<PsiMethod, Set<PsiMethod>>();
    private final Map<PsiMethod, JavaElementArrangementEntry> myMethodEntriesMap = new HashMap<PsiMethod, JavaElementArrangementEntry>();
    private final Map<PsiClass, List<Pair<PsiMethod, PsiMethod>>> myOverriddenMethods = new LinkedHashMap<PsiClass, List<Pair<PsiMethod, PsiMethod>>>();
    private final Set<PsiMethod> myTmpMethodDependencyRoots = new LinkedHashSet<PsiMethod>();
    private final Set<PsiMethod> myDependentMethods = new HashSet<PsiMethod>();
    private boolean myRebuildMethodDependencies;
    private final HashMap<PsiField, JavaElementArrangementEntry> myFields = ContainerUtil.newLinkedHashMap();
    private final Map<PsiField, Set<PsiField>> myFieldDependencies = ContainerUtil.newHashMap();

    @NotNull
    public List<JavaElementArrangementEntry> getEntries() {
        List<JavaElementArrangementEntry> list = this.myEntries;
        if (list == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void addEntry(@NotNull JavaElementArrangementEntry entry) {
        if (entry == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(1);
        }
        this.myEntries.add(entry);
    }

    @NotNull
    public Collection<JavaArrangementPropertyInfo> getProperties() {
        Collection<JavaArrangementPropertyInfo> collection = this.myProperties.values();
        if (collection == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getMethodDependencyRoots() {
        if (this.myRebuildMethodDependencies) {
            this.myMethodDependencyRoots.clear();
            HashMap<PsiMethod, ArrangementEntryDependencyInfo> cache = new HashMap<PsiMethod, ArrangementEntryDependencyInfo>();
            for (PsiMethod method : this.myTmpMethodDependencyRoots) {
                ArrangementEntryDependencyInfo info = this.buildMethodDependencyInfo(method, cache);
                if (info == null) continue;
                this.myMethodDependencyRoots.add(info);
            }
            this.myRebuildMethodDependencies = false;
        }
        List<ArrangementEntryDependencyInfo> list = this.myMethodDependencyRoots;
        if (list == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private ArrangementEntryDependencyInfo buildMethodDependencyInfo(@NotNull PsiMethod method, @NotNull Map<PsiMethod, ArrangementEntryDependencyInfo> cache) {
        JavaElementArrangementEntry entry;
        if (method == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(4);
        }
        if (cache == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(5);
        }
        if ((entry = this.myMethodEntriesMap.get(method)) == null) {
            return null;
        }
        ArrangementEntryDependencyInfo result = new ArrangementEntryDependencyInfo(entry);
        Stack toProcess = new Stack();
        toProcess.push((Object)Pair.create((Object)method, (Object)result));
        HashSet usedMethods = ContainerUtilRt.newHashSet();
        while (!toProcess.isEmpty()) {
            Pair pair = (Pair)toProcess.pop();
            Set<PsiMethod> dependentMethods = this.myMethodDependencies.get(pair.first);
            if (dependentMethods == null) continue;
            usedMethods.add(pair.first);
            for (PsiMethod dependentMethod : dependentMethods) {
                if (usedMethods.contains(dependentMethod)) {
                    return null;
                }
                JavaElementArrangementEntry dependentEntry = this.myMethodEntriesMap.get(dependentMethod);
                if (dependentEntry == null) continue;
                ArrangementEntryDependencyInfo dependentMethodInfo = cache.get(dependentMethod);
                if (dependentMethodInfo == null) {
                    dependentMethodInfo = new ArrangementEntryDependencyInfo(dependentEntry);
                    cache.put(dependentMethod, dependentMethodInfo);
                }
                Pair dependentPair = Pair.create((Object)dependentMethod, (Object)dependentMethodInfo);
                ((ArrangementEntryDependencyInfo)pair.second).addDependentEntryInfo((ArrangementEntryDependencyInfo)dependentPair.second);
                toProcess.push((Object)dependentPair);
            }
        }
        return result;
    }

    public void registerGetter(@NotNull String propertyName, @NotNull String className, @NotNull JavaElementArrangementEntry entry) {
        if (propertyName == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(6);
        }
        if (className == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(7);
        }
        if (entry == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(8);
        }
        this.getPropertyInfo(propertyName, className).setGetter(entry);
    }

    public void registerSetter(@NotNull String propertyName, @NotNull String className, @NotNull JavaElementArrangementEntry entry) {
        if (propertyName == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(9);
        }
        if (className == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(10);
        }
        if (entry == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(11);
        }
        this.getPropertyInfo(propertyName, className).setSetter(entry);
    }

    @NotNull
    private JavaArrangementPropertyInfo getPropertyInfo(@NotNull String propertyName, @NotNull String className) {
        Pair key2;
        JavaArrangementPropertyInfo propertyInfo;
        if (propertyName == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(12);
        }
        if (className == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(13);
        }
        if ((propertyInfo = this.myProperties.get(key2 = Pair.create((Object)propertyName, (Object)className))) == null) {
            propertyInfo = new JavaArrangementPropertyInfo();
            this.myProperties.put((Pair<String, String>)key2, propertyInfo);
        }
        JavaArrangementPropertyInfo javaArrangementPropertyInfo = propertyInfo;
        if (javaArrangementPropertyInfo == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(14);
        }
        return javaArrangementPropertyInfo;
    }

    public void onMethodEntryCreated(@NotNull PsiMethod method, @NotNull JavaElementArrangementEntry entry) {
        if (method == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(15);
        }
        if (entry == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(16);
        }
        this.myMethodEntriesMap.put(method, entry);
    }

    public void onFieldEntryCreated(@NotNull PsiField field, @NotNull JavaElementArrangementEntry entry) {
        if (field == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(17);
        }
        if (entry == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(18);
        }
        this.myFields.put(field, entry);
    }

    public void onOverriddenMethod(@NotNull PsiMethod baseMethod, @NotNull PsiMethod overridingMethod) {
        PsiClass clazz;
        if (baseMethod == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(19);
        }
        if (overridingMethod == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(20);
        }
        if ((clazz = baseMethod.getContainingClass()) == null) {
            return;
        }
        List<Pair<PsiMethod, PsiMethod>> methods = this.myOverriddenMethods.get(clazz);
        if (methods == null) {
            methods = new ArrayList<Pair<PsiMethod, PsiMethod>>();
            this.myOverriddenMethods.put(clazz, methods);
        }
        methods.add((Pair<PsiMethod, PsiMethod>)Pair.create((Object)baseMethod, (Object)overridingMethod));
    }

    @NotNull
    public List<JavaArrangementOverriddenMethodsInfo> getOverriddenMethods() {
        ArrayList<JavaArrangementOverriddenMethodsInfo> result = new ArrayList<JavaArrangementOverriddenMethodsInfo>();
        TObjectIntHashMap weights = new TObjectIntHashMap();
        Comparator comparator = (o1, o2) -> weights.get(o1.first) - weights.get(o2.first);
        for (Map.Entry<PsiClass, List<Pair<PsiMethod, PsiMethod>>> entry : this.myOverriddenMethods.entrySet()) {
            JavaArrangementOverriddenMethodsInfo info = new JavaArrangementOverriddenMethodsInfo(entry.getKey().getName());
            weights.clear();
            int i = 0;
            for (PsiMethod method : entry.getKey().getMethods()) {
                weights.put((Object)method, i++);
            }
            ContainerUtil.sort(entry.getValue(), (Comparator)comparator);
            for (Pair pair : entry.getValue()) {
                JavaElementArrangementEntry overridingMethodEntry = this.myMethodEntriesMap.get(pair.second);
                if (overridingMethodEntry == null) continue;
                info.addMethodEntry(overridingMethodEntry);
            }
            if (info.getMethodEntries().isEmpty()) continue;
            result.add(info);
        }
        ArrayList<JavaArrangementOverriddenMethodsInfo> arrayList = result;
        if (arrayList == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    public void registerMethodCallDependency(@NotNull PsiMethod caller, @NotNull PsiMethod callee) {
        if (caller == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(22);
        }
        if (callee == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(23);
        }
        this.myTmpMethodDependencyRoots.remove(callee);
        if (!this.myDependentMethods.contains(caller)) {
            this.myTmpMethodDependencyRoots.add(caller);
        }
        this.myDependentMethods.add(callee);
        Set<PsiMethod> methods = this.myMethodDependencies.get(caller);
        if (methods == null) {
            methods = new LinkedHashSet<PsiMethod>();
            this.myMethodDependencies.put(caller, methods);
        }
        if (!methods.contains(callee)) {
            methods.add(callee);
        }
        this.myRebuildMethodDependencies = true;
    }

    public void registerFieldInitializationDependency(@NotNull PsiField fieldToInitialize, @NotNull PsiField usedInInitialization) {
        HashSet fields;
        if (fieldToInitialize == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(24);
        }
        if (usedInInitialization == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(25);
        }
        if ((fields = this.myFieldDependencies.get(fieldToInitialize)) == null) {
            fields = ContainerUtil.newHashSet();
            this.myFieldDependencies.put(fieldToInitialize, fields);
        }
        fields.add(usedInInitialization);
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getFieldDependencyRoots() {
        List<ArrangementEntryDependencyInfo> list = new FieldDependenciesManager(this.myFieldDependencies, this.myFields).getRoots();
        if (list == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public Collection<JavaElementArrangementEntry> getFields() {
        Collection<JavaElementArrangementEntry> collection = this.myFields.values();
        if (collection == null) {
            JavaArrangementParseInfo.$$$reportNull$$$0(27);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overridingMethod";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caller";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldToInitialize";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedInInitialization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDependencyRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenMethods";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDependencyRoots";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addEntry";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildMethodDependencyInfo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerGetter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerSetter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onMethodEntryCreated";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onFieldEntryCreated";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onOverriddenMethod";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodCallDependency";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerFieldInitializationDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

