/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.LibraryNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageNode;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    public static final String SCANNING_PACKAGES_MESSAGE = AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]);
    private final ProjectFileIndex myFileIndex;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.packageDependencies.ui.TreeModelBuilder");
    private final boolean myShowModuleGroups;
    protected final JavaPsiFacade myJavaPsiFacade;
    private static final Key<Integer> FILE_COUNT = Key.create((String)"packages.FILE_COUNT");
    private final boolean myShowModules;
    private final boolean myGroupByScopeType;
    private final boolean myFlattenPackages;
    private boolean myShowFiles;
    private final boolean myShowIndividualLibs;
    private final Marker myMarker;
    private final boolean myAddUnmarkedFiles;
    private final PackageDependenciesNode myRoot;
    private final Map<ScopeType, Map<Pair<Module, PsiPackage>, PackageNode>> myModulePackageNodes;
    private final Map<ScopeType, Map<Pair<OrderEntry, PsiPackage>, PackageNode>> myLibraryPackageNodes;
    private final Map<ScopeType, Map<Module, ModuleNode>> myModuleNodes;
    private final Map<ScopeType, Map<String, ModuleGroupNode>> myModuleGroupNodes;
    private final Map<ScopeType, Map<OrderEntry, LibraryNode>> myLibraryNodes;
    private final ModuleGrouper myModuleGrouper;
    private int myScannedFileCount;
    private int myTotalFileCount;
    private int myMarkedFileCount;
    private GeneralGroupNode myAllLibsNode;
    private GeneralGroupNode mySourceRoot;
    private GeneralGroupNode myTestRoot;
    private GeneralGroupNode myLibsRoot;
    public static final String PRODUCTION_NAME = AnalysisScopeBundle.message((String)"package.dependencies.production.node.text", (Object[])new Object[0]);
    public static final String TEST_NAME = AnalysisScopeBundle.message((String)"package.dependencies.test.node.text", (Object[])new Object[0]);
    public static final String LIBRARY_NAME = AnalysisScopeBundle.message((String)"package.dependencies.library.node.text", (Object[])new Object[0]);

    public TreeModelBuilder(@NotNull Project project, boolean showIndividualLibs, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(0);
        }
        this.myModulePackageNodes = new HashMap<ScopeType, Map<Pair<Module, PsiPackage>, PackageNode>>();
        this.myLibraryPackageNodes = new HashMap<ScopeType, Map<Pair<OrderEntry, PsiPackage>, PackageNode>>();
        this.myModuleNodes = new HashMap<ScopeType, Map<Module, ModuleNode>>();
        this.myModuleGroupNodes = new HashMap<ScopeType, Map<String, ModuleGroupNode>>();
        this.myLibraryNodes = new HashMap<ScopeType, Map<OrderEntry, LibraryNode>>();
        this.myProject = project;
        boolean multiModuleProject = ModuleManager.getInstance((Project)project).getModules().length > 1;
        this.myShowModules = settings.UI_SHOW_MODULES && multiModuleProject;
        this.myGroupByScopeType = settings.UI_GROUP_BY_SCOPE_TYPE;
        this.myFlattenPackages = settings.UI_FLATTEN_PACKAGES;
        this.myShowFiles = settings.UI_SHOW_FILES;
        this.myShowIndividualLibs = showIndividualLibs;
        this.myShowModuleGroups = settings.UI_SHOW_MODULE_GROUPS && multiModuleProject;
        this.myModuleGrouper = ModuleGrouper.instanceFor((Project)project);
        this.myMarker = marker;
        this.myAddUnmarkedFiles = !settings.UI_FILTER_LEGALS;
        this.myRoot = new RootNode(project);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.createMaps(ScopeType.LIB);
        this.createMaps(ScopeType.SOURCE);
        this.createMaps(ScopeType.TEST);
        if (this.myGroupByScopeType) {
            this.mySourceRoot = new GeneralGroupNode(PRODUCTION_NAME, AllIcons.Modules.SourceFolder, project);
            this.myTestRoot = new GeneralGroupNode(TEST_NAME, AllIcons.Modules.TestSourceFolder, project);
            this.myLibsRoot = new GeneralGroupNode(LIBRARY_NAME, AllIcons.Nodes.PpLibFolder, project);
            this.myRoot.add((MutableTreeNode)this.mySourceRoot);
            this.myRoot.add((MutableTreeNode)this.myTestRoot);
            this.myRoot.add((MutableTreeNode)this.myLibsRoot);
        }
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
    }

    private void createMaps(ScopeType scopeType) {
        this.myModulePackageNodes.put(scopeType, new HashMap());
        this.myLibraryPackageNodes.put(scopeType, new HashMap());
        this.myModuleGroupNodes.put(scopeType, new HashMap());
        this.myModuleNodes.put(scopeType, new HashMap());
        this.myLibraryNodes.put(scopeType, new HashMap());
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Set<PsiFile> files, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new TreeModelBuilder(project, true, marker, settings).build(files, showProgress);
    }

    public static synchronized TreeModel createTreeModel(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new TreeModelBuilder(project, true, marker, settings).build(project);
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showIndividualLibs, Marker marker) {
        return new TreeModelBuilder(project, showIndividualLibs, marker, new DependenciesPanel.DependencyPanelSettings()).build(project);
    }

    private void countFiles(Project project) {
        Integer fileCount = (Integer)project.getUserData(FILE_COUNT);
        if (fileCount == null) {
            this.myFileIndex.iterateContent(fileOrDir -> {
                if (!fileOrDir.isDirectory()) {
                    this.counting();
                }
                return true;
            });
            for (VirtualFile root : LibraryUtil.getLibraryRoots((Project)project)) {
                this.countFilesRecursively(root);
            }
            project.putUserData(FILE_COUNT, (Object)this.myTotalFileCount);
        } else {
            this.myTotalFileCount = fileCount;
        }
    }

    public static void clearCaches(Project project) {
        project.putUserData(FILE_COUNT, null);
    }

    public TreeModel build(Project project) {
        Runnable buildingRunnable = () -> {
            this.countFiles(project);
            this.myFileIndex.iterateContent(new ContentIterator(){
                PackageDependenciesNode lastParent;
                VirtualFile dir;

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory()) {
                        if (this.lastParent != null && !Comparing.equal((Object)this.dir, (Object)fileOrDir.getParent())) {
                            this.lastParent = null;
                        }
                        this.lastParent = TreeModelBuilder.this.buildFileNode(fileOrDir, this.lastParent);
                        this.dir = fileOrDir.getParent();
                    } else {
                        this.lastParent = null;
                    }
                    return true;
                }
            });
            for (VirtualFile root : LibraryUtil.getLibraryRoots((Project)project)) {
                this.processFilesRecursively(root);
            }
        };
        buildingRunnable.run();
        return new TreeModel((TreeNode)this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private void processFilesRecursively(@NotNull VirtualFile file) {
        if (file == null) {
            TreeModelBuilder.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private PackageDependenciesNode parent;

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.parent = file.isDirectory() ? null : TreeModelBuilder.this.buildFileNode(file, this.parent);
                return true;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file.isDirectory()) {
                    this.parent = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/packageDependencies/ui/TreeModelBuilder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterChildrenVisited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void countFilesRecursively(VirtualFile file) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory()) {
                    TreeModelBuilder.this.counting();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/TreeModelBuilder$3", "visitFile"));
            }
        });
    }

    private void counting() {
        ++this.myTotalFileCount;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ((PanelProgressIndicator)indicator).update(SCANNING_PACKAGES_MESSAGE, true, 0.0);
        }
    }

    private TreeModel build(Set<PsiFile> files, boolean showProgress) {
        if (files.size() == 1) {
            this.myShowFiles = true;
        }
        Runnable buildingRunnable = () -> {
            for (PsiFile file : files) {
                if (file == null) continue;
                this.buildFileNode(file.getVirtualFile(), null);
            }
        };
        if (showProgress) {
            String title = AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, title, false, this.myProject);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator());
        return new TreeModel((TreeNode)this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    @Nullable
    private PackageDependenciesNode buildFileNode(VirtualFile file, @Nullable PackageDependenciesNode parent) {
        boolean isMarked;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ((PanelProgressIndicator)indicator).update(SCANNING_PACKAGES_MESSAGE, false, (double)this.myScannedFileCount++ / (double)this.myTotalFileCount);
        }
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file);
        if (isMarked) {
            ++this.myMarkedFileCount;
        }
        if (isMarked || this.myAddUnmarkedFiles) {
            PackageDependenciesNode dirNode;
            PackageDependenciesNode packageDependenciesNode = dirNode = parent != null ? parent : this.getFileParentNode(file);
            if (dirNode == null) {
                return null;
            }
            if (this.myShowFiles) {
                FileNode fileNode = new FileNode(file, this.myProject, isMarked);
                dirNode.add((MutableTreeNode)fileNode);
            } else {
                dirNode.addFile(file, isMarked);
            }
            return dirNode;
        }
        return null;
    }

    @Nullable
    public PackageDependenciesNode getFileParentNode(VirtualFile vFile) {
        LOG.assertTrue(vFile != null);
        VirtualFile containingDirectory = vFile.getParent();
        LOG.assertTrue(containingDirectory != null);
        PsiPackage aPackage = null;
        String packageName = this.myFileIndex.getPackageNameByDirectory(containingDirectory);
        if (packageName != null) {
            aPackage = this.myJavaPsiFacade.findPackage(packageName);
        }
        if (aPackage != null) {
            if (this.myFileIndex.isInLibrarySource(vFile) || this.myFileIndex.isInLibraryClasses(vFile)) {
                return this.getLibraryDirNode(aPackage, this.getLibraryForFile(vFile));
            }
            return this.getModuleDirNode(aPackage, this.myFileIndex.getModuleForFile(vFile), this.getFileScopeType(vFile));
        }
        return this.myFileIndex.isInLibrarySource(vFile) ? null : this.getModuleNode(this.myFileIndex.getModuleForFile(vFile), this.getFileScopeType(vFile));
    }

    private ScopeType getFileScopeType(VirtualFile file) {
        if (this.myFileIndex.isLibraryClassFile(file) || this.myFileIndex.isInLibrarySource(file)) {
            return ScopeType.LIB;
        }
        if (this.myFileIndex.isInTestSourceContent(file)) {
            return ScopeType.TEST;
        }
        return ScopeType.SOURCE;
    }

    @Nullable
    private OrderEntry getLibraryForFile(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        List orders = this.myFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry order : orders) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            return order;
        }
        return null;
    }

    private <T> T getMap(Map<ScopeType, T> map, ScopeType scopeType) {
        return map.get((Object)(this.myGroupByScopeType ? scopeType : ScopeType.SOURCE));
    }

    private PackageDependenciesNode getLibraryDirNode(PsiPackage aPackage, OrderEntry libraryOrJdk) {
        if (aPackage == null || aPackage.getName() == null) {
            return this.getLibraryOrJDKNode(libraryOrJdk);
        }
        if (!this.myShowModules && !this.myGroupByScopeType) {
            return this.getModuleDirNode(aPackage, null, ScopeType.LIB);
        }
        Pair descriptor = Pair.create((Object)(this.myShowIndividualLibs ? libraryOrJdk : null), (Object)aPackage);
        PackageNode node = this.getMap(this.myLibraryPackageNodes, ScopeType.LIB).get(descriptor);
        if (node != null) {
            return node;
        }
        node = new PackageNode(aPackage, this.myFlattenPackages);
        this.getMap(this.myLibraryPackageNodes, ScopeType.LIB).put((Pair<OrderEntry, PsiPackage>)descriptor, node);
        if (this.myFlattenPackages) {
            this.getLibraryOrJDKNode(libraryOrJdk).add((MutableTreeNode)((Object)node));
        } else {
            this.getLibraryDirNode(aPackage.getParentPackage(), libraryOrJdk).add((MutableTreeNode)((Object)node));
        }
        return node;
    }

    private PackageDependenciesNode getModuleDirNode(PsiPackage aPackage, Module module, ScopeType scopeType) {
        if (aPackage == null) {
            return this.getModuleNode(module, scopeType);
        }
        Pair descriptor = Pair.create((Object)(this.myShowModules ? module : null), (Object)aPackage);
        PackageNode node = this.getMap(this.myModulePackageNodes, scopeType).get(descriptor);
        if (node != null) {
            return node;
        }
        node = new PackageNode(aPackage, this.myFlattenPackages);
        this.getMap(this.myModulePackageNodes, scopeType).put((Pair<Module, PsiPackage>)descriptor, node);
        if (this.myFlattenPackages) {
            this.getModuleNode(module, scopeType).add((MutableTreeNode)((Object)node));
        } else {
            this.getModuleDirNode(aPackage.getParentPackage(), module, scopeType).add((MutableTreeNode)((Object)node));
        }
        return node;
    }

    @Nullable
    private PackageDependenciesNode getModuleNode(Module module, ScopeType scopeType) {
        if (module == null || !this.myShowModules) {
            return this.getRootNode(scopeType);
        }
        ModuleNode node = this.getMap(this.myModuleNodes, scopeType).get(module);
        if (node != null) {
            return node;
        }
        node = new ModuleNode(module, this.myShowModuleGroups ? this.myModuleGrouper : null);
        List groupPath = this.myModuleGrouper.getGroupPath(module);
        if (groupPath.isEmpty()) {
            this.getMap(this.myModuleNodes, scopeType).put(module, node);
            this.getRootNode(scopeType).add((MutableTreeNode)node);
            return node;
        }
        this.getMap(this.myModuleNodes, scopeType).put(module, node);
        if (this.myShowModuleGroups) {
            this.getParentModuleGroup(groupPath, scopeType).add((MutableTreeNode)node);
        } else {
            this.getRootNode(scopeType).add((MutableTreeNode)node);
        }
        return node;
    }

    private PackageDependenciesNode getParentModuleGroup(List<String> groupPath, ScopeType scopeType) {
        String key2 = StringUtil.join(groupPath, (String)",");
        ModuleGroupNode groupNode = this.getMap(this.myModuleGroupNodes, scopeType).get(key2);
        if (groupNode == null) {
            groupNode = new ModuleGroupNode(new ModuleGroup(groupPath), this.myProject);
            this.getMap(this.myModuleGroupNodes, scopeType).put(key2, groupNode);
            this.getRootNode(scopeType).add((MutableTreeNode)groupNode);
        }
        if (groupPath.size() > 1) {
            PackageDependenciesNode node = this.getParentModuleGroup(groupPath.subList(0, groupPath.size() - 1), scopeType);
            node.add((MutableTreeNode)groupNode);
        }
        return groupNode;
    }

    private PackageDependenciesNode getLibraryOrJDKNode(OrderEntry libraryOrJdk) {
        if (libraryOrJdk == null || !this.myShowModules) {
            return this.getRootNode(ScopeType.LIB);
        }
        if (!this.myShowIndividualLibs) {
            if (this.myGroupByScopeType) {
                return this.getRootNode(ScopeType.LIB);
            }
            if (this.myAllLibsNode == null) {
                this.myAllLibsNode = new GeneralGroupNode(AnalysisScopeBundle.message((String)"dependencies.libraries.node.text", (Object[])new Object[0]), AllIcons.Nodes.PpLibFolder, this.myProject);
                this.getRootNode(ScopeType.LIB).add((MutableTreeNode)this.myAllLibsNode);
            }
            return this.myAllLibsNode;
        }
        LibraryNode node = this.getMap(this.myLibraryNodes, ScopeType.LIB).get(libraryOrJdk);
        if (node != null) {
            return node;
        }
        node = new LibraryNode(libraryOrJdk, this.myProject);
        this.getMap(this.myLibraryNodes, ScopeType.LIB).put(libraryOrJdk, node);
        this.getRootNode(ScopeType.LIB).add((MutableTreeNode)((Object)node));
        return node;
    }

    @NotNull
    private PackageDependenciesNode getRootNode(ScopeType scopeType) {
        if (!this.myGroupByScopeType) {
            PackageDependenciesNode packageDependenciesNode = this.myRoot;
            if (packageDependenciesNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(2);
            }
            return packageDependenciesNode;
        }
        if (scopeType == ScopeType.TEST) {
            GeneralGroupNode generalGroupNode = this.myTestRoot;
            if (generalGroupNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(3);
            }
            return generalGroupNode;
        }
        if (scopeType == ScopeType.SOURCE) {
            GeneralGroupNode generalGroupNode = this.mySourceRoot;
            if (generalGroupNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(4);
            }
            return generalGroupNode;
        }
        GeneralGroupNode generalGroupNode = this.myLibsRoot;
        if (generalGroupNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(5);
        }
        return generalGroupNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/ui/TreeModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/ui/TreeModelBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ScopeType {
        TEST,
        SOURCE,
        LIB;

    }
}

