/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class JrtHandler
extends ArchiveHandler {
    private static final URI ROOT_URI = URI.create("jrt:/");
    private SoftReference<FileSystem> myFileSystem;

    public JrtHandler(@NotNull String path) {
        if (path == null) {
            JrtHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        JrtHandler jrtHandler = this;
        synchronized (jrtHandler) {
            FileSystem fs = (FileSystem)SoftReference.dereference(this.myFileSystem);
            if (fs != null) {
                this.myFileSystem = null;
                try {
                    fs.close();
                    ClassLoader loader = fs.getClass().getClassLoader();
                    if (loader instanceof MyClassLoader) {
                        ((MyClassLoader)loader).close();
                    }
                }
                catch (IOException e) {
                    Logger.getInstance(JrtHandler.class).info((Throwable)e);
                }
            }
        }
    }

    private synchronized FileSystem getFileSystem() throws IOException {
        FileSystem fs = (FileSystem)SoftReference.dereference(this.myFileSystem);
        if (fs == null) {
            String path = this.getFile().getPath();
            try {
                if (SystemInfo.IS_AT_LEAST_JAVA9) {
                    fs = FileSystems.newFileSystem(ROOT_URI, Collections.singletonMap("java.home", path));
                } else {
                    File file = new File(path, "lib/jrt-fs.jar");
                    if (!file.exists()) {
                        throw new IOException("Missing provider: " + file);
                    }
                    fs = FileSystems.newFileSystem(ROOT_URI, Collections.emptyMap(), (ClassLoader)new MyClassLoader(file));
                }
                this.myFileSystem = new SoftReference((Object)fs);
            }
            catch (Error | RuntimeException e) {
                throw new IOException("Error mounting JRT filesystem at " + path, e);
            }
        }
        return fs;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        final HashMap map = ContainerUtil.newHashMap();
        map.put("", this.createRootEntry());
        Path root = this.getFileSystem().getPath("/modules", new String[0]);
        if (!Files.exists(root, new LinkOption[0])) {
            throw new FileNotFoundException("JRT root missing");
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.process(dir, attrs);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                this.process(file, attrs);
                return FileVisitResult.CONTINUE;
            }

            private void process(Path entry, BasicFileAttributes attrs) throws IOException {
                Path relativePath;
                String path;
                int pathLength = entry.getNameCount();
                if (pathLength > 1 && !map.containsKey(path = (relativePath = entry.subpath(1, pathLength)).toString())) {
                    ArchiveHandler.EntryInfo parent = (ArchiveHandler.EntryInfo)map.get(pathLength > 2 ? relativePath.getParent().toString() : "");
                    if (parent == null) {
                        throw new IOException("Out of order: " + entry);
                    }
                    String shortName = entry.getFileName().toString();
                    long modified = attrs.lastModifiedTime().toMillis();
                    map.put(path, new ArchiveHandler.EntryInfo((CharSequence)shortName, attrs.isDirectory(), attrs.size(), modified, parent));
                }
            }
        });
        HashMap hashMap = map;
        if (hashMap == null) {
            JrtHandler.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        ArchiveHandler.EntryInfo entry;
        if (relativePath == null) {
            JrtHandler.$$$reportNull$$$0(2);
        }
        if ((entry = this.getEntryInfo(relativePath)) == null) {
            throw new FileNotFoundException(this.getFile() + " : " + relativePath);
        }
        Path path = this.getFileSystem().getPath("/modules/" + relativePath, new String[0]);
        byte[] byArray = Files.readAllBytes(path);
        if (byArray == null) {
            JrtHandler.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jrt/JrtHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jrt/JrtHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyClassLoader
    extends URLClassLoader {
        private MyClassLoader(File file) throws MalformedURLException {
            super(new URL[]{file.toURI().toURL()}, (ClassLoader)null);
        }
    }
}

