/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;

public class DefaultJdkConfigurator
implements ApplicationComponent {
    private final JavaSdk myJavaSdk;
    private final PropertiesComponent myPropertiesComponent;
    private final ProjectJdkTable myProjectJdkTable;

    public DefaultJdkConfigurator(JavaSdk javaSdk, PropertiesComponent propertiesComponent, ProjectJdkTable projectJdkTable) {
        this.myJavaSdk = javaSdk;
        this.myPropertiesComponent = propertiesComponent;
        this.myProjectJdkTable = projectJdkTable;
    }

    public void initComponent() {
        if (this.myPropertiesComponent.getBoolean("defaultJdkConfigured", false)) {
            return;
        }
        List jdks = this.myProjectJdkTable.getSdksOfType((SdkTypeId)this.myJavaSdk);
        if (jdks.isEmpty()) {
            String suggestedName;
            Collection homePaths = this.myJavaSdk.suggestHomePaths();
            if (homePaths.isEmpty()) {
                return;
            }
            String homePath = (String)ContainerUtil.find((Iterable)homePaths, path -> DefaultJdkConfigurator.isLTS(path));
            if (homePath == null) {
                homePath = (String)homePaths.iterator().next();
            }
            if (homePath != null && this.myJavaSdk.isValidSdkHome(homePath) && (suggestedName = this.myJavaSdk.suggestSdkName(null, homePath)) != null) {
                String finalHomePath = homePath;
                ApplicationManager.getApplication().runWriteAction(() -> this.myProjectJdkTable.addJdk(this.myJavaSdk.createJdk(suggestedName, finalHomePath, false)));
            }
        }
        this.myPropertiesComponent.setValue("defaultJdkConfigured", true);
    }

    private static boolean isLTS(String path) {
        JavaSdkVersion version = JavaSdkVersion.fromVersionString((String)path);
        return version != null && version.isLongTermSupport();
    }
}

