/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFormattingModelBuilder
implements FormattingModelBuilderEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.java.JavaFormattingModelBuilder");

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode formattingMode) {
        FileElement fileElement;
        if (element == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((fileElement = TreeUtil.getFileElement((TreeElement)((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)element)))) != null, (Object)("File element should not be null for " + element));
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        JavaCodeStyleSettings customJavaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        Block block = AbstractJavaBlock.newJavaBlock((ASTNode)fileElement, commonSettings, customJavaSettings, formattingMode);
        FormattingDocumentModelImpl model = FormattingDocumentModelImpl.createOn((PsiFile)element.getContainingFile());
        PsiBasedFormatterModelWithShiftIndentInside psiBasedFormatterModelWithShiftIndentInside = new PsiBasedFormatterModelWithShiftIndentInside(element.getContainingFile(), block, model);
        if (psiBasedFormatterModelWithShiftIndentInside == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        return psiBasedFormatterModelWithShiftIndentInside;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        return null;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        return formattingModel;
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return JavaFormattingModelBuilder.doGetRangeAffectingIndent(elementAtOffset);
    }

    @Nullable
    public static TextRange doGetRangeAffectingIndent(ASTNode elementAtOffset) {
        ASTNode current = elementAtOffset;
        if ((current = JavaFormattingModelBuilder.findNearestExpressionParent(current)) == null) {
            if (elementAtOffset.getElementType() == TokenType.WHITE_SPACE) {
                ASTNode prevElement = elementAtOffset.getTreePrev();
                if (prevElement == null) {
                    return elementAtOffset.getTextRange();
                }
                ASTNode prevExpressionParent = JavaFormattingModelBuilder.findNearestExpressionParent(prevElement);
                if (prevExpressionParent == null) {
                    return elementAtOffset.getTextRange();
                }
                return new TextRange(prevExpressionParent.getTextRange().getStartOffset(), elementAtOffset.getTextRange().getEndOffset());
            }
            return JavaFormattingModelBuilder.combineWithErrorElementIfPossible(elementAtOffset);
        }
        return current.getTextRange();
    }

    @Nullable
    private static TextRange combineWithErrorElementIfPossible(@NotNull ASTNode node) {
        if (node == null) {
            JavaFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        if (node.getElementType() == TokenType.ERROR_ELEMENT) {
            return node.getTextRange();
        }
        ASTNode prevLeaf = FormatterUtil.getPreviousLeaf((ASTNode)node, (IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
        if (prevLeaf == null || prevLeaf.getElementType() != TokenType.ERROR_ELEMENT) {
            return node.getTextRange();
        }
        TextRange range = JavaFormattingModelBuilder.doGetRangeAffectingIndent(prevLeaf);
        if (range == null) {
            return node.getTextRange();
        }
        return new TextRange(range.getStartOffset(), node.getTextRange().getEndOffset());
    }

    @Nullable
    private static ASTNode findNearestExpressionParent(ASTNode current) {
        PsiElement psi;
        ASTNode result;
        for (result = current; result != null && (!((psi = result.getPsi()) instanceof PsiExpression) || psi.getParent() instanceof PsiExpression); result = result.getTreeParent()) {
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/JavaFormattingModelBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/JavaFormattingModelBuilder";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsToUse";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "combineWithErrorElementIfPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

