/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.ide.TypePresentationService;
import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageViewBundle;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesProvider
implements FindUsagesProvider {
    public static final String DEFAULT_PACKAGE_NAME = UsageViewBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);

    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage != null && psiPackage.getQualifiedName().length() != 0;
        }
        return element instanceof PsiClass || element instanceof PsiVariable || element instanceof PsiMethod || element instanceof PsiPackage || element instanceof PsiJavaModule || element instanceof PsiLabeledStatement || ThrowSearchUtil.isSearchable(element) || element instanceof PsiMetaOwner && ((PsiMetaOwner)element).getMetaData() != null;
    }

    public String getHelpId(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiPackage) {
            return "reference.dialogs.findUsages.package";
        }
        if (element instanceof PsiClass) {
            return "reference.dialogs.findUsages.class";
        }
        if (element instanceof PsiMethod) {
            return "reference.dialogs.findUsages.method";
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            return "reference.dialogs.findUsages.throwUsages";
        }
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiDirectory) {
            String string = LangBundle.message((String)"terms.directory", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (element instanceof PsiFile) {
            String string = LangBundle.message((String)"terms.file", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string = LangBundle.message((String)"java.terms.exception", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = LangBundle.message((String)"java.terms.package", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = LangBundle.message((String)"java.terms.label", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (element instanceof PsiClass) {
            if (((PsiClass)element).isAnnotationType()) {
                String string = LangBundle.message((String)"java.terms.annotation.interface", (Object[])new Object[0]);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (((PsiClass)element).isEnum()) {
                String string = LangBundle.message((String)"java.terms.enum", (Object[])new Object[0]);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (((PsiClass)element).isInterface()) {
                String string = LangBundle.message((String)"java.terms.interface", (Object[])new Object[0]);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (element instanceof PsiTypeParameter) {
                String string = LangBundle.message((String)"java.terms.type.parameter", (Object[])new Object[0]);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = LangBundle.message((String)"java.terms.class", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (element instanceof PsiField) {
            String string = LangBundle.message((String)"java.terms.field", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (element instanceof PsiParameter) {
            String string = LangBundle.message((String)"java.terms.parameter", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (element instanceof PsiLocalVariable) {
            String string = LangBundle.message((String)"java.terms.variable", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            boolean isConstructor = psiMethod.isConstructor();
            if (isConstructor) {
                String string = LangBundle.message((String)"java.terms.constructor", (Object[])new Object[0]);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = LangBundle.message((String)"java.terms.method", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (element instanceof PsiExpression) {
            String string = LangBundle.message((String)"java.terms.expression", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (element instanceof PsiJavaModule) {
            String string = LangBundle.message((String)"java.terms.module", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(19);
            }
            return string;
        }
        String name = TypePresentationService.getService().getTypePresentableName(element.getClass());
        if (name != null) {
            String string = name;
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(20);
            }
            return string;
        }
        if ("" == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(21);
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(22);
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string = ThrowSearchUtil.getSearchableTypeName(element);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(23);
            }
            return string;
        }
        if (element instanceof PsiDirectory) {
            String string = JavaFindUsagesProvider.getPackageName((PsiDirectory)element, false);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(24);
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = JavaFindUsagesProvider.getPackageName((PsiPackage)element);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(25);
            }
            return string;
        }
        if (element instanceof PsiFile) {
            String string = ((PsiFile)element).getVirtualFile().getPresentableUrl();
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(26);
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = ((PsiLabeledStatement)element).getLabelIdentifier().getText();
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                String name = ((PsiAnonymousClass)element).getBaseClassReference().getReferenceName();
                String string = "anonymous " + StringUtil.notNullize((String)name, (String)"class");
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(28);
                }
                return string;
            }
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            String string = qName != null ? qName : (aClass.getName() != null ? aClass.getName() : "<unknown>");
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(29);
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            String formatted = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)131074);
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass != null) {
                String string = JavaFindUsagesProvider.getContainingClassDescription(psiClass, formatted);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(30);
                }
                return string;
            }
            String string = formatted;
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(31);
            }
            return string;
        }
        if (element instanceof PsiField) {
            PsiField psiField = (PsiField)element;
            String formatted = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass != null) {
                String string = JavaFindUsagesProvider.getContainingClassDescription(psiClass, formatted);
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(32);
                }
                return string;
            }
            String string = formatted;
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (element instanceof PsiVariable) {
            String string = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(34);
            }
            return string;
        }
        if (element instanceof PsiLiteralExpression) {
            String string = element.getText();
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(35);
            }
            return string;
        }
        if (element instanceof PsiJavaModule) {
            String string = ((PsiJavaModule)element).getName();
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(36);
            }
            return string;
        }
        if ("" == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(37);
        }
        return "";
    }

    private static String getContainingClassDescription(PsiClass aClass, String formatted) {
        String className;
        if (aClass instanceof PsiAnonymousClass) {
            return LangBundle.message((String)"java.terms.of.anonymous.class", (Object[])new Object[]{formatted});
        }
        String qualifiedName = aClass.getQualifiedName();
        String string = className = qualifiedName != null ? qualifiedName : aClass.getName();
        if (aClass.isInterface()) {
            return LangBundle.message((String)"java.terms.of.interface", (Object[])new Object[]{formatted, className});
        }
        if (aClass.isEnum()) {
            return LangBundle.message((String)"java.terms.of.enum", (Object[])new Object[]{formatted, className});
        }
        if (aClass.isAnnotationType()) {
            return LangBundle.message((String)"java.terms.of.annotation.type", (Object[])new Object[]{formatted, className});
        }
        return LangBundle.message((String)"java.terms.of.class", (Object[])new Object[]{formatted, className});
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(38);
        }
        if (element instanceof PsiDirectory) {
            String string = JavaFindUsagesProvider.getPackageName((PsiDirectory)element, false);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(39);
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = JavaFindUsagesProvider.getPackageName((PsiPackage)element);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(40);
            }
            return string;
        }
        if (element instanceof PsiFile) {
            String string = useFullName ? ((PsiFile)element).getVirtualFile().getPresentableUrl() : ((PsiFile)element).getName();
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(41);
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = ((PsiLabeledStatement)element).getLabelIdentifier().getText();
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(42);
            }
            return string;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string = ThrowSearchUtil.getSearchableTypeName(element);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(43);
            }
            return string;
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name != null) {
                String string = name;
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(44);
                }
                return string;
            }
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (useFullName) {
                int options = 263;
                String s = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)3);
                String string = JavaFindUsagesProvider.appendClassName(s, psiMethod.getContainingClass());
                if (string == null) {
                    JavaFindUsagesProvider.$$$reportNull$$$0(45);
                }
                return string;
            }
            int options = 257;
            String string = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(46);
            }
            return string;
        }
        if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            int varOptions = 7;
            int methodOptions = 257;
            String s = LangBundle.message((String)"java.terms.variable.of.method", (Object[])new Object[]{PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)varOptions, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)methodOptions, (int)2)});
            String string = JavaFindUsagesProvider.appendClassName(s, method.getContainingClass());
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(47);
            }
            return string;
        }
        if (element instanceof PsiField) {
            PsiField psiField = (PsiField)element;
            int options = 7;
            String s = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            String string = JavaFindUsagesProvider.appendClassName(s, psiField.getContainingClass());
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(48);
            }
            return string;
        }
        if (element instanceof PsiVariable) {
            int options = 7;
            String string = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (string == null) {
                JavaFindUsagesProvider.$$$reportNull$$$0(49);
            }
            return string;
        }
        if ("" == null) {
            JavaFindUsagesProvider.$$$reportNull$$$0(50);
        }
        return "";
    }

    private static String appendClassName(String s, PsiClass psiClass) {
        String qName;
        if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
            s = LangBundle.message((String)(psiClass.isInterface() ? "java.terms.of.interface" : "java.terms.of.class"), (Object[])new Object[]{s, qName});
        }
        return s;
    }

    public static String getPackageName(PsiDirectory directory, boolean includeRootDir) {
        String rootDir;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return directory.getVirtualFile().getPresentableUrl();
        }
        String packageName = JavaFindUsagesProvider.getPackageName(aPackage);
        if (includeRootDir && (rootDir = JavaFindUsagesProvider.getRootDirectoryForPackage(directory)) != null) {
            return UsageViewBundle.message((String)"usage.target.package.in.directory", (Object[])new Object[]{packageName, rootDir});
        }
        return packageName;
    }

    public static String getRootDirectoryForPackage(PsiDirectory directory) {
        PsiManager manager = directory.getManager();
        VirtualFile virtualFile = directory.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)manager.getProject()).getFileIndex();
        VirtualFile root = fileIndex.getSourceRootForFile(virtualFile);
        if (root == null) {
            root = fileIndex.getClassRootForFile(virtualFile);
        }
        if (root != null) {
            return root.getPresentableUrl();
        }
        return null;
    }

    public static String getPackageName(PsiPackage psiPackage) {
        if (psiPackage == null) {
            return null;
        }
        String name = psiPackage.getQualifiedName();
        if (name.length() > 0) {
            return name;
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public WordsScanner getWordsScanner() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/JavaFindUsagesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/JavaFindUsagesProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsagesFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

