/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.bintray;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.bintray.BintrayEndpoint;
import com.intellij.jarRepository.services.bintray.BintrayModel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BintrayRepositoryService
extends MavenRepositoryService {
    @Override
    @NotNull
    public String getDisplayName() {
        if ("Bintray" == null) {
            BintrayRepositoryService.$$$reportNull$$$0(0);
        }
        return "Bintray";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        BintrayModel.Repository info;
        if (url == null) {
            BintrayRepositoryService.$$$reportNull$$$0(1);
        }
        if ((info = BintrayRepositoryService.parseInfo(url)) != null) {
            BintrayEndpoint bintrayEndpoint = new BintrayEndpoint();
            if (info.repo != null) {
                RemoteRepositoryDescription repository = bintrayEndpoint.getRepository(info.subject, info.repo);
                List<Object> list = repository == null ? Collections.emptyList() : Collections.singletonList(repository);
                if (list == null) {
                    BintrayRepositoryService.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<RemoteRepositoryDescription> list = bintrayEndpoint.getRepositories(info.subject);
            if (list == null) {
                BintrayRepositoryService.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<RemoteRepositoryDescription> list = Collections.emptyList();
        if (list == null) {
            BintrayRepositoryService.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        BintrayModel.Repository info;
        if (url == null) {
            BintrayRepositoryService.$$$reportNull$$$0(5);
        }
        if (template == null) {
            BintrayRepositoryService.$$$reportNull$$$0(6);
        }
        if ((template.getPackaging() == null || template.getPackaging().equals("jar")) && (info = BintrayRepositoryService.parseInfo(url)) != null) {
            BintrayEndpoint bintrayEndpoint = new BintrayEndpoint();
            if (StringUtil.isNotEmpty((String)template.getClassNames())) {
                List<RepositoryArtifactDescription> list = bintrayEndpoint.getArtifacts(info.subject, info.repo, template.getClassNames());
                if (list == null) {
                    BintrayRepositoryService.$$$reportNull$$$0(7);
                }
                return list;
            }
            List<Object> artifacts = bintrayEndpoint.getArtifacts(info.subject, info.repo, template.getGroupId(), template.getArtifactId());
            if (!StringUtil.isEmpty((String)template.getVersion())) {
                String versionTemplate = StringUtil.trimStart((String)StringUtil.trimEnd((String)template.getVersion(), (String)"*"), (String)"*");
                artifacts = artifacts.stream().filter(a -> !a.getVersion().contains(versionTemplate)).collect(Collectors.toList());
            }
            List<RepositoryArtifactDescription> list = artifacts;
            if (list == null) {
                BintrayRepositoryService.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<RepositoryArtifactDescription> list = Collections.emptyList();
        if (list == null) {
            BintrayRepositoryService.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static BintrayModel.Repository parseInfo(String url) {
        try {
            URL theUrl = new URL(url);
            String host = theUrl.getHost();
            if (host != null) {
                List path = StringUtil.split((String)StringUtil.trimStart((String)theUrl.getPath(), (String)"/"), (String)"/");
                if (host.equals("dl.bintray.com")) {
                    if (!path.isEmpty()) {
                        return new BintrayModel.Repository((String)path.get(0), path.size() > 1 ? (String)path.get(1) : null);
                    }
                } else {
                    if (host.equals("jcenter.bintray.com")) {
                        return new BintrayModel.Repository("bintray", "jcenter");
                    }
                    if (host.endsWith(".bintray.com")) {
                        return new BintrayModel.Repository(StringUtil.trimEnd((String)host, (String)".bintray.com"), path.isEmpty() ? null : (String)path.get(0));
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/bintray/BintrayRepositoryService";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/bintray/BintrayRepositoryService";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

