/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.smartPointerPsiNodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSmartPointerPsiNode<Type extends SmartPsiElementPointer>
extends ProjectViewNode<Type>
implements PsiElementNavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.nodes.BasePsiNode");

    protected BaseSmartPointerPsiNode(Project project, Type value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        PsiElement value2 = this.getPsiElement();
        if (value2 == null) {
            ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>();
            if (arrayList == null) {
                BaseSmartPointerPsiNode.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        LOG.assertTrue(value2.isValid());
        Collection<AbstractTreeNode> collection = this.getChildrenImpl();
        if (collection == null) {
            BaseSmartPointerPsiNode.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected boolean isMarkReadOnly() {
        Object parentValue = this.getParentValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof PackageElement;
    }

    public PsiElement getTargetElement() {
        VirtualFile file = this.getVirtualFileForValue();
        if (file == null) {
            return null;
        }
        return file.isDirectory() ? PsiManager.getInstance((Project)this.getProject()).findDirectory(file) : PsiManager.getInstance((Project)this.getProject()).findFile(file);
    }

    private VirtualFile getVirtualFileForValue() {
        PsiElement value2 = this.getPsiElement();
        if (value2 == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)value2);
    }

    protected abstract void updateImpl(PresentationData var1);

    public void update(PresentationData data) {
        PsiElement value2 = this.getPsiElement();
        if (value2 == null || !value2.isValid()) {
            this.setValue(null);
        }
        if (this.getPsiElement() == null) {
            return;
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        LOG.assertTrue(value2.isValid());
        Icon icon = value2.getIcon(flags);
        data.setIcon(icon);
        data.setPresentableText(this.myName);
        if (this.isDeprecated()) {
            data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        }
        this.updateImpl(data);
        if (this.myProject != null) {
            CompoundProjectViewNodeDecorator.get((Project)this.myProject).decorate((ProjectViewNode)this, data);
        }
    }

    private boolean isDeprecated() {
        try {
            PsiElement element = this.getPsiElement();
            return element instanceof PsiDocCommentOwner && element.isValid() && ((PsiDocCommentOwner)element).isDeprecated();
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            BaseSmartPointerPsiNode.$$$reportNull$$$0(2);
        }
        if (this.getPsiElement() == null) {
            return false;
        }
        PsiFile containingFile = this.getPsiElement().getContainingFile();
        return file.equals(containingFile.getVirtualFile());
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            ((NavigationItem)this.getPsiElement()).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigateToSource();
    }

    protected PsiElement getPsiElement() {
        SmartPsiElementPointer value2 = (SmartPsiElementPointer)this.getValue();
        return value2 == null ? null : value2.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

