/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaCodeStyleManager;
import com.intellij.core.CoreJavaCodeStyleSettingsFacade;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.CoreJavaPsiImplementationHelper;
import com.intellij.core.CoreLanguageLevelProjectExtension;
import com.intellij.core.CorePackageIndex;
import com.intellij.core.CoreProjectEnvironment;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.JvmPsiConversionHelperImpl;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class JavaCoreProjectEnvironment
extends CoreProjectEnvironment {
    private final JavaFileManager myFileManager;
    private final PackageIndex myPackageIndex;

    public JavaCoreProjectEnvironment(Disposable parentDisposable, CoreApplicationEnvironment applicationEnvironment) {
        super(parentDisposable, applicationEnvironment);
        this.myProject.registerService(PsiElementFactory.class, (Object)new PsiElementFactoryImpl((PsiManagerEx)this.myPsiManager));
        this.myProject.registerService(JavaPsiImplementationHelper.class, (Object)this.createJavaPsiImplementationHelper());
        this.myProject.registerService(PsiResolveHelper.class, (Object)new PsiResolveHelperImpl((PsiManager)this.myPsiManager));
        this.myProject.registerService(LanguageLevelProjectExtension.class, (Object)new CoreLanguageLevelProjectExtension());
        this.myProject.registerService(JavaResolveCache.class, (Object)new JavaResolveCache(this.myMessageBus));
        this.myProject.registerService(JavaCodeStyleSettingsFacade.class, (Object)new CoreJavaCodeStyleSettingsFacade());
        this.myProject.registerService(JavaCodeStyleManager.class, (Object)new CoreJavaCodeStyleManager());
        this.myProject.registerService(ControlFlowFactory.class, (Object)new ControlFlowFactory((PsiManagerEx)this.myPsiManager));
        this.myPackageIndex = this.createCorePackageIndex();
        this.myProject.registerService(PackageIndex.class, (Object)this.myPackageIndex);
        this.myFileManager = this.createCoreFileManager();
        this.myProject.registerService(JavaFileManager.class, (Object)this.myFileManager);
        this.myProject.registerService(JvmPsiConversionHelper.class, (Object)new JvmPsiConversionHelperImpl());
        this.registerJavaPsiFacade();
        this.myProject.registerService(JvmFacade.class, (Object)new JvmFacadeImpl((Project)this.myProject, this.myMessageBus));
    }

    protected void registerJavaPsiFacade() {
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl((Project)this.myProject, (PsiManager)this.myPsiManager, this.myFileManager, this.myMessageBus);
        this.myProject.registerService(JavaPsiFacade.class, (Object)javaPsiFacade);
    }

    protected CoreJavaPsiImplementationHelper createJavaPsiImplementationHelper() {
        return new CoreJavaPsiImplementationHelper((Project)this.myProject);
    }

    protected JavaFileManager createCoreFileManager() {
        return new CoreJavaFileManager((PsiManager)this.myPsiManager);
    }

    protected PackageIndex createCorePackageIndex() {
        return new CorePackageIndex();
    }

    public void addJarToClassPath(File path) {
        assert (path.isFile());
        VirtualFile root = this.getEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (root == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path);
        }
        this.addSourcesToClasspath(root);
    }

    public void addSourcesToClasspath(@NotNull VirtualFile root) {
        if (root == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        assert (root.isDirectory());
        ((CoreJavaFileManager)this.myFileManager).addToClasspath(root);
        ((CorePackageIndex)this.myPackageIndex).addToClasspath(root);
        ((MockFileIndexFacade)this.myFileIndexFacade).addLibraryRoot(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/core/JavaCoreProjectEnvironment", "addSourcesToClasspath"));
    }
}

