/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.FileTypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrongPackageStatementInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            WrongPackageStatementInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            WrongPackageStatementInspectionBase.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
                return null;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            PsiDirectory directory = javaFile.getContainingDirectory();
            if (directory == null) {
                return null;
            }
            PsiPackage dirPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (dirPackage == null) {
                return null;
            }
            PsiPackageStatement packageStatement = javaFile.getPackageStatement();
            PsiClass[] classes2 = javaFile.getClasses();
            if (classes2.length == 0 && packageStatement == null) {
                return null;
            }
            String packageName = dirPackage.getQualifiedName();
            if (!Comparing.strEqual((String)packageName, (String)"", (boolean)true) && packageStatement == null) {
                String description = JavaErrorMessages.message("missing.package.statement", packageName);
                AdjustPackageNameFix fix = PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName) ? new AdjustPackageNameFix(packageName) : null;
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)classes2[0].getNameIdentifier(), description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
            }
            if (packageStatement != null) {
                PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                PsiPackage classPackage = (PsiPackage)packageReference.resolve();
                ArrayList<LocalQuickFix> availableFixes = new ArrayList<LocalQuickFix>();
                if (classPackage == null || !Comparing.equal((String)dirPackage.getQualifiedName(), (String)packageReference.getQualifiedName(), (boolean)true)) {
                    if (PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName)) {
                        availableFixes.add(new AdjustPackageNameFix(packageName));
                    }
                    String packName = classPackage != null ? classPackage.getQualifiedName() : packageReference.getQualifiedName();
                    this.addMoveToPackageFix(file, packName, availableFixes);
                }
                if (!availableFixes.isEmpty()) {
                    String description = JavaErrorMessages.message("package.name.file.path.mismatch", packageReference.getQualifiedName(), dirPackage.getQualifiedName());
                    LocalQuickFix[] fixes = availableFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)packageStatement.getPackageReference(), description, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    return new ProblemDescriptor[]{descriptor};
                }
            }
        }
        return null;
    }

    protected void addMoveToPackageFix(PsiFile file, String packName, List<LocalQuickFix> availableFixes) {
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            WrongPackageStatementInspectionBase.$$$reportNull$$$0(2);
        }
        return "";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            WrongPackageStatementInspectionBase.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"wrong.package.statement", (Object[])new Object[0]);
        if (string == null) {
            WrongPackageStatementInspectionBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("WrongPackageStatement" == null) {
            WrongPackageStatementInspectionBase.$$$reportNull$$$0(5);
        }
        return "WrongPackageStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

