/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IteratorDeclaration {
    @NotNull
    private final PsiLocalVariable myIterator;
    @Nullable
    private final PsiExpression myIterable;
    private final boolean myCollection;

    private IteratorDeclaration(@NotNull PsiLocalVariable iterator, @Nullable PsiExpression iterable, boolean collection) {
        if (iterator == null) {
            IteratorDeclaration.$$$reportNull$$$0(0);
        }
        this.myIterator = iterator;
        this.myIterable = iterable;
        this.myCollection = collection;
    }

    @NotNull
    public PsiLocalVariable getIterator() {
        PsiLocalVariable psiLocalVariable = this.myIterator;
        if (psiLocalVariable == null) {
            IteratorDeclaration.$$$reportNull$$$0(1);
        }
        return psiLocalVariable;
    }

    @Nullable
    public PsiExpression getIterable() {
        return this.myIterable;
    }

    public boolean isCollection() {
        return this.myCollection;
    }

    public boolean isHasNextCall(PsiExpression condition2) {
        return this.isIteratorMethodCall((PsiElement)condition2, "hasNext");
    }

    @Nullable
    public PsiElement findOnlyIteratorRef(PsiExpression parent) {
        PsiCodeBlock block;
        PsiElement element = PsiUtil.getVariableCodeBlock((PsiVariable)this.myIterator, null);
        PsiCodeBlock psiCodeBlock = block = element instanceof PsiCodeBlock ? (PsiCodeBlock)element : (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        if (block == null) {
            return null;
        }
        return ((Optional)((StreamEx)StreamEx.of((Object[])DefUseUtil.getRefs(block, (PsiVariable)this.myIterator, (PsiElement)Objects.requireNonNull(this.myIterator.getInitializer()))).filter(e -> PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)e, (boolean)false))).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    public boolean isIteratorMethodCall(PsiElement candidate, String method) {
        if (!(candidate instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)candidate;
        if (!call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiReferenceExpression expression2 = call.getMethodExpression();
        return method.equals(expression2.getReferenceName()) && ExpressionUtils.isReferenceTo(expression2.getQualifierExpression(), (PsiVariable)this.myIterator);
    }

    public PsiVariable getNextElementVariable(PsiStatement statement) {
        if (!(statement instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
        if (declaration2.getDeclaredElements().length != 1) {
            return null;
        }
        PsiElement element = declaration2.getDeclaredElements()[0];
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        if (!this.isIteratorMethodCall((PsiElement)var.getInitializer(), "next")) {
            return null;
        }
        return var;
    }

    @Contract(value="null -> null")
    private static IteratorDeclaration extract(PsiStatement statement) {
        boolean isCollection;
        if (!(statement instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
        if (declaration2.getDeclaredElements().length != 1) {
            return null;
        }
        PsiElement element = declaration2.getDeclaredElements()[0];
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)element;
        PsiExpression initializer = variable.getInitializer();
        if (!(initializer instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)initializer;
        if (!call.getArgumentList().isEmpty()) {
            return null;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        boolean listIterator = "listIterator".equals(methodExpression.getReferenceName());
        if (!"iterator".equals(methodExpression.getReferenceName()) && !listIterator) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        if (listIterator) {
            if (!InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.util.List")) {
                return null;
            }
            isCollection = true;
        } else {
            if (!InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.lang.Iterable")) {
                return null;
            }
            isCollection = InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.util.Collection");
        }
        if (!InheritanceUtil.isInheritor((PsiType)variable.getType(), (String)"java.util.Iterator")) {
            return null;
        }
        return new IteratorDeclaration(variable, methodExpression.getQualifierExpression(), isCollection);
    }

    @Nullable
    private static IteratorDeclaration fromForLoop(PsiForStatement statement) {
        if (statement.getUpdate() != null) {
            return null;
        }
        PsiStatement initialization = statement.getInitialization();
        IteratorDeclaration declaration2 = IteratorDeclaration.extract(initialization);
        if (declaration2 == null || !declaration2.isHasNextCall(statement.getCondition())) {
            return null;
        }
        return declaration2;
    }

    @Nullable
    private static IteratorDeclaration fromWhileLoop(PsiWhileStatement statement) {
        PsiElement previous = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement);
        if (!(previous instanceof PsiDeclarationStatement)) {
            return null;
        }
        IteratorDeclaration declaration2 = IteratorDeclaration.extract((PsiStatement)previous);
        if (declaration2 == null || !declaration2.isHasNextCall(statement.getCondition())) {
            return null;
        }
        if (!ReferencesSearch.search((PsiElement)declaration2.myIterator, (SearchScope)declaration2.myIterator.getUseScope()).forEach(ref -> PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)ref.getElement(), (boolean)true))) {
            return null;
        }
        return declaration2;
    }

    @Contract(value="null -> null")
    public static IteratorDeclaration fromLoop(PsiLoopStatement statement) {
        if (statement instanceof PsiWhileStatement) {
            return IteratorDeclaration.fromWhileLoop((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiForStatement) {
            return IteratorDeclaration.fromForLoop((PsiForStatement)statement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/util/IteratorDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/util/IteratorDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

