/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ToArrayMigration
extends BaseStreamApiMigration {
    protected ToArrayMigration(boolean shouldWarn) {
        super(shouldWarn, "toArray");
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiLocalVariable arrayVariable;
        if (project == null) {
            ToArrayMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            ToArrayMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            ToArrayMigration.$$$reportNull$$$0(2);
        }
        if ((arrayVariable = StreamApiMigrationInspection.extractArray(tb)) == null) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiExpression rValue = assignment.getRExpression();
        if (rValue == null) {
            return null;
        }
        PsiNewExpression initializer = (PsiNewExpression)ObjectUtils.tryCast((Object)arrayVariable.getInitializer(), PsiNewExpression.class);
        if (initializer == null) {
            return null;
        }
        PsiExpression dimension = (PsiExpression)ArrayUtil.getFirstElement((Object[])initializer.getArrayDimensions());
        if (dimension == null) {
            return null;
        }
        StreamApiMigrationInspection.CountingLoopSource loop = tb.getLastOperation(StreamApiMigrationInspection.CountingLoopSource.class);
        if (loop == null) {
            return null;
        }
        PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)initializer.getType(), PsiArrayType.class);
        if (arrayType == null) {
            return null;
        }
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)arrayVariable, tb.getStreamSourceStatement());
        if (status == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
            return null;
        }
        PsiType componentType = arrayType.getComponentType();
        String supplier = componentType instanceof PsiPrimitiveType || componentType.equalsToText("java.lang.Object") ? "" : arrayType.getCanonicalText() + "::new";
        CommentTracker ct = new CommentTracker();
        StreamApiMigrationInspection.MapOp mapping = new StreamApiMigrationInspection.MapOp(rValue, tb.getVariable(), assignment.getType());
        String replacementText = loop.withBound(dimension).createReplacement(ct) + mapping.createReplacement(ct) + ".toArray(" + supplier + ")";
        return ToArrayMigration.replaceInitializer(tb.getStreamSourceStatement(), (PsiVariable)arrayVariable, (PsiExpression)initializer, replacementText, status, ct);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/ToArrayMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

