/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.ForEachMigration;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyForEachInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher.Simple ITERABLE_FOREACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterCount(1);
    private static final CallMatcher.Simple STREAM_FOREACH_ORDERED = CallMatcher.instanceCall("java.util.stream.BaseStream", "forEachOrdered").parameterCount(1);
    private static final CallMatcher STREAM_FOREACH = CallMatcher.instanceCall("java.util.stream.BaseStream", "forEach", "forEachOrdered").parameterCount(1);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("forEach call can be simplified" == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(1);
        }
        return "forEach call can be simplified";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(2);
        }
        PsiFile file = holder.getFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)file) || virtualFile == null || !FileIndexFacade.getInstance((Project)holder.getProject()).isInSourceContent(virtualFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SimplifyForEachInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                boolean lastOpChanged;
                SimplifyForEachContext context = SimplifyForEachContext.from(call);
                if (context == null) {
                    return;
                }
                boolean opCountChanged = context.myTerminalBlock.getOperationCount() > 1;
                boolean bl = lastOpChanged = !(context.myMigration instanceof ForEachMigration);
                if (opCountChanged || lastOpChanged) {
                    String customMessage = lastOpChanged ? "Replace with " + context.myMigration.getReplacement() : "Extract intermediate operations";
                    ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem((PsiElement)context.myMainStatement, customMessage, highlightType, SimplifyForEachInspection.getRange(call).shiftRight(-call.getTextOffset()), new LocalQuickFix[]{new SimplifyForEachFix(customMessage)});
                }
            }
        };
        if (javaElementVisitor == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    @NotNull
    private static TextRange getRange(PsiMethodCallExpression call) {
        if (!InspectionProjectProfileManager.isInformationLevel((String)"SimplifyForEach", (PsiElement)call)) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            TextRange textRange = new TextRange(methodExpression.getTextOffset(), call.getArgumentList().getTextOffset());
            if (textRange == null) {
                SimplifyForEachInspection.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        TextRange textRange = new TextRange(call.getTextOffset(), call.getNextSibling().getTextOffset());
        if (textRange == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Nullable
    static TerminalBlock extractTerminalBlock(@Nullable PsiElement lambdaBody, @NotNull ExistingStreamSource source) {
        if (source == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(7);
        }
        if (lambdaBody instanceof PsiCodeBlock) {
            return TerminalBlock.from((StreamApiMigrationInspection.StreamSource)source, (PsiCodeBlock)lambdaBody);
        }
        if (lambdaBody instanceof PsiExpression) {
            return TerminalBlock.fromStatements(source, new PsiStatement[]{new LightExpressionStatement((PsiExpression)lambdaBody)});
        }
        return null;
    }

    @Nullable
    static PsiLambdaExpression extractLambdaFromForEach(@NotNull PsiMethodCallExpression call) {
        PsiExpression qualifier;
        if (call == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(8);
        }
        if ((qualifier = call.getMethodExpression().getQualifierExpression()) == null || !STREAM_FOREACH.test(call) && !SimplifyForEachInspection.isCollectionForEach(call, qualifier)) {
            return null;
        }
        PsiExpression arg = call.getArgumentList().getExpressions()[0];
        return (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
    }

    private static boolean isCollectionForEach(PsiMethodCallExpression call, PsiExpression qualifier) {
        return ITERABLE_FOREACH.test(call) && InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.Collection");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractTerminalBlock";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractLambdaFromForEach";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ForEachNonFinalFix
    extends PsiElementBaseIntentionAction
    implements HighPriorityAction {
        private final PsiElement myContext;

        public ForEachNonFinalFix(PsiElement context) {
            SimplifyForEachContext simplifyContext = ForEachNonFinalFix.findMigration(context);
            if (simplifyContext == null) {
                this.myContext = null;
            } else {
                this.myContext = context;
                this.setText("Avoid mutation using Stream API '" + simplifyContext.myMigration.getReplacement() + "' operation");
            }
        }

        private static SimplifyForEachContext findMigration(PsiElement context) {
            if (!(context instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)context))) {
                return null;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class);
            if (lambda2 == null) {
                return null;
            }
            PsiElement lambdaBody = lambda2.getBody();
            if (lambdaBody == null) {
                return null;
            }
            PsiExpressionList parameters2 = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)lambda2.getParent()), PsiExpressionList.class);
            if (parameters2 == null || parameters2.getExpressionCount() != 1) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parameters2.getParent(), PsiMethodCallExpression.class);
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext == null || simplifyForEachContext.myMigration instanceof ForEachMigration) {
                return null;
            }
            return simplifyForEachContext;
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiElement result;
            PsiMethodCallExpression call;
            SimplifyForEachContext simplifyForEachContext;
            if (project == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(1);
            }
            if ((simplifyForEachContext = SimplifyForEachContext.from(call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class), PsiMethodCallExpression.class))) != null && (result = simplifyForEachContext.migrate()) != null) {
                MigrateToStreamFix.simplify(project, result);
            }
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(3);
            }
            return this.myContext != null && this.myContext.isValid();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Avoid mutation using Stream API" == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(4);
            }
            return "Avoid mutation using Stream API";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$ForEachNonFinalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$ForEachNonFinalFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SimplifyForEachFix
    implements LocalQuickFix {
        @NotNull
        private final String myCustomName;

        protected SimplifyForEachFix(@NotNull String customName) {
            if (customName == null) {
                SimplifyForEachFix.$$$reportNull$$$0(0);
            }
            this.myCustomName = customName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myCustomName;
            if (string == null) {
                SimplifyForEachFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify forEach lambda" == null) {
                SimplifyForEachFix.$$$reportNull$$$0(2);
            }
            return "Simplify forEach lambda";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpressionStatement statement;
            if (project == null) {
                SimplifyForEachFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                SimplifyForEachFix.$$$reportNull$$$0(4);
            }
            if ((statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiExpressionStatement.class)) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)statement.getExpression(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext == null) {
                return;
            }
            PsiElement result = simplifyForEachContext.migrate();
            if (result == null) {
                return;
            }
            MigrateToStreamFix.simplify(project, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$SimplifyForEachFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$SimplifyForEachFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class SimplifyForEachContext {
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @NotNull
        private final PsiStatement myMainStatement;
        @NotNull
        private final BaseStreamApiMigration myMigration;
        @NotNull
        private final PsiElement myLambdaBody;

        private SimplifyForEachContext(@NotNull TerminalBlock terminalBlock, @NotNull PsiStatement mainStatement, @NotNull PsiElement body2, @NotNull BaseStreamApiMigration migration) {
            if (terminalBlock == null) {
                SimplifyForEachContext.$$$reportNull$$$0(0);
            }
            if (mainStatement == null) {
                SimplifyForEachContext.$$$reportNull$$$0(1);
            }
            if (body2 == null) {
                SimplifyForEachContext.$$$reportNull$$$0(2);
            }
            if (migration == null) {
                SimplifyForEachContext.$$$reportNull$$$0(3);
            }
            this.myTerminalBlock = terminalBlock;
            this.myMainStatement = mainStatement;
            this.myLambdaBody = body2;
            this.myMigration = migration;
        }

        public PsiElement migrate() {
            PsiElement result = this.myMigration.migrate(this.myMainStatement.getProject(), this.myLambdaBody, this.myTerminalBlock);
            if (result != null) {
                this.myTerminalBlock.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
            }
            return result;
        }

        static SimplifyForEachContext from(@Nullable PsiMethodCallExpression call) {
            if (call == null) {
                return null;
            }
            PsiLambdaExpression lambda2 = SimplifyForEachInspection.extractLambdaFromForEach(call);
            if (lambda2 == null) {
                return null;
            }
            PsiElement lambdaBody = lambda2.getBody();
            ExistingStreamSource source = ExistingStreamSource.extractSource(call, lambda2);
            if (source == null) {
                return null;
            }
            TerminalBlock terminalBlock = SimplifyForEachInspection.extractTerminalBlock(lambdaBody, source);
            if (terminalBlock == null) {
                return null;
            }
            PsiStatement mainStatement = source.getMainStatement();
            BaseStreamApiMigration migration = StreamApiMigrationInspection.findMigration(mainStatement, lambdaBody, terminalBlock, true, true);
            if (migration instanceof ForEachMigration && STREAM_FOREACH_ORDERED.test(call)) {
                migration = new ForEachMigration(migration.isShouldWarn(), "forEachOrdered");
            }
            return migration == null ? null : new SimplifyForEachContext(terminalBlock, mainStatement, lambdaBody, migration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "terminalBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mainStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "migration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$SimplifyForEachContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExistingStreamSource
    extends StreamApiMigrationInspection.StreamSource {
        private final boolean myIsCollectionForEach;

        protected ExistingStreamSource(PsiStatement mainStatement, PsiVariable variable, PsiExpression expression2, boolean isCollectionForEach) {
            super(mainStatement, variable, expression2);
            this.myIsCollectionForEach = isCollectionForEach;
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return this.myExpression.getText() + (this.myIsCollectionForEach ? ".stream()" : "");
        }

        @Nullable
        static ExistingStreamSource extractSource(PsiMethodCallExpression call, PsiLambdaExpression lambda2) {
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return null;
            }
            PsiParameter parameter2 = parameters2[0];
            boolean isCollectionForEach = ITERABLE_FOREACH.test(call);
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            PsiStatement parent = (PsiStatement)ObjectUtils.tryCast((Object)call.getParent(), PsiExpressionStatement.class);
            if (parent == null) {
                return null;
            }
            return new ExistingStreamSource(parent, (PsiVariable)parameter2, qualifier, isCollectionForEach);
        }
    }

    static class LightExpressionStatement
    extends LightElement
    implements PsiExpressionStatement {
        @NotNull
        private final PsiExpression myExpression;

        protected LightExpressionStatement(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                LightExpressionStatement.$$$reportNull$$$0(0);
            }
            super(expression2.getManager(), (Language)JavaLanguage.INSTANCE);
            this.myExpression = expression2;
        }

        @NotNull
        public PsiExpression getExpression() {
            PsiExpression psiExpression = this.myExpression;
            if (psiExpression == null) {
                LightExpressionStatement.$$$reportNull$$$0(1);
            }
            return psiExpression;
        }

        public String toString() {
            return this.myExpression.getText() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$LightExpressionStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$LightExpressionStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

