/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldExpressionIntoStreamInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FoldExpressionIntoStreamInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                FoldExpressionIntoStreamInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                TerminalGenerator generator = FoldExpressionIntoStreamInspection.getGenerator(expression2);
                if (generator == null) {
                    return;
                }
                List diff = FoldExpressionIntoStreamInspection.extractDiff(generator, expression2);
                if (diff.isEmpty()) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)expression2)) {
                    return;
                }
                boolean stringJoin = generator.isStringJoin(expression2, diff);
                String message2 = InspectionsBundle.message((String)(stringJoin ? "inspection.fold.expression.into.string.display.name" : "inspection.fold.expression.into.stream.display.name"), (Object[])new Object[0]);
                holder.registerProblem((PsiElement)expression2, message2, new LocalQuickFix[]{new FoldExpressionIntoStreamFix(stringJoin)});
            }
        };
        if (javaElementVisitor == null) {
            FoldExpressionIntoStreamInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static List<PsiExpression> extractDiff(TerminalGenerator generator, PsiPolyadicExpression expression2) {
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        PsiExpression[] operands2 = generator.getOperands(expression2);
        if (operands2.length < 3) {
            return Collections.emptyList();
        }
        ArrayList<PsiExpression> elements = new ArrayList<PsiExpression>();
        for (int i = 1; i < operands2.length; ++i) {
            if (!Objects.equals(operands2[0].getType(), operands2[i].getType())) {
                return Collections.emptyList();
            }
            EquivalenceChecker.Match match = equivalence.expressionsMatch(operands2[0], operands2[i]);
            PsiExpression left = null;
            PsiExpression right = null;
            if (match.isPartialMatch()) {
                left = (PsiExpression)ObjectUtils.tryCast((Object)match.getLeftDiff(), PsiExpression.class);
                right = (PsiExpression)ObjectUtils.tryCast((Object)match.getRightDiff(), PsiExpression.class);
            } else if (match.isExactMismatch() && generator.isDittoSupported()) {
                left = operands2[0];
                right = operands2[i];
            }
            if (left == null || right == null) {
                return Collections.emptyList();
            }
            if (elements.isEmpty()) {
                PsiBinaryExpression binOp;
                if (!StreamApiUtil.isSupportedStreamElement(left.getType()) || !ExpressionUtils.isSafelyRecomputableExpression(left)) {
                    return Collections.emptyList();
                }
                if (operands2[0] instanceof PsiBinaryExpression && (ComparisonUtils.isComparison((PsiExpression)(binOp = (PsiBinaryExpression)operands2[0])) && left == binOp.getLOperand() && ExpressionUtils.isSafelyRecomputableExpression(binOp.getROperand()) || left == binOp.getROperand() && ExpressionUtils.isSafelyRecomputableExpression(binOp.getLOperand()))) {
                    return Collections.emptyList();
                }
                elements.add(left);
            } else if (elements.get(0) != left) {
                return Collections.emptyList();
            }
            if (!Objects.equals(left.getType(), right.getType()) || !ExpressionUtils.isSafelyRecomputableExpression(right)) {
                return Collections.emptyList();
            }
            elements.add(right);
        }
        return elements;
    }

    @Nullable
    private static TerminalGenerator getGenerator(PsiPolyadicExpression polyadicExpression) {
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.OROR)) {
            return (elementType, lambda2, ct) -> ".anyMatch(" + lambda2 + ")";
        }
        if (tokenType.equals(JavaTokenType.ANDAND)) {
            return (elementType, lambda2, ct) -> ".allMatch(" + lambda2 + ")";
        }
        if (tokenType.equals(JavaTokenType.PLUS)) {
            String mapToString;
            PsiType type2 = polyadicExpression.getType();
            if (type2 instanceof PsiPrimitiveType) {
                if (!StreamApiUtil.isSupportedStreamElement(type2)) {
                    return null;
                }
                return (elementType, lambda2, ct) -> "." + StreamRefactoringUtil.getMapOperationName(elementType, type2) + "(" + lambda2 + ").sum()";
            }
            if (!TypeUtils.isJavaLangString(type2)) {
                return null;
            }
            Object[] operands2 = polyadicExpression.getOperands();
            PsiType operandType = operands2[0].getType();
            if (!InheritanceUtil.isInheritor((PsiType)operandType, (String)"java.lang.CharSequence")) {
                if (!StreamApiUtil.isSupportedStreamElement(operandType)) {
                    return null;
                }
                mapToString = "." + StreamRefactoringUtil.getMapOperationName(operandType, type2) + "(String::valueOf)";
            } else {
                mapToString = "";
            }
            Object delimiter = null;
            PsiExpression rest = null;
            if (operands2.length > 4 && ExpressionUtils.isSafelyRecomputableExpression(operands2[1])) {
                if (IntStreamEx.range((int)1, (int)operands2.length, (int)2).elements(operands2).pairMap(PsiEquivalenceUtil::areElementsEquivalent).allMatch(Boolean.TRUE::equals)) {
                    delimiter = operands2[1];
                    if (!(InheritanceUtil.isInheritor((PsiType)delimiter.getType(), (String)"java.lang.CharSequence") || delimiter instanceof PsiLiteralExpression && PsiType.CHAR.equals((Object)delimiter.getType()))) {
                        return null;
                    }
                    if (operands2.length % 2 == 0) {
                        rest = (PsiExpression)ArrayUtil.getLastElement((Object[])operands2);
                    }
                }
            }
            return new JoiningTerminalGenerator(operandType, mapToString, (PsiExpression)delimiter, rest);
        }
        return null;
    }

    @NotNull
    private static String mapToString(PsiType elementType, PsiType resultType, String lambda2) {
        String string = "." + StreamRefactoringUtil.getMapOperationName(elementType, resultType) + "(" + lambda2 + ")";
        if (string == null) {
            FoldExpressionIntoStreamInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/FoldExpressionIntoStreamInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/FoldExpressionIntoStreamInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JoiningTerminalGenerator
    implements TerminalGenerator {
        private final PsiType myOperandType;
        private final String myMapToString;
        private final PsiExpression myDelimiter;
        private final PsiExpression myRest;

        public JoiningTerminalGenerator(PsiType operandType, String mapToString, PsiExpression delimiter, PsiExpression rest) {
            this.myOperandType = operandType;
            this.myMapToString = mapToString;
            this.myDelimiter = delimiter;
            this.myRest = rest;
        }

        @Override
        public PsiExpression[] getOperands(PsiPolyadicExpression polyadicExpression) {
            Object[] ops = polyadicExpression.getOperands();
            return this.myDelimiter == null ? ops : (PsiExpression[])IntStreamEx.range((int)0, (int)ops.length, (int)2).elements(ops).toArray((Object[])PsiExpression.EMPTY_ARRAY);
        }

        @Override
        public boolean isDittoSupported() {
            return this.myDelimiter != null;
        }

        @Override
        public boolean isStringJoin(PsiPolyadicExpression expression2, List<? extends PsiExpression> diff) {
            if (!this.myMapToString.isEmpty()) {
                return false;
            }
            PsiExpression[] operands2 = this.getOperands(expression2);
            return operands2[0] == diff.get(0);
        }

        @Override
        @NotNull
        public String generateTerminal(PsiType elementType, String lambda2, CommentTracker ct) {
            String map = (lambda2 == null ? "" : FoldExpressionIntoStreamInspection.mapToString(elementType, this.myOperandType, lambda2)) + this.myMapToString;
            String string = map + ".collect(" + "java.util.stream.Collectors" + ".joining(" + this.getDelimiterText(ct) + "))" + (this.myRest == null ? "" : "+" + ct.text((PsiElement)this.myRest));
            if (string == null) {
                JoiningTerminalGenerator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        private String getDelimiterText(CommentTracker ct) {
            if (this.myDelimiter == null) {
                if ("" == null) {
                    JoiningTerminalGenerator.$$$reportNull$$$0(1);
                }
                return "";
            }
            String text2 = ct.text((PsiElement)this.myDelimiter);
            if (text2.startsWith("'")) {
                String string = PsiLiteralUtil.stringForCharLiteral((String)text2);
                if (string == null) {
                    JoiningTerminalGenerator.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = text2;
            if (string == null) {
                JoiningTerminalGenerator.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/streamMigration/FoldExpressionIntoStreamInspection$JoiningTerminalGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateTerminal";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelimiterText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class FoldExpressionIntoStreamFix
    implements LocalQuickFix {
        private final boolean myStringJoin;

        private FoldExpressionIntoStreamFix(boolean stringJoin) {
            this.myStringJoin = stringJoin;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)(this.myStringJoin ? "inspection.fold.expression.into.string.fix.name" : "inspection.fold.expression.into.stream.fix.name"), (Object[])new Object[0]);
            if (string == null) {
                FoldExpressionIntoStreamFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String operandCopyText;
            PsiPolyadicExpression expression2;
            if (project == null) {
                FoldExpressionIntoStreamFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                FoldExpressionIntoStreamFix.$$$reportNull$$$0(2);
            }
            if ((expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiPolyadicExpression.class)) == null) {
                return;
            }
            TerminalGenerator generator = FoldExpressionIntoStreamInspection.getGenerator(expression2);
            if (generator == null) {
                return;
            }
            List diffs = FoldExpressionIntoStreamInspection.extractDiff(generator, expression2);
            if (diffs.isEmpty()) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            PsiExpression firstExpression = (PsiExpression)diffs.get(0);
            assert (PsiTreeUtil.isAncestor((PsiElement)operands2[0], (PsiElement)firstExpression, (boolean)false));
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)firstExpression, (Object)marker);
            CommentTracker ct = new CommentTracker();
            PsiExpression operandCopy = (PsiExpression)ct.markUnchanged(operands2[0]).copy();
            PsiElement expressionCopy = PsiTreeUtil.releaseMark((PsiElement)operandCopy, (Object)marker);
            if (expressionCopy == null) {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiType elementType = firstExpression.getType();
            SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, elementType, true);
            String name = info.names.length > 0 ? info.names[0] : "v";
            name = codeStyleManager.suggestUniqueVariableName(name, (PsiElement)expression2, true);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression expressionCopyReplaced = (PsiExpression)expressionCopy.replace((PsiElement)factory.createExpressionFromText(name, expressionCopy));
            if (operandCopy == expressionCopy) {
                operandCopy = expressionCopyReplaced;
            }
            String lambda2 = (operandCopyText = operandCopy.getText()).equals(name) ? null : name + "->" + operandCopyText;
            String streamClass = StreamApiUtil.getStreamClassForType(elementType);
            if (streamClass == null) {
                return;
            }
            String source = streamClass + "." + (elementType instanceof PsiClassType ? "<" + elementType.getCanonicalText() + ">" : "") + "of" + StreamEx.of((Collection)diffs).map(ct::text).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")");
            String fullStream = source + generator.generateTerminal(elementType, lambda2, ct);
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)expression2, fullStream);
            FoldExpressionIntoStreamFix.cleanup(result);
        }

        private static void cleanup(PsiElement result) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)result.getProject());
            result = SimplifyStreamApiCallChainsInspection.simplifyStreamExpressions(result, false);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            result = codeStyleManager.shortenClassReferences(result);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/FoldExpressionIntoStreamInspection$FoldExpressionIntoStreamFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/FoldExpressionIntoStreamInspection$FoldExpressionIntoStreamFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface TerminalGenerator {
        default public PsiExpression[] getOperands(PsiPolyadicExpression polyadicExpression) {
            return polyadicExpression.getOperands();
        }

        default public boolean isDittoSupported() {
            return false;
        }

        @NotNull
        public String generateTerminal(PsiType var1, String var2, CommentTracker var3);

        default public boolean isStringJoin(PsiPolyadicExpression expression2, List<? extends PsiExpression> diff) {
            return false;
        }
    }
}

