/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionInvocationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String JAVA_LANG_REFLECT_METHOD = "java.lang.reflect.Method";
    private static final String JAVA_LANG_REFLECT_CONSTRUCTOR = "java.lang.reflect.Constructor";
    private static final String INVOKE = "invoke";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                super.visitMethodCallExpression(methodCall);
                if (JavaReflectionReferenceUtil.isCallToMethod(methodCall, JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_METHOD, JavaReflectionInvocationInspection.INVOKE)) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 1, holder, x$0 -> JavaReflectionInvocationInspection.isReflectionMethod(x$0));
                } else if (JavaReflectionReferenceUtil.isCallToMethod(methodCall, JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_CONSTRUCTOR, "newInstance")) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 0, holder, x$0 -> JavaReflectionInvocationInspection.isReflectionConstructor(x$0));
                }
            }
        };
        if (javaElementVisitor == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static boolean isReflectionMethod(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getMethod") || JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getDeclaredMethod");
    }

    private static boolean isReflectionConstructor(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getConstructor") || JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getDeclaredConstructor");
    }

    private static void checkReflectionCall(@NotNull PsiMethodCallExpression methodCall, int argumentOffset, @NotNull ProblemsHolder holder, @NotNull Predicate<PsiMethodCallExpression> methodPredicate) {
        PsiExpressionList argumentList;
        Arguments actualArguments;
        List<PsiExpression> requiredTypes;
        if (methodCall == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(3);
        }
        if (methodPredicate == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(4);
        }
        if ((requiredTypes = JavaReflectionInvocationInspection.getRequiredMethodArguments(methodCall.getMethodExpression().getQualifierExpression(), argumentOffset, methodPredicate)) != null && (actualArguments = JavaReflectionInvocationInspection.getActualMethodArguments((argumentList = methodCall.getArgumentList()).getExpressions(), argumentOffset, true)) != null) {
            if (requiredTypes.size() != actualArguments.expressions.length) {
                if (actualArguments.varargAsArray) {
                    PsiExpression[] expressions2 = argumentList.getExpressions();
                    PsiExpressionList element = expressions2.length == argumentOffset + 1 ? expressions2[argumentOffset] : argumentList;
                    holder.registerProblem((PsiElement)element, InspectionsBundle.message((String)"inspection.reflection.invocation.item.count", (Object[])new Object[]{requiredTypes.size()}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)argumentList, InspectionsBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{requiredTypes.size() + argumentOffset}), new LocalQuickFix[0]);
                }
                return;
            }
            for (int i = 0; i < requiredTypes.size(); ++i) {
                PsiExpression argument;
                PsiType actualType;
                JavaReflectionReferenceUtil.ReflectiveType requiredType = JavaReflectionReferenceUtil.getReflectiveType(requiredTypes.get(i));
                if (requiredType == null || (actualType = (argument = actualArguments.expressions[i]).getType()) == null || requiredType.isAssignableFrom(actualType)) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)argument, (boolean)false)) {
                    holder.registerProblem((PsiElement)argument, InspectionsBundle.message((String)(actualArguments.varargAsArray ? "inspection.reflection.invocation.item.not.assignable" : "inspection.reflection.invocation.argument.not.assignable"), (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
                    continue;
                }
                PsiExpression[] expressions3 = argumentList.getExpressions();
                PsiExpressionList element = expressions3.length == argumentOffset + 1 ? expressions3[argumentOffset] : argumentList;
                holder.registerProblem((PsiElement)element, InspectionsBundle.message((String)"inspection.reflection.invocation.array.not.assignable", (Object[])new Object[]{actualArguments.expressions.length}), new LocalQuickFix[0]);
                break;
            }
        }
    }

    @Nullable
    private static List<PsiExpression> getRequiredMethodArguments(@Nullable PsiExpression qualifier, int argumentOffset, @NotNull Predicate<PsiMethodCallExpression> methodPredicate) {
        PsiMethodCallExpression definitionCall;
        PsiExpression definition;
        if (methodPredicate == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(5);
        }
        if ((definition = JavaReflectionReferenceUtil.findDefinition(ParenthesesUtils.stripParentheses(qualifier))) instanceof PsiMethodCallExpression && methodPredicate.test(definitionCall = (PsiMethodCallExpression)definition)) {
            return JavaLangClassMemberReference.getReflectionMethodArguments(definitionCall, argumentOffset);
        }
        return null;
    }

    @Nullable
    static Arguments getActualMethodArguments(PsiExpression[] arguments, int argumentOffset, boolean allowVarargAsArray) {
        PsiExpression[] expressions2;
        if (allowVarargAsArray && arguments.length == argumentOffset + 1 && (expressions2 = JavaReflectionReferenceUtil.getVarargAsArray(arguments[argumentOffset])) != null) {
            return new Arguments(expressions2, true);
        }
        if (arguments.length >= argumentOffset) {
            expressions2 = argumentOffset != 0 ? Arrays.copyOfRange(arguments, argumentOffset, arguments.length) : arguments;
            for (int i = 0; i < expressions2.length; ++i) {
                PsiExpression castOperand = JavaReflectionInvocationInspection.unwrapDisambiguatingCastToObject(expressions2[i]);
                if (castOperand == null) continue;
                expressions2[i] = castOperand;
            }
            return new Arguments(expressions2, false);
        }
        return null;
    }

    @Nullable
    private static PsiExpression unwrapDisambiguatingCastToObject(@Nullable PsiExpression expression2) {
        PsiTypeCastExpression typeCast;
        PsiTypeElement castElement;
        if (expression2 instanceof PsiTypeCastExpression && (castElement = (typeCast = (PsiTypeCastExpression)expression2).getCastType()) != null && castElement.getType().equalsToText("java.lang.Object")) {
            return typeCast.getOperand();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReflectionCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredMethodArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Arguments {
        final PsiExpression[] expressions;
        final boolean varargAsArray;

        public Arguments(PsiExpression[] expressions2, boolean varargAsArray) {
            this.expressions = expressions2;
            this.varargAsArray = varargAsArray;
        }
    }
}

