/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousMethodCallUtil {
    private static final CallMatcher.Simple SINGLETON_COLLECTION = CallMatcher.staticCall("java.util.Collections", "singletonList", "singleton").parameterCount(1);

    private static void setupPatternMethods(PsiManager manager, GlobalSearchScope searchScope, List<PatternMethod> patternMethods) {
        PsiClass concurrentMapClass;
        PsiClass mapClass;
        PsiClass listClass;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiClass collectionClass = javaPsiFacade.findClass("java.util.Collection", searchScope);
        PsiType[] javaLangObject = new PsiType[]{PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)searchScope)};
        MethodSignature removeSignature = MethodSignatureUtil.createMethodSignature((String)"remove", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (collectionClass != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)removeSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, 0);
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature((String)"contains", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)containsSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(contains, 0, patternMethods, 0);
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)collectionClass)) {
                PsiClassType wildcardCollection = javaPsiFacade.getElementFactory().createType(collectionClass, (PsiType)PsiWildcardType.createUnbounded((PsiManager)manager));
                MethodSignature removeAllSignature = MethodSignatureUtil.createMethodSignature((String)"removeAll", (PsiType[])new PsiType[]{wildcardCollection}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiMethod removeAll = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)removeAllSignature, (boolean)false);
                SuspiciousMethodCallUtil.addMethod(removeAll, 0, patternMethods, 0);
            }
        }
        if ((listClass = javaPsiFacade.findClass("java.util.List", searchScope)) != null) {
            MethodSignature indexofSignature = MethodSignatureUtil.createMethodSignature((String)"indexOf", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod indexof = MethodSignatureUtil.findMethodBySignature((PsiClass)listClass, (MethodSignature)indexofSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(indexof, 0, patternMethods, 0);
            MethodSignature lastindexofSignature = MethodSignatureUtil.createMethodSignature((String)"lastIndexOf", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod lastindexof = MethodSignatureUtil.findMethodBySignature((PsiClass)listClass, (MethodSignature)lastindexofSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(lastindexof, 0, patternMethods, 0);
        }
        if ((mapClass = javaPsiFacade.findClass("java.util.Map", searchScope)) != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)removeSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, 0);
            MethodSignature getSignature = MethodSignatureUtil.createMethodSignature((String)"get", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod get = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)getSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(get, 0, patternMethods, 0);
            PsiTypeParameter[] typeParameters = mapClass.getTypeParameters();
            if (typeParameters.length > 0) {
                MethodSignature getOrDefaultSignature = MethodSignatureUtil.createMethodSignature((String)"getOrDefault", (PsiType[])new PsiType[]{javaLangObject[0], PsiSubstitutor.EMPTY.substitute(typeParameters[1])}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiMethod getOrDefault = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)getOrDefaultSignature, (boolean)false);
                SuspiciousMethodCallUtil.addMethod(getOrDefault, 0, patternMethods, 0);
            }
            MethodSignature removeWithDefaultSignature = MethodSignatureUtil.createMethodSignature((String)"remove", (PsiType[])new PsiType[]{javaLangObject[0], javaLangObject[0]}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod removeWithDefault = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)removeWithDefaultSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(removeWithDefault, 0, patternMethods, 0);
            SuspiciousMethodCallUtil.addMethod(removeWithDefault, 1, patternMethods, 1);
            MethodSignature containsKeySignature = MethodSignatureUtil.createMethodSignature((String)"containsKey", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod containsKey = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)containsKeySignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(containsKey, 0, patternMethods, 0);
            MethodSignature containsValueSignature = MethodSignatureUtil.createMethodSignature((String)"containsValue", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod containsValue = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)containsValueSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(containsValue, 1, patternMethods, 0);
        }
        if ((concurrentMapClass = javaPsiFacade.findClass("java.util.concurrent.ConcurrentHashMap", searchScope)) != null) {
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature((String)"contains", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature((PsiClass)concurrentMapClass, (MethodSignature)containsSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(contains, 1, patternMethods, 0);
        }
    }

    private static void addMethod(PsiMethod patternMethod, int typeParamIndex, List<PatternMethod> patternMethods, int argIdx) {
        if (patternMethod != null) {
            patternMethods.add(new PatternMethod(patternMethod, typeParamIndex, argIdx));
        }
    }

    private static boolean isInheritorOrSelf(PsiMethod inheritorCandidate, PsiMethod base) {
        PsiClass aClass = inheritorCandidate.getContainingClass();
        PsiClass bClass = base.getContainingClass();
        if (aClass == null || bClass == null) {
            return false;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)bClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return substitutor != null && MethodSignatureUtil.findMethodBySignature((PsiClass)bClass, (MethodSignature)inheritorCandidate.getSignature(substitutor), (boolean)false) == base;
    }

    @Nullable
    public static String getSuspiciousMethodCallMessage(@NotNull PsiMethodCallExpression methodCall, PsiExpression arg, PsiType argType, boolean reportConvertibleMethodCalls, @NotNull List<PatternMethod> patternMethods, int idx) {
        if (methodCall == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(0);
        }
        if (patternMethods == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(1);
        }
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        if (arg instanceof PsiConditionalExpression && argType != null && argType.equalsToText("java.lang.Object") && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)arg)) {
            return null;
        }
        return SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodExpression, argType, reportConvertibleMethodCalls, patternMethods, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getSuspiciousMethodCallMessage(PsiReferenceExpression methodExpression, PsiType argType, boolean reportConvertibleMethodCalls, @NotNull List<PatternMethod> patternMethods, int argIdx) {
        PsiExpression qualifier;
        if (patternMethods == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(2);
        }
        if ((qualifier = methodExpression.getQualifierExpression()) == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return null;
        }
        if (argType instanceof PsiPrimitiveType) {
            argType = ((PsiPrimitiveType)argType).getBoxedType((PsiElement)methodExpression);
        }
        if (argType == null) {
            return null;
        }
        JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod calleeMethod = (PsiMethod)element;
        NullableLazyValue lazyContextMethod = NullableLazyValue.createValue(() -> (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodExpression, PsiMethod.class));
        List<PatternMethod> list = patternMethods;
        synchronized (list) {
            if (patternMethods.isEmpty()) {
                SuspiciousMethodCallUtil.setupPatternMethods(methodExpression.getManager(), methodExpression.getResolveScope(), patternMethods);
            }
        }
        for (PatternMethod patternMethod : patternMethods) {
            PsiType paramType;
            PsiMethod method = patternMethod.patternMethod;
            if (!method.getName().equals(methodExpression.getReferenceName()) || patternMethod.argIdx != argIdx) continue;
            PsiMethod contextMethod = (PsiMethod)lazyContextMethod.getValue();
            if (contextMethod != null && SuspiciousMethodCallUtil.isInheritorOrSelf(contextMethod, method)) {
                return null;
            }
            PsiClass calleeClass = calleeMethod.getContainingClass();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            PsiClass patternClass = method.getContainingClass();
            assert (patternClass != null);
            assert (calleeClass != null);
            if ((substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)patternClass, (PsiClass)calleeClass, (PsiSubstitutor)substitutor)) == null || !method.getSignature(substitutor).equals(calleeMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
            PsiTypeParameter[] typeParameters = patternClass.getTypeParameters();
            if (typeParameters.length <= patternMethod.typeParameterIdx) {
                return null;
            }
            PsiTypeParameter typeParameter = typeParameters[patternMethod.typeParameterIdx];
            PsiType typeParamMapping = substitutor.substitute(typeParameter);
            if (typeParamMapping == null) {
                return null;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length == 1 && "removeAll".equals(method.getName()) && InheritanceUtil.isInheritor((PsiType)(paramType = parameters2[0].getType()), (String)"java.util.Collection")) {
                PsiType qualifierType = qualifier.getType();
                if (qualifierType != null) {
                    PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiType)argType, (GlobalSearchScope)calleeMethod.getResolveScope());
                    PsiType qualifierItemType = JavaGenericsUtil.getCollectionItemType((PsiType)qualifierType, (GlobalSearchScope)calleeMethod.getResolveScope());
                    if (qualifierItemType != null && itemType != null && !qualifierItemType.isAssignableFrom(itemType)) {
                        if (TypeUtils.isJavaLangObject(itemType) && SuspiciousMethodCallUtil.hasNullCollectionArg(methodExpression)) {
                            return null;
                        }
                        if (qualifierItemType.isConvertibleFrom(itemType) && !reportConvertibleMethodCalls) {
                            return null;
                        }
                        return InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor", (Object[])new Object[]{PsiFormatUtil.formatType((PsiType)qualifierType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatType((PsiType)itemType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY), "objects"});
                    }
                }
                return null;
            }
            String message2 = null;
            if (typeParamMapping instanceof PsiCapturedWildcardType) {
                typeParamMapping = ((PsiCapturedWildcardType)typeParamMapping).getWildcard();
            }
            if (!typeParamMapping.isAssignableFrom(argType)) {
                if (typeParamMapping.isConvertibleFrom(argType)) {
                    if (reportConvertibleMethodCalls) {
                        message2 = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor1", (Object[])new Object[]{PsiFormatUtil.formatMethod((PsiMethod)calleeMethod, (PsiSubstitutor)substitutor, (int)4097, (int)2)});
                    }
                } else {
                    PsiType qualifierType = qualifier.getType();
                    if (qualifierType != null) {
                        message2 = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor", (Object[])new Object[]{PsiFormatUtil.formatType((PsiType)qualifierType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatType((PsiType)argType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY), SuspiciousMethodCallUtil.getPreciseObjectTitle(patternClass, patternMethod.typeParameterIdx)});
                    }
                }
            }
            return message2;
        }
        return null;
    }

    private static String getPreciseObjectTitle(PsiClass patternClass, int index) {
        if (InheritanceUtil.isInheritor((PsiClass)patternClass, (String)"java.util.Map")) {
            return index == 0 ? "keys" : "values";
        }
        return "objects";
    }

    private static boolean hasNullCollectionArg(PsiReferenceExpression methodExpression) {
        PsiExpression arg;
        PsiMethodCallExpression argCall;
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)methodExpression.getParent(), PsiMethodCallExpression.class);
        return call != null && SINGLETON_COLLECTION.test(argCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)(arg = ExpressionUtils.resolveExpression((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions())))), PsiMethodCallExpression.class)) && ExpressionUtils.isNullLiteral(argCall.getArgumentList().getExpressions()[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "methodCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "patternMethods";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil";
        objectArray[2] = "getSuspiciousMethodCallMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PatternMethod {
        PsiMethod patternMethod;
        int typeParameterIdx;
        int argIdx;

        public PatternMethod(PsiMethod patternMethod, int typeParameterIdx, int argIdx) {
            this.patternMethod = patternMethod;
            this.typeParameterIdx = typeParameterIdx;
            this.argIdx = argIdx;
        }
    }
}

