/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantArrayForVarargsCallInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.RedundantArrayForVarargsCallInspection");
    private static final LocalQuickFix myQuickFixAction = new MyQuickFix();

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (place == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(1);
        }
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitCallExpression(PsiCallExpression expression2) {
                super.visitCallExpression(expression2);
                this.checkCall((PsiCall)expression2);
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                super.visitEnumConstant(enumConstant);
                this.checkCall((PsiCall)enumConstant);
            }

            public void visitClass(PsiClass aClass) {
            }

            private void checkCall(PsiCall expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)element;
                if (!method.isVarArgs() || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
                    return;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                PsiExpressionList argumentList = expression2.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiExpression[] args = argumentList.getExpressions();
                if (parameters2.length != args.length) {
                    return;
                }
                PsiExpression lastArg = args[args.length - 1];
                PsiParameter lastParameter = parameters2[args.length - 1];
                if (!lastParameter.isVarArgs()) {
                    return;
                }
                PsiType lastParamType = lastParameter.getType();
                LOG.assertTrue(lastParamType instanceof PsiEllipsisType, (Object)lastParamType);
                if (!(lastArg instanceof PsiNewExpression)) {
                    return;
                }
                PsiType substitutedLastParamType = substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType());
                PsiType lastArgType = lastArg.getType();
                if (lastArgType == null || !lastArgType.equals(substitutedLastParamType) && !lastArgType.equals(TypeConversionUtil.erasure((PsiType)substitutedLastParamType))) {
                    return;
                }
                PsiExpression[] initializers = RedundantArrayForVarargsCallInspection.getInitializers((PsiNewExpression)lastArg);
                if (initializers == null) {
                    return;
                }
                if (Arrays.stream(initializers).anyMatch(expr -> expr instanceof PsiArrayInitializerExpression)) {
                    return;
                }
                if (!this.isSafeToFlatten(expression2, method, initializers)) {
                    return;
                }
                String message2 = InspectionsBundle.message((String)"inspection.redundant.array.creation.for.varargs.call.descriptor", (Object[])new Object[0]);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)lastArg, message2, myQuickFixAction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                problems.add(descriptor);
            }

            private boolean isSafeToFlatten(@NotNull PsiCall callExpression, @NotNull PsiMethod oldRefMethod, @NotNull PsiExpression[] arrayElements) {
                PsiType type2;
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (oldRefMethod == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (arrayElements == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (arrayElements.length == 1 && (PsiType.NULL.equals((Object)(type2 = arrayElements[0].getType())) || type2 instanceof PsiArrayType)) {
                    return false;
                }
                PsiCall copy = (PsiCall)callExpression.copy();
                PsiExpressionList copyArgumentList = copy.getArgumentList();
                LOG.assertTrue(copyArgumentList != null);
                PsiExpression[] args = copyArgumentList.getExpressions();
                try {
                    args[args.length - 1].delete();
                    if (arrayElements.length > 0) {
                        copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
                    }
                    Project project = callExpression.getProject();
                    if (callExpression instanceof PsiEnumConstant) {
                        PsiEnumConstant enumConstant = (PsiEnumConstant)callExpression;
                        PsiClass containingClass = enumConstant.getContainingClass();
                        if (containingClass == null) {
                            return false;
                        }
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                        PsiClassType classType = facade.getElementFactory().createType(containingClass);
                        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(classType, copyArgumentList, (PsiElement)enumConstant);
                        return resolveResult.isValidResult() && resolveResult.getElement() == oldRefMethod;
                    }
                    JavaResolveResult resolveResult = copy.resolveMethodGenerics();
                    if (!resolveResult.isValidResult() || resolveResult.getElement() != oldRefMethod) {
                        return false;
                    }
                    if (callExpression.getParent() instanceof PsiExpressionStatement) {
                        return true;
                    }
                    ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiCallExpression)callExpression), false);
                    if (expectedTypes.length == 0) {
                        return false;
                    }
                    PsiType expressionType = ((PsiCallExpression)copy).getType();
                    if (expressionType == null) {
                        return false;
                    }
                    for (ExpectedTypeInfo expectedType : expectedTypes) {
                        if (!expectedType.getType().isAssignableFrom(expressionType)) continue;
                        return true;
                    }
                    return false;
                }
                catch (IncorrectOperationException e) {
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldRefMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arrayElements";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$1";
                objectArray[2] = "isSafeToFlatten";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static PsiExpression[] getInitializers(PsiNewExpression newExpression) {
        PsiArrayInitializerExpression initializer = newExpression.getArrayInitializer();
        if (initializer != null) {
            return initializer.getInitializers();
        }
        PsiExpression[] dims = newExpression.getArrayDimensions();
        if (dims.length > 0) {
            PsiExpression firstDimension = dims[0];
            Object value2 = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)firstDimension);
            if (value2 instanceof Integer && (Integer)value2 == 0) {
                return PsiExpression.EMPTY_ARRAY;
            }
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.array.creation.display.name", (Object[])new Object[0]);
        if (string == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("RedundantArrayCreation" == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(4);
        }
        return "RedundantArrayCreation";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiNewExpression arrayCreation;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if ((arrayCreation = (PsiNewExpression)descriptor.getPsiElement()) == null) {
                return;
            }
            InlineUtil.inlineArrayCreationForVarargs(arrayCreation);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.array.creation.quickfix", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

