/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EntryPointsManager")
public abstract class EntryPointsManagerBase
extends EntryPointsManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String[] STANDARD_ANNOS = new String[]{"javax.ws.rs.*"};
    private volatile List<String> ADDITIONAL_ANNOS;
    public JDOMExternalizableStringList ADDITIONAL_ANNOTATIONS;
    protected List<String> myWriteAnnotations;
    private final Map<String, SmartRefElementPointer> myPersistentEntryPoints;
    private final LinkedHashSet<ClassPattern> myPatterns;
    private final Set<RefElement> myTemporaryEntryPoints;
    private static final String VERSION = "2.0";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String ENTRY_POINT_ATTR = "entry_point";
    private boolean myAddNonJavaEntries;
    private boolean myResolved;
    protected final Project myProject;
    private long myLastModificationCount;

    public Collection<String> getAdditionalAnnotations() {
        List<String> annos = this.ADDITIONAL_ANNOS;
        if (annos == null) {
            EntryPoint[] extensions;
            annos = new ArrayList<String>();
            Collections.addAll(annos, STANDARD_ANNOS);
            for (EntryPoint extension : extensions = (EntryPoint[])Extensions.getExtensions((String)"com.intellij.deadCode", null)) {
                Object[] ignoredAnnotations = extension.getIgnoreAnnotations();
                if (ignoredAnnotations == null) continue;
                ContainerUtil.addAll(annos, (Object[])ignoredAnnotations);
            }
            this.ADDITIONAL_ANNOS = annos = Collections.unmodifiableList(annos);
        }
        return annos;
    }

    public EntryPointsManagerBase(final @NotNull Project project) {
        if (project == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(0);
        }
        this.ADDITIONAL_ANNOTATIONS = new JDOMExternalizableStringList();
        this.myWriteAnnotations = new ArrayList<String>();
        this.myPatterns = new LinkedHashSet();
        this.myAddNonJavaEntries = true;
        this.myLastModificationCount = -1L;
        this.myProject = project;
        this.myTemporaryEntryPoints = new HashSet<RefElement>();
        this.myPersistentEntryPoints = new LinkedHashMap<String, SmartRefElementPointer>();
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        ((ExtensionPointImpl)point).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<EntryPoint>(){

            public void extensionAdded(@NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.extensionRemoved(extension, pluginDescriptor);
            }

            public void extensionRemoved(@NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (EntryPointsManagerBase.this.ADDITIONAL_ANNOS != null) {
                    EntryPointsManagerBase.this.ADDITIONAL_ANNOS = null;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (!ApplicationManager.getApplication().isDisposed()) {
                            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
                        }
                    });
                }
                DaemonCodeAnalyzer.getInstance((Project)EntryPointsManagerBase.this.myProject).restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$extensionRemoved$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, (Disposable)this);
    }

    public static EntryPointsManagerBase getInstance(Project project) {
        return (EntryPointsManagerBase)((Object)ServiceManager.getService((Project)project, EntryPointsManager.class));
    }

    public void loadState(@NotNull Element element) {
        Element entryPointsElement;
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(1);
        }
        if ((entryPointsElement = element.getChild("entry_points")) != null) {
            String version = entryPointsElement.getAttributeValue(VERSION_ATTR);
            if (!Comparing.strEqual((String)version, (String)VERSION)) {
                EntryPointsManagerBase.convert(entryPointsElement, this.myPersistentEntryPoints);
            } else {
                List content = entryPointsElement.getChildren();
                for (Object aContent : content) {
                    Element entryElement = (Element)aContent;
                    if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
                    SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(entryElement);
                    this.myPersistentEntryPoints.put(entryPoint.getFQName(), (SmartRefElementPointer)entryPoint);
                }
            }
        }
        try {
            this.ADDITIONAL_ANNOTATIONS.readExternal(element);
        }
        catch (Throwable version) {
            // empty catch block
        }
        this.getPatterns().clear();
        for (Element pattern : element.getChildren("pattern")) {
            ClassPattern classPattern = new ClassPattern();
            XmlSerializer.deserializeInto((Object)classPattern, (Element)pattern);
            this.getPatterns().add(classPattern);
        }
        this.myWriteAnnotations.clear();
        Element writeAnnotations = element.getChild("writeAnnotations");
        if (writeAnnotations != null) {
            for (Element annoElement : writeAnnotations.getChildren("writeAnnotation")) {
                String value2 = annoElement.getAttributeValue("name");
                if (value2 == null) continue;
                this.myWriteAnnotations.add(value2);
            }
        }
    }

    public Element getState() {
        Element element = new Element("state");
        EntryPointsManagerBase.writeExternal(element, this.myPersistentEntryPoints, this.ADDITIONAL_ANNOTATIONS);
        if (!this.getPatterns().isEmpty()) {
            SkipDefaultsSerializationFilter filter = new SkipDefaultsSerializationFilter();
            for (ClassPattern pattern : this.getPatterns()) {
                element.addContent(XmlSerializer.serialize((Object)pattern, (SerializationFilter)filter));
            }
        }
        if (!this.myWriteAnnotations.isEmpty()) {
            Element writeAnnotations = new Element("writeAnnotations");
            for (String writeAnnotation : this.myWriteAnnotations) {
                writeAnnotations.addContent(new Element("writeAnnotation").setAttribute("name", writeAnnotation));
            }
            element.addContent(writeAnnotations);
        }
        return element;
    }

    public static void writeExternal(Element element, Map<String, SmartRefElementPointer> persistentEntryPoints, JDOMExternalizableStringList additional_annotations) {
        Collection<SmartRefElementPointer> elementPointers = persistentEntryPoints.values();
        if (!elementPointers.isEmpty()) {
            Element entryPointsElement = new Element("entry_points");
            entryPointsElement.setAttribute(VERSION_ATTR, VERSION);
            for (SmartRefElementPointer entryPoint : elementPointers) {
                assert (entryPoint.isPersistent());
                entryPoint.writeExternal(entryPointsElement);
            }
            element.addContent(entryPointsElement);
        }
        if (!additional_annotations.isEmpty()) {
            additional_annotations.writeExternal(element);
        }
    }

    public void resolveEntryPoints(@NotNull RefManager manager) {
        if (manager == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(2);
        }
        if (!this.myResolved) {
            this.myResolved = true;
            this.cleanup();
            this.validateEntryPoints();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (manager == null) {
                    EntryPointsManagerBase.$$$reportNull$$$0(9);
                }
                for (SmartRefElementPointer entryPoint : this.myPersistentEntryPoints.values()) {
                    if (!entryPoint.resolve(manager)) continue;
                    RefEntity refElement = entryPoint.getRefElement();
                    ((RefElementImpl)refElement).setEntry(true);
                    ((RefElementImpl)refElement).setPermanentEntry(entryPoint.isPersistent());
                }
                this.getPatternEntryPoints(manager).forEach(entity -> {
                    entity.setEntry(true);
                    entity.setPermanentEntry(true);
                });
            });
        }
    }

    private void purgeTemporaryEntryPoints() {
        for (RefElement entryPoint : this.myTemporaryEntryPoints) {
            ((RefElementImpl)entryPoint).setEntry(false);
        }
        this.myTemporaryEntryPoints.clear();
    }

    private List<RefElementImpl> getPatternEntryPoints(RefManager manager) {
        ArrayList<RefElementImpl> entries = new ArrayList<RefElementImpl>();
        for (ClassPattern pattern : this.myPatterns) {
            RefEntity refClass = manager.getReference("class", pattern.pattern);
            if (refClass == null) continue;
            if (pattern.method.isEmpty()) {
                for (RefMethod refMethod : ((RefClass)refClass).getConstructors()) {
                    entries.add((RefElementImpl)refMethod);
                }
                continue;
            }
            List children = refClass.getChildren();
            for (RefEntity entity : children) {
                if (!(entity instanceof RefMethodImpl) || !entity.getName().startsWith(pattern.method + "(")) continue;
                entries.add((RefElementImpl)entity);
            }
        }
        return entries;
    }

    public void addEntryPoint(@NotNull RefElement newEntryPoint, boolean isPersistent) {
        RefClass refClass;
        if (newEntryPoint == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(3);
        }
        if (!newEntryPoint.isValid()) {
            return;
        }
        if (isPersistent && (newEntryPoint instanceof RefClass || newEntryPoint instanceof RefMethod)) {
            RefClass refClass2 = refClass = newEntryPoint instanceof RefMethod ? ((RefMethod)newEntryPoint).getOwnerClass() : (RefClass)newEntryPoint;
            if (!refClass.isAnonymous()) {
                ClassPattern classPattern = new ClassPattern();
                classPattern.pattern = new SmartRefElementPointerImpl((RefEntity)refClass, true).getFQName();
                if (newEntryPoint instanceof RefMethod && !(newEntryPoint instanceof RefImplicitConstructor)) {
                    classPattern.method = EntryPointsManagerBase.getMethodName(newEntryPoint);
                }
                this.getPatterns().add(classPattern);
                EntryPointsManagerBase entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getRefManager().getProject());
                if (this != entryPointsManager) {
                    entryPointsManager.addEntryPoint(newEntryPoint, true);
                }
                return;
            }
        }
        if (newEntryPoint instanceof RefClass) {
            refClass = (RefClass)newEntryPoint;
            if (refClass.isAnonymous()) {
                return;
            }
            List refConstructors = refClass.getConstructors();
            if (refConstructors.size() == 1) {
                this.addEntryPoint((RefElement)refConstructors.get(0), isPersistent);
            } else if (refConstructors.size() > 1) {
                for (RefMethod refConstructor : refConstructors) {
                    this.addEntryPoint((RefElement)refConstructor, isPersistent);
                }
            }
        }
        if (!isPersistent) {
            this.myTemporaryEntryPoints.add(newEntryPoint);
            ((RefElementImpl)newEntryPoint).setEntry(true);
        } else if (this.myPersistentEntryPoints.get(newEntryPoint.getExternalName()) == null) {
            EntryPointsManagerBase entryPointsManager;
            SmartRefElementPointerImpl entry = new SmartRefElementPointerImpl((RefEntity)newEntryPoint, true);
            this.myPersistentEntryPoints.put(entry.getFQName(), (SmartRefElementPointer)entry);
            ((RefElementImpl)newEntryPoint).setEntry(true);
            ((RefElementImpl)newEntryPoint).setPermanentEntry(true);
            if (entry.isPersistent() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getRefManager().getProject()))) {
                entryPointsManager.addEntryPoint(newEntryPoint, true);
            }
        }
    }

    private static String getMethodName(@NotNull RefElement newEntryPoint) {
        String methodSignature;
        int indexOf;
        if (newEntryPoint == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(4);
        }
        return (indexOf = (methodSignature = newEntryPoint.getName()).indexOf("(")) > 0 ? methodSignature.substring(0, indexOf) : methodSignature;
    }

    public void removeEntryPoint(@NotNull RefElement anEntryPoint) {
        Project project;
        EntryPointsManagerBase entryPointsManager;
        if (anEntryPoint == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(5);
        }
        this.myTemporaryEntryPoints.remove(anEntryPoint);
        Set<Map.Entry<String, SmartRefElementPointer>> set = this.myPersistentEntryPoints.entrySet();
        String key2 = null;
        for (Map.Entry<String, SmartRefElementPointer> entry : set) {
            SmartRefElementPointer value2 = entry.getValue();
            if (value2.getRefElement() != anEntryPoint) continue;
            key2 = entry.getKey();
            break;
        }
        if (key2 != null) {
            this.myPersistentEntryPoints.remove(key2);
        }
        ((RefElementImpl)anEntryPoint).setEntry(false);
        if (anEntryPoint.isPermanentEntry() && anEntryPoint.isValid() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(project = anEntryPoint.getElement().getProject()))) {
            entryPointsManager.removeEntryPoint(anEntryPoint);
        }
        if (anEntryPoint instanceof RefMethod || anEntryPoint instanceof RefClass) {
            RefClass aClass;
            RefClass refClass = aClass = anEntryPoint instanceof RefClass ? (RefClass)anEntryPoint : ((RefMethod)anEntryPoint).getOwnerClass();
            if (aClass != null) {
                String qualifiedName = aClass.getQualifiedName();
                Iterator iterator = this.getPatterns().iterator();
                while (iterator.hasNext()) {
                    ClassPattern classPattern = (ClassPattern)iterator.next();
                    if (!Comparing.equal((String)classPattern.pattern, (String)qualifiedName)) continue;
                    if (anEntryPoint instanceof RefMethod && ((RefMethod)anEntryPoint).isConstructor() || anEntryPoint instanceof RefClass) {
                        if (!classPattern.method.isEmpty()) continue;
                        iterator.remove();
                        continue;
                    }
                    String methodName = EntryPointsManagerBase.getMethodName(anEntryPoint);
                    if (!methodName.equals(classPattern.method)) continue;
                    iterator.remove();
                }
            }
        }
    }

    @NotNull
    public RefElement[] getEntryPoints(RefManager refManager) {
        this.validateEntryPoints();
        ArrayList<Object> entries = new ArrayList<Object>();
        Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer refElementPointer : collection) {
            RefEntity elt = refElementPointer.getRefElement();
            if (!(elt instanceof RefElement)) continue;
            entries.add((RefElement)elt);
        }
        entries.addAll(this.myTemporaryEntryPoints);
        entries.addAll(this.getPatternEntryPoints(refManager));
        RefElement[] refElementArray = entries.toArray(new RefElement[0]);
        if (refElementArray == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(6);
        }
        return refElementArray;
    }

    public void dispose() {
        this.cleanup();
    }

    private void validateEntryPoints() {
        long count = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (count != this.myLastModificationCount) {
            SmartRefElementPointer[] entries;
            this.myLastModificationCount = count;
            Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
            for (SmartRefElementPointer entry : entries = collection.toArray(new SmartRefElementPointer[0])) {
                RefElement refElement = (RefElement)entry.getRefElement();
                if (refElement == null || refElement.isValid()) continue;
                this.myPersistentEntryPoints.remove(entry.getFQName());
            }
            Iterator<RefElement> it = this.myTemporaryEntryPoints.iterator();
            while (it.hasNext()) {
                RefElement refElement = it.next();
                if (refElement.isValid()) continue;
                it.remove();
            }
        }
    }

    public void cleanup() {
        this.purgeTemporaryEntryPoints();
        Collection<SmartRefElementPointer> entries = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer entry : entries) {
            entry.freeReference();
        }
    }

    public boolean isAddNonJavaEntries() {
        return this.myAddNonJavaEntries;
    }

    public void addAllPersistentEntries(EntryPointsManagerBase manager) {
        this.myPersistentEntryPoints.putAll(manager.myPersistentEntryPoints);
        this.myPatterns.addAll(manager.getPatterns());
    }

    static void convert(Element element, Map<? super String, ? super SmartRefElementPointer> persistentEntryPoints) {
        List content = element.getChildren();
        for (Object aContent : content) {
            Element entryElement = (Element)aContent;
            if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
            String fqName = entryElement.getAttributeValue("FQNAME");
            String type2 = entryElement.getAttributeValue("TYPE");
            if (Comparing.strEqual((String)type2, (String)"method")) {
                int spaceIdx = fqName.indexOf(32);
                int lastDotIdx = fqName.lastIndexOf(46);
                int parenIndex = fqName.indexOf(40);
                while (lastDotIdx > parenIndex) {
                    lastDotIdx = fqName.lastIndexOf(46, lastDotIdx - 1);
                }
                boolean notype = false;
                if (spaceIdx < 0 || spaceIdx + 1 > lastDotIdx || spaceIdx > parenIndex) {
                    notype = true;
                }
                String className = fqName.substring(notype ? 0 : spaceIdx + 1, lastDotIdx);
                String methodSignature = notype ? fqName.substring(lastDotIdx + 1) : fqName.substring(0, spaceIdx) + ' ' + fqName.substring(lastDotIdx + 1);
                fqName = className + " " + methodSignature;
            } else if (Comparing.strEqual((String)type2, (String)"field")) {
                int lastDotIdx = fqName.lastIndexOf(46);
                if (lastDotIdx <= 0 || lastDotIdx >= fqName.length() - 2) continue;
                String className = fqName.substring(0, lastDotIdx);
                String fieldName = fqName.substring(lastDotIdx + 1);
                fqName = className + " " + fieldName;
            }
            SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(type2, fqName);
            persistentEntryPoints.put(entryPoint.getFQName(), (SmartRefElementPointer)entryPoint);
        }
    }

    public void setAddNonJavaEntries(boolean addNonJavaEntries) {
        this.myAddNonJavaEntries = addNonJavaEntries;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return element instanceof PsiField && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), this.myWriteAnnotations, (int)0);
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        String qualifiedName;
        PsiClass containingClass;
        String qualifiedName2;
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(7);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)element;
        if (!this.ADDITIONAL_ANNOTATIONS.isEmpty() && this.ADDITIONAL_ANNOTATIONS.contains((Object)Deprecated.class.getName()) && element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return true;
        }
        if (element instanceof PsiClass && (qualifiedName2 = ((PsiClass)element).getQualifiedName()) != null) {
            for (ClassPattern pattern : this.getPatterns()) {
                if (!pattern.method.isEmpty() || !EntryPointsManagerBase.isAcceptedByPattern((PsiClass)element, qualifiedName2, pattern, new HashSet())) continue;
                return true;
            }
        }
        if (element instanceof PsiMethod && (containingClass = ((PsiMethod)element).getContainingClass()) != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            String name = ((PsiMethod)element).getName();
            for (ClassPattern pattern : this.getPatterns()) {
                if (pattern.method.isEmpty()) continue;
                boolean acceptedName = name.equals(pattern.method);
                if (!acceptedName) {
                    Pattern methodRegexp = pattern.getMethodRegexp();
                    boolean bl = acceptedName = methodRegexp != null && methodRegexp.matcher(name).matches();
                }
                if (!acceptedName || !EntryPointsManagerBase.isAcceptedByPattern(containingClass, qualifiedName, pattern, new HashSet())) continue;
                return true;
            }
        }
        return AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)owner, (Collection)this.ADDITIONAL_ANNOTATIONS) || AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)owner, this.getAdditionalAnnotations());
    }

    private static boolean isAcceptedByPattern(@NotNull PsiClass element, String qualifiedName, ClassPattern pattern, Set<? super PsiClass> visited) {
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(8);
        }
        if (qualifiedName == null) {
            return false;
        }
        if (qualifiedName.equals(pattern.pattern)) {
            return true;
        }
        Pattern regexp = pattern.getRegexp();
        if (regexp != null) {
            try {
                if (regexp.matcher(qualifiedName).matches()) {
                    return true;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (pattern.hierarchically) {
            for (PsiClass superClass : element.getSupers()) {
                String superClassQualifiedName = superClass.getQualifiedName();
                if (!visited.add((PsiClass)superClass) || !EntryPointsManagerBase.isAcceptedByPattern(superClass, superClassQualifiedName, pattern, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public LinkedHashSet<ClassPattern> getPatterns() {
        return this.myPatterns;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntryPoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anEntryPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/EntryPointsManagerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveEntryPoints";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEntryPoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeEntryPoint";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByPattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveEntryPoints$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class AddImplicitlyWriteAnnotation
    implements IntentionAction {
        private final String myQualifiedName;

        public AddImplicitlyWriteAnnotation(String qualifiedName) {
            this.myQualifiedName = qualifiedName;
        }

        @NotNull
        public String getText() {
            String string = QuickFixBundle.message("fix.unused.symbol.injection.text", this.myQualifiedName);
            if (string == null) {
                AddImplicitlyWriteAnnotation.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.unused.symbol.injection.family", new Object[0]);
            if (string == null) {
                AddImplicitlyWriteAnnotation.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project1, Editor editor, PsiFile file) {
            if (project1 == null) {
                AddImplicitlyWriteAnnotation.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                AddImplicitlyWriteAnnotation.$$$reportNull$$$0(3);
            }
            EntryPointsManagerBase.this.myWriteAnnotations.add(this.myQualifiedName);
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$AddImplicitlyWriteAnnotation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$AddImplicitlyWriteAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="pattern")
    public static class ClassPattern {
        @Attribute(value="value")
        public String pattern = "";
        @Attribute(value="hierarchically")
        public boolean hierarchically = false;
        @Attribute(value="method")
        public String method = "";
        private Pattern regexp;
        private Pattern methodRegexp;

        public ClassPattern(ClassPattern classPattern) {
            this.hierarchically = classPattern.hierarchically;
            this.pattern = classPattern.pattern;
            this.method = classPattern.method;
        }

        public ClassPattern() {
        }

        @Nullable
        public Pattern getRegexp() {
            if (this.regexp == null && this.pattern.contains("*")) {
                this.regexp = ClassPattern.createRegexp(this.pattern);
            }
            return this.regexp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPattern pattern1 = (ClassPattern)o;
            if (this.hierarchically != pattern1.hierarchically) {
                return false;
            }
            if (!this.pattern.equals(pattern1.pattern)) {
                return false;
            }
            return this.method.equals(pattern1.method);
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 31 * result + (this.hierarchically ? 1 : 0);
            result = 31 * result + this.method.hashCode();
            return result;
        }

        public Pattern getMethodRegexp() {
            if (this.methodRegexp == null && this.method.contains("*")) {
                this.methodRegexp = ClassPattern.createRegexp(this.method);
            }
            return this.methodRegexp;
        }

        private static Pattern createRegexp(String pattern) {
            String replace = pattern.replace(".", "\\.").replace("*", ".*");
            try {
                return Pattern.compile(replace);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }
    }
}

