/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;

public abstract class DfaValue {
    private final int myID;
    protected final DfaValueFactory myFactory;

    protected DfaValue(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myID = factory == null ? 0 : factory.registerValue(this);
    }

    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    public int getID() {
        return this.myID;
    }

    public DfaValue union(DfaValue other) {
        if (this == other) {
            return this;
        }
        if (this == DfaUnknownValue.getInstance() || other == DfaUnknownValue.getInstance()) {
            return DfaUnknownValue.getInstance();
        }
        return this.myFactory.getFactFactory().createValue(DfaFactMap.fromDfaValue(this).union(DfaFactMap.fromDfaValue(other)));
    }

    public DfaValue createNegated() {
        return DfaUnknownValue.getInstance();
    }

    public boolean equals(Object obj) {
        return obj instanceof DfaValue && this.getID() == ((DfaValue)obj).getID();
    }

    public int hashCode() {
        return this.getID();
    }
}

