/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaRelationValue
extends DfaValue {
    @NotNull
    private final DfaValue myLeftOperand;
    @NotNull
    private final DfaValue myRightOperand;
    @NotNull
    private final RelationType myRelation;

    @Override
    public DfaRelationValue createNegated() {
        return this.myFactory.getRelationFactory().createCanonicalRelation(this.myLeftOperand, this.myRelation.getNegated(), this.myRightOperand);
    }

    private DfaRelationValue(@NotNull DfaValue leftOperand2, @NotNull DfaValue rightOperand2, @NotNull RelationType relationType, DfaValueFactory factory) {
        if (leftOperand2 == null) {
            DfaRelationValue.$$$reportNull$$$0(0);
        }
        if (rightOperand2 == null) {
            DfaRelationValue.$$$reportNull$$$0(1);
        }
        if (relationType == null) {
            DfaRelationValue.$$$reportNull$$$0(2);
        }
        super(factory);
        this.myLeftOperand = leftOperand2;
        this.myRightOperand = rightOperand2;
        this.myRelation = relationType;
    }

    @NotNull
    public DfaValue getLeftOperand() {
        DfaValue dfaValue = this.myLeftOperand;
        if (dfaValue == null) {
            DfaRelationValue.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    @NotNull
    public DfaValue getRightOperand() {
        DfaValue dfaValue = this.myRightOperand;
        if (dfaValue == null) {
            DfaRelationValue.$$$reportNull$$$0(4);
        }
        return dfaValue;
    }

    public boolean isEquality() {
        return this.myRelation == RelationType.EQ;
    }

    public boolean isNonEquality() {
        return this.myRelation == RelationType.NE || this.myRelation == RelationType.GT || this.myRelation == RelationType.LT;
    }

    @NotNull
    public RelationType getRelation() {
        RelationType relationType = this.myRelation;
        if (relationType == null) {
            DfaRelationValue.$$$reportNull$$$0(5);
        }
        return relationType;
    }

    @NonNls
    public String toString() {
        return this.myLeftOperand + " " + (Object)((Object)this.myRelation) + " " + this.myRightOperand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaRelationValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaRelationValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftOperand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightOperand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final Map<Trinity<DfaValue, DfaValue, RelationType>, DfaRelationValue> myValues;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.myValues = new HashMap<Trinity<DfaValue, DfaValue, RelationType>, DfaRelationValue>();
        }

        public DfaRelationValue createRelation(DfaValue dfaLeft, RelationType relationType, DfaValue dfaRight) {
            if ((relationType == RelationType.IS || relationType == RelationType.IS_NOT) && dfaRight instanceof DfaFactMapValue && !(dfaLeft instanceof DfaFactMapValue)) {
                return this.createCanonicalRelation(dfaLeft, relationType, dfaRight);
            }
            if (dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaBoxedValue || dfaRight instanceof DfaUnboxedValue) {
                if (!(dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue)) {
                    RelationType flipped = relationType.getFlipped();
                    return flipped == null ? null : this.createCanonicalRelation(dfaRight, flipped, dfaLeft);
                }
                return this.createCanonicalRelation(dfaLeft, relationType, dfaRight);
            }
            if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaConstValue) {
                return this.createConstBasedRelation((DfaFactMapValue)dfaLeft, relationType, (DfaConstValue)dfaRight);
            }
            if (dfaRight instanceof DfaFactMapValue && dfaLeft instanceof DfaConstValue) {
                return this.createConstBasedRelation((DfaFactMapValue)dfaRight, relationType, (DfaConstValue)dfaLeft);
            }
            return null;
        }

        @NotNull
        private DfaRelationValue createConstBasedRelation(DfaFactMapValue dfaLeft, RelationType relationType, DfaConstValue dfaRight) {
            if (dfaRight.getValue() == null && Boolean.TRUE.equals(dfaLeft.get(DfaFactType.CAN_BE_NULL))) {
                DfaRelationValue dfaRelationValue = this.createCanonicalRelation(this.myFactory.getFactValue(DfaFactType.CAN_BE_NULL, Boolean.TRUE), relationType, dfaRight);
                if (dfaRelationValue == null) {
                    Factory.$$$reportNull$$$0(0);
                }
                return dfaRelationValue;
            }
            DfaRelationValue dfaRelationValue = this.createCanonicalRelation(DfaUnknownValue.getInstance(), relationType, dfaRight);
            if (dfaRelationValue == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return dfaRelationValue;
        }

        @NotNull
        private DfaRelationValue createCanonicalRelation(@NotNull DfaValue dfaLeft, @NotNull RelationType relationType, @NotNull DfaValue dfaRight) {
            if (dfaLeft == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (relationType == null) {
                Factory.$$$reportNull$$$0(3);
            }
            if (dfaRight == null) {
                Factory.$$$reportNull$$$0(4);
            }
            DfaRelationValue dfaRelationValue = this.myValues.computeIfAbsent((Trinity<DfaValue, DfaValue, RelationType>)Trinity.create((Object)dfaLeft, (Object)dfaRight, (Object)((Object)relationType)), k -> {
                if (dfaLeft == null) {
                    Factory.$$$reportNull$$$0(6);
                }
                if (dfaRight == null) {
                    Factory.$$$reportNull$$$0(7);
                }
                if (relationType == null) {
                    Factory.$$$reportNull$$$0(8);
                }
                return new DfaRelationValue(dfaLeft, dfaRight, relationType, this.myFactory);
            });
            if (dfaRelationValue == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return dfaRelationValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfaLeft";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relationType";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfaRight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConstBasedRelation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCanonicalRelation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createCanonicalRelation";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createCanonicalRelation$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum RelationType {
        LE("<="),
        LT("<"),
        GE(">="),
        GT(">"),
        EQ("=="),
        NE("!="),
        IS("is"),
        IS_NOT("isn't");

        private final String myName;

        private RelationType(String name) {
            this.myName = name;
        }

        public boolean isSubRelation(RelationType other) {
            if (other == this) {
                return true;
            }
            switch (this) {
                case LE: {
                    return other == LT || other == EQ;
                }
                case GE: {
                    return other == GT || other == EQ;
                }
                case NE: {
                    return other == LT || other == GT;
                }
            }
            return false;
        }

        @NotNull
        public RelationType getNegated() {
            switch (this) {
                case LE: {
                    RelationType relationType = GT;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(0);
                    }
                    return relationType;
                }
                case LT: {
                    RelationType relationType = GE;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(1);
                    }
                    return relationType;
                }
                case GE: {
                    RelationType relationType = LT;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(2);
                    }
                    return relationType;
                }
                case GT: {
                    RelationType relationType = LE;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(3);
                    }
                    return relationType;
                }
                case EQ: {
                    RelationType relationType = NE;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(4);
                    }
                    return relationType;
                }
                case NE: {
                    RelationType relationType = EQ;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(5);
                    }
                    return relationType;
                }
                case IS: {
                    RelationType relationType = IS_NOT;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(6);
                    }
                    return relationType;
                }
                case IS_NOT: {
                    RelationType relationType = IS;
                    if (relationType == null) {
                        RelationType.$$$reportNull$$$0(7);
                    }
                    return relationType;
                }
            }
            throw new InternalError("Unexpected enum value: " + (Object)((Object)this));
        }

        @Nullable
        public RelationType getFlipped() {
            switch (this) {
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
                case NE: 
                case EQ: {
                    return this;
                }
            }
            return null;
        }

        public boolean isInequality() {
            return this == LE || this == GE || this == LT || this == GT || this == NE;
        }

        public String toString() {
            return this.myName;
        }

        @Nullable
        public static RelationType fromElementType(IElementType type2) {
            if (JavaTokenType.EQEQ.equals(type2)) {
                return EQ;
            }
            if (JavaTokenType.NE.equals(type2)) {
                return NE;
            }
            if (JavaTokenType.LT.equals(type2)) {
                return LT;
            }
            if (JavaTokenType.GT.equals(type2)) {
                return GT;
            }
            if (JavaTokenType.LE.equals(type2)) {
                return LE;
            }
            if (JavaTokenType.GE.equals(type2)) {
                return GE;
            }
            if (JavaTokenType.INSTANCEOF_KEYWORD.equals(type2)) {
                return IS;
            }
            return null;
        }

        public static RelationType equivalence(boolean equal) {
            return equal ? EQ : NE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
        }
    }
}

